package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICNonReportable;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.common.ActionTypeEnum;
import drr.standards.iso.upi.AnnaDsbAssetClassEnum;
import drr.standards.iso.upi.AnnaDsbAttributesRecord;
import drr.standards.iso.upi.AnnaDsbHeader;
import drr.standards.iso.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iso.upi.AnnaDsbNotionalScheduleEnum;
import drr.standards.iso.upi.AnnaDsbUpiRecord;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1042_02")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1042_02.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1042_02 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1042_02";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType then if nonReportable -> postUpiData -> Header -> InstrumentType = AnnaDsbInstrumentTypeEnum -> Swap and nonReportable -> postUpiData -> Attributes -> NotionalSchedule = AnnaDsbNotionalScheduleEnum -> Constant and nonReportable -> postUpiData -> Header -> AssetClass = AnnaDsbAssetClassEnum -> Rates then (notionalAmountScheduleLeg1 -> amount exists and notionalAmountScheduleLeg1 -> amount count = notionalAmountScheduleLeg1 -> effectiveDate count)";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1042_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICTransactionReport).<ASICNonReportable>map("getNonReportable", _aSICTransactionReport -> _aSICTransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", aSICNonReportable -> aSICNonReportable.getPostUpiData()).<AnnaDsbHeader>map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).<AnnaDsbInstrumentTypeEnum>map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), MapperS.of(AnnaDsbInstrumentTypeEnum.SWAP), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(aSICTransactionReport).<ASICNonReportable>map("getNonReportable", _aSICTransactionReport -> _aSICTransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", aSICNonReportable -> aSICNonReportable.getPostUpiData()).<AnnaDsbAttributesRecord>map("getAttributes", annaDsbUpiRecord -> annaDsbUpiRecord.getAttributes()).<AnnaDsbNotionalScheduleEnum>map("getNotionalSchedule", annaDsbAttributesRecord -> annaDsbAttributesRecord.getNotionalSchedule()), MapperS.of(AnnaDsbNotionalScheduleEnum.CONSTANT), CardinalityOperator.All)).andNullSafe(areEqual(MapperS.of(aSICTransactionReport).<ASICNonReportable>map("getNonReportable", _aSICTransactionReport -> _aSICTransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", aSICNonReportable -> aSICNonReportable.getPostUpiData()).<AnnaDsbHeader>map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).<AnnaDsbAssetClassEnum>map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), MapperS.of(AnnaDsbAssetClassEnum.RATES), CardinalityOperator.All)).getOrDefault(false)) {
						return exists(MapperS.of(aSICTransactionReport).<NotionalAmountScheduleLeg1Report>mapC("getNotionalAmountScheduleLeg1", _aSICTransactionReport -> _aSICTransactionReport.getNotionalAmountScheduleLeg1()).<BigDecimal>map("getAmount", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getAmount())).andNullSafe(areEqual(MapperS.of(MapperS.of(aSICTransactionReport).<NotionalAmountScheduleLeg1Report>mapC("getNotionalAmountScheduleLeg1", _aSICTransactionReport -> _aSICTransactionReport.getNotionalAmountScheduleLeg1()).<BigDecimal>map("getAmount", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getAmount()).resultCount()), MapperS.of(MapperS.of(aSICTransactionReport).<NotionalAmountScheduleLeg1Report>mapC("getNotionalAmountScheduleLeg1", _aSICTransactionReport -> _aSICTransactionReport.getNotionalAmountScheduleLeg1()).<Date>map("getEffectiveDate", notionalAmountScheduleLeg1Report -> notionalAmountScheduleLeg1Report.getEffectiveDate()).resultCount()), CardinalityOperator.All));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1042_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
