package drr.regulation.asic.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.OtherPaymentReport;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import drr.regulation.common.ActionTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1075_02")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1075_02.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1075_02 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1075_02";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and assetClass = \"CRDT\" then if (actionType = ActionTypeEnum -> NEWT to-string and fixedRateLeg1 is absent and fixedRateLeg2 is absent and spreadLeg1 is absent and spreadLeg2 is absent) then otherPayment -> paymentType any = \"UFRO\" else if (otherPayment -> amount count <> otherPayment -> paymentType count and otherPayment -> paymentType count <> otherPayment -> currency count and otherPayment -> currency count <> otherPayment -> date count and otherPayment -> payer count <> otherPayment -> receiver count) then False";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1075_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperS.of(aSICTransactionReport).<String>map("getAssetClass", _aSICTransactionReport -> _aSICTransactionReport.getAssetClass()), MapperS.of("CRDT"), CardinalityOperator.All)).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).andNullSafe(notExists(MapperS.of(aSICTransactionReport).<BigDecimal>map("getFixedRateLeg1", _aSICTransactionReport -> _aSICTransactionReport.getFixedRateLeg1()))).andNullSafe(notExists(MapperS.of(aSICTransactionReport).<BigDecimal>map("getFixedRateLeg2", _aSICTransactionReport -> _aSICTransactionReport.getFixedRateLeg2()))).andNullSafe(notExists(MapperS.of(aSICTransactionReport).<SpreadLeg1>map("getSpreadLeg1", _aSICTransactionReport -> _aSICTransactionReport.getSpreadLeg1()))).andNullSafe(notExists(MapperS.of(aSICTransactionReport).<SpreadLeg2>map("getSpreadLeg2", _aSICTransactionReport -> _aSICTransactionReport.getSpreadLeg2()))).getOrDefault(false)) {
						return areEqual(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of("UFRO"), CardinalityOperator.Any);
					}
					if (notEqual(MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount()).resultCount()), MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), CardinalityOperator.Any).andNullSafe(notEqual(MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()).resultCount()), CardinalityOperator.Any)).andNullSafe(notEqual(MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()).resultCount()), MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<Date>map("getDate", otherPaymentReport -> otherPaymentReport.getDate()).resultCount()), CardinalityOperator.Any)).andNullSafe(notEqual(MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()).resultCount()), MapperS.of(MapperS.of(aSICTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _aSICTransactionReport -> _aSICTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()).resultCount()), CardinalityOperator.Any)).getOrDefault(false)) {
						return ComparisonResult.ofNullSafe(MapperS.of(false));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1075_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
