package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.ActionTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_2010_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_2010_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_2010_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_2010_01";
	String DEFINITION = "if actionType = ActionTypeEnum -> VALU to-string then if smallScaleBuySideEntityIndicator <> \"SSBS\" then delta exists else if [\"OPTN\", \"SWPT\"] any <> contractType then delta is absent";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_2010_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					if (notEqual(MapperS.of(aSICTransactionReport).<String>map("getSmallScaleBuySideEntityIndicator", _aSICTransactionReport -> _aSICTransactionReport.getSmallScaleBuySideEntityIndicator()), MapperS.of("SSBS"), CardinalityOperator.Any).getOrDefault(false)) {
						return exists(MapperS.of(aSICTransactionReport).<BigDecimal>map("getDelta", _aSICTransactionReport -> _aSICTransactionReport.getDelta()));
					}
					if (notEqual(MapperC.<String>of(MapperS.of("OPTN"), MapperS.of("SWPT")), MapperS.of(aSICTransactionReport).<String>map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), CardinalityOperator.Any).getOrDefault(false)) {
						return notExists(MapperS.of(aSICTransactionReport).<BigDecimal>map("getDelta", _aSICTransactionReport -> _aSICTransactionReport.getDelta()));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_2010_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
