package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.BarrierAndNotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("BarrierAndNotationMonetaryOrDecimalLowerBarrier")
@ImplementedBy(BarrierAndNotationMonetaryOrDecimalLowerBarrier.Default.class)
public interface BarrierAndNotationMonetaryOrDecimalLowerBarrier extends Validator<BarrierAndNotation> {
	
	String NAME = "BarrierAndNotationMonetaryOrDecimalLowerBarrier";
	String DEFINITION = "optional choice lowerBarrierPriceMonetary, lowerBarrierPriceDecimal";
	
	class Default implements BarrierAndNotationMonetaryOrDecimalLowerBarrier {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, BarrierAndNotation barrierAndNotation) {
			ComparisonResult result = executeDataRule(barrierAndNotation);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "BarrierAndNotation", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "BarrierAndNotation", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(BarrierAndNotation barrierAndNotation) {
			try {
				return choice(MapperS.of(barrierAndNotation), Arrays.asList("lowerBarrierPriceMonetary", "lowerBarrierPriceDecimal"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements BarrierAndNotationMonetaryOrDecimalLowerBarrier {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, BarrierAndNotation barrierAndNotation) {
			return Collections.emptyList();
		}
	}
}
