package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("SpreadLeg2MonetaryOrDecimalOrBasis")
@ImplementedBy(SpreadLeg2MonetaryOrDecimalOrBasis.Default.class)
public interface SpreadLeg2MonetaryOrDecimalOrBasis extends Validator<SpreadLeg2> {
	
	String NAME = "SpreadLeg2MonetaryOrDecimalOrBasis";
	String DEFINITION = "optional choice spreadLeg2Monetary, spreadLeg2Decimal, spreadLeg2Basis";
	
	class Default implements SpreadLeg2MonetaryOrDecimalOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadLeg2 spreadLeg2) {
			ComparisonResult result = executeDataRule(spreadLeg2);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadLeg2", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadLeg2", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SpreadLeg2 spreadLeg2) {
			try {
				return choice(MapperS.of(spreadLeg2), Arrays.asList("spreadLeg2Monetary", "spreadLeg2Decimal", "spreadLeg2Basis"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SpreadLeg2MonetaryOrDecimalOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadLeg2 spreadLeg2) {
			return Collections.emptyList();
		}
	}
}
