package drr.regulation.cftc.rewrite;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.cftc.rewrite.meta.ClearingSwapUSIsReportMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.57.0
 */
@RosettaDataType(value="ClearingSwapUSIsReport", builder=ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilderImpl.class, version="5.57.0")
@RuneDataType(value="ClearingSwapUSIsReport", model="drr", builder=ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilderImpl.class, version="5.57.0")
public interface ClearingSwapUSIsReport extends RosettaModelObject {

	ClearingSwapUSIsReportMeta metaData = new ClearingSwapUSIsReportMeta();

	/*********************** Getter Methods  ***********************/
	String getIdentifier();

	/*********************** Build Methods  ***********************/
	ClearingSwapUSIsReport build();
	
	ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder toBuilder();
	
	static ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder builder() {
		return new ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ClearingSwapUSIsReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ClearingSwapUSIsReport> getType() {
		return ClearingSwapUSIsReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("identifier"), String.class, getIdentifier(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ClearingSwapUSIsReportBuilder extends ClearingSwapUSIsReport, RosettaModelObjectBuilder {
		ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder setIdentifier(String identifier);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("identifier"), String.class, getIdentifier(), this);
		}
		

		ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder prune();
	}

	/*********************** Immutable Implementation of ClearingSwapUSIsReport  ***********************/
	class ClearingSwapUSIsReportImpl implements ClearingSwapUSIsReport {
		private final String identifier;
		
		protected ClearingSwapUSIsReportImpl(ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder builder) {
			this.identifier = builder.getIdentifier();
		}
		
		@Override
		@RosettaAttribute(value="identifier", isRequired=true)
		@RuneAttribute(value="identifier", isRequired=true)
		public String getIdentifier() {
			return identifier;
		}
		
		@Override
		public ClearingSwapUSIsReport build() {
			return this;
		}
		
		@Override
		public ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder toBuilder() {
			ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder builder) {
			ofNullable(getIdentifier()).ifPresent(builder::setIdentifier);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingSwapUSIsReport _that = getType().cast(o);
		
			if (!Objects.equals(identifier, _that.getIdentifier())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (identifier != null ? identifier.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingSwapUSIsReport {" +
				"identifier=" + this.identifier +
			'}';
		}
	}

	/*********************** Builder Implementation of ClearingSwapUSIsReport  ***********************/
	class ClearingSwapUSIsReportBuilderImpl implements ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder {
	
		protected String identifier;
		
		@Override
		@RosettaAttribute(value="identifier", isRequired=true)
		@RuneAttribute(value="identifier", isRequired=true)
		public String getIdentifier() {
			return identifier;
		}
		
		@RosettaAttribute(value="identifier", isRequired=true)
		@RuneAttribute(value="identifier", isRequired=true)
		@Override
		public ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder setIdentifier(String _identifier) {
			this.identifier = _identifier == null ? null : _identifier;
			return this;
		}
		
		@Override
		public ClearingSwapUSIsReport build() {
			return new ClearingSwapUSIsReport.ClearingSwapUSIsReportImpl(this);
		}
		
		@Override
		public ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getIdentifier()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder o = (ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder) other;
			
			
			merger.mergeBasic(getIdentifier(), o.getIdentifier(), this::setIdentifier);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingSwapUSIsReport _that = getType().cast(o);
		
			if (!Objects.equals(identifier, _that.getIdentifier())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (identifier != null ? identifier.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingSwapUSIsReportBuilder {" +
				"identifier=" + this.identifier +
			'}';
		}
	}
}
