package drr.regulation.cftc.rewrite;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.cftc.rewrite.meta.ClearingSwapUTIsReportMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.57.0
 */
@RosettaDataType(value="ClearingSwapUTIsReport", builder=ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilderImpl.class, version="5.57.0")
@RuneDataType(value="ClearingSwapUTIsReport", model="drr", builder=ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilderImpl.class, version="5.57.0")
public interface ClearingSwapUTIsReport extends RosettaModelObject {

	ClearingSwapUTIsReportMeta metaData = new ClearingSwapUTIsReportMeta();

	/*********************** Getter Methods  ***********************/
	String getIdentifier();

	/*********************** Build Methods  ***********************/
	ClearingSwapUTIsReport build();
	
	ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder toBuilder();
	
	static ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder builder() {
		return new ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ClearingSwapUTIsReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ClearingSwapUTIsReport> getType() {
		return ClearingSwapUTIsReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("identifier"), String.class, getIdentifier(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ClearingSwapUTIsReportBuilder extends ClearingSwapUTIsReport, RosettaModelObjectBuilder {
		ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder setIdentifier(String identifier);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("identifier"), String.class, getIdentifier(), this);
		}
		

		ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder prune();
	}

	/*********************** Immutable Implementation of ClearingSwapUTIsReport  ***********************/
	class ClearingSwapUTIsReportImpl implements ClearingSwapUTIsReport {
		private final String identifier;
		
		protected ClearingSwapUTIsReportImpl(ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder builder) {
			this.identifier = builder.getIdentifier();
		}
		
		@Override
		@RosettaAttribute(value="identifier", isRequired=true)
		@RuneAttribute(value="identifier", isRequired=true)
		public String getIdentifier() {
			return identifier;
		}
		
		@Override
		public ClearingSwapUTIsReport build() {
			return this;
		}
		
		@Override
		public ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder toBuilder() {
			ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder builder) {
			ofNullable(getIdentifier()).ifPresent(builder::setIdentifier);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingSwapUTIsReport _that = getType().cast(o);
		
			if (!Objects.equals(identifier, _that.getIdentifier())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (identifier != null ? identifier.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingSwapUTIsReport {" +
				"identifier=" + this.identifier +
			'}';
		}
	}

	/*********************** Builder Implementation of ClearingSwapUTIsReport  ***********************/
	class ClearingSwapUTIsReportBuilderImpl implements ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder {
	
		protected String identifier;
		
		@Override
		@RosettaAttribute(value="identifier", isRequired=true)
		@RuneAttribute(value="identifier", isRequired=true)
		public String getIdentifier() {
			return identifier;
		}
		
		@RosettaAttribute(value="identifier", isRequired=true)
		@RuneAttribute(value="identifier", isRequired=true)
		@Override
		public ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder setIdentifier(String _identifier) {
			this.identifier = _identifier == null ? null : _identifier;
			return this;
		}
		
		@Override
		public ClearingSwapUTIsReport build() {
			return new ClearingSwapUTIsReport.ClearingSwapUTIsReportImpl(this);
		}
		
		@Override
		public ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getIdentifier()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder o = (ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder) other;
			
			
			merger.mergeBasic(getIdentifier(), o.getIdentifier(), this::setIdentifier);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ClearingSwapUTIsReport _that = getType().cast(o);
		
			if (!Objects.equals(identifier, _that.getIdentifier())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (identifier != null ? identifier.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ClearingSwapUTIsReportBuilder {" +
				"identifier=" + this.identifier +
			'}';
		}
	}
}
