package drr.regulation.cftc.rewrite.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class CFTCPart43LabelProvider extends GraphBasedLabelProvider {
	public CFTCPart43LabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("cleared"), "01 Cleared");
		startNode.addLabel(Arrays.asList("counterparty1"), "13 Counterparty 1");
		startNode.addLabel(Arrays.asList("counterparty2"), "14 Counterparty 2");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierSource"), "15 Counterparty 2 identifier source");
		startNode.addLabel(Arrays.asList("submitterIdentifier"), "22 Submitter identifier");
		startNode.addLabel(Arrays.asList("customBasketIndicator"), "25 Custom basket indicator");
		startNode.addLabel(Arrays.asList("actionType"), "26 Action type");
		startNode.addLabel(Arrays.asList("eventType"), "27 Event type");
		startNode.addLabel(Arrays.asList("amendmentIndicator"), "28 Amendment indicator");
		startNode.addLabel(Arrays.asList("eventTimestamp"), "30 Event timestamp");
		startNode.addLabel(Arrays.asList("notionalAmountLeg1"), "31 Notional amount-Leg 1");
		startNode.addLabel(Arrays.asList("notionalAmountLeg2"), "31 Notional amount-Leg 2");
		startNode.addLabel(Arrays.asList("notionalCurrencyLeg1"), "32 Notional currency-Leg 1");
		startNode.addLabel(Arrays.asList("notionalCurrencyLeg2"), "32 Notional currency-Leg 2");
		startNode.addLabel(Arrays.asList("callAmount"), "36 Call amount");
		startNode.addLabel(Arrays.asList("callCurrency"), "37 Call currency");
		startNode.addLabel(Arrays.asList("putAmount"), "38 Put Amount");
		startNode.addLabel(Arrays.asList("putCurrency"), "39 Put currency");
		startNode.addLabel(Arrays.asList("notionalQuantityLeg1"), "40 Notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("notionalQuantityLeg2"), "40 Notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("quantityFrequencyLeg1"), "41 Quantity frequency-Leg 1");
		startNode.addLabel(Arrays.asList("quantityFrequencyLeg2"), "41 Quantity frequency-Leg 2");
		startNode.addLabel(Arrays.asList("quantityFrequencyMultiplierLeg1"), "42 Quantity frequency multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("quantityFrequencyMultiplierLeg2"), "42 Quantity frequency multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureLeg1"), "43 Quantity unit of measure-Leg 1");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureLeg2"), "43 Quantity unit of measure-Leg 2");
		startNode.addLabel(Arrays.asList("totalNotionalQuantityLeg1"), "44 Total notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("totalNotionalQuantityLeg2"), "44 Total notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("packageIndicator"), "45 Package Indicator");
		startNode.addLabel(Arrays.asList("packageTransactionPrice"), "47 Package Transaction Price");
		startNode.addLabel(Arrays.asList("packageTransactionPriceCurrency"), "48 Package Transaction Price Currency");
		startNode.addLabel(Arrays.asList("packageTransactionPriceNotation"), "49 Package Transaction Price Notation");
		startNode.addLabel(Arrays.asList("packageTransactionSpread"), "50 Package Transaction Spread");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadCurrency"), "51 Package Transaction Spread Currency");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadNotation"), "52 Package Transaction Spread Notation");
		startNode.addLabel(Arrays.asList("fixedRateDayCountConventionLeg1"), "53 Fixed rate day count convention-Leg 1");
		startNode.addLabel(Arrays.asList("fixedRateDayCountConventionLeg2"), "53 Fixed rate day count convention-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateDayCountConventionLeg1"), "53 Floating rate day count convention-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateDayCountConventionLeg2"), "53 Floating rate day count convention-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodLeg1"), "55 Floating rate reset frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodLeg2"), "55 Floating rate reset frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodMultiplierLeg1"), "56 Floating rate reset frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodMultiplierLeg2"), "56 Floating rate reset frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodLeg1"), "63 Fixed rate payment frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodLeg2"), "63 Fixed rate payment frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodLeg1"), "63 Floating rate payment frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodLeg2"), "63 Floating rate payment frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), "64 Fixed rate payment frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), "64 Fixed rate payment frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodMultiplierLeg1"), "64 Floating rate payment frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodMultiplierLeg2"), "64 Floating rate payment frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("exchangeRateLeg1"), "65 Exchange rate-Leg 1");
		startNode.addLabel(Arrays.asList("exchangeRateBasis"), "66 Exchange rate basis");
		startNode.addLabel(Arrays.asList("fixedRateLeg1"), "67 Fixed rate-Leg 1");
		startNode.addLabel(Arrays.asList("fixedRateLeg2"), "67 Fixed rate-Leg 2");
		startNode.addLabel(Arrays.asList("postPricedSwapIndicator"), "68 Post-priced swap indicator");
		startNode.addLabel(Arrays.asList("price"), "69 Price");
		startNode.addLabel(Arrays.asList("priceCurrency"), "70 Price currency");
		startNode.addLabel(Arrays.asList("priceNotation"), "71 Price notation");
		startNode.addLabel(Arrays.asList("priceUnitOfMeasure"), "72 Price unit of measure");
		startNode.addLabel(Arrays.asList("spreadLeg1"), "73 Spread-Leg 1");
		startNode.addLabel(Arrays.asList("spreadLeg2"), "73 Spread-Leg 2");
		startNode.addLabel(Arrays.asList("spreadCurrencyLeg1"), "74 Spread currency-Leg 1");
		startNode.addLabel(Arrays.asList("spreadCurrencyLeg2"), "74 Spread currency-Leg 2");
		startNode.addLabel(Arrays.asList("spreadNotationLeg1"), "75 Spread notation-Leg 1");
		startNode.addLabel(Arrays.asList("spreadNotationLeg2"), "75 Spread notation-Leg 2");
		startNode.addLabel(Arrays.asList("strikePrice"), "76 Strike Price");
		startNode.addLabel(Arrays.asList("strikePriceCurrency"), "77 Strike Price Currency");
		startNode.addLabel(Arrays.asList("strikePriceNotation"), "78 Strike Price notation");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "79 Option Premium Amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "80 Option Premium Currency");
		startNode.addLabel(Arrays.asList("firstExerciseDate"), "82 First exercise date");
		startNode.addLabel(Arrays.asList("indexFactor"), "85 Index factor");
		startNode.addLabel(Arrays.asList("embeddedOptionType"), "86 Embedded Option Type");
		startNode.addLabel(Arrays.asList("uniqueProductIdentifier"), "87 Unique product identifier");
		startNode.addLabel(Arrays.asList("settlementCurrencyLeg1"), "89 Settlement Currency Leg 1");
		startNode.addLabel(Arrays.asList("settlementCurrencyLeg2"), "89 Settlement Currency Leg 2");
		startNode.addLabel(Arrays.asList("settlementLocationLeg1"), "90 Settlement Location- Leg 1");
		startNode.addLabel(Arrays.asList("settlementLocationLeg2"), "90 Settlement Location- Leg 2");
		startNode.addLabel(Arrays.asList("nonStandardizedTermIndicator"), "92 Non-standardized Term Indicator");
		startNode.addLabel(Arrays.asList("blockTradeElectionIndicator"), "93 Block Trade Election Indicator");
		startNode.addLabel(Arrays.asList("effectiveDate"), "94 Effective Date");
		startNode.addLabel(Arrays.asList("expirationDate"), "95 Expiration date");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "96 Execution Timestamp");
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "97 Reporting timestamp");
		startNode.addLabel(Arrays.asList("platformIdentifier"), "98 Platform Identifier");
		startNode.addLabel(Arrays.asList("primeBrokerageTransactionIndicator"), "99 Prime brokerage transaction indicator");
		startNode.addLabel(Arrays.asList("uniqueSwapIdentifier"), "102 Unique Swap Identifier (USI)");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifier"), "103 Unique Transaction Identifier (UTI)");
		
		LabelNode cFTCGuidebookPart43Node = new LabelNode();
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("optionType"), "TR Option type");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("optionStyle"), "TR Option Style");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("assetClass"), "TR Asset Class");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("mandatoryClearingIndicator"), "TR Mandatory Clearing Indicator");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("maturityDateOfTheUnderlier"), "TR Maturity Date of the Underlier");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("largeNotionalOffFacilitySwapElectionIndicator"), "TR Large notional off-facility swap election indicator");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("sefOrDcmIndicator"), "TR SEF or DCM indicator");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("sefOrDcmAnonymousExecutionIndicator"), "TR SEF or DCM Anonymous Execution Indicator");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("messageType"), "TR Message Type");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("sdMspIndicatorParty1"), "TR SD MSP Indicator - Counterparty 1");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("sdMspIndicatorParty2"), "TR SD MSP Indicator - Counterparty 2");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("physicalCommodityIndicator"), "TR Physical commodity contract indicator");
		cFTCGuidebookPart43Node.addLabel(Arrays.asList("settlementType"), "TR Settlement Type");
		
		LabelNode cFTCNonReportablePart43Node = new LabelNode();
		cFTCNonReportablePart43Node.addLabel(Arrays.asList("counterparty1Format"), "Counterparty1 Format (non-reportable)");
		cFTCNonReportablePart43Node.addLabel(Arrays.asList("counterparty2Format"), "Counterparty2 Format (non-reportable)");
		
		startNode.addOutgoingEdge("cftcGuidebook", cFTCGuidebookPart43Node);
		startNode.addOutgoingEdge("nonReportable", cFTCNonReportablePart43Node);
	}
}
