package drr.regulation.cftc.rewrite.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.ClearingExceptionsAndExemptionsCounterparty2Report;
import drr.regulation.common.ClearingException;
import drr.regulation.common.ClearingExceptionReason;
import drr.regulation.common.ClearingExceptionReasonEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IntendedToClear;
import drr.regulation.common.functions.IsCleared;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ClearingExceptionsAndExemptionsCounterparty2Rule.ClearingExceptionsAndExemptionsCounterparty2RuleDefault.class)
public abstract class ClearingExceptionsAndExemptionsCounterparty2Rule implements ReportFunction<TransactionReportInstruction, List<? extends ClearingExceptionsAndExemptionsCounterparty2Report>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ClearingExceptionsAndExemptionsCounterparty2ExtractionRule clearingExceptionsAndExemptionsCounterparty2ExtractionRule;
	@Inject protected IntendedToClear intendedToClear;
	@Inject protected IsCleared isCleared;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends ClearingExceptionsAndExemptionsCounterparty2Report> evaluate(TransactionReportInstruction input) {
		List<ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends ClearingExceptionsAndExemptionsCounterparty2Report> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(ClearingExceptionsAndExemptionsCounterparty2Report::build).collect(Collectors.toList());
			objectValidator.validate(ClearingExceptionsAndExemptionsCounterparty2Report.class, output);
		}
		
		return output;
	}

	protected abstract List<ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class ClearingExceptionsAndExemptionsCounterparty2RuleDefault extends ClearingExceptionsAndExemptionsCounterparty2Rule {
		@Override
		protected List<ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder> assignOutput(List<ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> areEqual(MapperS.of(isCleared.evaluate(item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())), MapperS.of(false), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(intendedToClear.evaluate(item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())), MapperS.of(false), CardinalityOperator.All)).get());
			final MapperC<ClearingExceptionReason> thenArg1 = thenArg0
				.mapSingleToList(reportInstruction -> {
					final MapperC<PartyInformation> _thenArg0 = reportInstruction.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation())
						.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), reportInstruction.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), CardinalityOperator.All).get());
					final MapperC<PartyInformation> _thenArg1 = _thenArg0
						.filterItemNullSafe(item -> areEqual(item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<ClearingException>map("getClearingException", reportingRegime -> reportingRegime.getClearingException()).<Boolean>map("getClearingException", clearingException -> clearingException.getClearingException()), MapperS.of(true), CardinalityOperator.Any).get());
					final MapperListOfLists<ReportingRegime> thenArg2 = _thenArg1
						.mapItemToList(item -> item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()));
					final MapperC<ReportingRegime> thenArg3 = thenArg2
						.flattenList();
					final MapperC<ReportingRegime> thenArg4 = thenArg3
						.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.All).get());
					final MapperListOfLists<ClearingExceptionReasonEnum> thenArg5 = thenArg4
						.mapItemToList(item -> item.<ClearingException>map("getClearingException", reportingRegime -> reportingRegime.getClearingException()).<ClearingExceptionReasonEnum>mapC("getClearingExceptionReason", clearingException -> clearingException.getClearingExceptionReason()));
					final MapperC<ClearingExceptionReasonEnum> thenArg6 = thenArg5
						.flattenList();
					return thenArg6
						.mapItem(item -> MapperS.of(ClearingExceptionReason.builder()
							.setExceptionReason(item.get())
							.build()));
				});
			output = toBuilder(thenArg1
				.mapItem(item -> MapperS.of(ClearingExceptionsAndExemptionsCounterparty2Report.builder()
					.setValue(clearingExceptionsAndExemptionsCounterparty2ExtractionRule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
