package drr.regulation.cftc.rewrite.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.observable.asset.Price;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.common.settlement.FixedPrice;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.AveragingStrikeFeature;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStrike;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.CommodityBasisLegWithNoSpread;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FXLeg1;
import drr.regulation.common.functions.FXSwapLeg1;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.InterestRateLeg2FixedFloatSingleCurrency;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsCommodityOption;
import drr.regulation.common.functions.IsCreditDefaultSwap;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.IsEquityForward;
import drr.regulation.common.functions.IsEquityOption;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.IsFXSwap;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.LastAvailableSpotPrice;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.functions.CDECommodityNotional;
import drr.standards.iosco.cde.functions.CDEEquityForwardNotional;
import drr.standards.iosco.cde.functions.CDEEquityOptionNotional;
import drr.standards.iosco.cde.functions.CDEPerformanceNotional;
import drr.standards.iosco.cde.reports.CDECommodityOptionNotionalRule;
import drr.standards.iosco.cde.reports.CDECreditNotionalRule;
import drr.standards.iosco.cde.reports.CDEFXNotionalRule;
import drr.standards.iosco.cde.reports.CDEInterestRateNotionalRule;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(NotionalAmountLeg1Rule.NotionalAmountLeg1RuleDefault.class)
public abstract class NotionalAmountLeg1Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected CDECommodityNotional cDECommodityNotional;
	@Inject protected CDECommodityOptionNotionalRule cDECommodityOptionNotionalRule;
	@Inject protected CDECreditNotionalRule cDECreditNotionalRule;
	@Inject protected CDEEquityForwardNotional cDEEquityForwardNotional;
	@Inject protected CDEEquityOptionNotional cDEEquityOptionNotional;
	@Inject protected CDEFXNotionalRule cDEFXNotionalRule;
	@Inject protected CDEInterestRateNotionalRule cDEInterestRateNotionalRule;
	@Inject protected CDEPerformanceNotional cDEPerformanceNotional;
	@Inject protected CommodityBasisLegWithNoSpread commodityBasisLegWithNoSpread;
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXLeg1 fXLeg1;
	@Inject protected FXSwapLeg1 fXSwapLeg1;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected InterestRateLeg2FixedFloatSingleCurrency interestRateLeg2FixedFloatSingleCurrency;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsCommodityOption isCommodityOption;
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsEquity isEquity;
	@Inject protected IsEquityForward isEquityForward;
	@Inject protected IsEquityOption isEquityOption;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
	@Inject protected LastAvailableSpotPrice lastAvailableSpotPrice;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected TradeForEvent tradeForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class NotionalAmountLeg1RuleDefault extends NotionalAmountLeg1Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<BigDecimal> thenArg = MapperS.of(input)
				.mapSingleToItem(reportableEvent -> {
					final Boolean _boolean = isActionTypeTERM.evaluate(input);
					final MapperS<Trade> _thenArg;
					if ((_boolean == null ? false : _boolean)) {
						_thenArg = MapperS.of(beforeTradeForEvent.evaluate(input));
					} else {
						_thenArg = MapperS.of(tradeForEvent.evaluate(input));
					}
					return _thenArg
						.mapSingleToItem(item -> {
							final Boolean boolean0 = isCommodityOption.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean0 == null ? false : boolean0)) {
								if (exists(MapperS.of(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStrike>map("getStrike", optionExercise -> optionExercise.getStrike()).<Price>map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice())).getOrDefault(false)) {
									return MapperS.of(cDECommodityOptionNotionalRule.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()));
								}
								if (exists(MapperS.of(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStrike>map("getStrike", optionExercise -> optionExercise.getStrike()).<AveragingStrikeFeature>map("getAveragingStrikeFeature", optionStrike -> optionStrike.getAveragingStrikeFeature())).getOrDefault(false)) {
									if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()))).getOrDefault(false)) {
										final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule0 = MapperS.of(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).get();
										return MapperS.of(cDECommodityNotional.evaluate((referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()), lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())));
									}
									final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg0 = MapperS.of(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).<PriceQuantity>mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).get()).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
										.filterItemNullSafe(_item -> exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
									final MapperC<BigDecimal> thenArg1 = thenArg0
										.mapItem(_item -> _item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
									return MapperS.of(thenArg1.get());
								}
								return MapperS.<BigDecimal>ofNull();
							}
							final Boolean boolean1 = isCreditSwaption.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean1 == null ? false : boolean1)) {
								return MapperS.of(cDECreditNotionalRule.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get()));
							}
							if (ComparisonResult.ofNullSafe(MapperS.of(isFXForward.evaluate(productForTrade.evaluate(item.get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isFXOption.evaluate(productForTrade.evaluate(item.get()))))).getOrDefault(false)) {
								if (areEqual(MapperS.of(cDEFXNotionalRule.evaluate(fXLeg1.evaluate(productForTrade.evaluate(item.get())))), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
									return MapperS.of(new BigDecimal("99999999999999999999.99999"));
								}
								return MapperS.of(cDEFXNotionalRule.evaluate(fXLeg1.evaluate(productForTrade.evaluate(item.get()))));
							}
							final Boolean boolean2 = isFXSwap.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean2 == null ? false : boolean2)) {
								if (areEqual(MapperS.of(cDEFXNotionalRule.evaluate(fXSwapLeg1.evaluate(productForTrade.evaluate(item.get())))), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
									return MapperS.of(new BigDecimal("99999999999999999999.99999"));
								}
								return MapperS.of(cDEFXNotionalRule.evaluate(fXSwapLeg1.evaluate(productForTrade.evaluate(item.get()))));
							}
							if (areEqual(MapperS.of(qualify_InterestRate_Option_Swaption.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(cDEInterestRateNotionalRule.evaluate(interestRateLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get())))));
							}
							final Boolean boolean3 = isEquityOption.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean3 == null ? false : boolean3)) {
								return MapperS.of(cDEEquityOptionNotional.evaluate(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).getMulti()));
							}
							final Boolean boolean4 = isEquityForward.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean4 == null ? false : boolean4)) {
								return MapperS.of(cDEEquityForwardNotional.evaluate(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).getMulti()));
							}
							final Boolean boolean5 = isEquity.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean5 == null ? false : boolean5)) {
								return MapperS.of(cDEPerformanceNotional.evaluate(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).getMulti()));
							}
							final Boolean boolean6 = isCreditDefaultSwap.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean6 == null ? false : boolean6)) {
								return MapperS.of(cDECreditNotionalRule.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get()));
							}
							final Boolean boolean7 = qualify_Commodity_Swap_FixedFloat.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
							if ((boolean7 == null ? false : boolean7)) {
								final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule1 = MapperS.of(fixedPriceLeg1.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<ResolvablePriceQuantity>map("getPriceQuantity", fixedPricePayout -> fixedPricePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).get();
								final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = MapperS.of(fixedPriceLeg1.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).<FixedPrice>map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).<ReferenceWithMetaPriceSchedule>map("getPrice", fixedPrice -> fixedPrice.getPrice()).get();
								return MapperS.of(cDECommodityNotional.evaluate((referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()), (referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue())));
							}
							if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swaption.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).getOrDefault(false)) {
								final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule2 = MapperS.of(fixedPriceLeg1.evaluate(underlierForProduct.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).<ResolvablePriceQuantity>map("getPriceQuantity", fixedPricePayout -> fixedPricePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).get();
								final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule1 = MapperS.of(fixedPriceLeg1.evaluate(underlierForProduct.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).<FixedPrice>map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).<ReferenceWithMetaPriceSchedule>map("getPrice", fixedPrice -> fixedPrice.getPrice()).get();
								return MapperS.of(cDECommodityNotional.evaluate((referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()), (referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue())));
							}
							if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swaption.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(MapperS.of(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).getOrDefault(false)) {
								if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()))).getOrDefault(false)) {
									final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule3 = MapperS.of(commodityBasisLegWithNoSpread.evaluate(productForTrade.evaluate(item.get()))).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).get();
									return MapperS.of(cDECommodityNotional.evaluate((referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()), lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())));
								}
								final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg2 = MapperS.of(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg1.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(item.get()))))).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
									.filterItemNullSafe(_item -> exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
								final MapperC<BigDecimal> thenArg3 = thenArg2
									.mapItem(_item -> _item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
								return MapperS.of(thenArg3.get());
							}
							final Boolean boolean8 = qualify_Commodity_Swap_Basis.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
							if ((boolean8 == null ? false : boolean8)) {
								if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()))).getOrDefault(false)) {
									final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule4 = MapperS.of(commodityBasisLegWithNoSpread.evaluate(productForTrade.evaluate(item.get()))).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).get();
									return MapperS.of(cDECommodityNotional.evaluate((referenceWithMetaNonNegativeQuantitySchedule4 == null ? null : referenceWithMetaNonNegativeQuantitySchedule4.getValue()), lastAvailableSpotPrice.evaluate(reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())));
								}
								final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg4 = MapperS.of(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg1.evaluate(productForTrade.evaluate(item.get())))).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
									.filterItemNullSafe(_item -> exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
								final MapperC<BigDecimal> thenArg5 = thenArg4
									.mapItem(_item -> _item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
								return MapperS.of(thenArg5.get());
							}
							final Boolean boolean9 = isFixedFloatZeroCouponSwapKnownAmount.evaluate(productForTrade.evaluate(item.get()));
							if ((boolean9 == null ? false : boolean9)) {
								return MapperS.of(cDEInterestRateNotionalRule.evaluate(interestRateLeg2FixedFloatSingleCurrency.evaluate(productForTrade.evaluate(item.get()))));
							}
							if (areEqual(MapperS.of(qualify_AssetClass_InterestRate.evaluate(MapperS.of(productForTrade.evaluate(item.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
								return MapperS.of(cDEInterestRateNotionalRule.evaluate(interestRateLeg1.evaluate(productForTrade.evaluate(item.get()))));
							}
							return MapperS.<BigDecimal>ofNull();
						});
				});
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
