package drr.regulation.cftc.rewrite.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class CFTCPart45TransactionReportValidator implements Validator<CFTCPart45TransactionReport> {

	private List<ComparisonResult> getComparisonResults(CFTCPart45TransactionReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("cleared", (String) o.getCleared() != null ? 1 : 0, 1, 1), 
				checkCardinality("centralCounterparty", (String) o.getCentralCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingAccountOrigin", (String) o.getClearingAccountOrigin() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingMember", (String) o.getClearingMember() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapUSI", (String) o.getOriginalSwapUSI() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapUTI", (String) o.getOriginalSwapUTI() != null ? 1 : 0, 0, 1), 
				checkCardinality("originalSwapSDRIdentifier", (String) o.getOriginalSwapSDRIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingReceiptTimestamp", (ZonedDateTime) o.getClearingReceiptTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2IdentifierSource", (String) o.getCounterparty2IdentifierSource() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty1FinancialEntityIndicator", (Boolean) o.getCounterparty1FinancialEntityIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty2FinancialEntityIndicator", (Boolean) o.getCounterparty2FinancialEntityIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("buyerIdentifier", (String) o.getBuyerIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("sellerIdentifier", (String) o.getSellerIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("payerIdentifierLeg1", (String) o.getPayerIdentifierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("payerIdentifierLeg2", (String) o.getPayerIdentifierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("receiverIdentifierLeg1", (String) o.getReceiverIdentifierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("receiverIdentifierLeg2", (String) o.getReceiverIdentifierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("submitterIdentifier", (String) o.getSubmitterIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty1FederalEntityIndicator", (Boolean) o.getCounterparty1FederalEntityIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2FederalEntityIndicator", (Boolean) o.getCounterparty2FederalEntityIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("customBasketIndicator", (Boolean) o.getCustomBasketIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("actionType", (String) o.getActionType() != null ? 1 : 0, 1, 1), 
				checkCardinality("eventType", (String) o.getEventType() != null ? 1 : 0, 0, 1), 
				checkCardinality("amendmentIndicator", (Boolean) o.getAmendmentIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventIdentifier", (String) o.getEventIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventTimestamp", (ZonedDateTime) o.getEventTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("notionalAmountLeg1", (BigDecimal) o.getNotionalAmountLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalAmountLeg2", (BigDecimal) o.getNotionalAmountLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyLeg1", (ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyLeg2", (ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("callAmount", (BigDecimal) o.getCallAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("callCurrency", (ISOCurrencyCodeEnum) o.getCallCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("putAmount", (BigDecimal) o.getPutAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("putCurrency", (ISOCurrencyCodeEnum) o.getPutCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalQuantityLeg1", (BigDecimal) o.getNotionalQuantityLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalQuantityLeg2", (BigDecimal) o.getNotionalQuantityLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyLeg1", (String) o.getQuantityFrequencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyLeg2", (String) o.getQuantityFrequencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyMultiplierLeg1", (Integer) o.getQuantityFrequencyMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyMultiplierLeg2", (Integer) o.getQuantityFrequencyMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureLeg1", (String) o.getQuantityUnitOfMeasureLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureLeg2", (String) o.getQuantityUnitOfMeasureLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg1", (BigDecimal) o.getTotalNotionalQuantityLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg2", (BigDecimal) o.getTotalNotionalQuantityLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageIndicator", (Boolean) o.getPackageIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("packageIdentifier", (String) o.getPackageIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPrice", (BigDecimal) o.getPackageTransactionPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPriceCurrency", (ISOCurrencyCodeEnum) o.getPackageTransactionPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPriceNotation", (String) o.getPackageTransactionPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpread", (BigDecimal) o.getPackageTransactionSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadCurrency", (ISOCurrencyCodeEnum) o.getPackageTransactionSpreadCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadNotation", (String) o.getPackageTransactionSpreadNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionLeg1", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionLeg2", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionLeg1", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionLeg2", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixingDateLeg1", (Date) o.getFixingDateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixingDateLeg2", (Date) o.getFixingDateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodLeg1", (String) o.getFloatingRateResetFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodLeg2", (String) o.getFloatingRateResetFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierLeg1", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierLeg2", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodLeg1", (String) o.getFixedRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodLeg2", (String) o.getFixedRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodLeg1", (String) o.getFloatingRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodLeg2", (String) o.getFloatingRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierLeg1", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierLeg2", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierLeg1", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierLeg2", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateLeg1", (BigDecimal) o.getExchangeRateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateBasis", (String) o.getExchangeRateBasis() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateLeg1", (BigDecimal) o.getFixedRateLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateLeg2", (BigDecimal) o.getFixedRateLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("postPricedSwapIndicator", (Boolean) o.getPostPricedSwapIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("price", (BigDecimal) o.getPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceCurrency", (ISOCurrencyCodeEnum) o.getPriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceNotation", (String) o.getPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceUnitOfMeasure", (String) o.getPriceUnitOfMeasure() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg1", (BigDecimal) o.getSpreadLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg2", (BigDecimal) o.getSpreadLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadCurrencyLeg1", (ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadCurrencyLeg2", (ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotationLeg1", (String) o.getSpreadNotationLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadNotationLeg2", (String) o.getSpreadNotationLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePrice", (BigDecimal) o.getStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceCurrency", (String) o.getStrikePriceCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePriceNotation", (String) o.getStrikePriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumAmount", (BigDecimal) o.getOptionPremiumAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumCurrency", (ISOCurrencyCodeEnum) o.getOptionPremiumCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumPaymentDate", (Date) o.getOptionPremiumPaymentDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("firstExerciseDate", (Date) o.getFirstExerciseDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("cDSIndexAttachmentPoint", (BigDecimal) o.getCDSIndexAttachmentPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("cDSIndexDetachmentPoint", (BigDecimal) o.getCDSIndexDetachmentPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("indexFactor", (BigDecimal) o.getIndexFactor() != null ? 1 : 0, 0, 1), 
				checkCardinality("embeddedOptionType", (String) o.getEmbeddedOptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueProductIdentifier", (String) o.getUniqueProductIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("finalContractualSettlementDate", (Date) o.getFinalContractualSettlementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrencyLeg1", (ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrencyLeg2", (ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementLocationLeg1", (String) o.getSettlementLocationLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementLocationLeg2", (String) o.getSettlementLocationLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("allocationIndicator", (String) o.getAllocationIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("nonStandardizedTermIndicator", (Boolean) o.getNonStandardizedTermIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("blockTradeElectionIndicator", (Boolean) o.getBlockTradeElectionIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("effectiveDate", (Date) o.getEffectiveDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("expirationDate", (Date) o.getExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionTimestamp", (ZonedDateTime) o.getExecutionTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("platformIdentifier", (String) o.getPlatformIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("primeBrokerageTransactionIndicator", (Boolean) o.getPrimeBrokerageTransactionIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUSI", (String) o.getPriorUSI() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUTI", (String) o.getPriorUTI() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueSwapIdentifier", (String) o.getUniqueSwapIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueTransactionIdentifier", (String) o.getUniqueTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("jurisdiction", (String) o.getJurisdiction() != null ? 1 : 0, 1, 1), 
				checkCardinality("newSDRIdentifier", (String) o.getNewSDRIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollateralPortfolioCode", (String) o.getInitialMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollateralPortfolioCode", (String) o.getVariationMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("cftcGuidebook", (CFTCGuidebookPart45) o.getCftcGuidebook() != null ? 1 : 0, 1, 1), 
				checkCardinality("nonReportable", (CFTCNonReportablePart45) o.getNonReportable() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CFTCPart45TransactionReport", ValidationResult.ValidationType.CARDINALITY, "CFTCPart45TransactionReport", path, "", res.getError());
				}
				return success("CFTCPart45TransactionReport", ValidationResult.ValidationType.CARDINALITY, "CFTCPart45TransactionReport", path, "");
			})
			.collect(toList());
	}

}
