package drr.regulation.cftc.rewrite.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.NotionalAmountScheduleLeg1Report;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class NotionalAmountScheduleLeg1ReportValidator implements Validator<NotionalAmountScheduleLeg1Report> {

	private List<ComparisonResult> getComparisonResults(NotionalAmountScheduleLeg1Report o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("amount", (BigDecimal) o.getAmount() != null ? 1 : 0, 1, 1), 
				checkCardinality("effectiveDate", (Date) o.getEffectiveDate() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, NotionalAmountScheduleLeg1Report o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("NotionalAmountScheduleLeg1Report", ValidationResult.ValidationType.CARDINALITY, "NotionalAmountScheduleLeg1Report", path, "", res.getError());
				}
				return success("NotionalAmountScheduleLeg1Report", ValidationResult.ValidationType.CARDINALITY, "NotionalAmountScheduleLeg1Report", path, "");
			})
			.collect(toList());
	}

}
