package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("CFTCPart43TransactionReportFloatingRateResetFrequencyPeriodMultiplierCondition")
@ImplementedBy(CFTCPart43TransactionReportFloatingRateResetFrequencyPeriodMultiplierCondition.Default.class)
public interface CFTCPart43TransactionReportFloatingRateResetFrequencyPeriodMultiplierCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportFloatingRateResetFrequencyPeriodMultiplierCondition";
	String DEFINITION = "(if floatingRateResetFrequencyPeriodLeg1 exists and floatingRateResetFrequencyPeriodLeg1 <> \"ADHO\" then floatingRateResetFrequencyPeriodMultiplierLeg1 exists else floatingRateResetFrequencyPeriodMultiplierLeg1 is absent) and (if floatingRateResetFrequencyPeriodLeg2 exists and floatingRateResetFrequencyPeriodLeg2 <> \"ADHO\" then floatingRateResetFrequencyPeriodMultiplierLeg2 exists else floatingRateResetFrequencyPeriodMultiplierLeg2 is absent)";
	
	class Default implements CFTCPart43TransactionReportFloatingRateResetFrequencyPeriodMultiplierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				final ComparisonResult ifThenElseResult0;
				if (exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getFloatingRateResetFrequencyPeriodLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateResetFrequencyPeriodLeg1())).andNullSafe(notEqual(MapperS.of(cFTCPart43TransactionReport).<String>map("getFloatingRateResetFrequencyPeriodLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateResetFrequencyPeriodLeg1()), MapperS.of("ADHO"), CardinalityOperator.Any)).getOrDefault(false)) {
					ifThenElseResult0 = exists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateResetFrequencyPeriodMultiplierLeg1()));
				} else {
					ifThenElseResult0 = notExists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateResetFrequencyPeriodMultiplierLeg1()));
				}
				final ComparisonResult ifThenElseResult1;
				if (exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getFloatingRateResetFrequencyPeriodLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateResetFrequencyPeriodLeg2())).andNullSafe(notEqual(MapperS.of(cFTCPart43TransactionReport).<String>map("getFloatingRateResetFrequencyPeriodLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateResetFrequencyPeriodLeg2()), MapperS.of("ADHO"), CardinalityOperator.Any)).getOrDefault(false)) {
					ifThenElseResult1 = exists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateResetFrequencyPeriodMultiplierLeg2()));
				} else {
					ifThenElseResult1 = notExists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFloatingRateResetFrequencyPeriodMultiplierLeg2()));
				}
				return ifThenElseResult0.andNullSafe(ifThenElseResult1);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportFloatingRateResetFrequencyPeriodMultiplierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
