package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("CFTCPart43TransactionReportQuantityFrequencyMultiplierCondition")
@ImplementedBy(CFTCPart43TransactionReportQuantityFrequencyMultiplierCondition.Default.class)
public interface CFTCPart43TransactionReportQuantityFrequencyMultiplierCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportQuantityFrequencyMultiplierCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Commodity\" then ((if quantityFrequencyLeg1 exists and [\"ONDE\", \"ADHO\"] any <> quantityFrequencyLeg1 then quantityFrequencyMultiplierLeg1 exists else quantityFrequencyMultiplierLeg1 is absent) and (if quantityFrequencyLeg2 exists and [\"ONDE\", \"ADHO\"] any <> quantityFrequencyLeg2 then quantityFrequencyMultiplierLeg2 exists else quantityFrequencyMultiplierLeg2 is absent)) else quantityFrequencyMultiplierLeg1 is absent and quantityFrequencyMultiplierLeg2 is absent";
	
	class Default implements CFTCPart43TransactionReportQuantityFrequencyMultiplierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg1())).andNullSafe(notEqual(MapperC.<String>of(MapperS.of("ONDE"), MapperS.of("ADHO")), MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg1()), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyMultiplierLeg1()));
					} else {
						ifThenElseResult0 = notExists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyMultiplierLeg1()));
					}
					final ComparisonResult ifThenElseResult1;
					if (exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg2())).andNullSafe(notEqual(MapperC.<String>of(MapperS.of("ONDE"), MapperS.of("ADHO")), MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg2()), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyMultiplierLeg2()));
					} else {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyMultiplierLeg2()));
					}
					return ifThenElseResult0.andNullSafe(ifThenElseResult1);
				}
				return notExists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyMultiplierLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<Integer>map("getQuantityFrequencyMultiplierLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyMultiplierLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportQuantityFrequencyMultiplierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
