package drr.regulation.cftc.rewrite.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("CFTCPart45TransactionReportCallCurrencyCondition")
@ImplementedBy(CFTCPart45TransactionReportCallCurrencyCondition.Default.class)
public interface CFTCPart45TransactionReportCallCurrencyCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportCallCurrencyCondition";
	String DEFINITION = "if callAmount exists then callCurrency exists else callCurrency is absent";
	
	class Default implements CFTCPart45TransactionReportCallCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getCallAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallAmount())).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<ISOCurrencyCodeEnum>map("getCallCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallCurrency()));
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<ISOCurrencyCodeEnum>map("getCallCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallCurrency()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportCallCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
