package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("CFTCPart45TransactionReportPaymentFrequencyPeriodMultiplierCondition")
@ImplementedBy(CFTCPart45TransactionReportPaymentFrequencyPeriodMultiplierCondition.Default.class)
public interface CFTCPart45TransactionReportPaymentFrequencyPeriodMultiplierCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportPaymentFrequencyPeriodMultiplierCondition";
	String DEFINITION = "if [\"Credit\", \"InterestRate\", \"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass then ((if fixedRatePaymentFrequencyPeriodLeg1 exists and fixedRatePaymentFrequencyPeriodLeg1 <> \"ADHO\" then fixedRatePaymentFrequencyPeriodMultiplierLeg1 exists else if floatingRatePaymentFrequencyPeriodLeg1 exists and floatingRatePaymentFrequencyPeriodLeg1 <> \"ADHO\" then floatingRatePaymentFrequencyPeriodMultiplierLeg1 exists else fixedRatePaymentFrequencyPeriodMultiplierLeg1 is absent and floatingRatePaymentFrequencyPeriodMultiplierLeg1 is absent) and (if fixedRatePaymentFrequencyPeriodLeg2 exists and fixedRatePaymentFrequencyPeriodLeg2 <> \"ADHO\" then fixedRatePaymentFrequencyPeriodMultiplierLeg2 exists else if floatingRatePaymentFrequencyPeriodLeg2 exists and floatingRatePaymentFrequencyPeriodLeg2 <> \"ADHO\" then floatingRatePaymentFrequencyPeriodMultiplierLeg2 exists else fixedRatePaymentFrequencyPeriodMultiplierLeg2 is absent and floatingRatePaymentFrequencyPeriodMultiplierLeg2 is absent)) else fixedRatePaymentFrequencyPeriodMultiplierLeg1 is absent and floatingRatePaymentFrequencyPeriodMultiplierLeg1 is absent and fixedRatePaymentFrequencyPeriodMultiplierLeg2 is absent and floatingRatePaymentFrequencyPeriodMultiplierLeg2 is absent";
	
	class Default implements CFTCPart45TransactionReportPaymentFrequencyPeriodMultiplierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate"), MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), CardinalityOperator.Any).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getFixedRatePaymentFrequencyPeriodLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodLeg1())).andNullSafe(notEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getFixedRatePaymentFrequencyPeriodLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodLeg1()), MapperS.of("ADHO"), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierLeg1()));
					} else if (exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getFloatingRatePaymentFrequencyPeriodLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodLeg1())).andNullSafe(notEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getFloatingRatePaymentFrequencyPeriodLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodLeg1()), MapperS.of("ADHO"), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()));
					} else {
						ifThenElseResult0 = notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1())));
					}
					final ComparisonResult ifThenElseResult1;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getFixedRatePaymentFrequencyPeriodLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodLeg2())).andNullSafe(notEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getFixedRatePaymentFrequencyPeriodLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodLeg2()), MapperS.of("ADHO"), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierLeg2()));
					} else if (exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getFloatingRatePaymentFrequencyPeriodLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodLeg2())).andNullSafe(notEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getFloatingRatePaymentFrequencyPeriodLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodLeg2()), MapperS.of("ADHO"), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2()));
					} else {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2())));
					}
					return ifThenElseResult0.andNullSafe(ifThenElseResult1);
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()))).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierLeg2()))).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportPaymentFrequencyPeriodMultiplierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
