package drr.regulation.cftc.rewrite.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.ClearingExceptionsAndExemptionsCounterparty2Report;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ClearingExceptionsAndExemptionsCounterparty2ReportOnlyExistsValidator implements ValidatorWithArg<ClearingExceptionsAndExemptionsCounterparty2Report, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ClearingExceptionsAndExemptionsCounterparty2Report> ValidationResult<ClearingExceptionsAndExemptionsCounterparty2Report> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("value", ExistenceChecker.isSet((String) o.getValue()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ClearingExceptionsAndExemptionsCounterparty2Report", ValidationResult.ValidationType.ONLY_EXISTS, "ClearingExceptionsAndExemptionsCounterparty2Report", path, "");
		}
		return failure("ClearingExceptionsAndExemptionsCounterparty2Report", ValidationResult.ValidationType.ONLY_EXISTS, "ClearingExceptionsAndExemptionsCounterparty2Report", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
