package drr.regulation.cftc.tr.reports;

import cdm.event.common.Trade;
import cdm.product.template.AmericanExercise;
import cdm.product.template.BermudaExercise;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStyle;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCap;
import drr.regulation.common.functions.IsFloor;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.TradeForEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(OptionStyleRule.OptionStyleRuleDefault.class)
public abstract class OptionStyleRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCap isCap;
	@Inject protected IsFloor isFloor;
	@Inject protected IsOption isOption;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class OptionStyleRuleDefault extends OptionStyleRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()));
			output = thenArg1
				.mapSingleToItem(item -> {
					if (ComparisonResult.ofNullSafe(MapperS.of(isFloor.evaluate(item.get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCap.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of("EURO");
					}
					final Boolean _boolean = isOption.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle())
							.mapSingleToItem(_item -> {
								if (exists(_item.<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise())).getOrDefault(false)) {
									return MapperS.of("AMER");
								}
								if (exists(_item.<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise())).getOrDefault(false)) {
									return MapperS.of("EURO");
								}
								if (exists(_item.<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise())).getOrDefault(false)) {
									return MapperS.of("BERM");
								}
								return MapperS.<String>ofNull();
							});
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
