package drr.regulation.cftc.tr.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ExecutionVenueTypeEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(SefOrDcmIndicatorRule.SefOrDcmIndicatorRuleDefault.class)
public abstract class SefOrDcmIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class SefOrDcmIndicatorRuleDefault extends SefOrDcmIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<ReportableInformation> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()));
			output = thenArg
				.mapSingleToItem(item -> {
					if (areEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.SEF), CardinalityOperator.All).orNullSafe(areEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.DCM), CardinalityOperator.All)).getOrDefault(false)) {
						return MapperS.of(true);
					}
					return MapperS.of(false);
				}).get();
			
			return output;
		}
	}
}
