package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ClearingExceptionReasonEnum;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ClearingExceptionsAndExemptions.ClearingExceptionsAndExemptionsDefault.class)
public abstract class ClearingExceptionsAndExemptions implements RosettaFunction {

	/**
	* @param clearingExceptionReason 
	* @return result 
	*/
	public String evaluate(ClearingExceptionReasonEnum clearingExceptionReason) {
		String result = doEvaluate(clearingExceptionReason);
		
		return result;
	}

	protected abstract String doEvaluate(ClearingExceptionReasonEnum clearingExceptionReason);

	public static class ClearingExceptionsAndExemptionsDefault extends ClearingExceptionsAndExemptions {
		@Override
		protected String doEvaluate(ClearingExceptionReasonEnum clearingExceptionReason) {
			String result = null;
			return assignOutput(result, clearingExceptionReason);
		}
		
		protected String assignOutput(String result, ClearingExceptionReasonEnum clearingExceptionReason) {
			if (areEqual(MapperS.of(clearingExceptionReason), MapperS.of(ClearingExceptionReasonEnum.END_USER), CardinalityOperator.All).getOrDefault(false)) {
				result = "ENDU";
			} else if (areEqual(MapperS.of(clearingExceptionReason), MapperS.of(ClearingExceptionReasonEnum.INTER_AFFILIATE), CardinalityOperator.All).getOrDefault(false)) {
				result = "AFFL";
			} else if (areEqual(MapperS.of(clearingExceptionReason), MapperS.of(ClearingExceptionReasonEnum.SMALL_BANK), CardinalityOperator.All).getOrDefault(false)) {
				result = "SMBK";
			} else if (areEqual(MapperS.of(clearingExceptionReason), MapperS.of(ClearingExceptionReasonEnum.COOPERATIVE), CardinalityOperator.All).getOrDefault(false)) {
				result = "COOP";
			} else if (areEqual(MapperS.of(clearingExceptionReason), MapperS.of(ClearingExceptionReasonEnum.NO_ACTION_LETTER), CardinalityOperator.All).getOrDefault(false)) {
				result = "NOAL";
			} else if (areEqual(MapperS.of(clearingExceptionReason), MapperS.of(ClearingExceptionReasonEnum.EXCEPTION), CardinalityOperator.All).getOrDefault(false)) {
				result = "OTHR";
			} else {
				result = null;
			}
			
			return result;
		}
	}
}
