package drr.regulation.common.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CommodityQuantity.CommodityQuantityDefault.class)
public abstract class CommodityQuantity implements RosettaFunction {

	/**
	* @param commodityPayout 
	* @return quantity 
	*/
	public BigDecimal evaluate(CommodityPayout commodityPayout) {
		BigDecimal quantity = doEvaluate(commodityPayout);
		
		return quantity;
	}

	protected abstract BigDecimal doEvaluate(CommodityPayout commodityPayout);

	public static class CommodityQuantityDefault extends CommodityQuantity {
		@Override
		protected BigDecimal doEvaluate(CommodityPayout commodityPayout) {
			BigDecimal quantity = null;
			return assignOutput(quantity, commodityPayout);
		}
		
		protected BigDecimal assignOutput(BigDecimal quantity, CommodityPayout commodityPayout) {
			if (exists(MapperS.of(commodityPayout).<ResolvablePriceQuantity>map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).getOrDefault(false)) {
				quantity = MapperS.of(commodityPayout).<ResolvablePriceQuantity>map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get();
			} else {
				quantity = null;
			}
			
			return quantity;
		}
	}
}
