package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Create_PriceReportablePeriod.Create_PriceReportablePeriodDefault.class)
public abstract class Create_PriceReportablePeriod implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param priceValue 
	* @param periodEffectiveDate 
	* @param periodEndDate 
	* @param priceNotation 
	* @return reportablePeriod 
	*/
	public PriceReportablePeriod evaluate(BigDecimal priceValue, Date periodEffectiveDate, Date periodEndDate, PriceNotationEnum priceNotation) {
		PriceReportablePeriod.PriceReportablePeriodBuilder reportablePeriodBuilder = doEvaluate(priceValue, periodEffectiveDate, periodEndDate, priceNotation);
		
		final PriceReportablePeriod reportablePeriod;
		if (reportablePeriodBuilder == null) {
			reportablePeriod = null;
		} else {
			reportablePeriod = reportablePeriodBuilder.build();
			objectValidator.validate(PriceReportablePeriod.class, reportablePeriod);
		}
		
		return reportablePeriod;
	}

	protected abstract PriceReportablePeriod.PriceReportablePeriodBuilder doEvaluate(BigDecimal priceValue, Date periodEffectiveDate, Date periodEndDate, PriceNotationEnum priceNotation);

	public static class Create_PriceReportablePeriodDefault extends Create_PriceReportablePeriod {
		@Override
		protected PriceReportablePeriod.PriceReportablePeriodBuilder doEvaluate(BigDecimal priceValue, Date periodEffectiveDate, Date periodEndDate, PriceNotationEnum priceNotation) {
			PriceReportablePeriod.PriceReportablePeriodBuilder reportablePeriod = PriceReportablePeriod.builder();
			return assignOutput(reportablePeriod, priceValue, periodEffectiveDate, periodEndDate, priceNotation);
		}
		
		protected PriceReportablePeriod.PriceReportablePeriodBuilder assignOutput(PriceReportablePeriod.PriceReportablePeriodBuilder reportablePeriod, BigDecimal priceValue, Date periodEffectiveDate, Date periodEndDate, PriceNotationEnum priceNotation) {
			BigDecimal ifThenElseResult0 = null;
			if (areEqual(MapperS.of(priceNotation), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult0 = priceValue;
			}
			reportablePeriod
				.getOrCreatePeriodValue()
				.setPriceMonetary(ifThenElseResult0);
			
			BigDecimal ifThenElseResult1 = null;
			if (areEqual(MapperS.of(priceNotation), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(priceNotation), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult1 = priceValue;
			}
			reportablePeriod
				.getOrCreatePeriodValue()
				.setPricePercentage(ifThenElseResult1);
			
			reportablePeriod
				.getOrCreatePeriodValue()
				.setPriceNotation(priceNotation);
			
			reportablePeriod
				.setPeriodEffectiveDate(periodEffectiveDate);
			
			reportablePeriod
				.setPeriodEndDate(periodEndDate);
			
			return Optional.ofNullable(reportablePeriod)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
