package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaAssetClassEnum;
import cdm.product.common.settlement.CashSettlementTerms;
import cdm.product.common.settlement.PhysicalSettlementTerms;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option_Cash;
import cdm.product.qualification.functions.Qualify_Commodity_Option_Physical;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDF;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDS;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Spot_Forward;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Swap;
import cdm.product.qualification.functions.Qualify_ForeignExchange_VanillaOption;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(DeliveryTypeForProducts.DeliveryTypeForProductsDefault.class)
public abstract class DeliveryTypeForProducts implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsVarianceSwap isVarianceSwap;
	@Inject protected IsVolatilitySwap isVolatilitySwap;
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected Qualify_Commodity_Option_Cash qualify_Commodity_Option_Cash;
	@Inject protected Qualify_Commodity_Option_Physical qualify_Commodity_Option_Physical;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
	@Inject protected Qualify_ForeignExchange_NDF qualify_ForeignExchange_NDF;
	@Inject protected Qualify_ForeignExchange_NDS qualify_ForeignExchange_NDS;
	@Inject protected Qualify_ForeignExchange_Spot_Forward qualify_ForeignExchange_Spot_Forward;
	@Inject protected Qualify_ForeignExchange_Swap qualify_ForeignExchange_Swap;
	@Inject protected Qualify_ForeignExchange_VanillaOption qualify_ForeignExchange_VanillaOption;
	@Inject protected SettlementTermsLeg1 settlementTermsLeg1;
	@Inject protected SettlementTermsLeg2 settlementTermsLeg2;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @return deliveryType 
	*/
	public String evaluate(Product product) {
		String deliveryType = doEvaluate(product);
		
		return deliveryType;
	}

	protected abstract String doEvaluate(Product product);

	protected abstract MapperS<? extends SettlementTerms> settlementLeg(Product product);

	protected abstract MapperS<String> deliveryTypeFromSettlementLeg(Product product);

	public static class DeliveryTypeForProductsDefault extends DeliveryTypeForProducts {
		@Override
		protected String doEvaluate(Product product) {
			String deliveryType = null;
			return assignOutput(deliveryType, product);
		}
		
		protected String assignOutput(String deliveryType, Product product) {
			if (areEqual(MapperC.<String>of(MapperS.of("CASH"), MapperS.of("PHYS"), MapperS.of("OPTL")), deliveryTypeFromSettlementLeg(product), CardinalityOperator.Any).getOrDefault(false)) {
				deliveryType = deliveryTypeFromSettlementLeg(product).get();
			} else {
				final Boolean boolean0 = qualify_AssetClass_InterestRate.evaluate(economicTermsForProduct.evaluate(product));
				if ((boolean0 == null ? false : boolean0)) {
					deliveryType = "PHYS";
				} else {
					final Boolean boolean1 = qualify_AssetClass_Equity.evaluate(economicTermsForProduct.evaluate(product));
					if ((boolean1 == null ? false : boolean1)) {
						if (ComparisonResult.ofNullSafe(MapperS.of(isVarianceSwap.evaluate(product))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isVolatilitySwap.evaluate(product)))).orNullSafe(areEqual(MapperS.of(product).<Index>map("getIndex", _product -> _product.getIndex()).<ProductTaxonomy>mapC("getProductTaxonomy", index -> index.getProductTaxonomy()).<FieldWithMetaAssetClassEnum>map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).<AssetClassEnum>map("Type coercion", fieldWithMetaAssetClassEnum -> fieldWithMetaAssetClassEnum.getValue()), MapperS.of(AssetClassEnum.EQUITY), CardinalityOperator.Any)).orNullSafe(areEqual(MapperS.of(underlierForProduct.evaluate(product)).<Index>map("getIndex", _product -> _product.getIndex()).<ProductTaxonomy>mapC("getProductTaxonomy", index -> index.getProductTaxonomy()).<FieldWithMetaAssetClassEnum>map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).<AssetClassEnum>map("Type coercion", fieldWithMetaAssetClassEnum -> fieldWithMetaAssetClassEnum.getValue()), MapperS.of(AssetClassEnum.EQUITY), CardinalityOperator.Any)).getOrDefault(false)) {
							deliveryType = "CASH";
						} else {
							deliveryType = null;
						}
					} else {
						final Boolean boolean2 = qualify_AssetClass_Credit.evaluate(economicTermsForProduct.evaluate(product));
						if ((boolean2 == null ? false : boolean2)) {
							deliveryType = "OPTL";
						} else {
							final Boolean boolean3 = qualify_AssetClass_ForeignExchange.evaluate(economicTermsForProduct.evaluate(product));
							if ((boolean3 == null ? false : boolean3)) {
								if (ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_NDF.evaluate(economicTermsForProduct.evaluate(product)))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_NDS.evaluate(economicTermsForProduct.evaluate(product))))).getOrDefault(false)) {
									deliveryType = "CASH";
								} else if (ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_Swap.evaluate(economicTermsForProduct.evaluate(product)))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_Spot_Forward.evaluate(economicTermsForProduct.evaluate(product))))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_VanillaOption.evaluate(economicTermsForProduct.evaluate(product))))).getOrDefault(false)) {
									deliveryType = "PHYS";
								} else {
									deliveryType = null;
								}
							} else {
								final Boolean boolean4 = qualify_AssetClass_Commodity.evaluate(economicTermsForProduct.evaluate(product));
								if ((boolean4 == null ? false : boolean4)) {
									if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(product)))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(product))))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Option_Cash.evaluate(economicTermsForProduct.evaluate(product))))).getOrDefault(false)) {
										deliveryType = "CASH";
									} else if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Forward.evaluate(economicTermsForProduct.evaluate(product)))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Option_Physical.evaluate(economicTermsForProduct.evaluate(product))))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(product))))).getOrDefault(false)) {
										deliveryType = "PHYS";
									} else {
										deliveryType = null;
									}
								} else {
									deliveryType = null;
								}
							}
						}
					}
				}
			}
			
			return deliveryType;
		}
		
		@Override
		protected MapperS<? extends SettlementTerms> settlementLeg(Product product) {
			if (exists(MapperS.of(settlementTermsLeg1.evaluate(product))).getOrDefault(false)) {
				return MapperS.of(settlementTermsLeg1.evaluate(product));
			}
			return MapperS.of(settlementTermsLeg2.evaluate(product));
		}
		
		@Override
		protected MapperS<String> deliveryTypeFromSettlementLeg(Product product) {
			if (areEqual(settlementLeg(product).<SettlementTypeEnum>map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.CASH), CardinalityOperator.All).orNullSafe(exists(settlementLeg(product).<CashSettlementTerms>mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()))).getOrDefault(false)) {
				return MapperS.of("CASH");
			}
			if (areEqual(settlementLeg(product).<SettlementTypeEnum>map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.PHYSICAL), CardinalityOperator.All).orNullSafe(exists(settlementLeg(product).<PhysicalSettlementTerms>map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()))).getOrDefault(false)) {
				return MapperS.of("PHYS");
			}
			if (areEqual(settlementLeg(product).<SettlementTypeEnum>map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.CASH_OR_PHYSICAL), CardinalityOperator.All).orNullSafe(areEqual(settlementLeg(product).<SettlementTypeEnum>map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), MapperS.of(SettlementTypeEnum.ELECTION), CardinalityOperator.All)).getOrDefault(false)) {
				return MapperS.of("OPTL");
			}
			return MapperS.<String>ofNull();
		}
	}
}
