package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Security;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(InterestRateLeg1.InterestRateLeg1Default.class)
public abstract class InterestRateLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected InterestRateLeg1Basis interestRateLeg1Basis;
	@Inject protected InterestRateLeg1CapFloor interestRateLeg1CapFloor;
	@Inject protected InterestRateLeg1CrossCurrency interestRateLeg1CrossCurrency;
	@Inject protected InterestRateLeg1FixedFixed interestRateLeg1FixedFixed;
	@Inject protected InterestRateLeg1FixedFloatSingleCurrency interestRateLeg1FixedFloatSingleCurrency;
	@Inject protected InterestRateLeg1ZeroCouponSwapKnownAmount interestRateLeg1ZeroCouponSwapKnownAmount;
	@Inject protected IsCapFloor isCapFloor;
	@Inject protected IsCreditDefaultSwap isCreditDefaultSwap;
	@Inject protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
	@Inject protected IsInterestRateBasis isInterestRateBasis;
	@Inject protected IsInterestRateCrossCurrency isInterestRateCrossCurrency;
	@Inject protected IsInterestRateFixedFixed isInterestRateFixedFixed;
	@Inject protected IsInterestRateFixedFloatSingleCurrency isInterestRateFixedFloatSingleCurrency;
	@Inject protected IsInterestRateReturnSwap isInterestRateReturnSwap;

	/**
	* @param product 
	* @return interestRateLeg1 
	*/
	public InterestRatePayout evaluate(Product product) {
		InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1Builder = doEvaluate(product);
		
		final InterestRatePayout interestRateLeg1;
		if (interestRateLeg1Builder == null) {
			interestRateLeg1 = null;
		} else {
			interestRateLeg1 = interestRateLeg1Builder.build();
			objectValidator.validate(InterestRatePayout.class, interestRateLeg1);
		}
		
		return interestRateLeg1;
	}

	protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product);

	public static class InterestRateLeg1Default extends InterestRateLeg1 {
		@Override
		protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
			InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1 = InterestRatePayout.builder();
			return assignOutput(interestRateLeg1, product);
		}
		
		protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1, Product product) {
			final Boolean boolean0 = isFixedFloatZeroCouponSwapKnownAmount.evaluate(product);
			if ((boolean0 == null ? false : boolean0)) {
				interestRateLeg1 = toBuilder(interestRateLeg1ZeroCouponSwapKnownAmount.evaluate(product));
			} else {
				final Boolean boolean1 = isInterestRateFixedFloatSingleCurrency.evaluate(product);
				if ((boolean1 == null ? false : boolean1)) {
					interestRateLeg1 = toBuilder(interestRateLeg1FixedFloatSingleCurrency.evaluate(product));
				} else {
					final Boolean boolean2 = isInterestRateCrossCurrency.evaluate(product);
					if ((boolean2 == null ? false : boolean2)) {
						interestRateLeg1 = toBuilder(interestRateLeg1CrossCurrency.evaluate(product));
					} else {
						final Boolean boolean3 = isInterestRateFixedFixed.evaluate(product);
						if ((boolean3 == null ? false : boolean3)) {
							interestRateLeg1 = toBuilder(interestRateLeg1FixedFixed.evaluate(product));
						} else {
							final Boolean boolean4 = isInterestRateBasis.evaluate(product);
							if ((boolean4 == null ? false : boolean4)) {
								interestRateLeg1 = toBuilder(interestRateLeg1Basis.evaluate(product));
							} else {
								final Boolean boolean5 = isCapFloor.evaluate(product);
								if ((boolean5 == null ? false : boolean5)) {
									interestRateLeg1 = toBuilder(interestRateLeg1CapFloor.evaluate(product));
								} else {
									final Boolean boolean6 = isCreditDefaultSwap.evaluate(product);
									if ((boolean6 == null ? false : boolean6)) {
										interestRateLeg1 = toBuilder(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get());
									} else {
										final Boolean boolean7 = isInterestRateReturnSwap.evaluate(product);
										if ((boolean7 == null ? false : boolean7)) {
											if (exists(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct())).getOrDefault(false)) {
												interestRateLeg1 = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get());
											} else if (exists(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Security>map("getSecurity", _product -> _product.getSecurity())).getOrDefault(false)) {
												interestRateLeg1 = toBuilder(MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<Security>map("getSecurity", _product -> _product.getSecurity()).<EconomicTerms>map("getEconomicTerms", security -> security.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get());
											} else {
												interestRateLeg1 = null;
											}
										} else {
											interestRateLeg1 = null;
										}
									}
								}
							}
						}
					}
				}
			}
			
			return Optional.ofNullable(interestRateLeg1)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
