package drr.regulation.common.functions;

import cdm.event.common.ActionEnum;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableActionEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(IsActionTypeEROR.IsActionTypeERORDefault.class)
public abstract class IsActionTypeEROR implements RosettaFunction {

	/**
	* @param reportableEvent 
	* @return isActionTypeEror 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isActionTypeEror = doEvaluate(reportableEvent);
		
		return isActionTypeEror;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<ActionEnum> workflowStepAction(ReportableEvent reportableEvent);

	protected abstract MapperS<ReportableActionEnum> reportingAction(ReportableEvent reportableEvent);

	public static class IsActionTypeERORDefault extends IsActionTypeEROR {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isActionTypeEror = null;
			return assignOutput(isActionTypeEror, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isActionTypeEror, ReportableEvent reportableEvent) {
			isActionTypeEror = exists(reportingAction(reportableEvent)).andNullSafe(areEqual(reportingAction(reportableEvent), MapperS.of(ReportableActionEnum.ERROR), CardinalityOperator.All)).orNullSafe(areEqual(workflowStepAction(reportableEvent), MapperS.of(ActionEnum.CANCEL), CardinalityOperator.All)).get();
			
			return isActionTypeEror;
		}
		
		@Override
		protected MapperS<ActionEnum> workflowStepAction(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<ActionEnum>map("getAction", workflowStep -> workflowStep.getAction());
		}
		
		@Override
		protected MapperS<ReportableActionEnum> reportingAction(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<ReportableActionEnum>map("getReportableAction", reportableInformation -> reportableInformation.getReportableAction());
		}
	}
}
