package drr.regulation.common.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.qualification.functions.Qualify_ValuationUpdate;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import javax.inject.Inject;


@ImplementedBy(IsActionTypeVALU.IsActionTypeVALUDefault.class)
public abstract class IsActionTypeVALU implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected Qualify_ValuationUpdate qualify_ValuationUpdate;

	/**
	* @param reportableEvent 
	* @return isActionTypeValu 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isActionTypeValu = doEvaluate(reportableEvent);
		
		return isActionTypeValu;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	public static class IsActionTypeVALUDefault extends IsActionTypeVALU {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isActionTypeValu = null;
			return assignOutput(isActionTypeValu, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isActionTypeValu, ReportableEvent reportableEvent) {
			isActionTypeValu = qualify_ValuationUpdate.evaluate(MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).get());
			
			return isActionTypeValu;
		}
	}
}
