package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ActionTypeEnum;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(IsVRAllowedForActionType.IsVRAllowedForActionTypeDefault.class)
public abstract class IsVRAllowedForActionType implements RosettaFunction {

	/**
	* @param actionTypefromTrade 
	* @return validActionType 
	*/
	public Boolean evaluate(String actionTypefromTrade) {
		Boolean validActionType = doEvaluate(actionTypefromTrade);
		
		return validActionType;
	}

	protected abstract Boolean doEvaluate(String actionTypefromTrade);

	public static class IsVRAllowedForActionTypeDefault extends IsVRAllowedForActionType {
		@Override
		protected Boolean doEvaluate(String actionTypefromTrade) {
			Boolean validActionType = null;
			return assignOutput(validActionType, actionTypefromTrade);
		}
		
		protected Boolean assignOutput(Boolean validActionType, String actionTypefromTrade) {
			validActionType = areEqual(MapperS.of(actionTypefromTrade), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(actionTypefromTrade), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(actionTypefromTrade), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(actionTypefromTrade), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All)).orNullSafe(areEqual(MapperS.of(actionTypefromTrade), MapperS.of(ActionTypeEnum.POSC).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All)).get();
			
			return validActionType;
		}
	}
}
