package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.PayoutLeg;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.ReportableInformation;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PayoutLeg2.PayoutLeg2Default.class)
public abstract class PayoutLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityBasisLegWithNoSpread commodityBasisLegWithNoSpread;
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXLeg2 fXLeg2;
	@Inject protected FXSwapLeg2 fXSwapLeg2;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected LastAvailableSpotPrice lastAvailableSpotPrice;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @param tradeLot 
	* @param reportableInformation 
	* @return payoutLeg 
	*/
	public PayoutLegWithAuxiliary evaluate(Product product, TradeLot tradeLot, ReportableInformation reportableInformation) {
		PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder payoutLegBuilder = doEvaluate(product, tradeLot, reportableInformation);
		
		final PayoutLegWithAuxiliary payoutLeg;
		if (payoutLegBuilder == null) {
			payoutLeg = null;
		} else {
			payoutLeg = payoutLegBuilder.build();
			objectValidator.validate(PayoutLegWithAuxiliary.class, payoutLeg);
		}
		
		return payoutLeg;
	}

	protected abstract PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder doEvaluate(Product product, TradeLot tradeLot, ReportableInformation reportableInformation);

	public static class PayoutLeg2Default extends PayoutLeg2 {
		@Override
		protected PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder doEvaluate(Product product, TradeLot tradeLot, ReportableInformation reportableInformation) {
			PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder payoutLeg = PayoutLegWithAuxiliary.builder();
			return assignOutput(payoutLeg, product, tradeLot, reportableInformation);
		}
		
		protected PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder assignOutput(PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder payoutLeg, Product product, TradeLot tradeLot, ReportableInformation reportableInformation) {
			final Boolean boolean0 = qualify_InterestRate_Option_Swaption.evaluate(economicTermsForProduct.evaluate(product));
			if ((boolean0 == null ? false : boolean0)) {
				payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
					.setInterestRatePayout(interestRateLeg2.evaluate(underlierForProduct.evaluate(product)))
					.build());
			} else if (ComparisonResult.ofNullSafe(MapperS.of(isFXForward.evaluate(product))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isFXOption.evaluate(product)))).getOrDefault(false)) {
				payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
					.setCashflow(fXLeg2.evaluate(product))
					.build());
			} else {
				final Boolean boolean1 = isFXSwap.evaluate(product);
				if ((boolean1 == null ? false : boolean1)) {
					payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
						.setCashflow(fXSwapLeg2.evaluate(product))
						.build());
				} else {
					final Boolean boolean2 = qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(product));
					if ((boolean2 == null ? false : boolean2)) {
						payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
							.setCommodityPayout(commodityLeg2.evaluate(product))
							.setAuxiliaryLeg(PayoutLeg.builder()
								.setFixedPricePayout(fixedPriceLeg1.evaluate(product))
								.build())
							.build());
					} else {
						final Boolean boolean3 = qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(product));
						if ((boolean3 == null ? false : boolean3)) {
							final CommodityPayout ifThenElseResult;
							if (exists(MapperS.of(lastAvailableSpotPrice.evaluate(reportableInformation))).getOrDefault(false)) {
								ifThenElseResult = commodityBasisLegWithNoSpread.evaluate(product);
							} else {
								ifThenElseResult = commodityLeg2.evaluate(product);
							}
							payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
								.setCommodityPayout(ifThenElseResult)
								.setTradeLot(tradeLot)
								.setLastAvailableSpotPrice(lastAvailableSpotPrice.evaluate(reportableInformation))
								.build());
						} else {
							final Boolean boolean4 = isCommodityFixedPriceForward.evaluate(product);
							if ((boolean4 == null ? false : boolean4)) {
								payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
									.setForwardPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())
									.setAuxiliaryLeg(PayoutLeg.builder()
										.setFixedPricePayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get())
										.build())
									.build());
							} else {
								final Boolean boolean5 = isCommodityFloatingPriceForward.evaluate(product);
								if ((boolean5 == null ? false : boolean5)) {
									payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
										.setForwardPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())
										.setAuxiliaryLeg(PayoutLeg.builder()
											.setCommodityPayout(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())
											.build())
										.setTradeLot(tradeLot)
										.setLastAvailableSpotPrice(lastAvailableSpotPrice.evaluate(reportableInformation))
										.build());
								} else if (ComparisonResult.ofNullSafe(MapperS.of(qualify_AssetClass_InterestRate.evaluate(economicTermsForProduct.evaluate(product)))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_AssetClass_Equity.evaluate(economicTermsForProduct.evaluate(product))))).getOrDefault(false)) {
									payoutLeg = toBuilder(PayoutLegWithAuxiliary.builder()
										.setInterestRatePayout(interestRateLeg2.evaluate(product))
										.build());
								} else {
									payoutLeg = null;
								}
							}
						}
					}
				}
			}
			
			return Optional.ofNullable(payoutLeg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
