package drr.regulation.common.functions;

import cdm.base.datetime.CalculationPeriodFrequency;
import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(QuantityFrequencyOrCalculationPeriod.QuantityFrequencyOrCalculationPeriodDefault.class)
public abstract class QuantityFrequencyOrCalculationPeriod implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param calculationPeriodDates 
	* @param priceQuantity 
	* @return frequency 
	*/
	public Frequency evaluate(CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity) {
		Frequency.FrequencyBuilder frequencyBuilder = doEvaluate(calculationPeriodDates, priceQuantity);
		
		final Frequency frequency;
		if (frequencyBuilder == null) {
			frequency = null;
		} else {
			frequency = frequencyBuilder.build();
			objectValidator.validate(Frequency.class, frequency);
		}
		
		return frequency;
	}

	protected abstract Frequency.FrequencyBuilder doEvaluate(CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity);

	protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity);

	public static class QuantityFrequencyOrCalculationPeriodDefault extends QuantityFrequencyOrCalculationPeriod {
		@Override
		protected Frequency.FrequencyBuilder doEvaluate(CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity) {
			Frequency.FrequencyBuilder frequency = Frequency.builder();
			return assignOutput(frequency, calculationPeriodDates, priceQuantity);
		}
		
		protected Frequency.FrequencyBuilder assignOutput(Frequency.FrequencyBuilder frequency, CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity) {
			if (notEqual(MapperS.of(quantity(calculationPeriodDates, priceQuantity).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).<PeriodExtendedEnum>map("getPeriod", _frequency -> _frequency.getPeriod()).get()), MapperS.of(PeriodExtendedEnum.C), CardinalityOperator.Any).getOrDefault(false)) {
				frequency = toBuilder(quantity(calculationPeriodDates, priceQuantity).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).get());
			} else if (areEqual(MapperS.of(quantity(calculationPeriodDates, priceQuantity).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).<PeriodExtendedEnum>map("getPeriod", _frequency -> _frequency.getPeriod()).get()), MapperS.of(PeriodExtendedEnum.C), CardinalityOperator.All).getOrDefault(false)) {
				frequency = toBuilder(MapperS.of(calculationPeriodDates).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", _calculationPeriodDates -> _calculationPeriodDates.getCalculationPeriodFrequency()).get());
			} else {
				frequency = null;
			}
			
			return Optional.ofNullable(frequency)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity) {
			return MapperS.of(priceQuantity).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity())
				.filterItemNullSafe(item -> exists(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).orNullSafe(areEqual(MapperS.of(distinct(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue())).resultCount()), MapperS.of(1), CardinalityOperator.All)).get());
		}
	}
}
