package drr.regulation.common.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.validation.QuantityReportablePeriodTypeFormatValidator;
import drr.regulation.common.validation.QuantityReportablePeriodValidator;
import drr.regulation.common.validation.exists.QuantityReportablePeriodOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.57.0
 */
@RosettaMeta(model=QuantityReportablePeriod.class)
public class QuantityReportablePeriodMeta implements RosettaMetaData<QuantityReportablePeriod> {

	@Override
	public List<Validator<? super QuantityReportablePeriod>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super QuantityReportablePeriod, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super QuantityReportablePeriod> validator(ValidatorFactory factory) {
		return factory.<QuantityReportablePeriod>create(QuantityReportablePeriodValidator.class);
	}

	@Override
	public Validator<? super QuantityReportablePeriod> typeFormatValidator(ValidatorFactory factory) {
		return factory.<QuantityReportablePeriod>create(QuantityReportablePeriodTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super QuantityReportablePeriod> validator() {
		return new QuantityReportablePeriodValidator();
	}

	@Deprecated
	@Override
	public Validator<? super QuantityReportablePeriod> typeFormatValidator() {
		return new QuantityReportablePeriodTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super QuantityReportablePeriod, Set<String>> onlyExistsValidator() {
		return new QuantityReportablePeriodOnlyExistsValidator();
	}
}
