package drr.regulation.esma.emir.refit.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.esma.emir.refit.trade.meta.SpreadOfLeg1Meta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.57.0
 */
@RosettaDataType(value="SpreadOfLeg1", builder=SpreadOfLeg1.SpreadOfLeg1BuilderImpl.class, version="5.57.0")
@RuneDataType(value="SpreadOfLeg1", model="drr", builder=SpreadOfLeg1.SpreadOfLeg1BuilderImpl.class, version="5.57.0")
public interface SpreadOfLeg1 extends RosettaModelObject {

	SpreadOfLeg1Meta metaData = new SpreadOfLeg1Meta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getSpreadOfLeg1Monetary();
	BigDecimal getSpreadOfLeg1Percentage();
	BigDecimal getSpreadOfLeg1Basis();
	ISOCurrencyCodeEnum getSpreadCurrencyOfLeg1();
	PriceNotationEnum getSpreadOfLeg1Notation();

	/*********************** Build Methods  ***********************/
	SpreadOfLeg1 build();
	
	SpreadOfLeg1.SpreadOfLeg1Builder toBuilder();
	
	static SpreadOfLeg1.SpreadOfLeg1Builder builder() {
		return new SpreadOfLeg1.SpreadOfLeg1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SpreadOfLeg1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends SpreadOfLeg1> getType() {
		return SpreadOfLeg1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("spreadOfLeg1Monetary"), BigDecimal.class, getSpreadOfLeg1Monetary(), this);
		processor.processBasic(path.newSubPath("spreadOfLeg1Percentage"), BigDecimal.class, getSpreadOfLeg1Percentage(), this);
		processor.processBasic(path.newSubPath("spreadOfLeg1Basis"), BigDecimal.class, getSpreadOfLeg1Basis(), this);
		processor.processBasic(path.newSubPath("spreadCurrencyOfLeg1"), ISOCurrencyCodeEnum.class, getSpreadCurrencyOfLeg1(), this);
		processor.processBasic(path.newSubPath("spreadOfLeg1Notation"), PriceNotationEnum.class, getSpreadOfLeg1Notation(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface SpreadOfLeg1Builder extends SpreadOfLeg1, RosettaModelObjectBuilder {
		SpreadOfLeg1.SpreadOfLeg1Builder setSpreadOfLeg1Monetary(BigDecimal spreadOfLeg1Monetary);
		SpreadOfLeg1.SpreadOfLeg1Builder setSpreadOfLeg1Percentage(BigDecimal spreadOfLeg1Percentage);
		SpreadOfLeg1.SpreadOfLeg1Builder setSpreadOfLeg1Basis(BigDecimal spreadOfLeg1Basis);
		SpreadOfLeg1.SpreadOfLeg1Builder setSpreadCurrencyOfLeg1(ISOCurrencyCodeEnum spreadCurrencyOfLeg1);
		SpreadOfLeg1.SpreadOfLeg1Builder setSpreadOfLeg1Notation(PriceNotationEnum spreadOfLeg1Notation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("spreadOfLeg1Monetary"), BigDecimal.class, getSpreadOfLeg1Monetary(), this);
			processor.processBasic(path.newSubPath("spreadOfLeg1Percentage"), BigDecimal.class, getSpreadOfLeg1Percentage(), this);
			processor.processBasic(path.newSubPath("spreadOfLeg1Basis"), BigDecimal.class, getSpreadOfLeg1Basis(), this);
			processor.processBasic(path.newSubPath("spreadCurrencyOfLeg1"), ISOCurrencyCodeEnum.class, getSpreadCurrencyOfLeg1(), this);
			processor.processBasic(path.newSubPath("spreadOfLeg1Notation"), PriceNotationEnum.class, getSpreadOfLeg1Notation(), this);
		}
		

		SpreadOfLeg1.SpreadOfLeg1Builder prune();
	}

	/*********************** Immutable Implementation of SpreadOfLeg1  ***********************/
	class SpreadOfLeg1Impl implements SpreadOfLeg1 {
		private final BigDecimal spreadOfLeg1Monetary;
		private final BigDecimal spreadOfLeg1Percentage;
		private final BigDecimal spreadOfLeg1Basis;
		private final ISOCurrencyCodeEnum spreadCurrencyOfLeg1;
		private final PriceNotationEnum spreadOfLeg1Notation;
		
		protected SpreadOfLeg1Impl(SpreadOfLeg1.SpreadOfLeg1Builder builder) {
			this.spreadOfLeg1Monetary = builder.getSpreadOfLeg1Monetary();
			this.spreadOfLeg1Percentage = builder.getSpreadOfLeg1Percentage();
			this.spreadOfLeg1Basis = builder.getSpreadOfLeg1Basis();
			this.spreadCurrencyOfLeg1 = builder.getSpreadCurrencyOfLeg1();
			this.spreadOfLeg1Notation = builder.getSpreadOfLeg1Notation();
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1Monetary")
		@RuneAttribute("spreadOfLeg1Monetary")
		public BigDecimal getSpreadOfLeg1Monetary() {
			return spreadOfLeg1Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1Percentage")
		@RuneAttribute("spreadOfLeg1Percentage")
		public BigDecimal getSpreadOfLeg1Percentage() {
			return spreadOfLeg1Percentage;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1Basis")
		@RuneAttribute("spreadOfLeg1Basis")
		public BigDecimal getSpreadOfLeg1Basis() {
			return spreadOfLeg1Basis;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyOfLeg1")
		@RuneAttribute("spreadCurrencyOfLeg1")
		public ISOCurrencyCodeEnum getSpreadCurrencyOfLeg1() {
			return spreadCurrencyOfLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1Notation")
		@RuneAttribute("spreadOfLeg1Notation")
		public PriceNotationEnum getSpreadOfLeg1Notation() {
			return spreadOfLeg1Notation;
		}
		
		@Override
		public SpreadOfLeg1 build() {
			return this;
		}
		
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder toBuilder() {
			SpreadOfLeg1.SpreadOfLeg1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SpreadOfLeg1.SpreadOfLeg1Builder builder) {
			ofNullable(getSpreadOfLeg1Monetary()).ifPresent(builder::setSpreadOfLeg1Monetary);
			ofNullable(getSpreadOfLeg1Percentage()).ifPresent(builder::setSpreadOfLeg1Percentage);
			ofNullable(getSpreadOfLeg1Basis()).ifPresent(builder::setSpreadOfLeg1Basis);
			ofNullable(getSpreadCurrencyOfLeg1()).ifPresent(builder::setSpreadCurrencyOfLeg1);
			ofNullable(getSpreadOfLeg1Notation()).ifPresent(builder::setSpreadOfLeg1Notation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadOfLeg1 _that = getType().cast(o);
		
			if (!Objects.equals(spreadOfLeg1Monetary, _that.getSpreadOfLeg1Monetary())) return false;
			if (!Objects.equals(spreadOfLeg1Percentage, _that.getSpreadOfLeg1Percentage())) return false;
			if (!Objects.equals(spreadOfLeg1Basis, _that.getSpreadOfLeg1Basis())) return false;
			if (!Objects.equals(spreadCurrencyOfLeg1, _that.getSpreadCurrencyOfLeg1())) return false;
			if (!Objects.equals(spreadOfLeg1Notation, _that.getSpreadOfLeg1Notation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadOfLeg1Monetary != null ? spreadOfLeg1Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1Percentage != null ? spreadOfLeg1Percentage.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1Basis != null ? spreadOfLeg1Basis.hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyOfLeg1 != null ? spreadCurrencyOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1Notation != null ? spreadOfLeg1Notation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadOfLeg1 {" +
				"spreadOfLeg1Monetary=" + this.spreadOfLeg1Monetary + ", " +
				"spreadOfLeg1Percentage=" + this.spreadOfLeg1Percentage + ", " +
				"spreadOfLeg1Basis=" + this.spreadOfLeg1Basis + ", " +
				"spreadCurrencyOfLeg1=" + this.spreadCurrencyOfLeg1 + ", " +
				"spreadOfLeg1Notation=" + this.spreadOfLeg1Notation +
			'}';
		}
	}

	/*********************** Builder Implementation of SpreadOfLeg1  ***********************/
	class SpreadOfLeg1BuilderImpl implements SpreadOfLeg1.SpreadOfLeg1Builder {
	
		protected BigDecimal spreadOfLeg1Monetary;
		protected BigDecimal spreadOfLeg1Percentage;
		protected BigDecimal spreadOfLeg1Basis;
		protected ISOCurrencyCodeEnum spreadCurrencyOfLeg1;
		protected PriceNotationEnum spreadOfLeg1Notation;
		
		@Override
		@RosettaAttribute("spreadOfLeg1Monetary")
		@RuneAttribute("spreadOfLeg1Monetary")
		public BigDecimal getSpreadOfLeg1Monetary() {
			return spreadOfLeg1Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1Percentage")
		@RuneAttribute("spreadOfLeg1Percentage")
		public BigDecimal getSpreadOfLeg1Percentage() {
			return spreadOfLeg1Percentage;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1Basis")
		@RuneAttribute("spreadOfLeg1Basis")
		public BigDecimal getSpreadOfLeg1Basis() {
			return spreadOfLeg1Basis;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyOfLeg1")
		@RuneAttribute("spreadCurrencyOfLeg1")
		public ISOCurrencyCodeEnum getSpreadCurrencyOfLeg1() {
			return spreadCurrencyOfLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1Notation")
		@RuneAttribute("spreadOfLeg1Notation")
		public PriceNotationEnum getSpreadOfLeg1Notation() {
			return spreadOfLeg1Notation;
		}
		
		@RosettaAttribute("spreadOfLeg1Monetary")
		@RuneAttribute("spreadOfLeg1Monetary")
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder setSpreadOfLeg1Monetary(BigDecimal _spreadOfLeg1Monetary) {
			this.spreadOfLeg1Monetary = _spreadOfLeg1Monetary == null ? null : _spreadOfLeg1Monetary;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg1Percentage")
		@RuneAttribute("spreadOfLeg1Percentage")
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder setSpreadOfLeg1Percentage(BigDecimal _spreadOfLeg1Percentage) {
			this.spreadOfLeg1Percentage = _spreadOfLeg1Percentage == null ? null : _spreadOfLeg1Percentage;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg1Basis")
		@RuneAttribute("spreadOfLeg1Basis")
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder setSpreadOfLeg1Basis(BigDecimal _spreadOfLeg1Basis) {
			this.spreadOfLeg1Basis = _spreadOfLeg1Basis == null ? null : _spreadOfLeg1Basis;
			return this;
		}
		
		@RosettaAttribute("spreadCurrencyOfLeg1")
		@RuneAttribute("spreadCurrencyOfLeg1")
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder setSpreadCurrencyOfLeg1(ISOCurrencyCodeEnum _spreadCurrencyOfLeg1) {
			this.spreadCurrencyOfLeg1 = _spreadCurrencyOfLeg1 == null ? null : _spreadCurrencyOfLeg1;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg1Notation")
		@RuneAttribute("spreadOfLeg1Notation")
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder setSpreadOfLeg1Notation(PriceNotationEnum _spreadOfLeg1Notation) {
			this.spreadOfLeg1Notation = _spreadOfLeg1Notation == null ? null : _spreadOfLeg1Notation;
			return this;
		}
		
		@Override
		public SpreadOfLeg1 build() {
			return new SpreadOfLeg1.SpreadOfLeg1Impl(this);
		}
		
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getSpreadOfLeg1Monetary()!=null) return true;
			if (getSpreadOfLeg1Percentage()!=null) return true;
			if (getSpreadOfLeg1Basis()!=null) return true;
			if (getSpreadCurrencyOfLeg1()!=null) return true;
			if (getSpreadOfLeg1Notation()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SpreadOfLeg1.SpreadOfLeg1Builder o = (SpreadOfLeg1.SpreadOfLeg1Builder) other;
			
			
			merger.mergeBasic(getSpreadOfLeg1Monetary(), o.getSpreadOfLeg1Monetary(), this::setSpreadOfLeg1Monetary);
			merger.mergeBasic(getSpreadOfLeg1Percentage(), o.getSpreadOfLeg1Percentage(), this::setSpreadOfLeg1Percentage);
			merger.mergeBasic(getSpreadOfLeg1Basis(), o.getSpreadOfLeg1Basis(), this::setSpreadOfLeg1Basis);
			merger.mergeBasic(getSpreadCurrencyOfLeg1(), o.getSpreadCurrencyOfLeg1(), this::setSpreadCurrencyOfLeg1);
			merger.mergeBasic(getSpreadOfLeg1Notation(), o.getSpreadOfLeg1Notation(), this::setSpreadOfLeg1Notation);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadOfLeg1 _that = getType().cast(o);
		
			if (!Objects.equals(spreadOfLeg1Monetary, _that.getSpreadOfLeg1Monetary())) return false;
			if (!Objects.equals(spreadOfLeg1Percentage, _that.getSpreadOfLeg1Percentage())) return false;
			if (!Objects.equals(spreadOfLeg1Basis, _that.getSpreadOfLeg1Basis())) return false;
			if (!Objects.equals(spreadCurrencyOfLeg1, _that.getSpreadCurrencyOfLeg1())) return false;
			if (!Objects.equals(spreadOfLeg1Notation, _that.getSpreadOfLeg1Notation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadOfLeg1Monetary != null ? spreadOfLeg1Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1Percentage != null ? spreadOfLeg1Percentage.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1Basis != null ? spreadOfLeg1Basis.hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyOfLeg1 != null ? spreadCurrencyOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1Notation != null ? spreadOfLeg1Notation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadOfLeg1Builder {" +
				"spreadOfLeg1Monetary=" + this.spreadOfLeg1Monetary + ", " +
				"spreadOfLeg1Percentage=" + this.spreadOfLeg1Percentage + ", " +
				"spreadOfLeg1Basis=" + this.spreadOfLeg1Basis + ", " +
				"spreadCurrencyOfLeg1=" + this.spreadCurrencyOfLeg1 + ", " +
				"spreadOfLeg1Notation=" + this.spreadOfLeg1Notation +
			'}';
		}
	}
}
