package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(IsReportableEventRule.IsReportableEventRuleDefault.class)
public abstract class IsReportableEventRule implements ReportFunction<TransactionReportInstruction, List<Boolean>> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<Boolean> evaluate(TransactionReportInstruction input) {
		List<Boolean> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<Boolean> doEvaluate(TransactionReportInstruction input);

	public static class IsReportableEventRuleDefault extends IsReportableEventRule {
		@Override
		protected List<Boolean> doEvaluate(TransactionReportInstruction input) {
			List<Boolean> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<Boolean> assignOutput(List<Boolean> output, TransactionReportInstruction input) {
			final MapperC<ReportingRegime> thenArg = MapperS.of(input)
				.mapSingleToList(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()));
			output = thenArg
				.mapItem(item -> areEqual(item.<FieldWithMetaRegimeNameEnum>map("getRegimeName", reportingRegime -> reportingRegime.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(RegimeNameEnum.EMIR), CardinalityOperator.All).andNullSafe(areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.ESMA), CardinalityOperator.All)).asMapper()).getMulti();
			
			return output;
		}
	}
}
