package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import iso20022.auth030.esma.EnergyQuantityUnit2Code;


@ImplementedBy(QuantityUnitRule.QuantityUnitRuleDefault.class)
public abstract class QuantityUnitRule implements ReportFunction<ReportableDelivery, EnergyQuantityUnit2Code> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public EnergyQuantityUnit2Code evaluate(ReportableDelivery input) {
		EnergyQuantityUnit2Code output = doEvaluate(input);
		
		return output;
	}

	protected abstract EnergyQuantityUnit2Code doEvaluate(ReportableDelivery input);

	public static class QuantityUnitRuleDefault extends QuantityUnitRule {
		@Override
		protected EnergyQuantityUnit2Code doEvaluate(ReportableDelivery input) {
			EnergyQuantityUnit2Code output = null;
			return assignOutput(output, input);
		}
		
		protected EnergyQuantityUnit2Code assignOutput(EnergyQuantityUnit2Code output, ReportableDelivery input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<EnergyQuantityUnit2Code>map("getQuantityUnit", reportableDelivery -> reportableDelivery.getQuantityUnit())).get();
			
			return output;
		}
	}
}
