package drr.regulation.esma.emir.refit.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.MultiplyPrice;
import drr.standards.iosco.cde.reports.CDESpreadLeg2Rule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(SpreadOfLeg2PercentageRule.SpreadOfLeg2PercentageRuleDefault.class)
public abstract class SpreadOfLeg2PercentageRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg2Rule cDESpreadLeg2Rule;
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;
	@Inject protected GetPriceNotation getPriceNotation;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class SpreadOfLeg2PercentageRuleDefault extends SpreadOfLeg2PercentageRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<ReferenceWithMetaPriceSchedule> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final PriceSchedule priceSchedule = cDESpreadLeg2Rule.evaluate(item.get());
					return priceSchedule == null ? MapperS.<ReferenceWithMetaPriceSchedule>ofNull() : MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build());
				});
			final MapperS<BigDecimal> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = item.get();
					if (areEqual(MapperS.of(getPriceNotation.evaluate((referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()))), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
						final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule2 = item.get();
						return MapperS.of(multiplyPrice.evaluate(item.<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get(), getPriceNotation.evaluate((referenceWithMetaPriceSchedule2 == null ? null : referenceWithMetaPriceSchedule2.getValue()))));
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToBaseOneRate.evaluate(thenArg2.get())).get();
			
			return output;
		}
	}
}
