package drr.regulation.esma.emir.refit.trade.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.PackageTransactionSpread;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class PackageTransactionSpreadValidator implements Validator<PackageTransactionSpread> {

	private List<ComparisonResult> getComparisonResults(PackageTransactionSpread o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("packageTransactionSpreadMonetary", (BigDecimal) o.getPackageTransactionSpreadMonetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadPercentage", (BigDecimal) o.getPackageTransactionSpreadPercentage() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadBasis", (BigDecimal) o.getPackageTransactionSpreadBasis() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadNotation", (PriceNotationEnum) o.getPackageTransactionSpreadNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpreadCurrency", (ISOCurrencyCodeEnum) o.getPackageTransactionSpreadCurrency() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PackageTransactionSpread", ValidationResult.ValidationType.CARDINALITY, "PackageTransactionSpread", path, "", res.getError());
				}
				return success("PackageTransactionSpread", ValidationResult.ValidationType.CARDINALITY, "PackageTransactionSpread", path, "");
			})
			.collect(toList());
	}

}
