package drr.regulation.esma.emir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.StrikePriceAndNotation;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class StrikePriceAndNotationTypeFormatValidator implements Validator<StrikePriceAndNotation> {

	private List<ComparisonResult> getComparisonResults(StrikePriceAndNotation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("strikePriceMonetary", o.getStrikePriceMonetary(), of(18), of(13), empty(), empty()), 
				checkNumber("strikePricePercentage", o.getStrikePricePercentage(), of(11), of(10), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrikePriceAndNotation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("StrikePriceAndNotation", ValidationResult.ValidationType.TYPE_FORMAT, "StrikePriceAndNotation", path, "", res.getError());
				}
				return success("StrikePriceAndNotation", ValidationResult.ValidationType.TYPE_FORMAT, "StrikePriceAndNotation", path, "");
			})
			.collect(toList());
	}

}
