package drr.regulation.fca.ukemir.refit.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.fca.ukemir.refit.trade.meta.FCAUKEMIRTransactionReportMeta;
import iso20022.auth030.fca.EnergyLoadType1Code;
import iso20022.auth030.fca.Frequency13Code__1;
import iso20022.auth030.fca.InterestComputationMethod4Code;
import iso20022.auth030.fca.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 5.57.0
 */
@RosettaDataType(value="FCAUKEMIRTransactionReport", builder=FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilderImpl.class, version="5.57.0")
@RuneDataType(value="FCAUKEMIRTransactionReport", model="drr", builder=FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilderImpl.class, version="5.57.0")
public interface FCAUKEMIRTransactionReport extends RosettaModelObject {

	FCAUKEMIRTransactionReportMeta metaData = new FCAUKEMIRTransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	ZonedDateTime getReportingTimestamp();
	String getReportSubmittingEntityID();
	String getEntityResponsibleForReporting();
	String getCounterparty1();
	String getNatureOfCounterparty1();
	List<String> getCorporateSectorOfTheCounterparty1();
	Boolean getClearingThresholdOfCounterparty1();
	String getCounterparty2();
	ISOCountryCodeEnum getCountryOfTheCounterParty2();
	String getNatureOfCounterparty2();
	List<String> getCorporateSectorOfTheCounterparty2();
	Boolean getCounterparty2IdentifierType();
	String getClearingMember();
	Boolean getClearingThresholdOfCounterparty2();
	Boolean getReportingObligationOfTheCounterparty2();
	String getBrokerID();
	String getDirection();
	String getDirectionOfLeg1();
	String getDirectionOfLeg2();
	Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing();
	ExecutionAgent getExecutionAgent();
	String getUti();
	String getUtiProprietary();
	String getReportTrackingNumber();
	String getPriorUTI();
	String getPriorUTIProprietary();
	String getPtrrId();
	String getPackageIdentifier();
	String getSubsequentPositionUTI();
	String getIsin();
	String getUpi();
	String getProductClassification();
	String getContractType();
	String getAssetClass();
	Boolean getIsCrypto();
	String getUnderlyingIdentificationType();
	String getUnderlyingIdentification();
	List<String> getNameOfTheUnderlyingIndex();
	List<String> getIndicatorOfTheUnderlyingIndex();
	List<String> getIdentifierOfBasketConstituents();
	String getCustomBasketCode();
	ISOCurrencyCodeEnum getSettlementCurrency1();
	String getSettlementCurrency2();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ValuationType1Code getValuationMethod();
	BigDecimal getDelta();
	ZonedDateTime getValuationTimestamp();
	ZonedDateTime getConfirmationTimestamp();
	String getConfirmed();
	String getClearingObligation();
	String getCleared();
	ZonedDateTime getClearingTimestamp();
	String getCentralCounterparty();
	String getMasterAgreementType();
	String getOtherMasterAgreementType();
	Integer getMasterAgreementVersion();
	Boolean getIntragroup();
	Boolean getPtrr();
	String getTypeOfPTRRTechnique();
	String getPtrrServiceProvider();
	String getVenueOfExecution();
	ZonedDateTime getExecutionTimestamp();
	Date getEffectiveDate();
	Date getExpirationDate();
	Date getEarlyTerminationDate();
	Date getFinalContractualSettlementDate();
	String getDeliveryType();
	PriceAndNotation getPrice();
	List<? extends PriceScheduleReport> getPriceSchedule();
	PackageTransactionPrice getPackageTransactionPrice();
	BigDecimal getNotionalLeg1();
	ISOCurrencyCodeEnum getNotionalCurrency1();
	List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1();
	BigDecimal getTotalNotionalQuantityLeg1();
	List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1();
	BigDecimal getTotalNotionalQuantityLeg2();
	BigDecimal getNotionalLeg2();
	ISOCurrencyCodeEnum getNotionalCurrency2();
	List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2();
	List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2();
	List<? extends OtherPaymentReport> getOtherPayment();
	BigDecimal getFixedRateOfLeg1();
	InterestComputationMethod4Code getFixedRateDayCountConventionLeg1();
	String getFixedRatePaymentFrequencyPeriodLeg1();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1();
	String getIdentifierOfFloatingRateOfLeg1();
	String getIndicatorOfTheFloatingRateOfLeg1();
	String getNameOfTheFloatingRateOfLeg1();
	InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1();
	Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1();
	String getFloatingRateReferencePeriodOfLeg1TimePeriod();
	Integer getFloatingRateReferencePeriodOfLeg1Multiplier();
	String getFloatingRateResetFrequencyPeriodOfLeg1();
	Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1();
	SpreadOfLeg1 getSpreadOfLeg1();
	BigDecimal getFixedRateOfLeg2();
	InterestComputationMethod4Code getFixedRateDayCountConventionLeg2();
	String getFixedRatePaymentFrequencyPeriodLeg2();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2();
	String getIdentifierOfFloatingRateOfLeg2();
	String getIndicatorOfTheFloatingRateOfLeg2();
	String getNameOfTheFloatingRateOfLeg2();
	InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2();
	String getFloatingRatePaymentFrequencyPeriodOfLeg2();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2();
	String getFloatingRateReferencePeriodOfLeg2TimePeriod();
	Integer getFloatingRateReferencePeriodOfLeg2Multiplier();
	String getFloatingRateResetFrequencyPeriodOfLeg2();
	Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2();
	SpreadOfLeg2 getSpreadOfLeg2();
	PackageTransactionSpread getPackageTransactionSpread();
	BigDecimal getExchangeRate();
	BigDecimal getForwardExchangeRate();
	String getExchangeRateBasis();
	String getBaseProduct();
	String getSubProduct();
	String getFurtherSubProduct();
	List<String> getDeliveryPoint();
	String getInterconnectionPoint();
	EnergyLoadType1Code getLoadType();
	List<? extends DeliveryReport> getDeliveryReport();
	String getOptionType();
	String getOptionStyle();
	StrikePriceAndNotation getStrikePrice();
	List<? extends StrikePriceScheduleReport> getStrikePriceSchedule();
	BigDecimal getOptionPremiumAmount();
	ISOCurrencyCodeEnum getOptionPremiumCurrency();
	Date getOptionPremiumPaymentDate();
	Date getMaturityDateOfTheUnderlying();
	String getSeniority();
	String getReferenceEntity();
	Integer getSeries();
	Integer getVersion();
	BigDecimal getIndexFactor();
	Boolean getTranche();
	BigDecimal getCdSIndexAttachmentPoint();
	BigDecimal getCdSIndexDetachmentPoint();
	Boolean getCollateralPortfolioIndicator();
	String getCollateralPortfolioCode();
	String getActionType();
	String getEventType();
	Date getEventDate();
	String getLevel();
	FCAUKEMIRNonReportable getNonReportable();

	/*********************** Build Methods  ***********************/
	FCAUKEMIRTransactionReport build();
	
	FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder toBuilder();
	
	static FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder builder() {
		return new FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends FCAUKEMIRTransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends FCAUKEMIRTransactionReport> getType() {
		return FCAUKEMIRTransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty1"), String.class, getNatureOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty2"), String.class, getNatureOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
		processor.processBasic(path.newSubPath("direction"), String.class, getDirection(), this);
		processor.processBasic(path.newSubPath("directionOfLeg1"), String.class, getDirectionOfLeg1(), this);
		processor.processBasic(path.newSubPath("directionOfLeg2"), String.class, getDirectionOfLeg2(), this);
		processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
		processRosetta(path.newSubPath("executionAgent"), processor, ExecutionAgent.class, getExecutionAgent());
		processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
		processor.processBasic(path.newSubPath("utiProprietary"), String.class, getUtiProprietary(), this);
		processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
		processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
		processor.processBasic(path.newSubPath("upi"), String.class, getUpi(), this);
		processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
		processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
		processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
		processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), String.class, getIndicatorOfTheUnderlyingIndex(), this);
		processor.processBasic(path.newSubPath("identifierOfBasketConstituents"), String.class, getIdentifierOfBasketConstituents(), this);
		processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
		processor.processBasic(path.newSubPath("settlementCurrency1"), ISOCurrencyCodeEnum.class, getSettlementCurrency1(), this);
		processor.processBasic(path.newSubPath("settlementCurrency2"), String.class, getSettlementCurrency2(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
		processor.processBasic(path.newSubPath("confirmed"), String.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("clearingObligation"), String.class, getClearingObligation(), this);
		processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
		processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
		processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
		processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), String.class, getTypeOfPTRRTechnique(), this);
		processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
		processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processor.processBasic(path.newSubPath("deliveryType"), String.class, getDeliveryType(), this);
		processRosetta(path.newSubPath("price"), processor, PriceAndNotation.class, getPrice());
		processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.class, getPriceSchedule());
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, getNotionalLeg1(), this);
		processor.processBasic(path.newSubPath("notionalCurrency1"), ISOCurrencyCodeEnum.class, getNotionalCurrency1(), this);
		processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.class, getNotionalAmountScheduleLeg1());
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
		processRosetta(path.newSubPath("notionalQuantityScheduleLeg1"), processor, NotionalQuantityScheduleLeg1Report.class, getNotionalQuantityScheduleLeg1());
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
		processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, getNotionalLeg2(), this);
		processor.processBasic(path.newSubPath("notionalCurrency2"), ISOCurrencyCodeEnum.class, getNotionalCurrency2(), this);
		processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.class, getNotionalAmountScheduleLeg2());
		processRosetta(path.newSubPath("notionalQuantityScheduleLeg2"), processor, NotionalQuantityScheduleLeg2Report.class, getNotionalQuantityScheduleLeg2());
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.class, getOtherPayment());
		processor.processBasic(path.newSubPath("fixedRateOfLeg1"), BigDecimal.class, getFixedRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, getFixedRatePaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg1"), String.class, getIdentifierOfFloatingRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg1"), String.class, getIndicatorOfTheFloatingRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, getNameOfTheFloatingRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, getFloatingRatePaymentFrequencyPeriodOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg1TimePeriod(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg1Multiplier(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg1"), String.class, getFloatingRateResetFrequencyPeriodOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this);
		processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.class, getSpreadOfLeg1());
		processor.processBasic(path.newSubPath("fixedRateOfLeg2"), BigDecimal.class, getFixedRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, getFixedRatePaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg2"), String.class, getIdentifierOfFloatingRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg2"), String.class, getIndicatorOfTheFloatingRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, getNameOfTheFloatingRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg2"), String.class, getFloatingRatePaymentFrequencyPeriodOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg2TimePeriod(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg2Multiplier(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, getFloatingRateResetFrequencyPeriodOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this);
		processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.class, getSpreadOfLeg2());
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
		processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
		processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
		processor.processBasic(path.newSubPath("deliveryPoint"), String.class, getDeliveryPoint(), this);
		processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
		processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, getLoadType(), this);
		processRosetta(path.newSubPath("deliveryReport"), processor, DeliveryReport.class, getDeliveryReport());
		processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.class, getStrikePrice());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.class, getStrikePriceSchedule());
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("seniority"), String.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
		processor.processBasic(path.newSubPath("level"), String.class, getLevel(), this);
		processRosetta(path.newSubPath("nonReportable"), processor, FCAUKEMIRNonReportable.class, getNonReportable());
	}
	

	/*********************** Builder Interface  ***********************/
	interface FCAUKEMIRTransactionReportBuilder extends FCAUKEMIRTransactionReport, RosettaModelObjectBuilder {
		ExecutionAgent.ExecutionAgentBuilder getOrCreateExecutionAgent();
		@Override
		ExecutionAgent.ExecutionAgentBuilder getExecutionAgent();
		PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice();
		@Override
		PriceAndNotation.PriceAndNotationBuilder getPrice();
		PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int index);
		@Override
		List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule();
		PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice();
		@Override
		PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice();
		NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1();
		NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1(int index);
		@Override
		List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1();
		NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2();
		NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2(int index);
		@Override
		List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2();
		OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index);
		@Override
		List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment();
		SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1();
		@Override
		SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1();
		SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2();
		@Override
		SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2();
		PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread();
		@Override
		PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread();
		DeliveryReport.DeliveryReportBuilder getOrCreateDeliveryReport(int index);
		@Override
		List<? extends DeliveryReport.DeliveryReportBuilder> getDeliveryReport();
		StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice();
		@Override
		StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice();
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int index);
		@Override
		List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule();
		FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder getOrCreateNonReportable();
		@Override
		FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder getNonReportable();
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCounterparty1(String counterparty1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNatureOfCounterparty1(String natureOfCounterparty1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String corporateSectorOfTheCounterparty1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String corporateSectorOfTheCounterparty1, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean clearingThresholdOfCounterparty1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCounterparty2(String counterparty2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum countryOfTheCounterParty2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNatureOfCounterparty2(String natureOfCounterparty2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String corporateSectorOfTheCounterparty2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String corporateSectorOfTheCounterparty2, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingMember(String clearingMember);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean clearingThresholdOfCounterparty2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean reportingObligationOfTheCounterparty2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setBrokerID(String brokerID);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDirection(String direction);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDirectionOfLeg1(String directionOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDirectionOfLeg2(String directionOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExecutionAgent(ExecutionAgent executionAgent);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUti(String uti);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUtiProprietary(String utiProprietary);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReportTrackingNumber(String reportTrackingNumber);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPriorUTI(String priorUTI);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPtrrId(String ptrrId);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSubsequentPositionUTI(String subsequentPositionUTI);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIsin(String isin);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUpi(String upi);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setProductClassification(String productClassification);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setContractType(String contractType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setAssetClass(String assetClass);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIsCrypto(Boolean isCrypto);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUnderlyingIdentificationType(String underlyingIdentificationType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUnderlyingIdentification(String underlyingIdentification);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNameOfTheUnderlyingIndex(List<String> nameOfTheUnderlyingIndex);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(List<String> nameOfTheUnderlyingIndex);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(String indicatorOfTheUnderlyingIndex);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(String indicatorOfTheUnderlyingIndex, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<String> indicatorOfTheUnderlyingIndex);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<String> indicatorOfTheUnderlyingIndex);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIdentifierOfBasketConstituents(String identifierOfBasketConstituents);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIdentifierOfBasketConstituents(String identifierOfBasketConstituents, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIdentifierOfBasketConstituents(List<String> identifierOfBasketConstituents);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIdentifierOfBasketConstituents(List<String> identifierOfBasketConstituents);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCustomBasketCode(String customBasketCode);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSettlementCurrency1(ISOCurrencyCodeEnum settlementCurrency1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSettlementCurrency2(String settlementCurrency2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setValuationAmount(BigDecimal valuationAmount);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDelta(BigDecimal delta);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime confirmationTimestamp);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setConfirmed(String confirmed);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingObligation(String clearingObligation);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCleared(String cleared);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setMasterAgreementType(String masterAgreementType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOtherMasterAgreementType(String otherMasterAgreementType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setMasterAgreementVersion(Integer masterAgreementVersion);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIntragroup(Boolean intragroup);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPtrr(Boolean ptrr);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setTypeOfPTRRTechnique(String typeOfPTRRTechnique);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPtrrServiceProvider(String ptrrServiceProvider);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setVenueOfExecution(String venueOfExecution);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEffectiveDate(Date effectiveDate);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExpirationDate(Date expirationDate);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDeliveryType(String deliveryType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPrice(PriceAndNotation price);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addPriceSchedule(PriceScheduleReport priceSchedule);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addPriceSchedule(PriceScheduleReport priceSchedule, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> priceSchedule);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> priceSchedule);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice packageTransactionPrice);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalLeg1(BigDecimal notionalLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalCurrency1(ISOCurrencyCodeEnum notionalCurrency1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal totalNotionalQuantityLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal totalNotionalQuantityLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalLeg2(BigDecimal notionalLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalCurrency2(ISOCurrencyCodeEnum notionalCurrency2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRateOfLeg1(BigDecimal fixedRateOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code fixedRateDayCountConventionLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String fixedRatePaymentFrequencyPeriodLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIdentifierOfFloatingRateOfLeg1(String identifierOfFloatingRateOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg1(String indicatorOfTheFloatingRateOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String nameOfTheFloatingRateOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateReferencePeriodOfLeg1TimePeriod(String floatingRateReferencePeriodOfLeg1TimePeriod);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateReferencePeriodOfLeg1Multiplier(Integer floatingRateReferencePeriodOfLeg1Multiplier);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg1(String floatingRateResetFrequencyPeriodOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer floatingRateResetFrequencyPeriodMultiplierLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 spreadOfLeg1);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRateOfLeg2(BigDecimal fixedRateOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code fixedRateDayCountConventionLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String fixedRatePaymentFrequencyPeriodLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIdentifierOfFloatingRateOfLeg2(String identifierOfFloatingRateOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg2(String indicatorOfTheFloatingRateOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String nameOfTheFloatingRateOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg2(String floatingRatePaymentFrequencyPeriodOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String floatingRateReferencePeriodOfLeg2TimePeriod);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer floatingRateReferencePeriodOfLeg2Multiplier);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String floatingRateResetFrequencyPeriodOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer floatingRateResetFrequencyPeriodMultiplierLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 spreadOfLeg2);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread packageTransactionSpread);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal forwardExchangeRate);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setBaseProduct(String baseProduct);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSubProduct(String subProduct);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFurtherSubProduct(String furtherSubProduct);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryPoint(String deliveryPoint);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryPoint(String deliveryPoint, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoint);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoint);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setInterconnectionPoint(String interconnectionPoint);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code loadType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryReport(DeliveryReport deliveryReport);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryReport(DeliveryReport deliveryReport, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryReport(List<? extends DeliveryReport> deliveryReport);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDeliveryReport(List<? extends DeliveryReport> deliveryReport);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionType(String optionType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionStyle(String optionStyle);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setStrikePrice(StrikePriceAndNotation strikePrice);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport strikePriceSchedule);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport strikePriceSchedule, int idx);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedule);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedule);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSeniority(String seniority);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReferenceEntity(String referenceEntity);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSeries(Integer series);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setVersion(Integer version);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setTranche(Boolean tranche);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCollateralPortfolioCode(String collateralPortfolioCode);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setActionType(String actionType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEventType(String eventType);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEventDate(Date eventDate);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setLevel(String level);
		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNonReportable(FCAUKEMIRNonReportable nonReportable);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty1"), String.class, getNatureOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty2"), String.class, getNatureOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
			processor.processBasic(path.newSubPath("direction"), String.class, getDirection(), this);
			processor.processBasic(path.newSubPath("directionOfLeg1"), String.class, getDirectionOfLeg1(), this);
			processor.processBasic(path.newSubPath("directionOfLeg2"), String.class, getDirectionOfLeg2(), this);
			processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
			processRosetta(path.newSubPath("executionAgent"), processor, ExecutionAgent.ExecutionAgentBuilder.class, getExecutionAgent());
			processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
			processor.processBasic(path.newSubPath("utiProprietary"), String.class, getUtiProprietary(), this);
			processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
			processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
			processor.processBasic(path.newSubPath("upi"), String.class, getUpi(), this);
			processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
			processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
			processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
			processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), String.class, getIndicatorOfTheUnderlyingIndex(), this);
			processor.processBasic(path.newSubPath("identifierOfBasketConstituents"), String.class, getIdentifierOfBasketConstituents(), this);
			processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
			processor.processBasic(path.newSubPath("settlementCurrency1"), ISOCurrencyCodeEnum.class, getSettlementCurrency1(), this);
			processor.processBasic(path.newSubPath("settlementCurrency2"), String.class, getSettlementCurrency2(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
			processor.processBasic(path.newSubPath("confirmed"), String.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("clearingObligation"), String.class, getClearingObligation(), this);
			processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
			processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
			processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
			processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), String.class, getTypeOfPTRRTechnique(), this);
			processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
			processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processor.processBasic(path.newSubPath("deliveryType"), String.class, getDeliveryType(), this);
			processRosetta(path.newSubPath("price"), processor, PriceAndNotation.PriceAndNotationBuilder.class, getPrice());
			processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.PriceScheduleReportBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.PackageTransactionPriceBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, getNotionalLeg1(), this);
			processor.processBasic(path.newSubPath("notionalCurrency1"), ISOCurrencyCodeEnum.class, getNotionalCurrency1(), this);
			processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder.class, getNotionalAmountScheduleLeg1());
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
			processRosetta(path.newSubPath("notionalQuantityScheduleLeg1"), processor, NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder.class, getNotionalQuantityScheduleLeg1());
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
			processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, getNotionalLeg2(), this);
			processor.processBasic(path.newSubPath("notionalCurrency2"), ISOCurrencyCodeEnum.class, getNotionalCurrency2(), this);
			processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder.class, getNotionalAmountScheduleLeg2());
			processRosetta(path.newSubPath("notionalQuantityScheduleLeg2"), processor, NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder.class, getNotionalQuantityScheduleLeg2());
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.OtherPaymentReportBuilder.class, getOtherPayment());
			processor.processBasic(path.newSubPath("fixedRateOfLeg1"), BigDecimal.class, getFixedRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, getFixedRatePaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg1"), String.class, getIdentifierOfFloatingRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg1"), String.class, getIndicatorOfTheFloatingRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, getNameOfTheFloatingRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, getFloatingRatePaymentFrequencyPeriodOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg1TimePeriod(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg1Multiplier(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg1"), String.class, getFloatingRateResetFrequencyPeriodOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this);
			processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.SpreadOfLeg1Builder.class, getSpreadOfLeg1());
			processor.processBasic(path.newSubPath("fixedRateOfLeg2"), BigDecimal.class, getFixedRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, getFixedRatePaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg2"), String.class, getIdentifierOfFloatingRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg2"), String.class, getIndicatorOfTheFloatingRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, getNameOfTheFloatingRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg2"), String.class, getFloatingRatePaymentFrequencyPeriodOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg2TimePeriod(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg2Multiplier(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, getFloatingRateResetFrequencyPeriodOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this);
			processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.SpreadOfLeg2Builder.class, getSpreadOfLeg2());
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.PackageTransactionSpreadBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
			processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
			processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
			processor.processBasic(path.newSubPath("deliveryPoint"), String.class, getDeliveryPoint(), this);
			processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, getInterconnectionPoint(), this);
			processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, getLoadType(), this);
			processRosetta(path.newSubPath("deliveryReport"), processor, DeliveryReport.DeliveryReportBuilder.class, getDeliveryReport());
			processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.StrikePriceAndNotationBuilder.class, getStrikePrice());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.StrikePriceScheduleReportBuilder.class, getStrikePriceSchedule());
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("seniority"), String.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
			processor.processBasic(path.newSubPath("level"), String.class, getLevel(), this);
			processRosetta(path.newSubPath("nonReportable"), processor, FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder.class, getNonReportable());
		}
		

		FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of FCAUKEMIRTransactionReport  ***********************/
	class FCAUKEMIRTransactionReportImpl implements FCAUKEMIRTransactionReport {
		private final ZonedDateTime reportingTimestamp;
		private final String reportSubmittingEntityID;
		private final String entityResponsibleForReporting;
		private final String counterparty1;
		private final String natureOfCounterparty1;
		private final List<String> corporateSectorOfTheCounterparty1;
		private final Boolean clearingThresholdOfCounterparty1;
		private final String counterparty2;
		private final ISOCountryCodeEnum countryOfTheCounterParty2;
		private final String natureOfCounterparty2;
		private final List<String> corporateSectorOfTheCounterparty2;
		private final Boolean counterparty2IdentifierType;
		private final String clearingMember;
		private final Boolean clearingThresholdOfCounterparty2;
		private final Boolean reportingObligationOfTheCounterparty2;
		private final String brokerID;
		private final String direction;
		private final String directionOfLeg1;
		private final String directionOfLeg2;
		private final Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing;
		private final ExecutionAgent executionAgent;
		private final String uti;
		private final String utiProprietary;
		private final String reportTrackingNumber;
		private final String priorUTI;
		private final String priorUTIProprietary;
		private final String ptrrId;
		private final String packageIdentifier;
		private final String subsequentPositionUTI;
		private final String isin;
		private final String upi;
		private final String productClassification;
		private final String contractType;
		private final String assetClass;
		private final Boolean isCrypto;
		private final String underlyingIdentificationType;
		private final String underlyingIdentification;
		private final List<String> nameOfTheUnderlyingIndex;
		private final List<String> indicatorOfTheUnderlyingIndex;
		private final List<String> identifierOfBasketConstituents;
		private final String customBasketCode;
		private final ISOCurrencyCodeEnum settlementCurrency1;
		private final String settlementCurrency2;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ValuationType1Code valuationMethod;
		private final BigDecimal delta;
		private final ZonedDateTime valuationTimestamp;
		private final ZonedDateTime confirmationTimestamp;
		private final String confirmed;
		private final String clearingObligation;
		private final String cleared;
		private final ZonedDateTime clearingTimestamp;
		private final String centralCounterparty;
		private final String masterAgreementType;
		private final String otherMasterAgreementType;
		private final Integer masterAgreementVersion;
		private final Boolean intragroup;
		private final Boolean ptrr;
		private final String typeOfPTRRTechnique;
		private final String ptrrServiceProvider;
		private final String venueOfExecution;
		private final ZonedDateTime executionTimestamp;
		private final Date effectiveDate;
		private final Date expirationDate;
		private final Date earlyTerminationDate;
		private final Date finalContractualSettlementDate;
		private final String deliveryType;
		private final PriceAndNotation price;
		private final List<? extends PriceScheduleReport> priceSchedule;
		private final PackageTransactionPrice packageTransactionPrice;
		private final BigDecimal notionalLeg1;
		private final ISOCurrencyCodeEnum notionalCurrency1;
		private final List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1;
		private final BigDecimal totalNotionalQuantityLeg1;
		private final List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1;
		private final BigDecimal totalNotionalQuantityLeg2;
		private final BigDecimal notionalLeg2;
		private final ISOCurrencyCodeEnum notionalCurrency2;
		private final List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2;
		private final List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2;
		private final List<? extends OtherPaymentReport> otherPayment;
		private final BigDecimal fixedRateOfLeg1;
		private final InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
		private final String fixedRatePaymentFrequencyPeriodLeg1;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		private final String identifierOfFloatingRateOfLeg1;
		private final String indicatorOfTheFloatingRateOfLeg1;
		private final String nameOfTheFloatingRateOfLeg1;
		private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
		private final Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		private final String floatingRateReferencePeriodOfLeg1TimePeriod;
		private final Integer floatingRateReferencePeriodOfLeg1Multiplier;
		private final String floatingRateResetFrequencyPeriodOfLeg1;
		private final Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
		private final SpreadOfLeg1 spreadOfLeg1;
		private final BigDecimal fixedRateOfLeg2;
		private final InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
		private final String fixedRatePaymentFrequencyPeriodLeg2;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		private final String identifierOfFloatingRateOfLeg2;
		private final String indicatorOfTheFloatingRateOfLeg2;
		private final String nameOfTheFloatingRateOfLeg2;
		private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
		private final String floatingRatePaymentFrequencyPeriodOfLeg2;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		private final String floatingRateReferencePeriodOfLeg2TimePeriod;
		private final Integer floatingRateReferencePeriodOfLeg2Multiplier;
		private final String floatingRateResetFrequencyPeriodOfLeg2;
		private final Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
		private final SpreadOfLeg2 spreadOfLeg2;
		private final PackageTransactionSpread packageTransactionSpread;
		private final BigDecimal exchangeRate;
		private final BigDecimal forwardExchangeRate;
		private final String exchangeRateBasis;
		private final String baseProduct;
		private final String subProduct;
		private final String furtherSubProduct;
		private final List<String> deliveryPoint;
		private final String interconnectionPoint;
		private final EnergyLoadType1Code loadType;
		private final List<? extends DeliveryReport> deliveryReport;
		private final String optionType;
		private final String optionStyle;
		private final StrikePriceAndNotation strikePrice;
		private final List<? extends StrikePriceScheduleReport> strikePriceSchedule;
		private final BigDecimal optionPremiumAmount;
		private final ISOCurrencyCodeEnum optionPremiumCurrency;
		private final Date optionPremiumPaymentDate;
		private final Date maturityDateOfTheUnderlying;
		private final String seniority;
		private final String referenceEntity;
		private final Integer series;
		private final Integer version;
		private final BigDecimal indexFactor;
		private final Boolean tranche;
		private final BigDecimal cdSIndexAttachmentPoint;
		private final BigDecimal cdSIndexDetachmentPoint;
		private final Boolean collateralPortfolioIndicator;
		private final String collateralPortfolioCode;
		private final String actionType;
		private final String eventType;
		private final Date eventDate;
		private final String level;
		private final FCAUKEMIRNonReportable nonReportable;
		
		protected FCAUKEMIRTransactionReportImpl(FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder builder) {
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.counterparty1 = builder.getCounterparty1();
			this.natureOfCounterparty1 = builder.getNatureOfCounterparty1();
			this.corporateSectorOfTheCounterparty1 = ofNullable(builder.getCorporateSectorOfTheCounterparty1()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.clearingThresholdOfCounterparty1 = builder.getClearingThresholdOfCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.countryOfTheCounterParty2 = builder.getCountryOfTheCounterParty2();
			this.natureOfCounterparty2 = builder.getNatureOfCounterparty2();
			this.corporateSectorOfTheCounterparty2 = ofNullable(builder.getCorporateSectorOfTheCounterparty2()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
			this.clearingMember = builder.getClearingMember();
			this.clearingThresholdOfCounterparty2 = builder.getClearingThresholdOfCounterparty2();
			this.reportingObligationOfTheCounterparty2 = builder.getReportingObligationOfTheCounterparty2();
			this.brokerID = builder.getBrokerID();
			this.direction = builder.getDirection();
			this.directionOfLeg1 = builder.getDirectionOfLeg1();
			this.directionOfLeg2 = builder.getDirectionOfLeg2();
			this.directlyLinkedToCommercialActivityOrTreasuryFinancing = builder.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing();
			this.executionAgent = ofNullable(builder.getExecutionAgent()).map(f->f.build()).orElse(null);
			this.uti = builder.getUti();
			this.utiProprietary = builder.getUtiProprietary();
			this.reportTrackingNumber = builder.getReportTrackingNumber();
			this.priorUTI = builder.getPriorUTI();
			this.priorUTIProprietary = builder.getPriorUTIProprietary();
			this.ptrrId = builder.getPtrrId();
			this.packageIdentifier = builder.getPackageIdentifier();
			this.subsequentPositionUTI = builder.getSubsequentPositionUTI();
			this.isin = builder.getIsin();
			this.upi = builder.getUpi();
			this.productClassification = builder.getProductClassification();
			this.contractType = builder.getContractType();
			this.assetClass = builder.getAssetClass();
			this.isCrypto = builder.getIsCrypto();
			this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
			this.underlyingIdentification = builder.getUnderlyingIdentification();
			this.nameOfTheUnderlyingIndex = ofNullable(builder.getNameOfTheUnderlyingIndex()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.indicatorOfTheUnderlyingIndex = ofNullable(builder.getIndicatorOfTheUnderlyingIndex()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.identifierOfBasketConstituents = ofNullable(builder.getIdentifierOfBasketConstituents()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.customBasketCode = builder.getCustomBasketCode();
			this.settlementCurrency1 = builder.getSettlementCurrency1();
			this.settlementCurrency2 = builder.getSettlementCurrency2();
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationMethod = builder.getValuationMethod();
			this.delta = builder.getDelta();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.confirmationTimestamp = builder.getConfirmationTimestamp();
			this.confirmed = builder.getConfirmed();
			this.clearingObligation = builder.getClearingObligation();
			this.cleared = builder.getCleared();
			this.clearingTimestamp = builder.getClearingTimestamp();
			this.centralCounterparty = builder.getCentralCounterparty();
			this.masterAgreementType = builder.getMasterAgreementType();
			this.otherMasterAgreementType = builder.getOtherMasterAgreementType();
			this.masterAgreementVersion = builder.getMasterAgreementVersion();
			this.intragroup = builder.getIntragroup();
			this.ptrr = builder.getPtrr();
			this.typeOfPTRRTechnique = builder.getTypeOfPTRRTechnique();
			this.ptrrServiceProvider = builder.getPtrrServiceProvider();
			this.venueOfExecution = builder.getVenueOfExecution();
			this.executionTimestamp = builder.getExecutionTimestamp();
			this.effectiveDate = builder.getEffectiveDate();
			this.expirationDate = builder.getExpirationDate();
			this.earlyTerminationDate = builder.getEarlyTerminationDate();
			this.finalContractualSettlementDate = builder.getFinalContractualSettlementDate();
			this.deliveryType = builder.getDeliveryType();
			this.price = ofNullable(builder.getPrice()).map(f->f.build()).orElse(null);
			this.priceSchedule = ofNullable(builder.getPriceSchedule()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.packageTransactionPrice = ofNullable(builder.getPackageTransactionPrice()).map(f->f.build()).orElse(null);
			this.notionalLeg1 = builder.getNotionalLeg1();
			this.notionalCurrency1 = builder.getNotionalCurrency1();
			this.notionalAmountScheduleLeg1 = ofNullable(builder.getNotionalAmountScheduleLeg1()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.totalNotionalQuantityLeg1 = builder.getTotalNotionalQuantityLeg1();
			this.notionalQuantityScheduleLeg1 = ofNullable(builder.getNotionalQuantityScheduleLeg1()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.totalNotionalQuantityLeg2 = builder.getTotalNotionalQuantityLeg2();
			this.notionalLeg2 = builder.getNotionalLeg2();
			this.notionalCurrency2 = builder.getNotionalCurrency2();
			this.notionalAmountScheduleLeg2 = ofNullable(builder.getNotionalAmountScheduleLeg2()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.notionalQuantityScheduleLeg2 = ofNullable(builder.getNotionalQuantityScheduleLeg2()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.otherPayment = ofNullable(builder.getOtherPayment()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.fixedRateOfLeg1 = builder.getFixedRateOfLeg1();
			this.fixedRateDayCountConventionLeg1 = builder.getFixedRateDayCountConventionLeg1();
			this.fixedRatePaymentFrequencyPeriodLeg1 = builder.getFixedRatePaymentFrequencyPeriodLeg1();
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg1();
			this.identifierOfFloatingRateOfLeg1 = builder.getIdentifierOfFloatingRateOfLeg1();
			this.indicatorOfTheFloatingRateOfLeg1 = builder.getIndicatorOfTheFloatingRateOfLeg1();
			this.nameOfTheFloatingRateOfLeg1 = builder.getNameOfTheFloatingRateOfLeg1();
			this.floatingRateDayCountConventionOfLeg1 = builder.getFloatingRateDayCountConventionOfLeg1();
			this.floatingRatePaymentFrequencyPeriodOfLeg1 = builder.getFloatingRatePaymentFrequencyPeriodOfLeg1();
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1();
			this.floatingRateReferencePeriodOfLeg1TimePeriod = builder.getFloatingRateReferencePeriodOfLeg1TimePeriod();
			this.floatingRateReferencePeriodOfLeg1Multiplier = builder.getFloatingRateReferencePeriodOfLeg1Multiplier();
			this.floatingRateResetFrequencyPeriodOfLeg1 = builder.getFloatingRateResetFrequencyPeriodOfLeg1();
			this.floatingRateResetFrequencyPeriodMultiplierLeg1 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg1();
			this.spreadOfLeg1 = ofNullable(builder.getSpreadOfLeg1()).map(f->f.build()).orElse(null);
			this.fixedRateOfLeg2 = builder.getFixedRateOfLeg2();
			this.fixedRateDayCountConventionLeg2 = builder.getFixedRateDayCountConventionLeg2();
			this.fixedRatePaymentFrequencyPeriodLeg2 = builder.getFixedRatePaymentFrequencyPeriodLeg2();
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg2();
			this.identifierOfFloatingRateOfLeg2 = builder.getIdentifierOfFloatingRateOfLeg2();
			this.indicatorOfTheFloatingRateOfLeg2 = builder.getIndicatorOfTheFloatingRateOfLeg2();
			this.nameOfTheFloatingRateOfLeg2 = builder.getNameOfTheFloatingRateOfLeg2();
			this.floatingRateDayCountConventionOfLeg2 = builder.getFloatingRateDayCountConventionOfLeg2();
			this.floatingRatePaymentFrequencyPeriodOfLeg2 = builder.getFloatingRatePaymentFrequencyPeriodOfLeg2();
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2();
			this.floatingRateReferencePeriodOfLeg2TimePeriod = builder.getFloatingRateReferencePeriodOfLeg2TimePeriod();
			this.floatingRateReferencePeriodOfLeg2Multiplier = builder.getFloatingRateReferencePeriodOfLeg2Multiplier();
			this.floatingRateResetFrequencyPeriodOfLeg2 = builder.getFloatingRateResetFrequencyPeriodOfLeg2();
			this.floatingRateResetFrequencyPeriodMultiplierLeg2 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg2();
			this.spreadOfLeg2 = ofNullable(builder.getSpreadOfLeg2()).map(f->f.build()).orElse(null);
			this.packageTransactionSpread = ofNullable(builder.getPackageTransactionSpread()).map(f->f.build()).orElse(null);
			this.exchangeRate = builder.getExchangeRate();
			this.forwardExchangeRate = builder.getForwardExchangeRate();
			this.exchangeRateBasis = builder.getExchangeRateBasis();
			this.baseProduct = builder.getBaseProduct();
			this.subProduct = builder.getSubProduct();
			this.furtherSubProduct = builder.getFurtherSubProduct();
			this.deliveryPoint = ofNullable(builder.getDeliveryPoint()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.interconnectionPoint = builder.getInterconnectionPoint();
			this.loadType = builder.getLoadType();
			this.deliveryReport = ofNullable(builder.getDeliveryReport()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.optionType = builder.getOptionType();
			this.optionStyle = builder.getOptionStyle();
			this.strikePrice = ofNullable(builder.getStrikePrice()).map(f->f.build()).orElse(null);
			this.strikePriceSchedule = ofNullable(builder.getStrikePriceSchedule()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.optionPremiumAmount = builder.getOptionPremiumAmount();
			this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
			this.optionPremiumPaymentDate = builder.getOptionPremiumPaymentDate();
			this.maturityDateOfTheUnderlying = builder.getMaturityDateOfTheUnderlying();
			this.seniority = builder.getSeniority();
			this.referenceEntity = builder.getReferenceEntity();
			this.series = builder.getSeries();
			this.version = builder.getVersion();
			this.indexFactor = builder.getIndexFactor();
			this.tranche = builder.getTranche();
			this.cdSIndexAttachmentPoint = builder.getCdSIndexAttachmentPoint();
			this.cdSIndexDetachmentPoint = builder.getCdSIndexDetachmentPoint();
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.collateralPortfolioCode = builder.getCollateralPortfolioCode();
			this.actionType = builder.getActionType();
			this.eventType = builder.getEventType();
			this.eventDate = builder.getEventDate();
			this.level = builder.getLevel();
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
		@RuneAttribute(value="natureOfCounterparty1", isRequired=true)
		public String getNatureOfCounterparty1() {
			return natureOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public List<String> getCorporateSectorOfTheCounterparty1() {
			return corporateSectorOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		public Boolean getClearingThresholdOfCounterparty1() {
			return clearingThresholdOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
			return countryOfTheCounterParty2;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		public String getNatureOfCounterparty2() {
			return natureOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public List<String> getCorporateSectorOfTheCounterparty2() {
			return corporateSectorOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		public Boolean getClearingThresholdOfCounterparty2() {
			return clearingThresholdOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		public Boolean getReportingObligationOfTheCounterparty2() {
			return reportingObligationOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		public String getBrokerID() {
			return brokerID;
		}
		
		@Override
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		public String getDirection() {
			return direction;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg1")
		@RuneAttribute("directionOfLeg1")
		public String getDirectionOfLeg1() {
			return directionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg2")
		@RuneAttribute("directionOfLeg2")
		public String getDirectionOfLeg2() {
			return directionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		public Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() {
			return directlyLinkedToCommercialActivityOrTreasuryFinancing;
		}
		
		@Override
		@RosettaAttribute("executionAgent")
		@RuneAttribute("executionAgent")
		public ExecutionAgent getExecutionAgent() {
			return executionAgent;
		}
		
		@Override
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("utiProprietary")
		@RuneAttribute("utiProprietary")
		public String getUtiProprietary() {
			return utiProprietary;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public String getReportTrackingNumber() {
			return reportTrackingNumber;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public String getPriorUTIProprietary() {
			return priorUTIProprietary;
		}
		
		@Override
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		public String getPtrrId() {
			return ptrrId;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public String getSubsequentPositionUTI() {
			return subsequentPositionUTI;
		}
		
		@Override
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		public String getIsin() {
			return isin;
		}
		
		@Override
		@RosettaAttribute("upi")
		@RuneAttribute("upi")
		public String getUpi() {
			return upi;
		}
		
		@Override
		@RosettaAttribute(value="productClassification", isRequired=true)
		@RuneAttribute(value="productClassification", isRequired=true)
		public String getProductClassification() {
			return productClassification;
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="isCrypto", isRequired=true)
		@RuneAttribute(value="isCrypto", isRequired=true)
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public List<String> getNameOfTheUnderlyingIndex() {
			return nameOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheUnderlyingIndex")
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		public List<String> getIndicatorOfTheUnderlyingIndex() {
			return indicatorOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("identifierOfBasketConstituents")
		@RuneAttribute("identifierOfBasketConstituents")
		public List<String> getIdentifierOfBasketConstituents() {
			return identifierOfBasketConstituents;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		public ISOCurrencyCodeEnum getSettlementCurrency1() {
			return settlementCurrency1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency2")
		@RuneAttribute("settlementCurrency2")
		public String getSettlementCurrency2() {
			return settlementCurrency2;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public String getConfirmed() {
			return confirmed;
		}
		
		@Override
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		public String getClearingObligation() {
			return clearingObligation;
		}
		
		@Override
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public ZonedDateTime getClearingTimestamp() {
			return clearingTimestamp;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute(value="masterAgreementType", isRequired=true)
		@RuneAttribute(value="masterAgreementType", isRequired=true)
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		public String getOtherMasterAgreementType() {
			return otherMasterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public Integer getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public Boolean getIntragroup() {
			return intragroup;
		}
		
		@Override
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		public Boolean getPtrr() {
			return ptrr;
		}
		
		@Override
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		public String getTypeOfPTRRTechnique() {
			return typeOfPTRRTechnique;
		}
		
		@Override
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		public String getPtrrServiceProvider() {
			return ptrrServiceProvider;
		}
		
		@Override
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		public String getVenueOfExecution() {
			return venueOfExecution;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public Date getEarlyTerminationDate() {
			return earlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute(value="deliveryType", isRequired=true)
		@RuneAttribute(value="deliveryType", isRequired=true)
		public String getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public PriceAndNotation getPrice() {
			return price;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public List<? extends PriceScheduleReport> getPriceSchedule() {
			return priceSchedule;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public PackageTransactionPrice getPackageTransactionPrice() {
			return packageTransactionPrice;
		}
		
		@Override
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		public BigDecimal getNotionalLeg1() {
			return notionalLeg1;
		}
		
		@Override
		@RosettaAttribute(value="notionalCurrency1", isRequired=true)
		@RuneAttribute(value="notionalCurrency1", isRequired=true)
		public ISOCurrencyCodeEnum getNotionalCurrency1() {
			return notionalCurrency1;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1() {
			return notionalAmountScheduleLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg1")
		@RuneAttribute("notionalQuantityScheduleLeg1")
		public List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1() {
			return notionalQuantityScheduleLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		public BigDecimal getNotionalLeg2() {
			return notionalLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency2")
		@RuneAttribute("notionalCurrency2")
		public ISOCurrencyCodeEnum getNotionalCurrency2() {
			return notionalCurrency2;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2() {
			return notionalAmountScheduleLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg2")
		@RuneAttribute("notionalQuantityScheduleLeg2")
		public List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2() {
			return notionalQuantityScheduleLeg2;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg1")
		@RuneAttribute("fixedRateOfLeg1")
		public BigDecimal getFixedRateOfLeg1() {
			return fixedRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
			return fixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		public String getFixedRatePaymentFrequencyPeriodLeg1() {
			return fixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg1")
		@RuneAttribute("identifierOfFloatingRateOfLeg1")
		public String getIdentifierOfFloatingRateOfLeg1() {
			return identifierOfFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg1")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg1")
		public String getIndicatorOfTheFloatingRateOfLeg1() {
			return indicatorOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		public String getNameOfTheFloatingRateOfLeg1() {
			return nameOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
			return floatingRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1() {
			return floatingRatePaymentFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg1TimePeriod() {
			return floatingRateReferencePeriodOfLeg1TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg1Multiplier() {
			return floatingRateReferencePeriodOfLeg1Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		public String getFloatingRateResetFrequencyPeriodOfLeg1() {
			return floatingRateResetFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1")
		@RuneAttribute("spreadOfLeg1")
		public SpreadOfLeg1 getSpreadOfLeg1() {
			return spreadOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg2")
		@RuneAttribute("fixedRateOfLeg2")
		public BigDecimal getFixedRateOfLeg2() {
			return fixedRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
			return fixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		public String getFixedRatePaymentFrequencyPeriodLeg2() {
			return fixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg2")
		@RuneAttribute("identifierOfFloatingRateOfLeg2")
		public String getIdentifierOfFloatingRateOfLeg2() {
			return identifierOfFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg2")
		public String getIndicatorOfTheFloatingRateOfLeg2() {
			return indicatorOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		public String getNameOfTheFloatingRateOfLeg2() {
			return nameOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
			return floatingRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		public String getFloatingRatePaymentFrequencyPeriodOfLeg2() {
			return floatingRatePaymentFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
			return floatingRateReferencePeriodOfLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
			return floatingRateReferencePeriodOfLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		public String getFloatingRateResetFrequencyPeriodOfLeg2() {
			return floatingRateResetFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2")
		@RuneAttribute("spreadOfLeg2")
		public SpreadOfLeg2 getSpreadOfLeg2() {
			return spreadOfLeg2;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public PackageTransactionSpread getPackageTransactionSpread() {
			return packageTransactionSpread;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public BigDecimal getForwardExchangeRate() {
			return forwardExchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public String getBaseProduct() {
			return baseProduct;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public String getSubProduct() {
			return subProduct;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public String getFurtherSubProduct() {
			return furtherSubProduct;
		}
		
		@Override
		@RosettaAttribute("deliveryPoint")
		@RuneAttribute("deliveryPoint")
		public List<String> getDeliveryPoint() {
			return deliveryPoint;
		}
		
		@Override
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		public String getInterconnectionPoint() {
			return interconnectionPoint;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public EnergyLoadType1Code getLoadType() {
			return loadType;
		}
		
		@Override
		@RosettaAttribute("deliveryReport")
		@RuneAttribute("deliveryReport")
		public List<? extends DeliveryReport> getDeliveryReport() {
			return deliveryReport;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public StrikePriceAndNotation getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public List<? extends StrikePriceScheduleReport> getStrikePriceSchedule() {
			return strikePriceSchedule;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public String getSeniority() {
			return seniority;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public Integer getSeries() {
			return series;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public Boolean getTranche() {
			return tranche;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public BigDecimal getCdSIndexAttachmentPoint() {
			return cdSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public BigDecimal getCdSIndexDetachmentPoint() {
			return cdSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		public String getCollateralPortfolioCode() {
			return collateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		public String getLevel() {
			return level;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public FCAUKEMIRNonReportable getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public FCAUKEMIRTransactionReport build() {
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder toBuilder() {
			FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder builder) {
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getNatureOfCounterparty1()).ifPresent(builder::setNatureOfCounterparty1);
			ofNullable(getCorporateSectorOfTheCounterparty1()).ifPresent(builder::setCorporateSectorOfTheCounterparty1);
			ofNullable(getClearingThresholdOfCounterparty1()).ifPresent(builder::setClearingThresholdOfCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCountryOfTheCounterParty2()).ifPresent(builder::setCountryOfTheCounterParty2);
			ofNullable(getNatureOfCounterparty2()).ifPresent(builder::setNatureOfCounterparty2);
			ofNullable(getCorporateSectorOfTheCounterparty2()).ifPresent(builder::setCorporateSectorOfTheCounterparty2);
			ofNullable(getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
			ofNullable(getClearingMember()).ifPresent(builder::setClearingMember);
			ofNullable(getClearingThresholdOfCounterparty2()).ifPresent(builder::setClearingThresholdOfCounterparty2);
			ofNullable(getReportingObligationOfTheCounterparty2()).ifPresent(builder::setReportingObligationOfTheCounterparty2);
			ofNullable(getBrokerID()).ifPresent(builder::setBrokerID);
			ofNullable(getDirection()).ifPresent(builder::setDirection);
			ofNullable(getDirectionOfLeg1()).ifPresent(builder::setDirectionOfLeg1);
			ofNullable(getDirectionOfLeg2()).ifPresent(builder::setDirectionOfLeg2);
			ofNullable(getDirectlyLinkedToCommercialActivityOrTreasuryFinancing()).ifPresent(builder::setDirectlyLinkedToCommercialActivityOrTreasuryFinancing);
			ofNullable(getExecutionAgent()).ifPresent(builder::setExecutionAgent);
			ofNullable(getUti()).ifPresent(builder::setUti);
			ofNullable(getUtiProprietary()).ifPresent(builder::setUtiProprietary);
			ofNullable(getReportTrackingNumber()).ifPresent(builder::setReportTrackingNumber);
			ofNullable(getPriorUTI()).ifPresent(builder::setPriorUTI);
			ofNullable(getPriorUTIProprietary()).ifPresent(builder::setPriorUTIProprietary);
			ofNullable(getPtrrId()).ifPresent(builder::setPtrrId);
			ofNullable(getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
			ofNullable(getSubsequentPositionUTI()).ifPresent(builder::setSubsequentPositionUTI);
			ofNullable(getIsin()).ifPresent(builder::setIsin);
			ofNullable(getUpi()).ifPresent(builder::setUpi);
			ofNullable(getProductClassification()).ifPresent(builder::setProductClassification);
			ofNullable(getContractType()).ifPresent(builder::setContractType);
			ofNullable(getAssetClass()).ifPresent(builder::setAssetClass);
			ofNullable(getIsCrypto()).ifPresent(builder::setIsCrypto);
			ofNullable(getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
			ofNullable(getUnderlyingIdentification()).ifPresent(builder::setUnderlyingIdentification);
			ofNullable(getNameOfTheUnderlyingIndex()).ifPresent(builder::setNameOfTheUnderlyingIndex);
			ofNullable(getIndicatorOfTheUnderlyingIndex()).ifPresent(builder::setIndicatorOfTheUnderlyingIndex);
			ofNullable(getIdentifierOfBasketConstituents()).ifPresent(builder::setIdentifierOfBasketConstituents);
			ofNullable(getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
			ofNullable(getSettlementCurrency1()).ifPresent(builder::setSettlementCurrency1);
			ofNullable(getSettlementCurrency2()).ifPresent(builder::setSettlementCurrency2);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getDelta()).ifPresent(builder::setDelta);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getConfirmationTimestamp()).ifPresent(builder::setConfirmationTimestamp);
			ofNullable(getConfirmed()).ifPresent(builder::setConfirmed);
			ofNullable(getClearingObligation()).ifPresent(builder::setClearingObligation);
			ofNullable(getCleared()).ifPresent(builder::setCleared);
			ofNullable(getClearingTimestamp()).ifPresent(builder::setClearingTimestamp);
			ofNullable(getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
			ofNullable(getMasterAgreementType()).ifPresent(builder::setMasterAgreementType);
			ofNullable(getOtherMasterAgreementType()).ifPresent(builder::setOtherMasterAgreementType);
			ofNullable(getMasterAgreementVersion()).ifPresent(builder::setMasterAgreementVersion);
			ofNullable(getIntragroup()).ifPresent(builder::setIntragroup);
			ofNullable(getPtrr()).ifPresent(builder::setPtrr);
			ofNullable(getTypeOfPTRRTechnique()).ifPresent(builder::setTypeOfPTRRTechnique);
			ofNullable(getPtrrServiceProvider()).ifPresent(builder::setPtrrServiceProvider);
			ofNullable(getVenueOfExecution()).ifPresent(builder::setVenueOfExecution);
			ofNullable(getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getExpirationDate()).ifPresent(builder::setExpirationDate);
			ofNullable(getEarlyTerminationDate()).ifPresent(builder::setEarlyTerminationDate);
			ofNullable(getFinalContractualSettlementDate()).ifPresent(builder::setFinalContractualSettlementDate);
			ofNullable(getDeliveryType()).ifPresent(builder::setDeliveryType);
			ofNullable(getPrice()).ifPresent(builder::setPrice);
			ofNullable(getPriceSchedule()).ifPresent(builder::setPriceSchedule);
			ofNullable(getPackageTransactionPrice()).ifPresent(builder::setPackageTransactionPrice);
			ofNullable(getNotionalLeg1()).ifPresent(builder::setNotionalLeg1);
			ofNullable(getNotionalCurrency1()).ifPresent(builder::setNotionalCurrency1);
			ofNullable(getNotionalAmountScheduleLeg1()).ifPresent(builder::setNotionalAmountScheduleLeg1);
			ofNullable(getTotalNotionalQuantityLeg1()).ifPresent(builder::setTotalNotionalQuantityLeg1);
			ofNullable(getNotionalQuantityScheduleLeg1()).ifPresent(builder::setNotionalQuantityScheduleLeg1);
			ofNullable(getTotalNotionalQuantityLeg2()).ifPresent(builder::setTotalNotionalQuantityLeg2);
			ofNullable(getNotionalLeg2()).ifPresent(builder::setNotionalLeg2);
			ofNullable(getNotionalCurrency2()).ifPresent(builder::setNotionalCurrency2);
			ofNullable(getNotionalAmountScheduleLeg2()).ifPresent(builder::setNotionalAmountScheduleLeg2);
			ofNullable(getNotionalQuantityScheduleLeg2()).ifPresent(builder::setNotionalQuantityScheduleLeg2);
			ofNullable(getOtherPayment()).ifPresent(builder::setOtherPayment);
			ofNullable(getFixedRateOfLeg1()).ifPresent(builder::setFixedRateOfLeg1);
			ofNullable(getFixedRateDayCountConventionLeg1()).ifPresent(builder::setFixedRateDayCountConventionLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getIdentifierOfFloatingRateOfLeg1()).ifPresent(builder::setIdentifierOfFloatingRateOfLeg1);
			ofNullable(getIndicatorOfTheFloatingRateOfLeg1()).ifPresent(builder::setIndicatorOfTheFloatingRateOfLeg1);
			ofNullable(getNameOfTheFloatingRateOfLeg1()).ifPresent(builder::setNameOfTheFloatingRateOfLeg1);
			ofNullable(getFloatingRateDayCountConventionOfLeg1()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodOfLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodOfLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
			ofNullable(getFloatingRateReferencePeriodOfLeg1TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg1TimePeriod);
			ofNullable(getFloatingRateReferencePeriodOfLeg1Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg1Multiplier);
			ofNullable(getFloatingRateResetFrequencyPeriodOfLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg1);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg1);
			ofNullable(getSpreadOfLeg1()).ifPresent(builder::setSpreadOfLeg1);
			ofNullable(getFixedRateOfLeg2()).ifPresent(builder::setFixedRateOfLeg2);
			ofNullable(getFixedRateDayCountConventionLeg2()).ifPresent(builder::setFixedRateDayCountConventionLeg2);
			ofNullable(getFixedRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg2);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getIdentifierOfFloatingRateOfLeg2()).ifPresent(builder::setIdentifierOfFloatingRateOfLeg2);
			ofNullable(getIndicatorOfTheFloatingRateOfLeg2()).ifPresent(builder::setIndicatorOfTheFloatingRateOfLeg2);
			ofNullable(getNameOfTheFloatingRateOfLeg2()).ifPresent(builder::setNameOfTheFloatingRateOfLeg2);
			ofNullable(getFloatingRateDayCountConventionOfLeg2()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodOfLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
			ofNullable(getFloatingRateReferencePeriodOfLeg2TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2TimePeriod);
			ofNullable(getFloatingRateReferencePeriodOfLeg2Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2Multiplier);
			ofNullable(getFloatingRateResetFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg2);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg2);
			ofNullable(getSpreadOfLeg2()).ifPresent(builder::setSpreadOfLeg2);
			ofNullable(getPackageTransactionSpread()).ifPresent(builder::setPackageTransactionSpread);
			ofNullable(getExchangeRate()).ifPresent(builder::setExchangeRate);
			ofNullable(getForwardExchangeRate()).ifPresent(builder::setForwardExchangeRate);
			ofNullable(getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
			ofNullable(getBaseProduct()).ifPresent(builder::setBaseProduct);
			ofNullable(getSubProduct()).ifPresent(builder::setSubProduct);
			ofNullable(getFurtherSubProduct()).ifPresent(builder::setFurtherSubProduct);
			ofNullable(getDeliveryPoint()).ifPresent(builder::setDeliveryPoint);
			ofNullable(getInterconnectionPoint()).ifPresent(builder::setInterconnectionPoint);
			ofNullable(getLoadType()).ifPresent(builder::setLoadType);
			ofNullable(getDeliveryReport()).ifPresent(builder::setDeliveryReport);
			ofNullable(getOptionType()).ifPresent(builder::setOptionType);
			ofNullable(getOptionStyle()).ifPresent(builder::setOptionStyle);
			ofNullable(getStrikePrice()).ifPresent(builder::setStrikePrice);
			ofNullable(getStrikePriceSchedule()).ifPresent(builder::setStrikePriceSchedule);
			ofNullable(getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
			ofNullable(getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
			ofNullable(getOptionPremiumPaymentDate()).ifPresent(builder::setOptionPremiumPaymentDate);
			ofNullable(getMaturityDateOfTheUnderlying()).ifPresent(builder::setMaturityDateOfTheUnderlying);
			ofNullable(getSeniority()).ifPresent(builder::setSeniority);
			ofNullable(getReferenceEntity()).ifPresent(builder::setReferenceEntity);
			ofNullable(getSeries()).ifPresent(builder::setSeries);
			ofNullable(getVersion()).ifPresent(builder::setVersion);
			ofNullable(getIndexFactor()).ifPresent(builder::setIndexFactor);
			ofNullable(getTranche()).ifPresent(builder::setTranche);
			ofNullable(getCdSIndexAttachmentPoint()).ifPresent(builder::setCdSIndexAttachmentPoint);
			ofNullable(getCdSIndexDetachmentPoint()).ifPresent(builder::setCdSIndexDetachmentPoint);
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getCollateralPortfolioCode()).ifPresent(builder::setCollateralPortfolioCode);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getEventType()).ifPresent(builder::setEventType);
			ofNullable(getEventDate()).ifPresent(builder::setEventDate);
			ofNullable(getLevel()).ifPresent(builder::setLevel);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FCAUKEMIRTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(natureOfCounterparty1, _that.getNatureOfCounterparty1())) return false;
			if (!ListEquals.listEquals(corporateSectorOfTheCounterparty1, _that.getCorporateSectorOfTheCounterparty1())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty1, _that.getClearingThresholdOfCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) return false;
			if (!Objects.equals(natureOfCounterparty2, _that.getNatureOfCounterparty2())) return false;
			if (!ListEquals.listEquals(corporateSectorOfTheCounterparty2, _that.getCorporateSectorOfTheCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty2, _that.getClearingThresholdOfCounterparty2())) return false;
			if (!Objects.equals(reportingObligationOfTheCounterparty2, _that.getReportingObligationOfTheCounterparty2())) return false;
			if (!Objects.equals(brokerID, _that.getBrokerID())) return false;
			if (!Objects.equals(direction, _that.getDirection())) return false;
			if (!Objects.equals(directionOfLeg1, _that.getDirectionOfLeg1())) return false;
			if (!Objects.equals(directionOfLeg2, _that.getDirectionOfLeg2())) return false;
			if (!Objects.equals(directlyLinkedToCommercialActivityOrTreasuryFinancing, _that.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing())) return false;
			if (!Objects.equals(executionAgent, _that.getExecutionAgent())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(utiProprietary, _that.getUtiProprietary())) return false;
			if (!Objects.equals(reportTrackingNumber, _that.getReportTrackingNumber())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(priorUTIProprietary, _that.getPriorUTIProprietary())) return false;
			if (!Objects.equals(ptrrId, _that.getPtrrId())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(subsequentPositionUTI, _that.getSubsequentPositionUTI())) return false;
			if (!Objects.equals(isin, _that.getIsin())) return false;
			if (!Objects.equals(upi, _that.getUpi())) return false;
			if (!Objects.equals(productClassification, _that.getProductClassification())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!ListEquals.listEquals(nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) return false;
			if (!ListEquals.listEquals(indicatorOfTheUnderlyingIndex, _that.getIndicatorOfTheUnderlyingIndex())) return false;
			if (!ListEquals.listEquals(identifierOfBasketConstituents, _that.getIdentifierOfBasketConstituents())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(settlementCurrency1, _that.getSettlementCurrency1())) return false;
			if (!Objects.equals(settlementCurrency2, _that.getSettlementCurrency2())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(confirmed, _that.getConfirmed())) return false;
			if (!Objects.equals(clearingObligation, _that.getClearingObligation())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(clearingTimestamp, _that.getClearingTimestamp())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(otherMasterAgreementType, _that.getOtherMasterAgreementType())) return false;
			if (!Objects.equals(masterAgreementVersion, _that.getMasterAgreementVersion())) return false;
			if (!Objects.equals(intragroup, _that.getIntragroup())) return false;
			if (!Objects.equals(ptrr, _that.getPtrr())) return false;
			if (!Objects.equals(typeOfPTRRTechnique, _that.getTypeOfPTRRTechnique())) return false;
			if (!Objects.equals(ptrrServiceProvider, _that.getPtrrServiceProvider())) return false;
			if (!Objects.equals(venueOfExecution, _that.getVenueOfExecution())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(earlyTerminationDate, _that.getEarlyTerminationDate())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!ListEquals.listEquals(priceSchedule, _that.getPriceSchedule())) return false;
			if (!Objects.equals(packageTransactionPrice, _that.getPackageTransactionPrice())) return false;
			if (!Objects.equals(notionalLeg1, _that.getNotionalLeg1())) return false;
			if (!Objects.equals(notionalCurrency1, _that.getNotionalCurrency1())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg1, _that.getNotionalQuantityScheduleLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(notionalLeg2, _that.getNotionalLeg2())) return false;
			if (!Objects.equals(notionalCurrency2, _that.getNotionalCurrency2())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg2, _that.getNotionalQuantityScheduleLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(fixedRateOfLeg1, _that.getFixedRateOfLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg1, _that.getIdentifierOfFloatingRateOfLeg1())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg1, _that.getIndicatorOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1TimePeriod, _that.getFloatingRateReferencePeriodOfLeg1TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1Multiplier, _that.getFloatingRateReferencePeriodOfLeg1Multiplier())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg1, _that.getFloatingRateResetFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(spreadOfLeg1, _that.getSpreadOfLeg1())) return false;
			if (!Objects.equals(fixedRateOfLeg2, _that.getFixedRateOfLeg2())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg2, _that.getIdentifierOfFloatingRateOfLeg2())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg2, _that.getIndicatorOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(spreadOfLeg2, _that.getSpreadOfLeg2())) return false;
			if (!Objects.equals(packageTransactionSpread, _that.getPackageTransactionSpread())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(forwardExchangeRate, _that.getForwardExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(baseProduct, _that.getBaseProduct())) return false;
			if (!Objects.equals(subProduct, _that.getSubProduct())) return false;
			if (!Objects.equals(furtherSubProduct, _that.getFurtherSubProduct())) return false;
			if (!ListEquals.listEquals(deliveryPoint, _that.getDeliveryPoint())) return false;
			if (!Objects.equals(interconnectionPoint, _that.getInterconnectionPoint())) return false;
			if (!Objects.equals(loadType, _that.getLoadType())) return false;
			if (!ListEquals.listEquals(deliveryReport, _that.getDeliveryReport())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!ListEquals.listEquals(strikePriceSchedule, _that.getStrikePriceSchedule())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(seniority, _that.getSeniority())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(series, _that.getSeries())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(tranche, _that.getTranche())) return false;
			if (!Objects.equals(cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(collateralPortfolioCode, _that.getCollateralPortfolioCode())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty1 != null ? natureOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty1 != null ? corporateSectorOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty1 != null ? clearingThresholdOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (countryOfTheCounterParty2 != null ? countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty2 != null ? natureOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty2 != null ? corporateSectorOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty2 != null ? clearingThresholdOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (reportingObligationOfTheCounterparty2 != null ? reportingObligationOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (brokerID != null ? brokerID.hashCode() : 0);
			_result = 31 * _result + (direction != null ? direction.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg1 != null ? directionOfLeg1.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg2 != null ? directionOfLeg2.hashCode() : 0);
			_result = 31 * _result + (directlyLinkedToCommercialActivityOrTreasuryFinancing != null ? directlyLinkedToCommercialActivityOrTreasuryFinancing.hashCode() : 0);
			_result = 31 * _result + (executionAgent != null ? executionAgent.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (utiProprietary != null ? utiProprietary.hashCode() : 0);
			_result = 31 * _result + (reportTrackingNumber != null ? reportTrackingNumber.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (priorUTIProprietary != null ? priorUTIProprietary.hashCode() : 0);
			_result = 31 * _result + (ptrrId != null ? ptrrId.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (subsequentPositionUTI != null ? subsequentPositionUTI.hashCode() : 0);
			_result = 31 * _result + (isin != null ? isin.hashCode() : 0);
			_result = 31 * _result + (upi != null ? upi.hashCode() : 0);
			_result = 31 * _result + (productClassification != null ? productClassification.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (nameOfTheUnderlyingIndex != null ? nameOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheUnderlyingIndex != null ? indicatorOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (identifierOfBasketConstituents != null ? identifierOfBasketConstituents.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (settlementCurrency1 != null ? settlementCurrency1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrency2 != null ? settlementCurrency2.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmed != null ? confirmed.hashCode() : 0);
			_result = 31 * _result + (clearingObligation != null ? clearingObligation.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (clearingTimestamp != null ? clearingTimestamp.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.hashCode() : 0);
			_result = 31 * _result + (otherMasterAgreementType != null ? otherMasterAgreementType.hashCode() : 0);
			_result = 31 * _result + (masterAgreementVersion != null ? masterAgreementVersion.hashCode() : 0);
			_result = 31 * _result + (intragroup != null ? intragroup.hashCode() : 0);
			_result = 31 * _result + (ptrr != null ? ptrr.hashCode() : 0);
			_result = 31 * _result + (typeOfPTRRTechnique != null ? typeOfPTRRTechnique.hashCode() : 0);
			_result = 31 * _result + (ptrrServiceProvider != null ? ptrrServiceProvider.hashCode() : 0);
			_result = 31 * _result + (venueOfExecution != null ? venueOfExecution.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (earlyTerminationDate != null ? earlyTerminationDate.hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceSchedule != null ? priceSchedule.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPrice != null ? packageTransactionPrice.hashCode() : 0);
			_result = 31 * _result + (notionalLeg1 != null ? notionalLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency1 != null ? notionalCurrency1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1 != null ? notionalAmountScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg1 != null ? notionalQuantityScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalLeg2 != null ? notionalLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency2 != null ? notionalCurrency2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2 != null ? notionalAmountScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg2 != null ? notionalQuantityScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg1 != null ? fixedRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg1 != null ? fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg1 != null ? fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg1 != null ? identifierOfFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg1 != null ? indicatorOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg1 != null ? nameOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg1 != null ? floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg1 != null ? floatingRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1TimePeriod != null ? floatingRateReferencePeriodOfLeg1TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1Multiplier != null ? floatingRateReferencePeriodOfLeg1Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg1 != null ? floatingRateResetFrequencyPeriodOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1 != null ? spreadOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg2 != null ? fixedRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg2 != null ? fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg2 != null ? fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg2 != null ? identifierOfFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg2 != null ? indicatorOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg2 != null ? nameOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg2 != null ? floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg2 != null ? floatingRatePaymentFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2TimePeriod != null ? floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2Multiplier != null ? floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg2 != null ? floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2 != null ? spreadOfLeg2.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpread != null ? packageTransactionSpread.hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (forwardExchangeRate != null ? forwardExchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (baseProduct != null ? baseProduct.hashCode() : 0);
			_result = 31 * _result + (subProduct != null ? subProduct.hashCode() : 0);
			_result = 31 * _result + (furtherSubProduct != null ? furtherSubProduct.hashCode() : 0);
			_result = 31 * _result + (deliveryPoint != null ? deliveryPoint.hashCode() : 0);
			_result = 31 * _result + (interconnectionPoint != null ? interconnectionPoint.hashCode() : 0);
			_result = 31 * _result + (loadType != null ? loadType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (deliveryReport != null ? deliveryReport.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceSchedule != null ? strikePriceSchedule.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (seniority != null ? seniority.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (series != null ? series.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (tranche != null ? tranche.hashCode() : 0);
			_result = 31 * _result + (cdSIndexAttachmentPoint != null ? cdSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cdSIndexDetachmentPoint != null ? cdSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCode != null ? collateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (level != null ? level.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FCAUKEMIRTransactionReport {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"natureOfCounterparty1=" + this.natureOfCounterparty1 + ", " +
				"corporateSectorOfTheCounterparty1=" + this.corporateSectorOfTheCounterparty1 + ", " +
				"clearingThresholdOfCounterparty1=" + this.clearingThresholdOfCounterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"countryOfTheCounterParty2=" + this.countryOfTheCounterParty2 + ", " +
				"natureOfCounterparty2=" + this.natureOfCounterparty2 + ", " +
				"corporateSectorOfTheCounterparty2=" + this.corporateSectorOfTheCounterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"clearingThresholdOfCounterparty2=" + this.clearingThresholdOfCounterparty2 + ", " +
				"reportingObligationOfTheCounterparty2=" + this.reportingObligationOfTheCounterparty2 + ", " +
				"brokerID=" + this.brokerID + ", " +
				"direction=" + this.direction + ", " +
				"directionOfLeg1=" + this.directionOfLeg1 + ", " +
				"directionOfLeg2=" + this.directionOfLeg2 + ", " +
				"directlyLinkedToCommercialActivityOrTreasuryFinancing=" + this.directlyLinkedToCommercialActivityOrTreasuryFinancing + ", " +
				"executionAgent=" + this.executionAgent + ", " +
				"uti=" + this.uti + ", " +
				"utiProprietary=" + this.utiProprietary + ", " +
				"reportTrackingNumber=" + this.reportTrackingNumber + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"priorUTIProprietary=" + this.priorUTIProprietary + ", " +
				"ptrrId=" + this.ptrrId + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"subsequentPositionUTI=" + this.subsequentPositionUTI + ", " +
				"isin=" + this.isin + ", " +
				"upi=" + this.upi + ", " +
				"productClassification=" + this.productClassification + ", " +
				"contractType=" + this.contractType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", " +
				"indicatorOfTheUnderlyingIndex=" + this.indicatorOfTheUnderlyingIndex + ", " +
				"identifierOfBasketConstituents=" + this.identifierOfBasketConstituents + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"settlementCurrency1=" + this.settlementCurrency1 + ", " +
				"settlementCurrency2=" + this.settlementCurrency2 + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"confirmed=" + this.confirmed + ", " +
				"clearingObligation=" + this.clearingObligation + ", " +
				"cleared=" + this.cleared + ", " +
				"clearingTimestamp=" + this.clearingTimestamp + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"otherMasterAgreementType=" + this.otherMasterAgreementType + ", " +
				"masterAgreementVersion=" + this.masterAgreementVersion + ", " +
				"intragroup=" + this.intragroup + ", " +
				"ptrr=" + this.ptrr + ", " +
				"typeOfPTRRTechnique=" + this.typeOfPTRRTechnique + ", " +
				"ptrrServiceProvider=" + this.ptrrServiceProvider + ", " +
				"venueOfExecution=" + this.venueOfExecution + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"earlyTerminationDate=" + this.earlyTerminationDate + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"price=" + this.price + ", " +
				"priceSchedule=" + this.priceSchedule + ", " +
				"packageTransactionPrice=" + this.packageTransactionPrice + ", " +
				"notionalLeg1=" + this.notionalLeg1 + ", " +
				"notionalCurrency1=" + this.notionalCurrency1 + ", " +
				"notionalAmountScheduleLeg1=" + this.notionalAmountScheduleLeg1 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"notionalQuantityScheduleLeg1=" + this.notionalQuantityScheduleLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"notionalLeg2=" + this.notionalLeg2 + ", " +
				"notionalCurrency2=" + this.notionalCurrency2 + ", " +
				"notionalAmountScheduleLeg2=" + this.notionalAmountScheduleLeg2 + ", " +
				"notionalQuantityScheduleLeg2=" + this.notionalQuantityScheduleLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"fixedRateOfLeg1=" + this.fixedRateOfLeg1 + ", " +
				"fixedRateDayCountConventionLeg1=" + this.fixedRateDayCountConventionLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"identifierOfFloatingRateOfLeg1=" + this.identifierOfFloatingRateOfLeg1 + ", " +
				"indicatorOfTheFloatingRateOfLeg1=" + this.indicatorOfTheFloatingRateOfLeg1 + ", " +
				"nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", " +
				"floatingRateDayCountConventionOfLeg1=" + this.floatingRateDayCountConventionOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg1=" + this.floatingRatePaymentFrequencyPeriodOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", " +
				"floatingRateReferencePeriodOfLeg1TimePeriod=" + this.floatingRateReferencePeriodOfLeg1TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg1Multiplier=" + this.floatingRateReferencePeriodOfLeg1Multiplier + ", " +
				"floatingRateResetFrequencyPeriodOfLeg1=" + this.floatingRateResetFrequencyPeriodOfLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", " +
				"spreadOfLeg1=" + this.spreadOfLeg1 + ", " +
				"fixedRateOfLeg2=" + this.fixedRateOfLeg2 + ", " +
				"fixedRateDayCountConventionLeg2=" + this.fixedRateDayCountConventionLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"identifierOfFloatingRateOfLeg2=" + this.identifierOfFloatingRateOfLeg2 + ", " +
				"indicatorOfTheFloatingRateOfLeg2=" + this.indicatorOfTheFloatingRateOfLeg2 + ", " +
				"nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", " +
				"floatingRateDayCountConventionOfLeg2=" + this.floatingRateDayCountConventionOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg2=" + this.floatingRatePaymentFrequencyPeriodOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", " +
				"floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", " +
				"floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", " +
				"spreadOfLeg2=" + this.spreadOfLeg2 + ", " +
				"packageTransactionSpread=" + this.packageTransactionSpread + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"forwardExchangeRate=" + this.forwardExchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"baseProduct=" + this.baseProduct + ", " +
				"subProduct=" + this.subProduct + ", " +
				"furtherSubProduct=" + this.furtherSubProduct + ", " +
				"deliveryPoint=" + this.deliveryPoint + ", " +
				"interconnectionPoint=" + this.interconnectionPoint + ", " +
				"loadType=" + this.loadType + ", " +
				"deliveryReport=" + this.deliveryReport + ", " +
				"optionType=" + this.optionType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"strikePriceSchedule=" + this.strikePriceSchedule + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"seniority=" + this.seniority + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"series=" + this.series + ", " +
				"version=" + this.version + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"tranche=" + this.tranche + ", " +
				"cdSIndexAttachmentPoint=" + this.cdSIndexAttachmentPoint + ", " +
				"cdSIndexDetachmentPoint=" + this.cdSIndexDetachmentPoint + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"collateralPortfolioCode=" + this.collateralPortfolioCode + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"eventDate=" + this.eventDate + ", " +
				"level=" + this.level + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}

	/*********************** Builder Implementation of FCAUKEMIRTransactionReport  ***********************/
	class FCAUKEMIRTransactionReportBuilderImpl implements FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder {
	
		protected ZonedDateTime reportingTimestamp;
		protected String reportSubmittingEntityID;
		protected String entityResponsibleForReporting;
		protected String counterparty1;
		protected String natureOfCounterparty1;
		protected List<String> corporateSectorOfTheCounterparty1 = new ArrayList<>();
		protected Boolean clearingThresholdOfCounterparty1;
		protected String counterparty2;
		protected ISOCountryCodeEnum countryOfTheCounterParty2;
		protected String natureOfCounterparty2;
		protected List<String> corporateSectorOfTheCounterparty2 = new ArrayList<>();
		protected Boolean counterparty2IdentifierType;
		protected String clearingMember;
		protected Boolean clearingThresholdOfCounterparty2;
		protected Boolean reportingObligationOfTheCounterparty2;
		protected String brokerID;
		protected String direction;
		protected String directionOfLeg1;
		protected String directionOfLeg2;
		protected Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing;
		protected ExecutionAgent.ExecutionAgentBuilder executionAgent;
		protected String uti;
		protected String utiProprietary;
		protected String reportTrackingNumber;
		protected String priorUTI;
		protected String priorUTIProprietary;
		protected String ptrrId;
		protected String packageIdentifier;
		protected String subsequentPositionUTI;
		protected String isin;
		protected String upi;
		protected String productClassification;
		protected String contractType;
		protected String assetClass;
		protected Boolean isCrypto;
		protected String underlyingIdentificationType;
		protected String underlyingIdentification;
		protected List<String> nameOfTheUnderlyingIndex = new ArrayList<>();
		protected List<String> indicatorOfTheUnderlyingIndex = new ArrayList<>();
		protected List<String> identifierOfBasketConstituents = new ArrayList<>();
		protected String customBasketCode;
		protected ISOCurrencyCodeEnum settlementCurrency1;
		protected String settlementCurrency2;
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ValuationType1Code valuationMethod;
		protected BigDecimal delta;
		protected ZonedDateTime valuationTimestamp;
		protected ZonedDateTime confirmationTimestamp;
		protected String confirmed;
		protected String clearingObligation;
		protected String cleared;
		protected ZonedDateTime clearingTimestamp;
		protected String centralCounterparty;
		protected String masterAgreementType;
		protected String otherMasterAgreementType;
		protected Integer masterAgreementVersion;
		protected Boolean intragroup;
		protected Boolean ptrr;
		protected String typeOfPTRRTechnique;
		protected String ptrrServiceProvider;
		protected String venueOfExecution;
		protected ZonedDateTime executionTimestamp;
		protected Date effectiveDate;
		protected Date expirationDate;
		protected Date earlyTerminationDate;
		protected Date finalContractualSettlementDate;
		protected String deliveryType;
		protected PriceAndNotation.PriceAndNotationBuilder price;
		protected List<PriceScheduleReport.PriceScheduleReportBuilder> priceSchedule = new ArrayList<>();
		protected PackageTransactionPrice.PackageTransactionPriceBuilder packageTransactionPrice;
		protected BigDecimal notionalLeg1;
		protected ISOCurrencyCodeEnum notionalCurrency1;
		protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> notionalAmountScheduleLeg1 = new ArrayList<>();
		protected BigDecimal totalNotionalQuantityLeg1;
		protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> notionalQuantityScheduleLeg1 = new ArrayList<>();
		protected BigDecimal totalNotionalQuantityLeg2;
		protected BigDecimal notionalLeg2;
		protected ISOCurrencyCodeEnum notionalCurrency2;
		protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> notionalAmountScheduleLeg2 = new ArrayList<>();
		protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> notionalQuantityScheduleLeg2 = new ArrayList<>();
		protected List<OtherPaymentReport.OtherPaymentReportBuilder> otherPayment = new ArrayList<>();
		protected BigDecimal fixedRateOfLeg1;
		protected InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
		protected String fixedRatePaymentFrequencyPeriodLeg1;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		protected String identifierOfFloatingRateOfLeg1;
		protected String indicatorOfTheFloatingRateOfLeg1;
		protected String nameOfTheFloatingRateOfLeg1;
		protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
		protected Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		protected String floatingRateReferencePeriodOfLeg1TimePeriod;
		protected Integer floatingRateReferencePeriodOfLeg1Multiplier;
		protected String floatingRateResetFrequencyPeriodOfLeg1;
		protected Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
		protected SpreadOfLeg1.SpreadOfLeg1Builder spreadOfLeg1;
		protected BigDecimal fixedRateOfLeg2;
		protected InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
		protected String fixedRatePaymentFrequencyPeriodLeg2;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		protected String identifierOfFloatingRateOfLeg2;
		protected String indicatorOfTheFloatingRateOfLeg2;
		protected String nameOfTheFloatingRateOfLeg2;
		protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
		protected String floatingRatePaymentFrequencyPeriodOfLeg2;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		protected String floatingRateReferencePeriodOfLeg2TimePeriod;
		protected Integer floatingRateReferencePeriodOfLeg2Multiplier;
		protected String floatingRateResetFrequencyPeriodOfLeg2;
		protected Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
		protected SpreadOfLeg2.SpreadOfLeg2Builder spreadOfLeg2;
		protected PackageTransactionSpread.PackageTransactionSpreadBuilder packageTransactionSpread;
		protected BigDecimal exchangeRate;
		protected BigDecimal forwardExchangeRate;
		protected String exchangeRateBasis;
		protected String baseProduct;
		protected String subProduct;
		protected String furtherSubProduct;
		protected List<String> deliveryPoint = new ArrayList<>();
		protected String interconnectionPoint;
		protected EnergyLoadType1Code loadType;
		protected List<DeliveryReport.DeliveryReportBuilder> deliveryReport = new ArrayList<>();
		protected String optionType;
		protected String optionStyle;
		protected StrikePriceAndNotation.StrikePriceAndNotationBuilder strikePrice;
		protected List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> strikePriceSchedule = new ArrayList<>();
		protected BigDecimal optionPremiumAmount;
		protected ISOCurrencyCodeEnum optionPremiumCurrency;
		protected Date optionPremiumPaymentDate;
		protected Date maturityDateOfTheUnderlying;
		protected String seniority;
		protected String referenceEntity;
		protected Integer series;
		protected Integer version;
		protected BigDecimal indexFactor;
		protected Boolean tranche;
		protected BigDecimal cdSIndexAttachmentPoint;
		protected BigDecimal cdSIndexDetachmentPoint;
		protected Boolean collateralPortfolioIndicator;
		protected String collateralPortfolioCode;
		protected String actionType;
		protected String eventType;
		protected Date eventDate;
		protected String level;
		protected FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder nonReportable;
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
		@RuneAttribute(value="natureOfCounterparty1", isRequired=true)
		public String getNatureOfCounterparty1() {
			return natureOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public List<String> getCorporateSectorOfTheCounterparty1() {
			return corporateSectorOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		public Boolean getClearingThresholdOfCounterparty1() {
			return clearingThresholdOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
			return countryOfTheCounterParty2;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		public String getNatureOfCounterparty2() {
			return natureOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public List<String> getCorporateSectorOfTheCounterparty2() {
			return corporateSectorOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		public Boolean getClearingThresholdOfCounterparty2() {
			return clearingThresholdOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		public Boolean getReportingObligationOfTheCounterparty2() {
			return reportingObligationOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		public String getBrokerID() {
			return brokerID;
		}
		
		@Override
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		public String getDirection() {
			return direction;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg1")
		@RuneAttribute("directionOfLeg1")
		public String getDirectionOfLeg1() {
			return directionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg2")
		@RuneAttribute("directionOfLeg2")
		public String getDirectionOfLeg2() {
			return directionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		public Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() {
			return directlyLinkedToCommercialActivityOrTreasuryFinancing;
		}
		
		@Override
		@RosettaAttribute("executionAgent")
		@RuneAttribute("executionAgent")
		public ExecutionAgent.ExecutionAgentBuilder getExecutionAgent() {
			return executionAgent;
		}
		
		@Override
		public ExecutionAgent.ExecutionAgentBuilder getOrCreateExecutionAgent() {
			ExecutionAgent.ExecutionAgentBuilder result;
			if (executionAgent!=null) {
				result = executionAgent;
			}
			else {
				result = executionAgent = ExecutionAgent.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("utiProprietary")
		@RuneAttribute("utiProprietary")
		public String getUtiProprietary() {
			return utiProprietary;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public String getReportTrackingNumber() {
			return reportTrackingNumber;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public String getPriorUTIProprietary() {
			return priorUTIProprietary;
		}
		
		@Override
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		public String getPtrrId() {
			return ptrrId;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public String getSubsequentPositionUTI() {
			return subsequentPositionUTI;
		}
		
		@Override
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		public String getIsin() {
			return isin;
		}
		
		@Override
		@RosettaAttribute("upi")
		@RuneAttribute("upi")
		public String getUpi() {
			return upi;
		}
		
		@Override
		@RosettaAttribute(value="productClassification", isRequired=true)
		@RuneAttribute(value="productClassification", isRequired=true)
		public String getProductClassification() {
			return productClassification;
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="isCrypto", isRequired=true)
		@RuneAttribute(value="isCrypto", isRequired=true)
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public List<String> getNameOfTheUnderlyingIndex() {
			return nameOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheUnderlyingIndex")
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		public List<String> getIndicatorOfTheUnderlyingIndex() {
			return indicatorOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("identifierOfBasketConstituents")
		@RuneAttribute("identifierOfBasketConstituents")
		public List<String> getIdentifierOfBasketConstituents() {
			return identifierOfBasketConstituents;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		public ISOCurrencyCodeEnum getSettlementCurrency1() {
			return settlementCurrency1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency2")
		@RuneAttribute("settlementCurrency2")
		public String getSettlementCurrency2() {
			return settlementCurrency2;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public String getConfirmed() {
			return confirmed;
		}
		
		@Override
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		public String getClearingObligation() {
			return clearingObligation;
		}
		
		@Override
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public ZonedDateTime getClearingTimestamp() {
			return clearingTimestamp;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute(value="masterAgreementType", isRequired=true)
		@RuneAttribute(value="masterAgreementType", isRequired=true)
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		public String getOtherMasterAgreementType() {
			return otherMasterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public Integer getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public Boolean getIntragroup() {
			return intragroup;
		}
		
		@Override
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		public Boolean getPtrr() {
			return ptrr;
		}
		
		@Override
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		public String getTypeOfPTRRTechnique() {
			return typeOfPTRRTechnique;
		}
		
		@Override
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		public String getPtrrServiceProvider() {
			return ptrrServiceProvider;
		}
		
		@Override
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		public String getVenueOfExecution() {
			return venueOfExecution;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public Date getEarlyTerminationDate() {
			return earlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute(value="deliveryType", isRequired=true)
		@RuneAttribute(value="deliveryType", isRequired=true)
		public String getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public PriceAndNotation.PriceAndNotationBuilder getPrice() {
			return price;
		}
		
		@Override
		public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice() {
			PriceAndNotation.PriceAndNotationBuilder result;
			if (price!=null) {
				result = price;
			}
			else {
				result = price = PriceAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule() {
			return priceSchedule;
		}
		
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int index) {
			if (priceSchedule==null) {
				this.priceSchedule = new ArrayList<>();
			}
			return getIndex(priceSchedule, index, () -> {
						PriceScheduleReport.PriceScheduleReportBuilder newPriceSchedule = PriceScheduleReport.builder();
						return newPriceSchedule;
					});
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice() {
			return packageTransactionPrice;
		}
		
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice() {
			PackageTransactionPrice.PackageTransactionPriceBuilder result;
			if (packageTransactionPrice!=null) {
				result = packageTransactionPrice;
			}
			else {
				result = packageTransactionPrice = PackageTransactionPrice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		public BigDecimal getNotionalLeg1() {
			return notionalLeg1;
		}
		
		@Override
		@RosettaAttribute(value="notionalCurrency1", isRequired=true)
		@RuneAttribute(value="notionalCurrency1", isRequired=true)
		public ISOCurrencyCodeEnum getNotionalCurrency1() {
			return notionalCurrency1;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1() {
			return notionalAmountScheduleLeg1;
		}
		
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index) {
			if (notionalAmountScheduleLeg1==null) {
				this.notionalAmountScheduleLeg1 = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg1, index, () -> {
						NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder newNotionalAmountScheduleLeg1 = NotionalAmountScheduleLeg1Report.builder();
						return newNotionalAmountScheduleLeg1;
					});
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg1")
		@RuneAttribute("notionalQuantityScheduleLeg1")
		public List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1() {
			return notionalQuantityScheduleLeg1;
		}
		
		@Override
		public NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1(int index) {
			if (notionalQuantityScheduleLeg1==null) {
				this.notionalQuantityScheduleLeg1 = new ArrayList<>();
			}
			return getIndex(notionalQuantityScheduleLeg1, index, () -> {
						NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder newNotionalQuantityScheduleLeg1 = NotionalQuantityScheduleLeg1Report.builder();
						return newNotionalQuantityScheduleLeg1;
					});
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		public BigDecimal getNotionalLeg2() {
			return notionalLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency2")
		@RuneAttribute("notionalCurrency2")
		public ISOCurrencyCodeEnum getNotionalCurrency2() {
			return notionalCurrency2;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2() {
			return notionalAmountScheduleLeg2;
		}
		
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index) {
			if (notionalAmountScheduleLeg2==null) {
				this.notionalAmountScheduleLeg2 = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg2, index, () -> {
						NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder newNotionalAmountScheduleLeg2 = NotionalAmountScheduleLeg2Report.builder();
						return newNotionalAmountScheduleLeg2;
					});
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg2")
		@RuneAttribute("notionalQuantityScheduleLeg2")
		public List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2() {
			return notionalQuantityScheduleLeg2;
		}
		
		@Override
		public NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2(int index) {
			if (notionalQuantityScheduleLeg2==null) {
				this.notionalQuantityScheduleLeg2 = new ArrayList<>();
			}
			return getIndex(notionalQuantityScheduleLeg2, index, () -> {
						NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder newNotionalQuantityScheduleLeg2 = NotionalQuantityScheduleLeg2Report.builder();
						return newNotionalQuantityScheduleLeg2;
					});
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index) {
			if (otherPayment==null) {
				this.otherPayment = new ArrayList<>();
			}
			return getIndex(otherPayment, index, () -> {
						OtherPaymentReport.OtherPaymentReportBuilder newOtherPayment = OtherPaymentReport.builder();
						return newOtherPayment;
					});
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg1")
		@RuneAttribute("fixedRateOfLeg1")
		public BigDecimal getFixedRateOfLeg1() {
			return fixedRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
			return fixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		public String getFixedRatePaymentFrequencyPeriodLeg1() {
			return fixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg1")
		@RuneAttribute("identifierOfFloatingRateOfLeg1")
		public String getIdentifierOfFloatingRateOfLeg1() {
			return identifierOfFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg1")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg1")
		public String getIndicatorOfTheFloatingRateOfLeg1() {
			return indicatorOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		public String getNameOfTheFloatingRateOfLeg1() {
			return nameOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
			return floatingRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1() {
			return floatingRatePaymentFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg1TimePeriod() {
			return floatingRateReferencePeriodOfLeg1TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg1Multiplier() {
			return floatingRateReferencePeriodOfLeg1Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		public String getFloatingRateResetFrequencyPeriodOfLeg1() {
			return floatingRateResetFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1")
		@RuneAttribute("spreadOfLeg1")
		public SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1() {
			return spreadOfLeg1;
		}
		
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1() {
			SpreadOfLeg1.SpreadOfLeg1Builder result;
			if (spreadOfLeg1!=null) {
				result = spreadOfLeg1;
			}
			else {
				result = spreadOfLeg1 = SpreadOfLeg1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg2")
		@RuneAttribute("fixedRateOfLeg2")
		public BigDecimal getFixedRateOfLeg2() {
			return fixedRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
			return fixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		public String getFixedRatePaymentFrequencyPeriodLeg2() {
			return fixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg2")
		@RuneAttribute("identifierOfFloatingRateOfLeg2")
		public String getIdentifierOfFloatingRateOfLeg2() {
			return identifierOfFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg2")
		public String getIndicatorOfTheFloatingRateOfLeg2() {
			return indicatorOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		public String getNameOfTheFloatingRateOfLeg2() {
			return nameOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
			return floatingRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		public String getFloatingRatePaymentFrequencyPeriodOfLeg2() {
			return floatingRatePaymentFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
			return floatingRateReferencePeriodOfLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
			return floatingRateReferencePeriodOfLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		public String getFloatingRateResetFrequencyPeriodOfLeg2() {
			return floatingRateResetFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2")
		@RuneAttribute("spreadOfLeg2")
		public SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2() {
			return spreadOfLeg2;
		}
		
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2() {
			SpreadOfLeg2.SpreadOfLeg2Builder result;
			if (spreadOfLeg2!=null) {
				result = spreadOfLeg2;
			}
			else {
				result = spreadOfLeg2 = SpreadOfLeg2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread() {
			return packageTransactionSpread;
		}
		
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread() {
			PackageTransactionSpread.PackageTransactionSpreadBuilder result;
			if (packageTransactionSpread!=null) {
				result = packageTransactionSpread;
			}
			else {
				result = packageTransactionSpread = PackageTransactionSpread.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public BigDecimal getForwardExchangeRate() {
			return forwardExchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public String getBaseProduct() {
			return baseProduct;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public String getSubProduct() {
			return subProduct;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public String getFurtherSubProduct() {
			return furtherSubProduct;
		}
		
		@Override
		@RosettaAttribute("deliveryPoint")
		@RuneAttribute("deliveryPoint")
		public List<String> getDeliveryPoint() {
			return deliveryPoint;
		}
		
		@Override
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		public String getInterconnectionPoint() {
			return interconnectionPoint;
		}
		
		@Override
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		public EnergyLoadType1Code getLoadType() {
			return loadType;
		}
		
		@Override
		@RosettaAttribute("deliveryReport")
		@RuneAttribute("deliveryReport")
		public List<? extends DeliveryReport.DeliveryReportBuilder> getDeliveryReport() {
			return deliveryReport;
		}
		
		@Override
		public DeliveryReport.DeliveryReportBuilder getOrCreateDeliveryReport(int index) {
			if (deliveryReport==null) {
				this.deliveryReport = new ArrayList<>();
			}
			return getIndex(deliveryReport, index, () -> {
						DeliveryReport.DeliveryReportBuilder newDeliveryReport = DeliveryReport.builder();
						return newDeliveryReport;
					});
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice() {
			StrikePriceAndNotation.StrikePriceAndNotationBuilder result;
			if (strikePrice!=null) {
				result = strikePrice;
			}
			else {
				result = strikePrice = StrikePriceAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule() {
			return strikePriceSchedule;
		}
		
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int index) {
			if (strikePriceSchedule==null) {
				this.strikePriceSchedule = new ArrayList<>();
			}
			return getIndex(strikePriceSchedule, index, () -> {
						StrikePriceScheduleReport.StrikePriceScheduleReportBuilder newStrikePriceSchedule = StrikePriceScheduleReport.builder();
						return newStrikePriceSchedule;
					});
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public String getSeniority() {
			return seniority;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public Integer getSeries() {
			return series;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public Boolean getTranche() {
			return tranche;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public BigDecimal getCdSIndexAttachmentPoint() {
			return cdSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public BigDecimal getCdSIndexDetachmentPoint() {
			return cdSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		public String getCollateralPortfolioCode() {
			return collateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		public String getLevel() {
			return level;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder getOrCreateNonReportable() {
			FCAUKEMIRNonReportable.FCAUKEMIRNonReportableBuilder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = FCAUKEMIRNonReportable.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
		@RuneAttribute(value="natureOfCounterparty1", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNatureOfCounterparty1(String _natureOfCounterparty1) {
			this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
			return this;
		}
		
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
			if (_corporateSectorOfTheCounterparty1 != null) {
				this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int idx) {
			getIndex(this.corporateSectorOfTheCounterparty1, idx, () -> _corporateSectorOfTheCounterparty1);
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
			if (corporateSectorOfTheCounterparty1s != null) {
				for (final String toAdd : corporateSectorOfTheCounterparty1s) {
					this.corporateSectorOfTheCounterparty1.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
			if (corporateSectorOfTheCounterparty1s == null) {
				this.corporateSectorOfTheCounterparty1 = new ArrayList<>();
			} else {
				this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean _clearingThresholdOfCounterparty1) {
			this.clearingThresholdOfCounterparty1 = _clearingThresholdOfCounterparty1 == null ? null : _clearingThresholdOfCounterparty1;
			return this;
		}
		
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum _countryOfTheCounterParty2) {
			this.countryOfTheCounterParty2 = _countryOfTheCounterParty2 == null ? null : _countryOfTheCounterParty2;
			return this;
		}
		
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNatureOfCounterparty2(String _natureOfCounterparty2) {
			this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
			return this;
		}
		
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
			if (_corporateSectorOfTheCounterparty2 != null) {
				this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int idx) {
			getIndex(this.corporateSectorOfTheCounterparty2, idx, () -> _corporateSectorOfTheCounterparty2);
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
			if (corporateSectorOfTheCounterparty2s != null) {
				for (final String toAdd : corporateSectorOfTheCounterparty2s) {
					this.corporateSectorOfTheCounterparty2.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
			if (corporateSectorOfTheCounterparty2s == null) {
				this.corporateSectorOfTheCounterparty2 = new ArrayList<>();
			} else {
				this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean _clearingThresholdOfCounterparty2) {
			this.clearingThresholdOfCounterparty2 = _clearingThresholdOfCounterparty2 == null ? null : _clearingThresholdOfCounterparty2;
			return this;
		}
		
		@RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean _reportingObligationOfTheCounterparty2) {
			this.reportingObligationOfTheCounterparty2 = _reportingObligationOfTheCounterparty2 == null ? null : _reportingObligationOfTheCounterparty2;
			return this;
		}
		
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setBrokerID(String _brokerID) {
			this.brokerID = _brokerID == null ? null : _brokerID;
			return this;
		}
		
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDirection(String _direction) {
			this.direction = _direction == null ? null : _direction;
			return this;
		}
		
		@RosettaAttribute("directionOfLeg1")
		@RuneAttribute("directionOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDirectionOfLeg1(String _directionOfLeg1) {
			this.directionOfLeg1 = _directionOfLeg1 == null ? null : _directionOfLeg1;
			return this;
		}
		
		@RosettaAttribute("directionOfLeg2")
		@RuneAttribute("directionOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDirectionOfLeg2(String _directionOfLeg2) {
			this.directionOfLeg2 = _directionOfLeg2 == null ? null : _directionOfLeg2;
			return this;
		}
		
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean _directlyLinkedToCommercialActivityOrTreasuryFinancing) {
			this.directlyLinkedToCommercialActivityOrTreasuryFinancing = _directlyLinkedToCommercialActivityOrTreasuryFinancing == null ? null : _directlyLinkedToCommercialActivityOrTreasuryFinancing;
			return this;
		}
		
		@RosettaAttribute("executionAgent")
		@RuneAttribute("executionAgent")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExecutionAgent(ExecutionAgent _executionAgent) {
			this.executionAgent = _executionAgent == null ? null : _executionAgent.toBuilder();
			return this;
		}
		
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUti(String _uti) {
			this.uti = _uti == null ? null : _uti;
			return this;
		}
		
		@RosettaAttribute("utiProprietary")
		@RuneAttribute("utiProprietary")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUtiProprietary(String _utiProprietary) {
			this.utiProprietary = _utiProprietary == null ? null : _utiProprietary;
			return this;
		}
		
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReportTrackingNumber(String _reportTrackingNumber) {
			this.reportTrackingNumber = _reportTrackingNumber == null ? null : _reportTrackingNumber;
			return this;
		}
		
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPtrrId(String _ptrrId) {
			this.ptrrId = _ptrrId == null ? null : _ptrrId;
			return this;
		}
		
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
			this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
			return this;
		}
		
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIsin(String _isin) {
			this.isin = _isin == null ? null : _isin;
			return this;
		}
		
		@RosettaAttribute("upi")
		@RuneAttribute("upi")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUpi(String _upi) {
			this.upi = _upi == null ? null : _upi;
			return this;
		}
		
		@RosettaAttribute(value="productClassification", isRequired=true)
		@RuneAttribute(value="productClassification", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setProductClassification(String _productClassification) {
			this.productClassification = _productClassification == null ? null : _productClassification;
			return this;
		}
		
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setContractType(String _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setAssetClass(String _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@RosettaAttribute(value="isCrypto", isRequired=true)
		@RuneAttribute(value="isCrypto", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIsCrypto(Boolean _isCrypto) {
			this.isCrypto = _isCrypto == null ? null : _isCrypto;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
			this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
			this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
			return this;
		}
		
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			if (_nameOfTheUnderlyingIndex != null) {
				this.nameOfTheUnderlyingIndex.add(_nameOfTheUnderlyingIndex);
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex, int idx) {
			getIndex(this.nameOfTheUnderlyingIndex, idx, () -> _nameOfTheUnderlyingIndex);
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNameOfTheUnderlyingIndex(List<String> nameOfTheUnderlyingIndexs) {
			if (nameOfTheUnderlyingIndexs != null) {
				for (final String toAdd : nameOfTheUnderlyingIndexs) {
					this.nameOfTheUnderlyingIndex.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("nameOfTheUnderlyingIndex")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(List<String> nameOfTheUnderlyingIndexs) {
			if (nameOfTheUnderlyingIndexs == null) {
				this.nameOfTheUnderlyingIndex = new ArrayList<>();
			} else {
				this.nameOfTheUnderlyingIndex = nameOfTheUnderlyingIndexs.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("indicatorOfTheUnderlyingIndex")
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(String _indicatorOfTheUnderlyingIndex) {
			if (_indicatorOfTheUnderlyingIndex != null) {
				this.indicatorOfTheUnderlyingIndex.add(_indicatorOfTheUnderlyingIndex);
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(String _indicatorOfTheUnderlyingIndex, int idx) {
			getIndex(this.indicatorOfTheUnderlyingIndex, idx, () -> _indicatorOfTheUnderlyingIndex);
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<String> indicatorOfTheUnderlyingIndexs) {
			if (indicatorOfTheUnderlyingIndexs != null) {
				for (final String toAdd : indicatorOfTheUnderlyingIndexs) {
					this.indicatorOfTheUnderlyingIndex.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("indicatorOfTheUnderlyingIndex")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<String> indicatorOfTheUnderlyingIndexs) {
			if (indicatorOfTheUnderlyingIndexs == null) {
				this.indicatorOfTheUnderlyingIndex = new ArrayList<>();
			} else {
				this.indicatorOfTheUnderlyingIndex = indicatorOfTheUnderlyingIndexs.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("identifierOfBasketConstituents")
		@RuneAttribute("identifierOfBasketConstituents")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIdentifierOfBasketConstituents(String _identifierOfBasketConstituents) {
			if (_identifierOfBasketConstituents != null) {
				this.identifierOfBasketConstituents.add(_identifierOfBasketConstituents);
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIdentifierOfBasketConstituents(String _identifierOfBasketConstituents, int idx) {
			getIndex(this.identifierOfBasketConstituents, idx, () -> _identifierOfBasketConstituents);
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addIdentifierOfBasketConstituents(List<String> identifierOfBasketConstituentss) {
			if (identifierOfBasketConstituentss != null) {
				for (final String toAdd : identifierOfBasketConstituentss) {
					this.identifierOfBasketConstituents.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("identifierOfBasketConstituents")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIdentifierOfBasketConstituents(List<String> identifierOfBasketConstituentss) {
			if (identifierOfBasketConstituentss == null) {
				this.identifierOfBasketConstituents = new ArrayList<>();
			} else {
				this.identifierOfBasketConstituents = identifierOfBasketConstituentss.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
			return this;
		}
		
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSettlementCurrency1(ISOCurrencyCodeEnum _settlementCurrency1) {
			this.settlementCurrency1 = _settlementCurrency1 == null ? null : _settlementCurrency1;
			return this;
		}
		
		@RosettaAttribute("settlementCurrency2")
		@RuneAttribute("settlementCurrency2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSettlementCurrency2(String _settlementCurrency2) {
			this.settlementCurrency2 = _settlementCurrency2 == null ? null : _settlementCurrency2;
			return this;
		}
		
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
			this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
			return this;
		}
		
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setConfirmed(String _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingObligation(String _clearingObligation) {
			this.clearingObligation = _clearingObligation == null ? null : _clearingObligation;
			return this;
		}
		
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCleared(String _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@RosettaAttribute(value="masterAgreementType", isRequired=true)
		@RuneAttribute(value="masterAgreementType", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setMasterAgreementType(String _masterAgreementType) {
			this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
			return this;
		}
		
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOtherMasterAgreementType(String _otherMasterAgreementType) {
			this.otherMasterAgreementType = _otherMasterAgreementType == null ? null : _otherMasterAgreementType;
			return this;
		}
		
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
			this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
			return this;
		}
		
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIntragroup(Boolean _intragroup) {
			this.intragroup = _intragroup == null ? null : _intragroup;
			return this;
		}
		
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPtrr(Boolean _ptrr) {
			this.ptrr = _ptrr == null ? null : _ptrr;
			return this;
		}
		
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setTypeOfPTRRTechnique(String _typeOfPTRRTechnique) {
			this.typeOfPTRRTechnique = _typeOfPTRRTechnique == null ? null : _typeOfPTRRTechnique;
			return this;
		}
		
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPtrrServiceProvider(String _ptrrServiceProvider) {
			this.ptrrServiceProvider = _ptrrServiceProvider == null ? null : _ptrrServiceProvider;
			return this;
		}
		
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setVenueOfExecution(String _venueOfExecution) {
			this.venueOfExecution = _venueOfExecution == null ? null : _venueOfExecution;
			return this;
		}
		
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@RosettaAttribute(value="deliveryType", isRequired=true)
		@RuneAttribute(value="deliveryType", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDeliveryType(String _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@RosettaAttribute("price")
		@RuneAttribute("price")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPrice(PriceAndNotation _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule, int idx) {
			getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
			if (priceSchedules != null) {
				for (final PriceScheduleReport toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("priceSchedule")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalLeg1(BigDecimal _notionalLeg1) {
			this.notionalLeg1 = _notionalLeg1 == null ? null : _notionalLeg1;
			return this;
		}
		
		@RosettaAttribute(value="notionalCurrency1", isRequired=true)
		@RuneAttribute(value="notionalCurrency1", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalCurrency1(ISOCurrencyCodeEnum _notionalCurrency1) {
			this.notionalCurrency1 = _notionalCurrency1 == null ? null : _notionalCurrency1;
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1) {
			if (_notionalAmountScheduleLeg1 != null) {
				this.notionalAmountScheduleLeg1.add(_notionalAmountScheduleLeg1.toBuilder());
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1, int idx) {
			getIndex(this.notionalAmountScheduleLeg1, idx, () -> _notionalAmountScheduleLeg1.toBuilder());
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
			if (notionalAmountScheduleLeg1s != null) {
				for (final NotionalAmountScheduleLeg1Report toAdd : notionalAmountScheduleLeg1s) {
					this.notionalAmountScheduleLeg1.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
			if (notionalAmountScheduleLeg1s == null) {
				this.notionalAmountScheduleLeg1 = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal _totalNotionalQuantityLeg1) {
			this.totalNotionalQuantityLeg1 = _totalNotionalQuantityLeg1 == null ? null : _totalNotionalQuantityLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalQuantityScheduleLeg1")
		@RuneAttribute("notionalQuantityScheduleLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1) {
			if (_notionalQuantityScheduleLeg1 != null) {
				this.notionalQuantityScheduleLeg1.add(_notionalQuantityScheduleLeg1.toBuilder());
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1, int idx) {
			getIndex(this.notionalQuantityScheduleLeg1, idx, () -> _notionalQuantityScheduleLeg1.toBuilder());
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1s) {
			if (notionalQuantityScheduleLeg1s != null) {
				for (final NotionalQuantityScheduleLeg1Report toAdd : notionalQuantityScheduleLeg1s) {
					this.notionalQuantityScheduleLeg1.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalQuantityScheduleLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1s) {
			if (notionalQuantityScheduleLeg1s == null) {
				this.notionalQuantityScheduleLeg1 = new ArrayList<>();
			} else {
				this.notionalQuantityScheduleLeg1 = notionalQuantityScheduleLeg1s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal _totalNotionalQuantityLeg2) {
			this.totalNotionalQuantityLeg2 = _totalNotionalQuantityLeg2 == null ? null : _totalNotionalQuantityLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalLeg2(BigDecimal _notionalLeg2) {
			this.notionalLeg2 = _notionalLeg2 == null ? null : _notionalLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalCurrency2")
		@RuneAttribute("notionalCurrency2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalCurrency2(ISOCurrencyCodeEnum _notionalCurrency2) {
			this.notionalCurrency2 = _notionalCurrency2 == null ? null : _notionalCurrency2;
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2) {
			if (_notionalAmountScheduleLeg2 != null) {
				this.notionalAmountScheduleLeg2.add(_notionalAmountScheduleLeg2.toBuilder());
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2, int idx) {
			getIndex(this.notionalAmountScheduleLeg2, idx, () -> _notionalAmountScheduleLeg2.toBuilder());
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
			if (notionalAmountScheduleLeg2s != null) {
				for (final NotionalAmountScheduleLeg2Report toAdd : notionalAmountScheduleLeg2s) {
					this.notionalAmountScheduleLeg2.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
			if (notionalAmountScheduleLeg2s == null) {
				this.notionalAmountScheduleLeg2 = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("notionalQuantityScheduleLeg2")
		@RuneAttribute("notionalQuantityScheduleLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2) {
			if (_notionalQuantityScheduleLeg2 != null) {
				this.notionalQuantityScheduleLeg2.add(_notionalQuantityScheduleLeg2.toBuilder());
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2, int idx) {
			getIndex(this.notionalQuantityScheduleLeg2, idx, () -> _notionalQuantityScheduleLeg2.toBuilder());
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2s) {
			if (notionalQuantityScheduleLeg2s != null) {
				for (final NotionalQuantityScheduleLeg2Report toAdd : notionalQuantityScheduleLeg2s) {
					this.notionalQuantityScheduleLeg2.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalQuantityScheduleLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2s) {
			if (notionalQuantityScheduleLeg2s == null) {
				this.notionalQuantityScheduleLeg2 = new ArrayList<>();
			} else {
				this.notionalQuantityScheduleLeg2 = notionalQuantityScheduleLeg2s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment, int idx) {
			getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPaymentReport toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("otherPayment")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("fixedRateOfLeg1")
		@RuneAttribute("fixedRateOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRateOfLeg1(BigDecimal _fixedRateOfLeg1) {
			this.fixedRateOfLeg1 = _fixedRateOfLeg1 == null ? null : _fixedRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code _fixedRateDayCountConventionLeg1) {
			this.fixedRateDayCountConventionLeg1 = _fixedRateDayCountConventionLeg1 == null ? null : _fixedRateDayCountConventionLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String _fixedRatePaymentFrequencyPeriodLeg1) {
			this.fixedRatePaymentFrequencyPeriodLeg1 = _fixedRatePaymentFrequencyPeriodLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg1) {
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = _fixedRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("identifierOfFloatingRateOfLeg1")
		@RuneAttribute("identifierOfFloatingRateOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIdentifierOfFloatingRateOfLeg1(String _identifierOfFloatingRateOfLeg1) {
			this.identifierOfFloatingRateOfLeg1 = _identifierOfFloatingRateOfLeg1 == null ? null : _identifierOfFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg1")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg1(String _indicatorOfTheFloatingRateOfLeg1) {
			this.indicatorOfTheFloatingRateOfLeg1 = _indicatorOfTheFloatingRateOfLeg1 == null ? null : _indicatorOfTheFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String _nameOfTheFloatingRateOfLeg1) {
			this.nameOfTheFloatingRateOfLeg1 = _nameOfTheFloatingRateOfLeg1 == null ? null : _nameOfTheFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg1) {
			this.floatingRateDayCountConventionOfLeg1 = _floatingRateDayCountConventionOfLeg1 == null ? null : _floatingRateDayCountConventionOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 _floatingRatePaymentFrequencyPeriodOfLeg1) {
			this.floatingRatePaymentFrequencyPeriodOfLeg1 = _floatingRatePaymentFrequencyPeriodOfLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1) {
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 = _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateReferencePeriodOfLeg1TimePeriod(String _floatingRateReferencePeriodOfLeg1TimePeriod) {
			this.floatingRateReferencePeriodOfLeg1TimePeriod = _floatingRateReferencePeriodOfLeg1TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg1TimePeriod;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateReferencePeriodOfLeg1Multiplier(Integer _floatingRateReferencePeriodOfLeg1Multiplier) {
			this.floatingRateReferencePeriodOfLeg1Multiplier = _floatingRateReferencePeriodOfLeg1Multiplier == null ? null : _floatingRateReferencePeriodOfLeg1Multiplier;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg1(String _floatingRateResetFrequencyPeriodOfLeg1) {
			this.floatingRateResetFrequencyPeriodOfLeg1 = _floatingRateResetFrequencyPeriodOfLeg1 == null ? null : _floatingRateResetFrequencyPeriodOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer _floatingRateResetFrequencyPeriodMultiplierLeg1) {
			this.floatingRateResetFrequencyPeriodMultiplierLeg1 = _floatingRateResetFrequencyPeriodMultiplierLeg1 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg1")
		@RuneAttribute("spreadOfLeg1")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 _spreadOfLeg1) {
			this.spreadOfLeg1 = _spreadOfLeg1 == null ? null : _spreadOfLeg1.toBuilder();
			return this;
		}
		
		@RosettaAttribute("fixedRateOfLeg2")
		@RuneAttribute("fixedRateOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRateOfLeg2(BigDecimal _fixedRateOfLeg2) {
			this.fixedRateOfLeg2 = _fixedRateOfLeg2 == null ? null : _fixedRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code _fixedRateDayCountConventionLeg2) {
			this.fixedRateDayCountConventionLeg2 = _fixedRateDayCountConventionLeg2 == null ? null : _fixedRateDayCountConventionLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String _fixedRatePaymentFrequencyPeriodLeg2) {
			this.fixedRatePaymentFrequencyPeriodLeg2 = _fixedRatePaymentFrequencyPeriodLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg2) {
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = _fixedRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("identifierOfFloatingRateOfLeg2")
		@RuneAttribute("identifierOfFloatingRateOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIdentifierOfFloatingRateOfLeg2(String _identifierOfFloatingRateOfLeg2) {
			this.identifierOfFloatingRateOfLeg2 = _identifierOfFloatingRateOfLeg2 == null ? null : _identifierOfFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg2(String _indicatorOfTheFloatingRateOfLeg2) {
			this.indicatorOfTheFloatingRateOfLeg2 = _indicatorOfTheFloatingRateOfLeg2 == null ? null : _indicatorOfTheFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String _nameOfTheFloatingRateOfLeg2) {
			this.nameOfTheFloatingRateOfLeg2 = _nameOfTheFloatingRateOfLeg2 == null ? null : _nameOfTheFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg2) {
			this.floatingRateDayCountConventionOfLeg2 = _floatingRateDayCountConventionOfLeg2 == null ? null : _floatingRateDayCountConventionOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg2(String _floatingRatePaymentFrequencyPeriodOfLeg2) {
			this.floatingRatePaymentFrequencyPeriodOfLeg2 = _floatingRatePaymentFrequencyPeriodOfLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2) {
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 = _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String _floatingRateReferencePeriodOfLeg2TimePeriod) {
			this.floatingRateReferencePeriodOfLeg2TimePeriod = _floatingRateReferencePeriodOfLeg2TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg2TimePeriod;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer _floatingRateReferencePeriodOfLeg2Multiplier) {
			this.floatingRateReferencePeriodOfLeg2Multiplier = _floatingRateReferencePeriodOfLeg2Multiplier == null ? null : _floatingRateReferencePeriodOfLeg2Multiplier;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String _floatingRateResetFrequencyPeriodOfLeg2) {
			this.floatingRateResetFrequencyPeriodOfLeg2 = _floatingRateResetFrequencyPeriodOfLeg2 == null ? null : _floatingRateResetFrequencyPeriodOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer _floatingRateResetFrequencyPeriodMultiplierLeg2) {
			this.floatingRateResetFrequencyPeriodMultiplierLeg2 = _floatingRateResetFrequencyPeriodMultiplierLeg2 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg2")
		@RuneAttribute("spreadOfLeg2")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 _spreadOfLeg2) {
			this.spreadOfLeg2 = _spreadOfLeg2 == null ? null : _spreadOfLeg2.toBuilder();
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal _forwardExchangeRate) {
			this.forwardExchangeRate = _forwardExchangeRate == null ? null : _forwardExchangeRate;
			return this;
		}
		
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setBaseProduct(String _baseProduct) {
			this.baseProduct = _baseProduct == null ? null : _baseProduct;
			return this;
		}
		
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSubProduct(String _subProduct) {
			this.subProduct = _subProduct == null ? null : _subProduct;
			return this;
		}
		
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
			this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
			return this;
		}
		
		@RosettaAttribute("deliveryPoint")
		@RuneAttribute("deliveryPoint")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint) {
			if (_deliveryPoint != null) {
				this.deliveryPoint.add(_deliveryPoint);
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint, int idx) {
			getIndex(this.deliveryPoint, idx, () -> _deliveryPoint);
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoints) {
			if (deliveryPoints != null) {
				for (final String toAdd : deliveryPoints) {
					this.deliveryPoint.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("deliveryPoint")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoints) {
			if (deliveryPoints == null) {
				this.deliveryPoint = new ArrayList<>();
			} else {
				this.deliveryPoint = deliveryPoints.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("interconnectionPoint")
		@RuneAttribute("interconnectionPoint")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setInterconnectionPoint(String _interconnectionPoint) {
			this.interconnectionPoint = _interconnectionPoint == null ? null : _interconnectionPoint;
			return this;
		}
		
		@RosettaAttribute("loadType")
		@RuneAttribute("loadType")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code _loadType) {
			this.loadType = _loadType == null ? null : _loadType;
			return this;
		}
		
		@RosettaAttribute("deliveryReport")
		@RuneAttribute("deliveryReport")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryReport(DeliveryReport _deliveryReport) {
			if (_deliveryReport != null) {
				this.deliveryReport.add(_deliveryReport.toBuilder());
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryReport(DeliveryReport _deliveryReport, int idx) {
			getIndex(this.deliveryReport, idx, () -> _deliveryReport.toBuilder());
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addDeliveryReport(List<? extends DeliveryReport> deliveryReports) {
			if (deliveryReports != null) {
				for (final DeliveryReport toAdd : deliveryReports) {
					this.deliveryReport.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("deliveryReport")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setDeliveryReport(List<? extends DeliveryReport> deliveryReports) {
			if (deliveryReports == null) {
				this.deliveryReport = new ArrayList<>();
			} else {
				this.deliveryReport = deliveryReports.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionType(String _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionStyle(String _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setStrikePrice(StrikePriceAndNotation _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule, int idx) {
			getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final StrikePriceScheduleReport toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("strikePriceSchedule")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSeniority(String _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setReferenceEntity(String _referenceEntity) {
			this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
			return this;
		}
		
		@RosettaAttribute("series")
		@RuneAttribute("series")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@RosettaAttribute("version")
		@RuneAttribute("version")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setVersion(Integer _version) {
			this.version = _version == null ? null : _version;
			return this;
		}
		
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setTranche(Boolean _tranche) {
			this.tranche = _tranche == null ? null : _tranche;
			return this;
		}
		
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
			this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setActionType(String _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEventType(String _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setEventDate(Date _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setLevel(String _level) {
			this.level = _level == null ? null : _level;
			return this;
		}
		
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder setNonReportable(FCAUKEMIRNonReportable _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@Override
		public FCAUKEMIRTransactionReport build() {
			return new FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportImpl(this);
		}
		
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder prune() {
			if (executionAgent!=null && !executionAgent.prune().hasData()) executionAgent = null;
			if (price!=null && !price.prune().hasData()) price = null;
			priceSchedule = priceSchedule.stream().filter(b->b!=null).<PriceScheduleReport.PriceScheduleReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (packageTransactionPrice!=null && !packageTransactionPrice.prune().hasData()) packageTransactionPrice = null;
			notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1.stream().filter(b->b!=null).<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalQuantityScheduleLeg1 = notionalQuantityScheduleLeg1.stream().filter(b->b!=null).<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2.stream().filter(b->b!=null).<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalQuantityScheduleLeg2 = notionalQuantityScheduleLeg2.stream().filter(b->b!=null).<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			otherPayment = otherPayment.stream().filter(b->b!=null).<OtherPaymentReport.OtherPaymentReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (spreadOfLeg1!=null && !spreadOfLeg1.prune().hasData()) spreadOfLeg1 = null;
			if (spreadOfLeg2!=null && !spreadOfLeg2.prune().hasData()) spreadOfLeg2 = null;
			if (packageTransactionSpread!=null && !packageTransactionSpread.prune().hasData()) packageTransactionSpread = null;
			deliveryReport = deliveryReport.stream().filter(b->b!=null).<DeliveryReport.DeliveryReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (strikePrice!=null && !strikePrice.prune().hasData()) strikePrice = null;
			strikePriceSchedule = strikePriceSchedule.stream().filter(b->b!=null).<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getReportingTimestamp()!=null) return true;
			if (getReportSubmittingEntityID()!=null) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getNatureOfCounterparty1()!=null) return true;
			if (getCorporateSectorOfTheCounterparty1()!=null && !getCorporateSectorOfTheCounterparty1().isEmpty()) return true;
			if (getClearingThresholdOfCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCountryOfTheCounterParty2()!=null) return true;
			if (getNatureOfCounterparty2()!=null) return true;
			if (getCorporateSectorOfTheCounterparty2()!=null && !getCorporateSectorOfTheCounterparty2().isEmpty()) return true;
			if (getCounterparty2IdentifierType()!=null) return true;
			if (getClearingMember()!=null) return true;
			if (getClearingThresholdOfCounterparty2()!=null) return true;
			if (getReportingObligationOfTheCounterparty2()!=null) return true;
			if (getBrokerID()!=null) return true;
			if (getDirection()!=null) return true;
			if (getDirectionOfLeg1()!=null) return true;
			if (getDirectionOfLeg2()!=null) return true;
			if (getDirectlyLinkedToCommercialActivityOrTreasuryFinancing()!=null) return true;
			if (getExecutionAgent()!=null && getExecutionAgent().hasData()) return true;
			if (getUti()!=null) return true;
			if (getUtiProprietary()!=null) return true;
			if (getReportTrackingNumber()!=null) return true;
			if (getPriorUTI()!=null) return true;
			if (getPriorUTIProprietary()!=null) return true;
			if (getPtrrId()!=null) return true;
			if (getPackageIdentifier()!=null) return true;
			if (getSubsequentPositionUTI()!=null) return true;
			if (getIsin()!=null) return true;
			if (getUpi()!=null) return true;
			if (getProductClassification()!=null) return true;
			if (getContractType()!=null) return true;
			if (getAssetClass()!=null) return true;
			if (getIsCrypto()!=null) return true;
			if (getUnderlyingIdentificationType()!=null) return true;
			if (getUnderlyingIdentification()!=null) return true;
			if (getNameOfTheUnderlyingIndex()!=null && !getNameOfTheUnderlyingIndex().isEmpty()) return true;
			if (getIndicatorOfTheUnderlyingIndex()!=null && !getIndicatorOfTheUnderlyingIndex().isEmpty()) return true;
			if (getIdentifierOfBasketConstituents()!=null && !getIdentifierOfBasketConstituents().isEmpty()) return true;
			if (getCustomBasketCode()!=null) return true;
			if (getSettlementCurrency1()!=null) return true;
			if (getSettlementCurrency2()!=null) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getDelta()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getConfirmationTimestamp()!=null) return true;
			if (getConfirmed()!=null) return true;
			if (getClearingObligation()!=null) return true;
			if (getCleared()!=null) return true;
			if (getClearingTimestamp()!=null) return true;
			if (getCentralCounterparty()!=null) return true;
			if (getMasterAgreementType()!=null) return true;
			if (getOtherMasterAgreementType()!=null) return true;
			if (getMasterAgreementVersion()!=null) return true;
			if (getIntragroup()!=null) return true;
			if (getPtrr()!=null) return true;
			if (getTypeOfPTRRTechnique()!=null) return true;
			if (getPtrrServiceProvider()!=null) return true;
			if (getVenueOfExecution()!=null) return true;
			if (getExecutionTimestamp()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			if (getExpirationDate()!=null) return true;
			if (getEarlyTerminationDate()!=null) return true;
			if (getFinalContractualSettlementDate()!=null) return true;
			if (getDeliveryType()!=null) return true;
			if (getPrice()!=null && getPrice().hasData()) return true;
			if (getPriceSchedule()!=null && getPriceSchedule().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getPackageTransactionPrice()!=null && getPackageTransactionPrice().hasData()) return true;
			if (getNotionalLeg1()!=null) return true;
			if (getNotionalCurrency1()!=null) return true;
			if (getNotionalAmountScheduleLeg1()!=null && getNotionalAmountScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getTotalNotionalQuantityLeg1()!=null) return true;
			if (getNotionalQuantityScheduleLeg1()!=null && getNotionalQuantityScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getTotalNotionalQuantityLeg2()!=null) return true;
			if (getNotionalLeg2()!=null) return true;
			if (getNotionalCurrency2()!=null) return true;
			if (getNotionalAmountScheduleLeg2()!=null && getNotionalAmountScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getNotionalQuantityScheduleLeg2()!=null && getNotionalQuantityScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getOtherPayment()!=null && getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getFixedRateOfLeg1()!=null) return true;
			if (getFixedRateDayCountConventionLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getIdentifierOfFloatingRateOfLeg1()!=null) return true;
			if (getIndicatorOfTheFloatingRateOfLeg1()!=null) return true;
			if (getNameOfTheFloatingRateOfLeg1()!=null) return true;
			if (getFloatingRateDayCountConventionOfLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodOfLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg1TimePeriod()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg1Multiplier()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodOfLeg1()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getSpreadOfLeg1()!=null && getSpreadOfLeg1().hasData()) return true;
			if (getFixedRateOfLeg2()!=null) return true;
			if (getFixedRateDayCountConventionLeg2()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodLeg2()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getIdentifierOfFloatingRateOfLeg2()!=null) return true;
			if (getIndicatorOfTheFloatingRateOfLeg2()!=null) return true;
			if (getNameOfTheFloatingRateOfLeg2()!=null) return true;
			if (getFloatingRateDayCountConventionOfLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodOfLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg2TimePeriod()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg2Multiplier()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodOfLeg2()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getSpreadOfLeg2()!=null && getSpreadOfLeg2().hasData()) return true;
			if (getPackageTransactionSpread()!=null && getPackageTransactionSpread().hasData()) return true;
			if (getExchangeRate()!=null) return true;
			if (getForwardExchangeRate()!=null) return true;
			if (getExchangeRateBasis()!=null) return true;
			if (getBaseProduct()!=null) return true;
			if (getSubProduct()!=null) return true;
			if (getFurtherSubProduct()!=null) return true;
			if (getDeliveryPoint()!=null && !getDeliveryPoint().isEmpty()) return true;
			if (getInterconnectionPoint()!=null) return true;
			if (getLoadType()!=null) return true;
			if (getDeliveryReport()!=null && getDeliveryReport().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getOptionType()!=null) return true;
			if (getOptionStyle()!=null) return true;
			if (getStrikePrice()!=null && getStrikePrice().hasData()) return true;
			if (getStrikePriceSchedule()!=null && getStrikePriceSchedule().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getOptionPremiumAmount()!=null) return true;
			if (getOptionPremiumCurrency()!=null) return true;
			if (getOptionPremiumPaymentDate()!=null) return true;
			if (getMaturityDateOfTheUnderlying()!=null) return true;
			if (getSeniority()!=null) return true;
			if (getReferenceEntity()!=null) return true;
			if (getSeries()!=null) return true;
			if (getVersion()!=null) return true;
			if (getIndexFactor()!=null) return true;
			if (getTranche()!=null) return true;
			if (getCdSIndexAttachmentPoint()!=null) return true;
			if (getCdSIndexDetachmentPoint()!=null) return true;
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getCollateralPortfolioCode()!=null) return true;
			if (getActionType()!=null) return true;
			if (getEventType()!=null) return true;
			if (getEventDate()!=null) return true;
			if (getLevel()!=null) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder o = (FCAUKEMIRTransactionReport.FCAUKEMIRTransactionReportBuilder) other;
			
			merger.mergeRosetta(getExecutionAgent(), o.getExecutionAgent(), this::setExecutionAgent);
			merger.mergeRosetta(getPrice(), o.getPrice(), this::setPrice);
			merger.mergeRosetta(getPriceSchedule(), o.getPriceSchedule(), this::getOrCreatePriceSchedule);
			merger.mergeRosetta(getPackageTransactionPrice(), o.getPackageTransactionPrice(), this::setPackageTransactionPrice);
			merger.mergeRosetta(getNotionalAmountScheduleLeg1(), o.getNotionalAmountScheduleLeg1(), this::getOrCreateNotionalAmountScheduleLeg1);
			merger.mergeRosetta(getNotionalQuantityScheduleLeg1(), o.getNotionalQuantityScheduleLeg1(), this::getOrCreateNotionalQuantityScheduleLeg1);
			merger.mergeRosetta(getNotionalAmountScheduleLeg2(), o.getNotionalAmountScheduleLeg2(), this::getOrCreateNotionalAmountScheduleLeg2);
			merger.mergeRosetta(getNotionalQuantityScheduleLeg2(), o.getNotionalQuantityScheduleLeg2(), this::getOrCreateNotionalQuantityScheduleLeg2);
			merger.mergeRosetta(getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
			merger.mergeRosetta(getSpreadOfLeg1(), o.getSpreadOfLeg1(), this::setSpreadOfLeg1);
			merger.mergeRosetta(getSpreadOfLeg2(), o.getSpreadOfLeg2(), this::setSpreadOfLeg2);
			merger.mergeRosetta(getPackageTransactionSpread(), o.getPackageTransactionSpread(), this::setPackageTransactionSpread);
			merger.mergeRosetta(getDeliveryReport(), o.getDeliveryReport(), this::getOrCreateDeliveryReport);
			merger.mergeRosetta(getStrikePrice(), o.getStrikePrice(), this::setStrikePrice);
			merger.mergeRosetta(getStrikePriceSchedule(), o.getStrikePriceSchedule(), this::getOrCreateStrikePriceSchedule);
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getReportSubmittingEntityID(), o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID);
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getNatureOfCounterparty1(), o.getNatureOfCounterparty1(), this::setNatureOfCounterparty1);
			merger.mergeBasic(getCorporateSectorOfTheCounterparty1(), o.getCorporateSectorOfTheCounterparty1(), (Consumer<String>) this::addCorporateSectorOfTheCounterparty1);
			merger.mergeBasic(getClearingThresholdOfCounterparty1(), o.getClearingThresholdOfCounterparty1(), this::setClearingThresholdOfCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCountryOfTheCounterParty2(), o.getCountryOfTheCounterParty2(), this::setCountryOfTheCounterParty2);
			merger.mergeBasic(getNatureOfCounterparty2(), o.getNatureOfCounterparty2(), this::setNatureOfCounterparty2);
			merger.mergeBasic(getCorporateSectorOfTheCounterparty2(), o.getCorporateSectorOfTheCounterparty2(), (Consumer<String>) this::addCorporateSectorOfTheCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierType(), o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType);
			merger.mergeBasic(getClearingMember(), o.getClearingMember(), this::setClearingMember);
			merger.mergeBasic(getClearingThresholdOfCounterparty2(), o.getClearingThresholdOfCounterparty2(), this::setClearingThresholdOfCounterparty2);
			merger.mergeBasic(getReportingObligationOfTheCounterparty2(), o.getReportingObligationOfTheCounterparty2(), this::setReportingObligationOfTheCounterparty2);
			merger.mergeBasic(getBrokerID(), o.getBrokerID(), this::setBrokerID);
			merger.mergeBasic(getDirection(), o.getDirection(), this::setDirection);
			merger.mergeBasic(getDirectionOfLeg1(), o.getDirectionOfLeg1(), this::setDirectionOfLeg1);
			merger.mergeBasic(getDirectionOfLeg2(), o.getDirectionOfLeg2(), this::setDirectionOfLeg2);
			merger.mergeBasic(getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), o.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this::setDirectlyLinkedToCommercialActivityOrTreasuryFinancing);
			merger.mergeBasic(getUti(), o.getUti(), this::setUti);
			merger.mergeBasic(getUtiProprietary(), o.getUtiProprietary(), this::setUtiProprietary);
			merger.mergeBasic(getReportTrackingNumber(), o.getReportTrackingNumber(), this::setReportTrackingNumber);
			merger.mergeBasic(getPriorUTI(), o.getPriorUTI(), this::setPriorUTI);
			merger.mergeBasic(getPriorUTIProprietary(), o.getPriorUTIProprietary(), this::setPriorUTIProprietary);
			merger.mergeBasic(getPtrrId(), o.getPtrrId(), this::setPtrrId);
			merger.mergeBasic(getPackageIdentifier(), o.getPackageIdentifier(), this::setPackageIdentifier);
			merger.mergeBasic(getSubsequentPositionUTI(), o.getSubsequentPositionUTI(), this::setSubsequentPositionUTI);
			merger.mergeBasic(getIsin(), o.getIsin(), this::setIsin);
			merger.mergeBasic(getUpi(), o.getUpi(), this::setUpi);
			merger.mergeBasic(getProductClassification(), o.getProductClassification(), this::setProductClassification);
			merger.mergeBasic(getContractType(), o.getContractType(), this::setContractType);
			merger.mergeBasic(getAssetClass(), o.getAssetClass(), this::setAssetClass);
			merger.mergeBasic(getIsCrypto(), o.getIsCrypto(), this::setIsCrypto);
			merger.mergeBasic(getUnderlyingIdentificationType(), o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType);
			merger.mergeBasic(getUnderlyingIdentification(), o.getUnderlyingIdentification(), this::setUnderlyingIdentification);
			merger.mergeBasic(getNameOfTheUnderlyingIndex(), o.getNameOfTheUnderlyingIndex(), (Consumer<String>) this::addNameOfTheUnderlyingIndex);
			merger.mergeBasic(getIndicatorOfTheUnderlyingIndex(), o.getIndicatorOfTheUnderlyingIndex(), (Consumer<String>) this::addIndicatorOfTheUnderlyingIndex);
			merger.mergeBasic(getIdentifierOfBasketConstituents(), o.getIdentifierOfBasketConstituents(), (Consumer<String>) this::addIdentifierOfBasketConstituents);
			merger.mergeBasic(getCustomBasketCode(), o.getCustomBasketCode(), this::setCustomBasketCode);
			merger.mergeBasic(getSettlementCurrency1(), o.getSettlementCurrency1(), this::setSettlementCurrency1);
			merger.mergeBasic(getSettlementCurrency2(), o.getSettlementCurrency2(), this::setSettlementCurrency2);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getDelta(), o.getDelta(), this::setDelta);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getConfirmationTimestamp(), o.getConfirmationTimestamp(), this::setConfirmationTimestamp);
			merger.mergeBasic(getConfirmed(), o.getConfirmed(), this::setConfirmed);
			merger.mergeBasic(getClearingObligation(), o.getClearingObligation(), this::setClearingObligation);
			merger.mergeBasic(getCleared(), o.getCleared(), this::setCleared);
			merger.mergeBasic(getClearingTimestamp(), o.getClearingTimestamp(), this::setClearingTimestamp);
			merger.mergeBasic(getCentralCounterparty(), o.getCentralCounterparty(), this::setCentralCounterparty);
			merger.mergeBasic(getMasterAgreementType(), o.getMasterAgreementType(), this::setMasterAgreementType);
			merger.mergeBasic(getOtherMasterAgreementType(), o.getOtherMasterAgreementType(), this::setOtherMasterAgreementType);
			merger.mergeBasic(getMasterAgreementVersion(), o.getMasterAgreementVersion(), this::setMasterAgreementVersion);
			merger.mergeBasic(getIntragroup(), o.getIntragroup(), this::setIntragroup);
			merger.mergeBasic(getPtrr(), o.getPtrr(), this::setPtrr);
			merger.mergeBasic(getTypeOfPTRRTechnique(), o.getTypeOfPTRRTechnique(), this::setTypeOfPTRRTechnique);
			merger.mergeBasic(getPtrrServiceProvider(), o.getPtrrServiceProvider(), this::setPtrrServiceProvider);
			merger.mergeBasic(getVenueOfExecution(), o.getVenueOfExecution(), this::setVenueOfExecution);
			merger.mergeBasic(getExecutionTimestamp(), o.getExecutionTimestamp(), this::setExecutionTimestamp);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getExpirationDate(), o.getExpirationDate(), this::setExpirationDate);
			merger.mergeBasic(getEarlyTerminationDate(), o.getEarlyTerminationDate(), this::setEarlyTerminationDate);
			merger.mergeBasic(getFinalContractualSettlementDate(), o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate);
			merger.mergeBasic(getDeliveryType(), o.getDeliveryType(), this::setDeliveryType);
			merger.mergeBasic(getNotionalLeg1(), o.getNotionalLeg1(), this::setNotionalLeg1);
			merger.mergeBasic(getNotionalCurrency1(), o.getNotionalCurrency1(), this::setNotionalCurrency1);
			merger.mergeBasic(getTotalNotionalQuantityLeg1(), o.getTotalNotionalQuantityLeg1(), this::setTotalNotionalQuantityLeg1);
			merger.mergeBasic(getTotalNotionalQuantityLeg2(), o.getTotalNotionalQuantityLeg2(), this::setTotalNotionalQuantityLeg2);
			merger.mergeBasic(getNotionalLeg2(), o.getNotionalLeg2(), this::setNotionalLeg2);
			merger.mergeBasic(getNotionalCurrency2(), o.getNotionalCurrency2(), this::setNotionalCurrency2);
			merger.mergeBasic(getFixedRateOfLeg1(), o.getFixedRateOfLeg1(), this::setFixedRateOfLeg1);
			merger.mergeBasic(getFixedRateDayCountConventionLeg1(), o.getFixedRateDayCountConventionLeg1(), this::setFixedRateDayCountConventionLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodLeg1(), o.getFixedRatePaymentFrequencyPeriodLeg1(), this::setFixedRatePaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getIdentifierOfFloatingRateOfLeg1(), o.getIdentifierOfFloatingRateOfLeg1(), this::setIdentifierOfFloatingRateOfLeg1);
			merger.mergeBasic(getIndicatorOfTheFloatingRateOfLeg1(), o.getIndicatorOfTheFloatingRateOfLeg1(), this::setIndicatorOfTheFloatingRateOfLeg1);
			merger.mergeBasic(getNameOfTheFloatingRateOfLeg1(), o.getNameOfTheFloatingRateOfLeg1(), this::setNameOfTheFloatingRateOfLeg1);
			merger.mergeBasic(getFloatingRateDayCountConventionOfLeg1(), o.getFloatingRateDayCountConventionOfLeg1(), this::setFloatingRateDayCountConventionOfLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodOfLeg1(), o.getFloatingRatePaymentFrequencyPeriodOfLeg1(), this::setFloatingRatePaymentFrequencyPeriodOfLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg1TimePeriod(), o.getFloatingRateReferencePeriodOfLeg1TimePeriod(), this::setFloatingRateReferencePeriodOfLeg1TimePeriod);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg1Multiplier(), o.getFloatingRateReferencePeriodOfLeg1Multiplier(), this::setFloatingRateReferencePeriodOfLeg1Multiplier);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodOfLeg1(), o.getFloatingRateResetFrequencyPeriodOfLeg1(), this::setFloatingRateResetFrequencyPeriodOfLeg1);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierLeg1(), o.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getFixedRateOfLeg2(), o.getFixedRateOfLeg2(), this::setFixedRateOfLeg2);
			merger.mergeBasic(getFixedRateDayCountConventionLeg2(), o.getFixedRateDayCountConventionLeg2(), this::setFixedRateDayCountConventionLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodLeg2(), o.getFixedRatePaymentFrequencyPeriodLeg2(), this::setFixedRatePaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getIdentifierOfFloatingRateOfLeg2(), o.getIdentifierOfFloatingRateOfLeg2(), this::setIdentifierOfFloatingRateOfLeg2);
			merger.mergeBasic(getIndicatorOfTheFloatingRateOfLeg2(), o.getIndicatorOfTheFloatingRateOfLeg2(), this::setIndicatorOfTheFloatingRateOfLeg2);
			merger.mergeBasic(getNameOfTheFloatingRateOfLeg2(), o.getNameOfTheFloatingRateOfLeg2(), this::setNameOfTheFloatingRateOfLeg2);
			merger.mergeBasic(getFloatingRateDayCountConventionOfLeg2(), o.getFloatingRateDayCountConventionOfLeg2(), this::setFloatingRateDayCountConventionOfLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodOfLeg2(), o.getFloatingRatePaymentFrequencyPeriodOfLeg2(), this::setFloatingRatePaymentFrequencyPeriodOfLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg2TimePeriod(), o.getFloatingRateReferencePeriodOfLeg2TimePeriod(), this::setFloatingRateReferencePeriodOfLeg2TimePeriod);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg2Multiplier(), o.getFloatingRateReferencePeriodOfLeg2Multiplier(), this::setFloatingRateReferencePeriodOfLeg2Multiplier);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodOfLeg2(), o.getFloatingRateResetFrequencyPeriodOfLeg2(), this::setFloatingRateResetFrequencyPeriodOfLeg2);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierLeg2(), o.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getExchangeRate(), o.getExchangeRate(), this::setExchangeRate);
			merger.mergeBasic(getForwardExchangeRate(), o.getForwardExchangeRate(), this::setForwardExchangeRate);
			merger.mergeBasic(getExchangeRateBasis(), o.getExchangeRateBasis(), this::setExchangeRateBasis);
			merger.mergeBasic(getBaseProduct(), o.getBaseProduct(), this::setBaseProduct);
			merger.mergeBasic(getSubProduct(), o.getSubProduct(), this::setSubProduct);
			merger.mergeBasic(getFurtherSubProduct(), o.getFurtherSubProduct(), this::setFurtherSubProduct);
			merger.mergeBasic(getDeliveryPoint(), o.getDeliveryPoint(), (Consumer<String>) this::addDeliveryPoint);
			merger.mergeBasic(getInterconnectionPoint(), o.getInterconnectionPoint(), this::setInterconnectionPoint);
			merger.mergeBasic(getLoadType(), o.getLoadType(), this::setLoadType);
			merger.mergeBasic(getOptionType(), o.getOptionType(), this::setOptionType);
			merger.mergeBasic(getOptionStyle(), o.getOptionStyle(), this::setOptionStyle);
			merger.mergeBasic(getOptionPremiumAmount(), o.getOptionPremiumAmount(), this::setOptionPremiumAmount);
			merger.mergeBasic(getOptionPremiumCurrency(), o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency);
			merger.mergeBasic(getOptionPremiumPaymentDate(), o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate);
			merger.mergeBasic(getMaturityDateOfTheUnderlying(), o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying);
			merger.mergeBasic(getSeniority(), o.getSeniority(), this::setSeniority);
			merger.mergeBasic(getReferenceEntity(), o.getReferenceEntity(), this::setReferenceEntity);
			merger.mergeBasic(getSeries(), o.getSeries(), this::setSeries);
			merger.mergeBasic(getVersion(), o.getVersion(), this::setVersion);
			merger.mergeBasic(getIndexFactor(), o.getIndexFactor(), this::setIndexFactor);
			merger.mergeBasic(getTranche(), o.getTranche(), this::setTranche);
			merger.mergeBasic(getCdSIndexAttachmentPoint(), o.getCdSIndexAttachmentPoint(), this::setCdSIndexAttachmentPoint);
			merger.mergeBasic(getCdSIndexDetachmentPoint(), o.getCdSIndexDetachmentPoint(), this::setCdSIndexDetachmentPoint);
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getCollateralPortfolioCode(), o.getCollateralPortfolioCode(), this::setCollateralPortfolioCode);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getEventType(), o.getEventType(), this::setEventType);
			merger.mergeBasic(getEventDate(), o.getEventDate(), this::setEventDate);
			merger.mergeBasic(getLevel(), o.getLevel(), this::setLevel);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FCAUKEMIRTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(natureOfCounterparty1, _that.getNatureOfCounterparty1())) return false;
			if (!ListEquals.listEquals(corporateSectorOfTheCounterparty1, _that.getCorporateSectorOfTheCounterparty1())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty1, _that.getClearingThresholdOfCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) return false;
			if (!Objects.equals(natureOfCounterparty2, _that.getNatureOfCounterparty2())) return false;
			if (!ListEquals.listEquals(corporateSectorOfTheCounterparty2, _that.getCorporateSectorOfTheCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty2, _that.getClearingThresholdOfCounterparty2())) return false;
			if (!Objects.equals(reportingObligationOfTheCounterparty2, _that.getReportingObligationOfTheCounterparty2())) return false;
			if (!Objects.equals(brokerID, _that.getBrokerID())) return false;
			if (!Objects.equals(direction, _that.getDirection())) return false;
			if (!Objects.equals(directionOfLeg1, _that.getDirectionOfLeg1())) return false;
			if (!Objects.equals(directionOfLeg2, _that.getDirectionOfLeg2())) return false;
			if (!Objects.equals(directlyLinkedToCommercialActivityOrTreasuryFinancing, _that.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing())) return false;
			if (!Objects.equals(executionAgent, _that.getExecutionAgent())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(utiProprietary, _that.getUtiProprietary())) return false;
			if (!Objects.equals(reportTrackingNumber, _that.getReportTrackingNumber())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(priorUTIProprietary, _that.getPriorUTIProprietary())) return false;
			if (!Objects.equals(ptrrId, _that.getPtrrId())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(subsequentPositionUTI, _that.getSubsequentPositionUTI())) return false;
			if (!Objects.equals(isin, _that.getIsin())) return false;
			if (!Objects.equals(upi, _that.getUpi())) return false;
			if (!Objects.equals(productClassification, _that.getProductClassification())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!ListEquals.listEquals(nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) return false;
			if (!ListEquals.listEquals(indicatorOfTheUnderlyingIndex, _that.getIndicatorOfTheUnderlyingIndex())) return false;
			if (!ListEquals.listEquals(identifierOfBasketConstituents, _that.getIdentifierOfBasketConstituents())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(settlementCurrency1, _that.getSettlementCurrency1())) return false;
			if (!Objects.equals(settlementCurrency2, _that.getSettlementCurrency2())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(confirmed, _that.getConfirmed())) return false;
			if (!Objects.equals(clearingObligation, _that.getClearingObligation())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(clearingTimestamp, _that.getClearingTimestamp())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(otherMasterAgreementType, _that.getOtherMasterAgreementType())) return false;
			if (!Objects.equals(masterAgreementVersion, _that.getMasterAgreementVersion())) return false;
			if (!Objects.equals(intragroup, _that.getIntragroup())) return false;
			if (!Objects.equals(ptrr, _that.getPtrr())) return false;
			if (!Objects.equals(typeOfPTRRTechnique, _that.getTypeOfPTRRTechnique())) return false;
			if (!Objects.equals(ptrrServiceProvider, _that.getPtrrServiceProvider())) return false;
			if (!Objects.equals(venueOfExecution, _that.getVenueOfExecution())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(earlyTerminationDate, _that.getEarlyTerminationDate())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!ListEquals.listEquals(priceSchedule, _that.getPriceSchedule())) return false;
			if (!Objects.equals(packageTransactionPrice, _that.getPackageTransactionPrice())) return false;
			if (!Objects.equals(notionalLeg1, _that.getNotionalLeg1())) return false;
			if (!Objects.equals(notionalCurrency1, _that.getNotionalCurrency1())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg1, _that.getNotionalQuantityScheduleLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(notionalLeg2, _that.getNotionalLeg2())) return false;
			if (!Objects.equals(notionalCurrency2, _that.getNotionalCurrency2())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg2, _that.getNotionalQuantityScheduleLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(fixedRateOfLeg1, _that.getFixedRateOfLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg1, _that.getIdentifierOfFloatingRateOfLeg1())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg1, _that.getIndicatorOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1TimePeriod, _that.getFloatingRateReferencePeriodOfLeg1TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1Multiplier, _that.getFloatingRateReferencePeriodOfLeg1Multiplier())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg1, _that.getFloatingRateResetFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(spreadOfLeg1, _that.getSpreadOfLeg1())) return false;
			if (!Objects.equals(fixedRateOfLeg2, _that.getFixedRateOfLeg2())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg2, _that.getIdentifierOfFloatingRateOfLeg2())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg2, _that.getIndicatorOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(spreadOfLeg2, _that.getSpreadOfLeg2())) return false;
			if (!Objects.equals(packageTransactionSpread, _that.getPackageTransactionSpread())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(forwardExchangeRate, _that.getForwardExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(baseProduct, _that.getBaseProduct())) return false;
			if (!Objects.equals(subProduct, _that.getSubProduct())) return false;
			if (!Objects.equals(furtherSubProduct, _that.getFurtherSubProduct())) return false;
			if (!ListEquals.listEquals(deliveryPoint, _that.getDeliveryPoint())) return false;
			if (!Objects.equals(interconnectionPoint, _that.getInterconnectionPoint())) return false;
			if (!Objects.equals(loadType, _that.getLoadType())) return false;
			if (!ListEquals.listEquals(deliveryReport, _that.getDeliveryReport())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!ListEquals.listEquals(strikePriceSchedule, _that.getStrikePriceSchedule())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(seniority, _that.getSeniority())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(series, _that.getSeries())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(tranche, _that.getTranche())) return false;
			if (!Objects.equals(cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(collateralPortfolioCode, _that.getCollateralPortfolioCode())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty1 != null ? natureOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty1 != null ? corporateSectorOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty1 != null ? clearingThresholdOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (countryOfTheCounterParty2 != null ? countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty2 != null ? natureOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty2 != null ? corporateSectorOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty2 != null ? clearingThresholdOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (reportingObligationOfTheCounterparty2 != null ? reportingObligationOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (brokerID != null ? brokerID.hashCode() : 0);
			_result = 31 * _result + (direction != null ? direction.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg1 != null ? directionOfLeg1.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg2 != null ? directionOfLeg2.hashCode() : 0);
			_result = 31 * _result + (directlyLinkedToCommercialActivityOrTreasuryFinancing != null ? directlyLinkedToCommercialActivityOrTreasuryFinancing.hashCode() : 0);
			_result = 31 * _result + (executionAgent != null ? executionAgent.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (utiProprietary != null ? utiProprietary.hashCode() : 0);
			_result = 31 * _result + (reportTrackingNumber != null ? reportTrackingNumber.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (priorUTIProprietary != null ? priorUTIProprietary.hashCode() : 0);
			_result = 31 * _result + (ptrrId != null ? ptrrId.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (subsequentPositionUTI != null ? subsequentPositionUTI.hashCode() : 0);
			_result = 31 * _result + (isin != null ? isin.hashCode() : 0);
			_result = 31 * _result + (upi != null ? upi.hashCode() : 0);
			_result = 31 * _result + (productClassification != null ? productClassification.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (nameOfTheUnderlyingIndex != null ? nameOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheUnderlyingIndex != null ? indicatorOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (identifierOfBasketConstituents != null ? identifierOfBasketConstituents.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (settlementCurrency1 != null ? settlementCurrency1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrency2 != null ? settlementCurrency2.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmed != null ? confirmed.hashCode() : 0);
			_result = 31 * _result + (clearingObligation != null ? clearingObligation.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (clearingTimestamp != null ? clearingTimestamp.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.hashCode() : 0);
			_result = 31 * _result + (otherMasterAgreementType != null ? otherMasterAgreementType.hashCode() : 0);
			_result = 31 * _result + (masterAgreementVersion != null ? masterAgreementVersion.hashCode() : 0);
			_result = 31 * _result + (intragroup != null ? intragroup.hashCode() : 0);
			_result = 31 * _result + (ptrr != null ? ptrr.hashCode() : 0);
			_result = 31 * _result + (typeOfPTRRTechnique != null ? typeOfPTRRTechnique.hashCode() : 0);
			_result = 31 * _result + (ptrrServiceProvider != null ? ptrrServiceProvider.hashCode() : 0);
			_result = 31 * _result + (venueOfExecution != null ? venueOfExecution.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (earlyTerminationDate != null ? earlyTerminationDate.hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceSchedule != null ? priceSchedule.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPrice != null ? packageTransactionPrice.hashCode() : 0);
			_result = 31 * _result + (notionalLeg1 != null ? notionalLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency1 != null ? notionalCurrency1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1 != null ? notionalAmountScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg1 != null ? notionalQuantityScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalLeg2 != null ? notionalLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency2 != null ? notionalCurrency2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2 != null ? notionalAmountScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg2 != null ? notionalQuantityScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg1 != null ? fixedRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg1 != null ? fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg1 != null ? fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg1 != null ? identifierOfFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg1 != null ? indicatorOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg1 != null ? nameOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg1 != null ? floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg1 != null ? floatingRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1TimePeriod != null ? floatingRateReferencePeriodOfLeg1TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1Multiplier != null ? floatingRateReferencePeriodOfLeg1Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg1 != null ? floatingRateResetFrequencyPeriodOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1 != null ? spreadOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg2 != null ? fixedRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg2 != null ? fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg2 != null ? fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg2 != null ? identifierOfFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg2 != null ? indicatorOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg2 != null ? nameOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg2 != null ? floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg2 != null ? floatingRatePaymentFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2TimePeriod != null ? floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2Multiplier != null ? floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg2 != null ? floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2 != null ? spreadOfLeg2.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpread != null ? packageTransactionSpread.hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (forwardExchangeRate != null ? forwardExchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (baseProduct != null ? baseProduct.hashCode() : 0);
			_result = 31 * _result + (subProduct != null ? subProduct.hashCode() : 0);
			_result = 31 * _result + (furtherSubProduct != null ? furtherSubProduct.hashCode() : 0);
			_result = 31 * _result + (deliveryPoint != null ? deliveryPoint.hashCode() : 0);
			_result = 31 * _result + (interconnectionPoint != null ? interconnectionPoint.hashCode() : 0);
			_result = 31 * _result + (loadType != null ? loadType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (deliveryReport != null ? deliveryReport.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceSchedule != null ? strikePriceSchedule.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (seniority != null ? seniority.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (series != null ? series.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (tranche != null ? tranche.hashCode() : 0);
			_result = 31 * _result + (cdSIndexAttachmentPoint != null ? cdSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cdSIndexDetachmentPoint != null ? cdSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCode != null ? collateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (level != null ? level.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FCAUKEMIRTransactionReportBuilder {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"natureOfCounterparty1=" + this.natureOfCounterparty1 + ", " +
				"corporateSectorOfTheCounterparty1=" + this.corporateSectorOfTheCounterparty1 + ", " +
				"clearingThresholdOfCounterparty1=" + this.clearingThresholdOfCounterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"countryOfTheCounterParty2=" + this.countryOfTheCounterParty2 + ", " +
				"natureOfCounterparty2=" + this.natureOfCounterparty2 + ", " +
				"corporateSectorOfTheCounterparty2=" + this.corporateSectorOfTheCounterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"clearingThresholdOfCounterparty2=" + this.clearingThresholdOfCounterparty2 + ", " +
				"reportingObligationOfTheCounterparty2=" + this.reportingObligationOfTheCounterparty2 + ", " +
				"brokerID=" + this.brokerID + ", " +
				"direction=" + this.direction + ", " +
				"directionOfLeg1=" + this.directionOfLeg1 + ", " +
				"directionOfLeg2=" + this.directionOfLeg2 + ", " +
				"directlyLinkedToCommercialActivityOrTreasuryFinancing=" + this.directlyLinkedToCommercialActivityOrTreasuryFinancing + ", " +
				"executionAgent=" + this.executionAgent + ", " +
				"uti=" + this.uti + ", " +
				"utiProprietary=" + this.utiProprietary + ", " +
				"reportTrackingNumber=" + this.reportTrackingNumber + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"priorUTIProprietary=" + this.priorUTIProprietary + ", " +
				"ptrrId=" + this.ptrrId + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"subsequentPositionUTI=" + this.subsequentPositionUTI + ", " +
				"isin=" + this.isin + ", " +
				"upi=" + this.upi + ", " +
				"productClassification=" + this.productClassification + ", " +
				"contractType=" + this.contractType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", " +
				"indicatorOfTheUnderlyingIndex=" + this.indicatorOfTheUnderlyingIndex + ", " +
				"identifierOfBasketConstituents=" + this.identifierOfBasketConstituents + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"settlementCurrency1=" + this.settlementCurrency1 + ", " +
				"settlementCurrency2=" + this.settlementCurrency2 + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"confirmed=" + this.confirmed + ", " +
				"clearingObligation=" + this.clearingObligation + ", " +
				"cleared=" + this.cleared + ", " +
				"clearingTimestamp=" + this.clearingTimestamp + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"otherMasterAgreementType=" + this.otherMasterAgreementType + ", " +
				"masterAgreementVersion=" + this.masterAgreementVersion + ", " +
				"intragroup=" + this.intragroup + ", " +
				"ptrr=" + this.ptrr + ", " +
				"typeOfPTRRTechnique=" + this.typeOfPTRRTechnique + ", " +
				"ptrrServiceProvider=" + this.ptrrServiceProvider + ", " +
				"venueOfExecution=" + this.venueOfExecution + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"earlyTerminationDate=" + this.earlyTerminationDate + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"price=" + this.price + ", " +
				"priceSchedule=" + this.priceSchedule + ", " +
				"packageTransactionPrice=" + this.packageTransactionPrice + ", " +
				"notionalLeg1=" + this.notionalLeg1 + ", " +
				"notionalCurrency1=" + this.notionalCurrency1 + ", " +
				"notionalAmountScheduleLeg1=" + this.notionalAmountScheduleLeg1 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"notionalQuantityScheduleLeg1=" + this.notionalQuantityScheduleLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"notionalLeg2=" + this.notionalLeg2 + ", " +
				"notionalCurrency2=" + this.notionalCurrency2 + ", " +
				"notionalAmountScheduleLeg2=" + this.notionalAmountScheduleLeg2 + ", " +
				"notionalQuantityScheduleLeg2=" + this.notionalQuantityScheduleLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"fixedRateOfLeg1=" + this.fixedRateOfLeg1 + ", " +
				"fixedRateDayCountConventionLeg1=" + this.fixedRateDayCountConventionLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"identifierOfFloatingRateOfLeg1=" + this.identifierOfFloatingRateOfLeg1 + ", " +
				"indicatorOfTheFloatingRateOfLeg1=" + this.indicatorOfTheFloatingRateOfLeg1 + ", " +
				"nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", " +
				"floatingRateDayCountConventionOfLeg1=" + this.floatingRateDayCountConventionOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg1=" + this.floatingRatePaymentFrequencyPeriodOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", " +
				"floatingRateReferencePeriodOfLeg1TimePeriod=" + this.floatingRateReferencePeriodOfLeg1TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg1Multiplier=" + this.floatingRateReferencePeriodOfLeg1Multiplier + ", " +
				"floatingRateResetFrequencyPeriodOfLeg1=" + this.floatingRateResetFrequencyPeriodOfLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", " +
				"spreadOfLeg1=" + this.spreadOfLeg1 + ", " +
				"fixedRateOfLeg2=" + this.fixedRateOfLeg2 + ", " +
				"fixedRateDayCountConventionLeg2=" + this.fixedRateDayCountConventionLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"identifierOfFloatingRateOfLeg2=" + this.identifierOfFloatingRateOfLeg2 + ", " +
				"indicatorOfTheFloatingRateOfLeg2=" + this.indicatorOfTheFloatingRateOfLeg2 + ", " +
				"nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", " +
				"floatingRateDayCountConventionOfLeg2=" + this.floatingRateDayCountConventionOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg2=" + this.floatingRatePaymentFrequencyPeriodOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", " +
				"floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", " +
				"floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", " +
				"spreadOfLeg2=" + this.spreadOfLeg2 + ", " +
				"packageTransactionSpread=" + this.packageTransactionSpread + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"forwardExchangeRate=" + this.forwardExchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"baseProduct=" + this.baseProduct + ", " +
				"subProduct=" + this.subProduct + ", " +
				"furtherSubProduct=" + this.furtherSubProduct + ", " +
				"deliveryPoint=" + this.deliveryPoint + ", " +
				"interconnectionPoint=" + this.interconnectionPoint + ", " +
				"loadType=" + this.loadType + ", " +
				"deliveryReport=" + this.deliveryReport + ", " +
				"optionType=" + this.optionType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"strikePriceSchedule=" + this.strikePriceSchedule + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"seniority=" + this.seniority + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"series=" + this.series + ", " +
				"version=" + this.version + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"tranche=" + this.tranche + ", " +
				"cdSIndexAttachmentPoint=" + this.cdSIndexAttachmentPoint + ", " +
				"cdSIndexDetachmentPoint=" + this.cdSIndexDetachmentPoint + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"collateralPortfolioCode=" + this.collateralPortfolioCode + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"eventDate=" + this.eventDate + ", " +
				"level=" + this.level + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}
}
