package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.AdmittedToTradingVenue;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.functions.GetExecutionTimestamp;
import drr.regulation.common.functions.GetIsin;
import drr.regulation.common.functions.GetTransactionInformationForRegime;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iso.MicData;
import drr.standards.iso.MicTypeEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(UKEMIR_ISIN.UKEMIR_ISINDefault.class)
public abstract class UKEMIR_ISIN implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetExecutionTimestamp getExecutionTimestamp;
	@Inject protected GetIsin getIsin;
	@Inject protected GetMicDataForFacility getMicDataForFacility;
	@Inject protected GetTransactionInformationForRegime getTransactionInformationForRegime;
	@Inject protected IsSI isSI;
	@Inject protected IsUKEmirTradingVenue isUKEmirTradingVenue;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param reportableEvent 
	* @return isin 
	*/
	public String evaluate(ReportableEvent reportableEvent) {
		String isin = doEvaluate(reportableEvent);
		
		return isin;
	}

	protected abstract String doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends MicData> micDataForFacility(ReportableEvent reportableEvent);

	protected abstract MapperS<String> venueMic(ReportableEvent reportableEvent);

	protected abstract MapperS<String> productIsin(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends TransactionInformation> transactionInformation(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> isinTotv(ReportableEvent reportableEvent);

	public static class UKEMIR_ISINDefault extends UKEMIR_ISIN {
		@Override
		protected String doEvaluate(ReportableEvent reportableEvent) {
			String isin = null;
			return assignOutput(isin, reportableEvent);
		}
		
		protected String assignOutput(String isin, ReportableEvent reportableEvent) {
			if (exists(venueMic(reportableEvent)).getOrDefault(false)) {
				if (exists(productIsin(reportableEvent)).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isUKEmirTradingVenue.evaluate(micDataForFacility(reportableEvent).get())))).getOrDefault(false)) {
					isin = productIsin(reportableEvent).get();
				} else if (ComparisonResult.ofNullSafe(MapperS.of(isSI.evaluate(micDataForFacility(reportableEvent).get()))).andNullSafe(ComparisonResult.ofNullSafe(isinTotv(reportableEvent))).getOrDefault(false)) {
					isin = productIsin(reportableEvent).get();
				} else {
					isin = null;
				}
			} else if (exists(productIsin(reportableEvent)).andNullSafe(ComparisonResult.ofNullSafe(isinTotv(reportableEvent))).getOrDefault(false)) {
				isin = productIsin(reportableEvent).get();
			} else {
				isin = null;
			}
			
			return isin;
		}
		
		@Override
		protected MapperS<? extends MicData> micDataForFacility(ReportableEvent reportableEvent) {
			return MapperS.of(getMicDataForFacility.evaluate(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get()));
		}
		
		@Override
		protected MapperS<String> venueMic(ReportableEvent reportableEvent) {
			final MapperS<? extends MicData> thenArg = micDataForFacility(reportableEvent);
			return thenArg
				.mapSingleToItem(item -> {
					if (areEqual(item.<String>map("getStatus", micData -> micData.getStatus()), MapperS.of("EXPIRED"), CardinalityOperator.All).andNullSafe(lessThanEquals(item.<Date>map("getExpiryDate", micData -> micData.getExpiryDate()), MapperS.of(getExecutionTimestamp.evaluate(reportableEvent)).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())), CardinalityOperator.All)).orNullSafe(notEqual(item.<String>map("getStatus", micData -> micData.getStatus()), MapperS.of("EXPIRED"), CardinalityOperator.Any)).getOrDefault(false)) {
						if (areEqual(item.<MicTypeEnum>map("getMicType", micData -> micData.getMicType()), MapperS.of(MicTypeEnum.SGMT), CardinalityOperator.All).getOrDefault(false)) {
							return item.<String>map("getMic", micData -> micData.getMic());
						}
						return item.<String>map("getOperatingMic", micData -> micData.getOperatingMic());
					}
					return MapperS.<String>ofNull();
				});
		}
		
		@Override
		protected MapperS<String> productIsin(ReportableEvent reportableEvent) {
			return MapperS.of(getIsin.evaluate(productForEvent.evaluate(reportableEvent)));
		}
		
		@Override
		protected MapperS<? extends TransactionInformation> transactionInformation(ReportableEvent reportableEvent) {
			return MapperS.of(getTransactionInformationForRegime.evaluate(reportableEvent, RegimeNameEnum.UKEMIR, SupervisoryBodyEnum.FCA));
		}
		
		@Override
		protected MapperS<Boolean> isinTotv(ReportableEvent reportableEvent) {
			return MapperS.of(areEqual(transactionInformation(reportableEvent).<CommonTransactionInformation>map("getFcaTransactionInformation", _transactionInformation -> _transactionInformation.getFcaTransactionInformation()).<AdmittedToTradingVenue>map("getAdmittedToTradingVenue", commonTransactionInformation -> commonTransactionInformation.getAdmittedToTradingVenue()), MapperS.of(AdmittedToTradingVenue.ADMITTED), CardinalityOperator.All).getOrDefault(false));
		}
	}
}
