package drr.regulation.fca.ukemir.refit.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.trade.DeliveryReport;
import drr.regulation.fca.ukemir.refit.trade.validation.DeliveryReportTypeFormatValidator;
import drr.regulation.fca.ukemir.refit.trade.validation.DeliveryReportValidator;
import drr.regulation.fca.ukemir.refit.trade.validation.exists.DeliveryReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.57.0
 */
@RosettaMeta(model=DeliveryReport.class)
public class DeliveryReportMeta implements RosettaMetaData<DeliveryReport> {

	@Override
	public List<Validator<? super DeliveryReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super DeliveryReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super DeliveryReport> validator(ValidatorFactory factory) {
		return factory.<DeliveryReport>create(DeliveryReportValidator.class);
	}

	@Override
	public Validator<? super DeliveryReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<DeliveryReport>create(DeliveryReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super DeliveryReport> validator() {
		return new DeliveryReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super DeliveryReport> typeFormatValidator() {
		return new DeliveryReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super DeliveryReport, Set<String>> onlyExistsValidator() {
		return new DeliveryReportOnlyExistsValidator();
	}
}
