package drr.regulation.fca.ukemir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class FCAUKEMIRTransactionReportTypeFormatValidator implements Validator<FCAUKEMIRTransactionReport> {

	private List<ComparisonResult> getComparisonResults(FCAUKEMIRTransactionReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("entityResponsibleForReporting", o.getEntityResponsibleForReporting(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("counterparty1", o.getCounterparty1(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("counterparty2", o.getCounterparty2(), 20, of(72), of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), 
				checkString("clearingMember", o.getClearingMember(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("brokerID", o.getBrokerID(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("uti", o.getUti(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), 
				checkString("utiProprietary", o.getUtiProprietary(), 0, of(52), of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,50}[a-zA-Z0-9]{1}"))), 
				checkString("reportTrackingNumber", o.getReportTrackingNumber(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkString("priorUTI", o.getPriorUTI(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), 
				checkString("priorUTIProprietary", o.getPriorUTIProprietary(), 0, of(52), of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,50}[a-zA-Z0-9]{1}"))), 
				checkString("ptrrId", o.getPtrrId(), 1, of(52), of(Pattern.compile("[A-Z0-9]{1,52}"))), 
				checkString("packageIdentifier", o.getPackageIdentifier(), 1, of(35), of(Pattern.compile("[a-zA-Z0-9]{1,35}"))), 
				checkString("subsequentPositionUTI", o.getSubsequentPositionUTI(), 0, of(52), of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,50}[a-zA-Z0-9]{1}"))), 
				checkString("isin", o.getIsin(), 0, empty(), of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), 
				checkString("productClassification", o.getProductClassification(), 0, empty(), of(Pattern.compile("[A-Z]{6,6}"))), 
				checkString("assetClass", o.getAssetClass(), 1, of(4), empty()), 
				checkString("underlyingIdentificationType", o.getUnderlyingIdentificationType(), 1, of(1), of(Pattern.compile("[a-zA-Z]"))), 
				checkString("underlyingIdentification", o.getUnderlyingIdentification(), 0, empty(), of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), 
				checkString("nameOfTheUnderlyingIndex", o.getNameOfTheUnderlyingIndex(), 1, of(50), of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_\\&]{1,50}"))), 
				checkString("indicatorOfTheUnderlyingIndex", o.getIndicatorOfTheUnderlyingIndex(), 1, of(4), empty()), 
				checkString("identifierOfBasketConstituents", o.getIdentifierOfBasketConstituents(), 0, empty(), of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), 
				checkString("customBasketCode", o.getCustomBasketCode(), 20, of(72), of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), 
				checkNumber("valuationAmount", o.getValuationAmount(), of(25), of(5), empty(), empty()), 
				checkNumber("delta", o.getDelta(), of(25), of(5), empty(), empty()), 
				checkString("cleared", o.getCleared(), 1, of(1), of(Pattern.compile("[a-zA-Z]"))), 
				checkString("centralCounterparty", o.getCentralCounterparty(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("otherMasterAgreementType", o.getOtherMasterAgreementType(), 1, of(50), of(Pattern.compile("[a-zA-Z0-9]{1,50}"))), 
				checkNumber("masterAgreementVersion", o.getMasterAgreementVersion(), empty(), of(0), empty(), empty()), 
				checkString("ptrrServiceProvider", o.getPtrrServiceProvider(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkNumber("notionalLeg1", o.getNotionalLeg1(), of(25), of(5), empty(), empty()), 
				checkNumber("totalNotionalQuantityLeg1", o.getTotalNotionalQuantityLeg1(), of(25), of(5), empty(), empty()), 
				checkNumber("totalNotionalQuantityLeg2", o.getTotalNotionalQuantityLeg2(), of(25), of(5), empty(), empty()), 
				checkNumber("notionalLeg2", o.getNotionalLeg2(), of(25), of(5), empty(), empty()), 
				checkNumber("fixedRateOfLeg1", o.getFixedRateOfLeg1(), of(11), of(10), empty(), empty()), 
				checkString("fixedRatePaymentFrequencyPeriodLeg1", o.getFixedRatePaymentFrequencyPeriodLeg1(), 1, of(4), empty()), 
				checkNumber("fixedRatePaymentFrequencyPeriodMultiplierLeg1", o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), of(3), of(0), empty(), empty()), 
				checkString("identifierOfFloatingRateOfLeg1", o.getIdentifierOfFloatingRateOfLeg1(), 0, empty(), of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), 
				checkString("indicatorOfTheFloatingRateOfLeg1", o.getIndicatorOfTheFloatingRateOfLeg1(), 1, of(4), empty()), 
				checkString("nameOfTheFloatingRateOfLeg1", o.getNameOfTheFloatingRateOfLeg1(), 1, of(50), of(Pattern.compile("[a-zA-Z0-9]{1,50}"))), 
				checkNumber("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1", o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), of(3), of(0), empty(), empty()), 
				checkString("floatingRateReferencePeriodOfLeg1TimePeriod", o.getFloatingRateReferencePeriodOfLeg1TimePeriod(), 1, of(4), empty()), 
				checkNumber("floatingRateReferencePeriodOfLeg1Multiplier", o.getFloatingRateReferencePeriodOfLeg1Multiplier(), of(3), of(0), empty(), empty()), 
				checkString("floatingRateResetFrequencyPeriodOfLeg1", o.getFloatingRateResetFrequencyPeriodOfLeg1(), 1, of(4), empty()), 
				checkNumber("floatingRateResetFrequencyPeriodMultiplierLeg1", o.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), of(3), of(0), empty(), empty()), 
				checkNumber("fixedRateOfLeg2", o.getFixedRateOfLeg2(), of(11), of(10), empty(), empty()), 
				checkString("fixedRatePaymentFrequencyPeriodLeg2", o.getFixedRatePaymentFrequencyPeriodLeg2(), 1, of(4), empty()), 
				checkNumber("fixedRatePaymentFrequencyPeriodMultiplierLeg2", o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), of(3), of(0), empty(), empty()), 
				checkString("identifierOfFloatingRateOfLeg2", o.getIdentifierOfFloatingRateOfLeg2(), 0, empty(), of(Pattern.compile("[A-Z]{2,2}[A-Z0-9]{9,9}[0-9]{1,1}"))), 
				checkString("indicatorOfTheFloatingRateOfLeg2", o.getIndicatorOfTheFloatingRateOfLeg2(), 1, of(4), empty()), 
				checkString("nameOfTheFloatingRateOfLeg2", o.getNameOfTheFloatingRateOfLeg2(), 1, of(50), of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_\\&]{1,50}"))), 
				checkNumber("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2", o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), of(3), of(0), empty(), empty()), 
				checkString("floatingRateReferencePeriodOfLeg2TimePeriod", o.getFloatingRateReferencePeriodOfLeg2TimePeriod(), 1, of(4), empty()), 
				checkNumber("floatingRateReferencePeriodOfLeg2Multiplier", o.getFloatingRateReferencePeriodOfLeg2Multiplier(), of(3), of(0), empty(), empty()), 
				checkString("floatingRateResetFrequencyPeriodOfLeg2", o.getFloatingRateResetFrequencyPeriodOfLeg2(), 1, of(4), empty()), 
				checkNumber("floatingRateResetFrequencyPeriodMultiplierLeg2", o.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), of(3), of(0), empty(), empty()), 
				checkNumber("exchangeRate", o.getExchangeRate(), of(18), of(13), empty(), empty()), 
				checkNumber("forwardExchangeRate", o.getForwardExchangeRate(), of(18), of(13), empty(), empty()), 
				checkString("exchangeRateBasis", o.getExchangeRateBasis(), 7, of(7), of(Pattern.compile("[A-Z]{3,3}/[A-Z]{3,3}"))), 
				checkString("deliveryPoint", o.getDeliveryPoint(), 0, empty(), of(Pattern.compile("[A-Z0-9\\-]{16}"))), 
				checkString("interconnectionPoint", o.getInterconnectionPoint(), 0, empty(), of(Pattern.compile("[A-Z0-9\\-]{16}"))), 
				checkString("optionType", o.getOptionType(), 1, of(4), empty()), 
				checkString("optionStyle", o.getOptionStyle(), 1, of(4), empty()), 
				checkNumber("optionPremiumAmount", o.getOptionPremiumAmount(), of(25), of(5), empty(), empty()), 
				checkString("seniority", o.getSeniority(), 1, of(4), empty()), 
				checkNumber("series", o.getSeries(), of(5), of(0), empty(), empty()), 
				checkNumber("version", o.getVersion(), of(5), of(0), empty(), empty()), 
				checkNumber("indexFactor", o.getIndexFactor(), of(11), of(10), empty(), empty()), 
				checkNumber("cdSIndexAttachmentPoint", o.getCdSIndexAttachmentPoint(), of(11), of(10), empty(), empty()), 
				checkNumber("cdSIndexDetachmentPoint", o.getCdSIndexDetachmentPoint(), of(11), of(10), empty(), empty()), 
				checkString("collateralPortfolioCode", o.getCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("FCAUKEMIRTransactionReport", ValidationResult.ValidationType.TYPE_FORMAT, "FCAUKEMIRTransactionReport", path, "", res.getError());
				}
				return success("FCAUKEMIRTransactionReport", ValidationResult.ValidationType.TYPE_FORMAT, "FCAUKEMIRTransactionReport", path, "");
			})
			.collect(toList());
	}

}
