package drr.regulation.fca.ukemir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.SpreadOfLeg1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class SpreadOfLeg1TypeFormatValidator implements Validator<SpreadOfLeg1> {

	private List<ComparisonResult> getComparisonResults(SpreadOfLeg1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("spreadOfLeg1Monetary", o.getSpreadOfLeg1Monetary(), of(18), of(13), empty(), empty()), 
				checkNumber("spreadOfLeg1Percentage", o.getSpreadOfLeg1Percentage(), of(11), of(10), empty(), empty()), 
				checkNumber("spreadOfLeg1Basis", o.getSpreadOfLeg1Basis(), of(5), empty(), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SpreadOfLeg1", ValidationResult.ValidationType.TYPE_FORMAT, "SpreadOfLeg1", path, "", res.getError());
				}
				return success("SpreadOfLeg1", ValidationResult.ValidationType.TYPE_FORMAT, "SpreadOfLeg1", path, "");
			})
			.collect(toList());
	}

}
