package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.PriceAndNotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("PriceAndNotationMonetaryOrPercentage")
@ImplementedBy(PriceAndNotationMonetaryOrPercentage.Default.class)
public interface PriceAndNotationMonetaryOrPercentage extends Validator<PriceAndNotation> {
	
	String NAME = "PriceAndNotationMonetaryOrPercentage";
	String DEFINITION = "optional choice priceMonetary, pricePercentage";
	
	class Default implements PriceAndNotationMonetaryOrPercentage {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceAndNotation priceAndNotation) {
			ComparisonResult result = executeDataRule(priceAndNotation);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PriceAndNotation", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "PriceAndNotation", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(PriceAndNotation priceAndNotation) {
			try {
				return choice(MapperS.of(priceAndNotation), Arrays.asList("priceMonetary", "pricePercentage"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PriceAndNotationMonetaryOrPercentage {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceAndNotation priceAndNotation) {
			return Collections.emptyList();
		}
	}
}
