package drr.regulation.jfsa.rewrite.margin;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.jfsa.rewrite.margin.meta.JFSAMarginReportMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.57.0
 */
@RosettaDataType(value="JFSAMarginReport", builder=JFSAMarginReport.JFSAMarginReportBuilderImpl.class, version="5.57.0")
@RuneDataType(value="JFSAMarginReport", model="drr", builder=JFSAMarginReport.JFSAMarginReportBuilderImpl.class, version="5.57.0")
public interface JFSAMarginReport extends RosettaModelObject {

	JFSAMarginReportMeta metaData = new JFSAMarginReportMeta();

	/*********************** Getter Methods  ***********************/
	PartiesToTheDerivative getPartiesToTheDerivative();
	CollateralReport getCollateral();

	/*********************** Build Methods  ***********************/
	JFSAMarginReport build();
	
	JFSAMarginReport.JFSAMarginReportBuilder toBuilder();
	
	static JFSAMarginReport.JFSAMarginReportBuilder builder() {
		return new JFSAMarginReport.JFSAMarginReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends JFSAMarginReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends JFSAMarginReport> getType() {
		return JFSAMarginReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("partiesToTheDerivative"), processor, PartiesToTheDerivative.class, getPartiesToTheDerivative());
		processRosetta(path.newSubPath("collateral"), processor, CollateralReport.class, getCollateral());
	}
	

	/*********************** Builder Interface  ***********************/
	interface JFSAMarginReportBuilder extends JFSAMarginReport, RosettaModelObjectBuilder {
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder getOrCreatePartiesToTheDerivative();
		@Override
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder getPartiesToTheDerivative();
		CollateralReport.CollateralReportBuilder getOrCreateCollateral();
		@Override
		CollateralReport.CollateralReportBuilder getCollateral();
		JFSAMarginReport.JFSAMarginReportBuilder setPartiesToTheDerivative(PartiesToTheDerivative partiesToTheDerivative);
		JFSAMarginReport.JFSAMarginReportBuilder setCollateral(CollateralReport collateral);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("partiesToTheDerivative"), processor, PartiesToTheDerivative.PartiesToTheDerivativeBuilder.class, getPartiesToTheDerivative());
			processRosetta(path.newSubPath("collateral"), processor, CollateralReport.CollateralReportBuilder.class, getCollateral());
		}
		

		JFSAMarginReport.JFSAMarginReportBuilder prune();
	}

	/*********************** Immutable Implementation of JFSAMarginReport  ***********************/
	class JFSAMarginReportImpl implements JFSAMarginReport {
		private final PartiesToTheDerivative partiesToTheDerivative;
		private final CollateralReport collateral;
		
		protected JFSAMarginReportImpl(JFSAMarginReport.JFSAMarginReportBuilder builder) {
			this.partiesToTheDerivative = ofNullable(builder.getPartiesToTheDerivative()).map(f->f.build()).orElse(null);
			this.collateral = ofNullable(builder.getCollateral()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="partiesToTheDerivative", isRequired=true)
		@RuneAttribute(value="partiesToTheDerivative", isRequired=true)
		public PartiesToTheDerivative getPartiesToTheDerivative() {
			return partiesToTheDerivative;
		}
		
		@Override
		@RosettaAttribute(value="collateral", isRequired=true)
		@RuneAttribute(value="collateral", isRequired=true)
		public CollateralReport getCollateral() {
			return collateral;
		}
		
		@Override
		public JFSAMarginReport build() {
			return this;
		}
		
		@Override
		public JFSAMarginReport.JFSAMarginReportBuilder toBuilder() {
			JFSAMarginReport.JFSAMarginReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(JFSAMarginReport.JFSAMarginReportBuilder builder) {
			ofNullable(getPartiesToTheDerivative()).ifPresent(builder::setPartiesToTheDerivative);
			ofNullable(getCollateral()).ifPresent(builder::setCollateral);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			JFSAMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(partiesToTheDerivative, _that.getPartiesToTheDerivative())) return false;
			if (!Objects.equals(collateral, _that.getCollateral())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (partiesToTheDerivative != null ? partiesToTheDerivative.hashCode() : 0);
			_result = 31 * _result + (collateral != null ? collateral.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "JFSAMarginReport {" +
				"partiesToTheDerivative=" + this.partiesToTheDerivative + ", " +
				"collateral=" + this.collateral +
			'}';
		}
	}

	/*********************** Builder Implementation of JFSAMarginReport  ***********************/
	class JFSAMarginReportBuilderImpl implements JFSAMarginReport.JFSAMarginReportBuilder {
	
		protected PartiesToTheDerivative.PartiesToTheDerivativeBuilder partiesToTheDerivative;
		protected CollateralReport.CollateralReportBuilder collateral;
		
		@Override
		@RosettaAttribute(value="partiesToTheDerivative", isRequired=true)
		@RuneAttribute(value="partiesToTheDerivative", isRequired=true)
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder getPartiesToTheDerivative() {
			return partiesToTheDerivative;
		}
		
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder getOrCreatePartiesToTheDerivative() {
			PartiesToTheDerivative.PartiesToTheDerivativeBuilder result;
			if (partiesToTheDerivative!=null) {
				result = partiesToTheDerivative;
			}
			else {
				result = partiesToTheDerivative = PartiesToTheDerivative.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute(value="collateral", isRequired=true)
		@RuneAttribute(value="collateral", isRequired=true)
		public CollateralReport.CollateralReportBuilder getCollateral() {
			return collateral;
		}
		
		@Override
		public CollateralReport.CollateralReportBuilder getOrCreateCollateral() {
			CollateralReport.CollateralReportBuilder result;
			if (collateral!=null) {
				result = collateral;
			}
			else {
				result = collateral = CollateralReport.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute(value="partiesToTheDerivative", isRequired=true)
		@RuneAttribute(value="partiesToTheDerivative", isRequired=true)
		@Override
		public JFSAMarginReport.JFSAMarginReportBuilder setPartiesToTheDerivative(PartiesToTheDerivative _partiesToTheDerivative) {
			this.partiesToTheDerivative = _partiesToTheDerivative == null ? null : _partiesToTheDerivative.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="collateral", isRequired=true)
		@RuneAttribute(value="collateral", isRequired=true)
		@Override
		public JFSAMarginReport.JFSAMarginReportBuilder setCollateral(CollateralReport _collateral) {
			this.collateral = _collateral == null ? null : _collateral.toBuilder();
			return this;
		}
		
		@Override
		public JFSAMarginReport build() {
			return new JFSAMarginReport.JFSAMarginReportImpl(this);
		}
		
		@Override
		public JFSAMarginReport.JFSAMarginReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public JFSAMarginReport.JFSAMarginReportBuilder prune() {
			if (partiesToTheDerivative!=null && !partiesToTheDerivative.prune().hasData()) partiesToTheDerivative = null;
			if (collateral!=null && !collateral.prune().hasData()) collateral = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPartiesToTheDerivative()!=null && getPartiesToTheDerivative().hasData()) return true;
			if (getCollateral()!=null && getCollateral().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public JFSAMarginReport.JFSAMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			JFSAMarginReport.JFSAMarginReportBuilder o = (JFSAMarginReport.JFSAMarginReportBuilder) other;
			
			merger.mergeRosetta(getPartiesToTheDerivative(), o.getPartiesToTheDerivative(), this::setPartiesToTheDerivative);
			merger.mergeRosetta(getCollateral(), o.getCollateral(), this::setCollateral);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			JFSAMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(partiesToTheDerivative, _that.getPartiesToTheDerivative())) return false;
			if (!Objects.equals(collateral, _that.getCollateral())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (partiesToTheDerivative != null ? partiesToTheDerivative.hashCode() : 0);
			_result = 31 * _result + (collateral != null ? collateral.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "JFSAMarginReportBuilder {" +
				"partiesToTheDerivative=" + this.partiesToTheDerivative + ", " +
				"collateral=" + this.collateral +
			'}';
		}
	}
}
