package drr.regulation.jfsa.rewrite.margin.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import drr.regulation.jfsa.rewrite.margin.JFSAMarginReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.57.0
 */
@RosettaDataRule("JFSAMarginReportDTCC_JFSA_BR_0050_01")
@ImplementedBy(JFSAMarginReportDTCC_JFSA_BR_0050_01.Default.class)
public interface JFSAMarginReportDTCC_JFSA_BR_0050_01 extends Validator<JFSAMarginReport> {
	
	String NAME = "JFSAMarginReportDTCC_JFSA_BR_0050_01";
	String DEFINITION = "if collateral -> actionType = MarginActionEnum -> MARU then (if collateral -> initialMarginCollectedByReportingCounterpartyPreHaircut exists or collateral -> initialMarginCollectedByReportingCounterpartyPostHaircut exists then collateral -> currencyofInitialMarginCollected exists)";
	
	class Default implements JFSAMarginReportDTCC_JFSA_BR_0050_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSAMarginReport jFSAMarginReport) {
			ComparisonResult result = executeDataRule(jFSAMarginReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSAMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSAMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSAMarginReport jFSAMarginReport) {
			try {
				if (areEqual(MapperS.of(jFSAMarginReport).<CollateralReport>map("getCollateral", _jFSAMarginReport -> _jFSAMarginReport.getCollateral()).<MarginActionEnum>map("getActionType", collateralReport -> collateralReport.getActionType()), MapperS.of(MarginActionEnum.MARU), CardinalityOperator.All).getOrDefault(false)) {
					if (exists(MapperS.of(jFSAMarginReport).<CollateralReport>map("getCollateral", _jFSAMarginReport -> _jFSAMarginReport.getCollateral()).<BigDecimal>map("getInitialMarginCollectedByReportingCounterpartyPreHaircut", collateralReport -> collateralReport.getInitialMarginCollectedByReportingCounterpartyPreHaircut())).orNullSafe(exists(MapperS.of(jFSAMarginReport).<CollateralReport>map("getCollateral", _jFSAMarginReport -> _jFSAMarginReport.getCollateral()).<BigDecimal>map("getInitialMarginCollectedByReportingCounterpartyPostHaircut", collateralReport -> collateralReport.getInitialMarginCollectedByReportingCounterpartyPostHaircut()))).getOrDefault(false)) {
						return exists(MapperS.of(jFSAMarginReport).<CollateralReport>map("getCollateral", _jFSAMarginReport -> _jFSAMarginReport.getCollateral()).<ISOCurrencyCodeEnum>map("getCurrencyofInitialMarginCollected", collateralReport -> collateralReport.getCurrencyofInitialMarginCollected()));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSAMarginReportDTCC_JFSA_BR_0050_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSAMarginReport jFSAMarginReport) {
			return Collections.emptyList();
		}
	}
}
