package drr.regulation.jfsa.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.jfsa.rewrite.trade.meta.JFSATransactionReportMeta;
import iso20022.auth030.jfsa.InterestComputationMethod4Code;
import iso20022.auth030.jfsa.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 5.57.0
 */
@RosettaDataType(value="JFSATransactionReport", builder=JFSATransactionReport.JFSATransactionReportBuilderImpl.class, version="5.57.0")
@RuneDataType(value="JFSATransactionReport", model="drr", builder=JFSATransactionReport.JFSATransactionReportBuilderImpl.class, version="5.57.0")
public interface JFSATransactionReport extends RosettaModelObject {

	JFSATransactionReportMeta metaData = new JFSATransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	Date getEffectiveDate();
	Date getExpirationDate();
	Date getEarlyTerminationDate();
	ZonedDateTime getReportingTimestamp();
	ZonedDateTime getExecutionTimestamp();
	String getEntityResponsibleForReporting();
	String getCounterparty1();
	String getCounterparty2();
	Boolean getCounterparty2IdentifierType();
	String getDirection1();
	String getDirection2Leg1();
	String getDirection2Leg2();
	String getSubmitterIdentifier();
	String getNewSDRIdentifier();
	String getOriginalSwapSDRIdentifier();
	String getCleared();
	String getCentralCounterparty();
	String getClearingMember();
	String getPlatformIdentifier();
	String getConfirmed();
	Date getFinalContractualSettlementDate();
	ZonedDateTime getConfirmationTimestamp();
	ISOCurrencyCodeEnum getSettlementCurrencyLeg1();
	ISOCurrencyCodeEnum getSettlementCurrencyLeg2();
	String getClearingAccountOrigin();
	String getOriginalSwapUTI();
	String getOriginalSwapUTIProprietary();
	ZonedDateTime getClearingReceiptTimestamp();
	String getUti();
	String getUtiProprietary();
	String getPriorUti();
	String getPriorUtiProprietary();
	InterestComputationMethod4Code getFixedRateDayCountConventionLeg1();
	InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1();
	InterestComputationMethod4Code getFixedRateDayCountConventionLeg2();
	InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2();
	String getFixedRatePaymentFrequencyPeriodLeg1();
	String getFixedRatePaymentFrequencyPeriodLeg2();
	String getFloatingRatePaymentFrequencyPeriodLeg1();
	String getFloatingRatePaymentFrequencyPeriodLeg2();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg1();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg2();
	ZonedDateTime getFixingDateLeg1();
	ZonedDateTime getFixingDateLeg2();
	String getFloatingRateResetFrequencyPeriodLeg1();
	String getFloatingRateResetFrequencyPeriodOfLeg2();
	Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1();
	Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2();
	List<? extends OtherPaymentReport> getOtherPayment();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ValuationType1Code getValuationMethod();
	ZonedDateTime getValuationTimestamp();
	Boolean getCollateralPortfolioIndicator();
	String getInitialMarginCollateralPortfolioCode();
	String getVariationMarginCollateralPortfolioCode();
	PriceAndNotation getPrice();
	String getPriceNotation();
	String getPriceUnitOfMeasure();
	List<? extends PriceScheduleReport> getPriceSchedule();
	BigDecimal getFixedRateLeg1();
	BigDecimal getFixedRateLeg2();
	SpreadOfLeg1 getSpreadOfLeg1();
	String getSpreadNotationOfLeg1();
	SpreadOfLeg2 getSpreadOfLeg2();
	String getSpreadNotationOfLeg2();
	StrikePriceAndNotation getStrikePrice();
	String getStrikePriceNotation();
	List<? extends StrikePriceScheduleReport> getStrikePriceSchedule();
	BigDecimal getOptionPremiumAmount();
	ISOCurrencyCodeEnum getOptionPremiumCurrency();
	Date getOptionPremiumPaymentDate();
	Date getFirstExerciseDate();
	BigDecimal getExchangeRate();
	String getExchangeRateBasis();
	BigDecimal getNotionalLeg1();
	BigDecimal getNotionalLeg2();
	BigDecimal getCallAmount();
	BigDecimal getPutAmount();
	ISOCurrencyCodeEnum getNotionalCurrencyOfLeg1();
	ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2();
	ISOCurrencyCodeEnum getCallCurrency();
	ISOCurrencyCodeEnum getPutCurrency();
	String getQuantityUnitOfMeasureLeg1();
	String getQuantityUnitOfMeasureLeg2();
	List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1();
	List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2();
	BigDecimal getTotalNotionalQuantityLeg1();
	BigDecimal getTotalNotionalQuantityLeg2();
	List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1();
	List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2();
	String getActionType();
	String getEventType();
	ZonedDateTime getEventTimestamp();
	String getEventIdentifier();
	BigDecimal getIndexFactor();
	String getEmbeddedOptionType();
	String getUpi();
	String getDeliveryType();
	String getAssetClass();
	String getUnderlyingIdentificationType();
	String getUnderlyingIdentification();
	String getUnderlyingIndexIndicator();
	String getNameOfTheUnderlyingIndex();
	String getReferenceEntity();
	String getIndicatorOfTheFloatingRateOfLeg1();
	String getIndicatorOfTheFloatingRateOfLeg2();
	String getNameOfTheFloatingRateOfLeg1();
	String getNameOfTheFloatingRateOfLeg2();
	String getFloatingRateReferencePeriodOfLeg1TimePeriod();
	String getFloatingRateReferencePeriodOfLeg2TimePeriod();
	Integer getFloatingRateReferencePeriodOfLeg1Multiplier();
	Integer getFloatingRateReferencePeriodOfLeg2Multiplier();
	Boolean getIsCrypto();
	Date getMaturityDateOfTheUnderlying();
	String getSeniority();
	Integer getSeries();
	Integer getVersion();
	BigDecimal getCdSIndexAttachmentPoint();
	BigDecimal getCdSIndexDetachmentPoint();
	String getCustomBasketCode();
	List<? extends BasketConstituentsReport> getBasketConstituents();
	String getContractType();
	String getOptionStyle();
	String getOptionType();
	String getPackageIdentifier();
	PackageTransactionPrice getPackageTransactionPrice();
	ISOCurrencyCodeEnum getPackageTransactionPriceCurrency();
	String getPackageTransactionPriceNotation();
	PackageTransactionSpread getPackageTransactionSpread();
	ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency();
	String getPackageTransactionSpreadNotation();
	BigDecimal getDelta();
	String getTechnicalRecordId();
	BarrierAndNotation getBarrier();
	JFSANonReportable getNonReportable();

	/*********************** Build Methods  ***********************/
	JFSATransactionReport build();
	
	JFSATransactionReport.JFSATransactionReportBuilder toBuilder();
	
	static JFSATransactionReport.JFSATransactionReportBuilder builder() {
		return new JFSATransactionReport.JFSATransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends JFSATransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends JFSATransactionReport> getType() {
		return JFSATransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("direction1"), String.class, getDirection1(), this);
		processor.processBasic(path.newSubPath("direction2Leg1"), String.class, getDirection2Leg1(), this);
		processor.processBasic(path.newSubPath("direction2Leg2"), String.class, getDirection2Leg2(), this);
		processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
		processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("confirmed"), String.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
		processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg2(), this);
		processor.processBasic(path.newSubPath("clearingAccountOrigin"), String.class, getClearingAccountOrigin(), this);
		processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
		processor.processBasic(path.newSubPath("originalSwapUTIProprietary"), String.class, getOriginalSwapUTIProprietary(), this);
		processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
		processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
		processor.processBasic(path.newSubPath("utiProprietary"), String.class, getUtiProprietary(), this);
		processor.processBasic(path.newSubPath("priorUti"), String.class, getPriorUti(), this);
		processor.processBasic(path.newSubPath("priorUtiProprietary"), String.class, getPriorUtiProprietary(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, getFixedRatePaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, getFixedRatePaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg1"), String.class, getFloatingRatePaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg2"), String.class, getFloatingRatePaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("fixingDateLeg1"), ZonedDateTime.class, getFixingDateLeg1(), this);
		processor.processBasic(path.newSubPath("fixingDateLeg2"), ZonedDateTime.class, getFixingDateLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodLeg1"), String.class, getFloatingRateResetFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, getFloatingRateResetFrequencyPeriodOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.class, getOtherPayment());
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processRosetta(path.newSubPath("price"), processor, PriceAndNotation.class, getPrice());
		processor.processBasic(path.newSubPath("priceNotation"), String.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.class, getPriceSchedule());
		processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, getFixedRateLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, getFixedRateLeg2(), this);
		processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.class, getSpreadOfLeg1());
		processor.processBasic(path.newSubPath("spreadNotationOfLeg1"), String.class, getSpreadNotationOfLeg1(), this);
		processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.class, getSpreadOfLeg2());
		processor.processBasic(path.newSubPath("spreadNotationOfLeg2"), String.class, getSpreadNotationOfLeg2(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.class, getStrikePrice());
		processor.processBasic(path.newSubPath("strikePriceNotation"), String.class, getStrikePriceNotation(), this);
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.class, getStrikePriceSchedule());
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, getNotionalLeg1(), this);
		processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, getNotionalLeg2(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("notionalCurrencyOfLeg1"), ISOCurrencyCodeEnum.class, getNotionalCurrencyOfLeg1(), this);
		processor.processBasic(path.newSubPath("notionalCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, getNotionalCurrencyOfLeg2(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.class, getNotionalAmountScheduleLeg1());
		processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.class, getNotionalAmountScheduleLeg2());
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
		processRosetta(path.newSubPath("notionalQuantityScheduleLeg1"), processor, NotionalQuantityScheduleLeg1Report.class, getNotionalQuantityScheduleLeg1());
		processRosetta(path.newSubPath("notionalQuantityScheduleLeg2"), processor, NotionalQuantityScheduleLeg2Report.class, getNotionalQuantityScheduleLeg2());
		processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), String.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("upi"), String.class, getUpi(), this);
		processor.processBasic(path.newSubPath("deliveryType"), String.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
		processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
		processor.processBasic(path.newSubPath("underlyingIndexIndicator"), String.class, getUnderlyingIndexIndicator(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg1"), String.class, getIndicatorOfTheFloatingRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg2"), String.class, getIndicatorOfTheFloatingRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, getNameOfTheFloatingRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, getNameOfTheFloatingRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg1TimePeriod(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg2TimePeriod(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg1Multiplier(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg2Multiplier(), this);
		processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("seniority"), String.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), String.class, getPackageTransactionPriceNotation(), this);
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), String.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processRosetta(path.newSubPath("barrier"), processor, BarrierAndNotation.class, getBarrier());
		processRosetta(path.newSubPath("nonReportable"), processor, JFSANonReportable.class, getNonReportable());
	}
	

	/*********************** Builder Interface  ***********************/
	interface JFSATransactionReportBuilder extends JFSATransactionReport, RosettaModelObjectBuilder {
		OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index);
		@Override
		List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment();
		PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice();
		@Override
		PriceAndNotation.PriceAndNotationBuilder getPrice();
		PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int index);
		@Override
		List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule();
		SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1();
		@Override
		SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1();
		SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2();
		@Override
		SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2();
		StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice();
		@Override
		StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice();
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int index);
		@Override
		List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule();
		NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1();
		NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2();
		NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1(int index);
		@Override
		List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1();
		NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2(int index);
		@Override
		List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2();
		BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index);
		@Override
		List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents();
		PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice();
		@Override
		PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice();
		PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread();
		@Override
		PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread();
		BarrierAndNotation.BarrierAndNotationBuilder getOrCreateBarrier();
		@Override
		BarrierAndNotation.BarrierAndNotationBuilder getBarrier();
		JFSANonReportable.JFSANonReportableBuilder getOrCreateNonReportable();
		@Override
		JFSANonReportable.JFSANonReportableBuilder getNonReportable();
		JFSATransactionReport.JFSATransactionReportBuilder setEffectiveDate(Date effectiveDate);
		JFSATransactionReport.JFSATransactionReportBuilder setExpirationDate(Date expirationDate);
		JFSATransactionReport.JFSATransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		JFSATransactionReport.JFSATransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		JFSATransactionReport.JFSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		JFSATransactionReport.JFSATransactionReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		JFSATransactionReport.JFSATransactionReportBuilder setCounterparty1(String counterparty1);
		JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2(String counterparty2);
		JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		JFSATransactionReport.JFSATransactionReportBuilder setDirection1(String direction1);
		JFSATransactionReport.JFSATransactionReportBuilder setDirection2Leg1(String direction2Leg1);
		JFSATransactionReport.JFSATransactionReportBuilder setDirection2Leg2(String direction2Leg2);
		JFSATransactionReport.JFSATransactionReportBuilder setSubmitterIdentifier(String submitterIdentifier);
		JFSATransactionReport.JFSATransactionReportBuilder setNewSDRIdentifier(String newSDRIdentifier);
		JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapSDRIdentifier(String originalSwapSDRIdentifier);
		JFSATransactionReport.JFSATransactionReportBuilder setCleared(String cleared);
		JFSATransactionReport.JFSATransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		JFSATransactionReport.JFSATransactionReportBuilder setClearingMember(String clearingMember);
		JFSATransactionReport.JFSATransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		JFSATransactionReport.JFSATransactionReportBuilder setConfirmed(String confirmed);
		JFSATransactionReport.JFSATransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		JFSATransactionReport.JFSATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime confirmationTimestamp);
		JFSATransactionReport.JFSATransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum settlementCurrencyLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum settlementCurrencyLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setClearingAccountOrigin(String clearingAccountOrigin);
		JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapUTI(String originalSwapUTI);
		JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapUTIProprietary(String originalSwapUTIProprietary);
		JFSATransactionReport.JFSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime clearingReceiptTimestamp);
		JFSATransactionReport.JFSATransactionReportBuilder setUti(String uti);
		JFSATransactionReport.JFSATransactionReportBuilder setUtiProprietary(String utiProprietary);
		JFSATransactionReport.JFSATransactionReportBuilder setPriorUti(String priorUti);
		JFSATransactionReport.JFSATransactionReportBuilder setPriorUtiProprietary(String priorUtiProprietary);
		JFSATransactionReport.JFSATransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code fixedRateDayCountConventionLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code fixedRateDayCountConventionLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String fixedRatePaymentFrequencyPeriodLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String fixedRatePaymentFrequencyPeriodLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg1(String floatingRatePaymentFrequencyPeriodLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg2(String floatingRatePaymentFrequencyPeriodLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg1(Integer floatingRatePaymentFrequencyPeriodMultiplierLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg2(Integer floatingRatePaymentFrequencyPeriodMultiplierLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setFixingDateLeg1(ZonedDateTime fixingDateLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFixingDateLeg2(ZonedDateTime fixingDateLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodLeg1(String floatingRateResetFrequencyPeriodLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String floatingRateResetFrequencyPeriodOfLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer floatingRateResetFrequencyPeriodMultiplierLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer floatingRateResetFrequencyPeriodMultiplierLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment);
		JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment, int idx);
		JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		JFSATransactionReport.JFSATransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		JFSATransactionReport.JFSATransactionReportBuilder setValuationAmount(BigDecimal valuationAmount);
		JFSATransactionReport.JFSATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		JFSATransactionReport.JFSATransactionReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		JFSATransactionReport.JFSATransactionReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		JFSATransactionReport.JFSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		JFSATransactionReport.JFSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		JFSATransactionReport.JFSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		JFSATransactionReport.JFSATransactionReportBuilder setPrice(PriceAndNotation price);
		JFSATransactionReport.JFSATransactionReportBuilder setPriceNotation(String priceNotation);
		JFSATransactionReport.JFSATransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(PriceScheduleReport priceSchedule);
		JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(PriceScheduleReport priceSchedule, int idx);
		JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> priceSchedule);
		JFSATransactionReport.JFSATransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> priceSchedule);
		JFSATransactionReport.JFSATransactionReportBuilder setFixedRateLeg1(BigDecimal fixedRateLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setFixedRateLeg2(BigDecimal fixedRateLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 spreadOfLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setSpreadNotationOfLeg1(String spreadNotationOfLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 spreadOfLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setSpreadNotationOfLeg2(String spreadNotationOfLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setStrikePrice(StrikePriceAndNotation strikePrice);
		JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceNotation(String strikePriceNotation);
		JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport strikePriceSchedule);
		JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport strikePriceSchedule, int idx);
		JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedule);
		JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedule);
		JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		JFSATransactionReport.JFSATransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		JFSATransactionReport.JFSATransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		JFSATransactionReport.JFSATransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		JFSATransactionReport.JFSATransactionReportBuilder setNotionalLeg1(BigDecimal notionalLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setNotionalLeg2(BigDecimal notionalLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setCallAmount(BigDecimal callAmount);
		JFSATransactionReport.JFSATransactionReportBuilder setPutAmount(BigDecimal putAmount);
		JFSATransactionReport.JFSATransactionReportBuilder setNotionalCurrencyOfLeg1(ISOCurrencyCodeEnum notionalCurrencyOfLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setNotionalCurrencyOfLeg2(ISOCurrencyCodeEnum notionalCurrencyOfLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		JFSATransactionReport.JFSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		JFSATransactionReport.JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1, int idx);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2, int idx);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal totalNotionalQuantityLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal totalNotionalQuantityLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1, int idx);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2, int idx);
		JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setActionType(String actionType);
		JFSATransactionReport.JFSATransactionReportBuilder setEventType(String eventType);
		JFSATransactionReport.JFSATransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		JFSATransactionReport.JFSATransactionReportBuilder setEventIdentifier(String eventIdentifier);
		JFSATransactionReport.JFSATransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		JFSATransactionReport.JFSATransactionReportBuilder setEmbeddedOptionType(String embeddedOptionType);
		JFSATransactionReport.JFSATransactionReportBuilder setUpi(String upi);
		JFSATransactionReport.JFSATransactionReportBuilder setDeliveryType(String deliveryType);
		JFSATransactionReport.JFSATransactionReportBuilder setAssetClass(String assetClass);
		JFSATransactionReport.JFSATransactionReportBuilder setUnderlyingIdentificationType(String underlyingIdentificationType);
		JFSATransactionReport.JFSATransactionReportBuilder setUnderlyingIdentification(String underlyingIdentification);
		JFSATransactionReport.JFSATransactionReportBuilder setUnderlyingIndexIndicator(String underlyingIndexIndicator);
		JFSATransactionReport.JFSATransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		JFSATransactionReport.JFSATransactionReportBuilder setReferenceEntity(String referenceEntity);
		JFSATransactionReport.JFSATransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg1(String indicatorOfTheFloatingRateOfLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg2(String indicatorOfTheFloatingRateOfLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String nameOfTheFloatingRateOfLeg1);
		JFSATransactionReport.JFSATransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String nameOfTheFloatingRateOfLeg2);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg1TimePeriod(String floatingRateReferencePeriodOfLeg1TimePeriod);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String floatingRateReferencePeriodOfLeg2TimePeriod);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg1Multiplier(Integer floatingRateReferencePeriodOfLeg1Multiplier);
		JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer floatingRateReferencePeriodOfLeg2Multiplier);
		JFSATransactionReport.JFSATransactionReportBuilder setIsCrypto(Boolean isCrypto);
		JFSATransactionReport.JFSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		JFSATransactionReport.JFSATransactionReportBuilder setSeniority(String seniority);
		JFSATransactionReport.JFSATransactionReportBuilder setSeries(Integer series);
		JFSATransactionReport.JFSATransactionReportBuilder setVersion(Integer version);
		JFSATransactionReport.JFSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		JFSATransactionReport.JFSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		JFSATransactionReport.JFSATransactionReportBuilder setCustomBasketCode(String customBasketCode);
		JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int idx);
		JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		JFSATransactionReport.JFSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		JFSATransactionReport.JFSATransactionReportBuilder setContractType(String contractType);
		JFSATransactionReport.JFSATransactionReportBuilder setOptionStyle(String optionStyle);
		JFSATransactionReport.JFSATransactionReportBuilder setOptionType(String optionType);
		JFSATransactionReport.JFSATransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice packageTransactionPrice);
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPriceNotation(String packageTransactionPriceNotation);
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread packageTransactionSpread);
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpreadNotation(String packageTransactionSpreadNotation);
		JFSATransactionReport.JFSATransactionReportBuilder setDelta(BigDecimal delta);
		JFSATransactionReport.JFSATransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		JFSATransactionReport.JFSATransactionReportBuilder setBarrier(BarrierAndNotation barrier);
		JFSATransactionReport.JFSATransactionReportBuilder setNonReportable(JFSANonReportable nonReportable);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("direction1"), String.class, getDirection1(), this);
			processor.processBasic(path.newSubPath("direction2Leg1"), String.class, getDirection2Leg1(), this);
			processor.processBasic(path.newSubPath("direction2Leg2"), String.class, getDirection2Leg2(), this);
			processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
			processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("confirmed"), String.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
			processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg2(), this);
			processor.processBasic(path.newSubPath("clearingAccountOrigin"), String.class, getClearingAccountOrigin(), this);
			processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
			processor.processBasic(path.newSubPath("originalSwapUTIProprietary"), String.class, getOriginalSwapUTIProprietary(), this);
			processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
			processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
			processor.processBasic(path.newSubPath("utiProprietary"), String.class, getUtiProprietary(), this);
			processor.processBasic(path.newSubPath("priorUti"), String.class, getPriorUti(), this);
			processor.processBasic(path.newSubPath("priorUtiProprietary"), String.class, getPriorUtiProprietary(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, getFixedRatePaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, getFixedRatePaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg1"), String.class, getFloatingRatePaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg2"), String.class, getFloatingRatePaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("fixingDateLeg1"), ZonedDateTime.class, getFixingDateLeg1(), this);
			processor.processBasic(path.newSubPath("fixingDateLeg2"), ZonedDateTime.class, getFixingDateLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodLeg1"), String.class, getFloatingRateResetFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, getFloatingRateResetFrequencyPeriodOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.OtherPaymentReportBuilder.class, getOtherPayment());
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processRosetta(path.newSubPath("price"), processor, PriceAndNotation.PriceAndNotationBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceNotation"), String.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.PriceScheduleReportBuilder.class, getPriceSchedule());
			processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, getFixedRateLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, getFixedRateLeg2(), this);
			processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.SpreadOfLeg1Builder.class, getSpreadOfLeg1());
			processor.processBasic(path.newSubPath("spreadNotationOfLeg1"), String.class, getSpreadNotationOfLeg1(), this);
			processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.SpreadOfLeg2Builder.class, getSpreadOfLeg2());
			processor.processBasic(path.newSubPath("spreadNotationOfLeg2"), String.class, getSpreadNotationOfLeg2(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.StrikePriceAndNotationBuilder.class, getStrikePrice());
			processor.processBasic(path.newSubPath("strikePriceNotation"), String.class, getStrikePriceNotation(), this);
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.StrikePriceScheduleReportBuilder.class, getStrikePriceSchedule());
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, getNotionalLeg1(), this);
			processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, getNotionalLeg2(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("notionalCurrencyOfLeg1"), ISOCurrencyCodeEnum.class, getNotionalCurrencyOfLeg1(), this);
			processor.processBasic(path.newSubPath("notionalCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, getNotionalCurrencyOfLeg2(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder.class, getNotionalAmountScheduleLeg1());
			processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder.class, getNotionalAmountScheduleLeg2());
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
			processRosetta(path.newSubPath("notionalQuantityScheduleLeg1"), processor, NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder.class, getNotionalQuantityScheduleLeg1());
			processRosetta(path.newSubPath("notionalQuantityScheduleLeg2"), processor, NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder.class, getNotionalQuantityScheduleLeg2());
			processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), String.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("upi"), String.class, getUpi(), this);
			processor.processBasic(path.newSubPath("deliveryType"), String.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
			processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
			processor.processBasic(path.newSubPath("underlyingIndexIndicator"), String.class, getUnderlyingIndexIndicator(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg1"), String.class, getIndicatorOfTheFloatingRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg2"), String.class, getIndicatorOfTheFloatingRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, getNameOfTheFloatingRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, getNameOfTheFloatingRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg1TimePeriod(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg2TimePeriod(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg1Multiplier(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg2Multiplier(), this);
			processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("seniority"), String.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.PackageTransactionPriceBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), String.class, getPackageTransactionPriceNotation(), this);
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.PackageTransactionSpreadBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), String.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processRosetta(path.newSubPath("barrier"), processor, BarrierAndNotation.BarrierAndNotationBuilder.class, getBarrier());
			processRosetta(path.newSubPath("nonReportable"), processor, JFSANonReportable.JFSANonReportableBuilder.class, getNonReportable());
		}
		

		JFSATransactionReport.JFSATransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of JFSATransactionReport  ***********************/
	class JFSATransactionReportImpl implements JFSATransactionReport {
		private final Date effectiveDate;
		private final Date expirationDate;
		private final Date earlyTerminationDate;
		private final ZonedDateTime reportingTimestamp;
		private final ZonedDateTime executionTimestamp;
		private final String entityResponsibleForReporting;
		private final String counterparty1;
		private final String counterparty2;
		private final Boolean counterparty2IdentifierType;
		private final String direction1;
		private final String direction2Leg1;
		private final String direction2Leg2;
		private final String submitterIdentifier;
		private final String newSDRIdentifier;
		private final String originalSwapSDRIdentifier;
		private final String cleared;
		private final String centralCounterparty;
		private final String clearingMember;
		private final String platformIdentifier;
		private final String confirmed;
		private final Date finalContractualSettlementDate;
		private final ZonedDateTime confirmationTimestamp;
		private final ISOCurrencyCodeEnum settlementCurrencyLeg1;
		private final ISOCurrencyCodeEnum settlementCurrencyLeg2;
		private final String clearingAccountOrigin;
		private final String originalSwapUTI;
		private final String originalSwapUTIProprietary;
		private final ZonedDateTime clearingReceiptTimestamp;
		private final String uti;
		private final String utiProprietary;
		private final String priorUti;
		private final String priorUtiProprietary;
		private final InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
		private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
		private final InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
		private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
		private final String fixedRatePaymentFrequencyPeriodLeg1;
		private final String fixedRatePaymentFrequencyPeriodLeg2;
		private final String floatingRatePaymentFrequencyPeriodLeg1;
		private final String floatingRatePaymentFrequencyPeriodLeg2;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierLeg1;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierLeg2;
		private final ZonedDateTime fixingDateLeg1;
		private final ZonedDateTime fixingDateLeg2;
		private final String floatingRateResetFrequencyPeriodLeg1;
		private final String floatingRateResetFrequencyPeriodOfLeg2;
		private final Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
		private final Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
		private final List<? extends OtherPaymentReport> otherPayment;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ValuationType1Code valuationMethod;
		private final ZonedDateTime valuationTimestamp;
		private final Boolean collateralPortfolioIndicator;
		private final String initialMarginCollateralPortfolioCode;
		private final String variationMarginCollateralPortfolioCode;
		private final PriceAndNotation price;
		private final String priceNotation;
		private final String priceUnitOfMeasure;
		private final List<? extends PriceScheduleReport> priceSchedule;
		private final BigDecimal fixedRateLeg1;
		private final BigDecimal fixedRateLeg2;
		private final SpreadOfLeg1 spreadOfLeg1;
		private final String spreadNotationOfLeg1;
		private final SpreadOfLeg2 spreadOfLeg2;
		private final String spreadNotationOfLeg2;
		private final StrikePriceAndNotation strikePrice;
		private final String strikePriceNotation;
		private final List<? extends StrikePriceScheduleReport> strikePriceSchedule;
		private final BigDecimal optionPremiumAmount;
		private final ISOCurrencyCodeEnum optionPremiumCurrency;
		private final Date optionPremiumPaymentDate;
		private final Date firstExerciseDate;
		private final BigDecimal exchangeRate;
		private final String exchangeRateBasis;
		private final BigDecimal notionalLeg1;
		private final BigDecimal notionalLeg2;
		private final BigDecimal callAmount;
		private final BigDecimal putAmount;
		private final ISOCurrencyCodeEnum notionalCurrencyOfLeg1;
		private final ISOCurrencyCodeEnum notionalCurrencyOfLeg2;
		private final ISOCurrencyCodeEnum callCurrency;
		private final ISOCurrencyCodeEnum putCurrency;
		private final String quantityUnitOfMeasureLeg1;
		private final String quantityUnitOfMeasureLeg2;
		private final List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1;
		private final List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2;
		private final BigDecimal totalNotionalQuantityLeg1;
		private final BigDecimal totalNotionalQuantityLeg2;
		private final List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1;
		private final List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2;
		private final String actionType;
		private final String eventType;
		private final ZonedDateTime eventTimestamp;
		private final String eventIdentifier;
		private final BigDecimal indexFactor;
		private final String embeddedOptionType;
		private final String upi;
		private final String deliveryType;
		private final String assetClass;
		private final String underlyingIdentificationType;
		private final String underlyingIdentification;
		private final String underlyingIndexIndicator;
		private final String nameOfTheUnderlyingIndex;
		private final String referenceEntity;
		private final String indicatorOfTheFloatingRateOfLeg1;
		private final String indicatorOfTheFloatingRateOfLeg2;
		private final String nameOfTheFloatingRateOfLeg1;
		private final String nameOfTheFloatingRateOfLeg2;
		private final String floatingRateReferencePeriodOfLeg1TimePeriod;
		private final String floatingRateReferencePeriodOfLeg2TimePeriod;
		private final Integer floatingRateReferencePeriodOfLeg1Multiplier;
		private final Integer floatingRateReferencePeriodOfLeg2Multiplier;
		private final Boolean isCrypto;
		private final Date maturityDateOfTheUnderlying;
		private final String seniority;
		private final Integer series;
		private final Integer version;
		private final BigDecimal cdSIndexAttachmentPoint;
		private final BigDecimal cdSIndexDetachmentPoint;
		private final String customBasketCode;
		private final List<? extends BasketConstituentsReport> basketConstituents;
		private final String contractType;
		private final String optionStyle;
		private final String optionType;
		private final String packageIdentifier;
		private final PackageTransactionPrice packageTransactionPrice;
		private final ISOCurrencyCodeEnum packageTransactionPriceCurrency;
		private final String packageTransactionPriceNotation;
		private final PackageTransactionSpread packageTransactionSpread;
		private final ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
		private final String packageTransactionSpreadNotation;
		private final BigDecimal delta;
		private final String technicalRecordId;
		private final BarrierAndNotation barrier;
		private final JFSANonReportable nonReportable;
		
		protected JFSATransactionReportImpl(JFSATransactionReport.JFSATransactionReportBuilder builder) {
			this.effectiveDate = builder.getEffectiveDate();
			this.expirationDate = builder.getExpirationDate();
			this.earlyTerminationDate = builder.getEarlyTerminationDate();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.executionTimestamp = builder.getExecutionTimestamp();
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
			this.direction1 = builder.getDirection1();
			this.direction2Leg1 = builder.getDirection2Leg1();
			this.direction2Leg2 = builder.getDirection2Leg2();
			this.submitterIdentifier = builder.getSubmitterIdentifier();
			this.newSDRIdentifier = builder.getNewSDRIdentifier();
			this.originalSwapSDRIdentifier = builder.getOriginalSwapSDRIdentifier();
			this.cleared = builder.getCleared();
			this.centralCounterparty = builder.getCentralCounterparty();
			this.clearingMember = builder.getClearingMember();
			this.platformIdentifier = builder.getPlatformIdentifier();
			this.confirmed = builder.getConfirmed();
			this.finalContractualSettlementDate = builder.getFinalContractualSettlementDate();
			this.confirmationTimestamp = builder.getConfirmationTimestamp();
			this.settlementCurrencyLeg1 = builder.getSettlementCurrencyLeg1();
			this.settlementCurrencyLeg2 = builder.getSettlementCurrencyLeg2();
			this.clearingAccountOrigin = builder.getClearingAccountOrigin();
			this.originalSwapUTI = builder.getOriginalSwapUTI();
			this.originalSwapUTIProprietary = builder.getOriginalSwapUTIProprietary();
			this.clearingReceiptTimestamp = builder.getClearingReceiptTimestamp();
			this.uti = builder.getUti();
			this.utiProprietary = builder.getUtiProprietary();
			this.priorUti = builder.getPriorUti();
			this.priorUtiProprietary = builder.getPriorUtiProprietary();
			this.fixedRateDayCountConventionLeg1 = builder.getFixedRateDayCountConventionLeg1();
			this.floatingRateDayCountConventionOfLeg1 = builder.getFloatingRateDayCountConventionOfLeg1();
			this.fixedRateDayCountConventionLeg2 = builder.getFixedRateDayCountConventionLeg2();
			this.floatingRateDayCountConventionOfLeg2 = builder.getFloatingRateDayCountConventionOfLeg2();
			this.fixedRatePaymentFrequencyPeriodLeg1 = builder.getFixedRatePaymentFrequencyPeriodLeg1();
			this.fixedRatePaymentFrequencyPeriodLeg2 = builder.getFixedRatePaymentFrequencyPeriodLeg2();
			this.floatingRatePaymentFrequencyPeriodLeg1 = builder.getFloatingRatePaymentFrequencyPeriodLeg1();
			this.floatingRatePaymentFrequencyPeriodLeg2 = builder.getFloatingRatePaymentFrequencyPeriodLeg2();
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg1();
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg2();
			this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1();
			this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2();
			this.fixingDateLeg1 = builder.getFixingDateLeg1();
			this.fixingDateLeg2 = builder.getFixingDateLeg2();
			this.floatingRateResetFrequencyPeriodLeg1 = builder.getFloatingRateResetFrequencyPeriodLeg1();
			this.floatingRateResetFrequencyPeriodOfLeg2 = builder.getFloatingRateResetFrequencyPeriodOfLeg2();
			this.floatingRateResetFrequencyPeriodMultiplierLeg1 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg1();
			this.floatingRateResetFrequencyPeriodMultiplierLeg2 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg2();
			this.otherPayment = ofNullable(builder.getOtherPayment()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationMethod = builder.getValuationMethod();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.price = ofNullable(builder.getPrice()).map(f->f.build()).orElse(null);
			this.priceNotation = builder.getPriceNotation();
			this.priceUnitOfMeasure = builder.getPriceUnitOfMeasure();
			this.priceSchedule = ofNullable(builder.getPriceSchedule()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.fixedRateLeg1 = builder.getFixedRateLeg1();
			this.fixedRateLeg2 = builder.getFixedRateLeg2();
			this.spreadOfLeg1 = ofNullable(builder.getSpreadOfLeg1()).map(f->f.build()).orElse(null);
			this.spreadNotationOfLeg1 = builder.getSpreadNotationOfLeg1();
			this.spreadOfLeg2 = ofNullable(builder.getSpreadOfLeg2()).map(f->f.build()).orElse(null);
			this.spreadNotationOfLeg2 = builder.getSpreadNotationOfLeg2();
			this.strikePrice = ofNullable(builder.getStrikePrice()).map(f->f.build()).orElse(null);
			this.strikePriceNotation = builder.getStrikePriceNotation();
			this.strikePriceSchedule = ofNullable(builder.getStrikePriceSchedule()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.optionPremiumAmount = builder.getOptionPremiumAmount();
			this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
			this.optionPremiumPaymentDate = builder.getOptionPremiumPaymentDate();
			this.firstExerciseDate = builder.getFirstExerciseDate();
			this.exchangeRate = builder.getExchangeRate();
			this.exchangeRateBasis = builder.getExchangeRateBasis();
			this.notionalLeg1 = builder.getNotionalLeg1();
			this.notionalLeg2 = builder.getNotionalLeg2();
			this.callAmount = builder.getCallAmount();
			this.putAmount = builder.getPutAmount();
			this.notionalCurrencyOfLeg1 = builder.getNotionalCurrencyOfLeg1();
			this.notionalCurrencyOfLeg2 = builder.getNotionalCurrencyOfLeg2();
			this.callCurrency = builder.getCallCurrency();
			this.putCurrency = builder.getPutCurrency();
			this.quantityUnitOfMeasureLeg1 = builder.getQuantityUnitOfMeasureLeg1();
			this.quantityUnitOfMeasureLeg2 = builder.getQuantityUnitOfMeasureLeg2();
			this.notionalAmountScheduleLeg1 = ofNullable(builder.getNotionalAmountScheduleLeg1()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.notionalAmountScheduleLeg2 = ofNullable(builder.getNotionalAmountScheduleLeg2()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.totalNotionalQuantityLeg1 = builder.getTotalNotionalQuantityLeg1();
			this.totalNotionalQuantityLeg2 = builder.getTotalNotionalQuantityLeg2();
			this.notionalQuantityScheduleLeg1 = ofNullable(builder.getNotionalQuantityScheduleLeg1()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.notionalQuantityScheduleLeg2 = ofNullable(builder.getNotionalQuantityScheduleLeg2()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.actionType = builder.getActionType();
			this.eventType = builder.getEventType();
			this.eventTimestamp = builder.getEventTimestamp();
			this.eventIdentifier = builder.getEventIdentifier();
			this.indexFactor = builder.getIndexFactor();
			this.embeddedOptionType = builder.getEmbeddedOptionType();
			this.upi = builder.getUpi();
			this.deliveryType = builder.getDeliveryType();
			this.assetClass = builder.getAssetClass();
			this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
			this.underlyingIdentification = builder.getUnderlyingIdentification();
			this.underlyingIndexIndicator = builder.getUnderlyingIndexIndicator();
			this.nameOfTheUnderlyingIndex = builder.getNameOfTheUnderlyingIndex();
			this.referenceEntity = builder.getReferenceEntity();
			this.indicatorOfTheFloatingRateOfLeg1 = builder.getIndicatorOfTheFloatingRateOfLeg1();
			this.indicatorOfTheFloatingRateOfLeg2 = builder.getIndicatorOfTheFloatingRateOfLeg2();
			this.nameOfTheFloatingRateOfLeg1 = builder.getNameOfTheFloatingRateOfLeg1();
			this.nameOfTheFloatingRateOfLeg2 = builder.getNameOfTheFloatingRateOfLeg2();
			this.floatingRateReferencePeriodOfLeg1TimePeriod = builder.getFloatingRateReferencePeriodOfLeg1TimePeriod();
			this.floatingRateReferencePeriodOfLeg2TimePeriod = builder.getFloatingRateReferencePeriodOfLeg2TimePeriod();
			this.floatingRateReferencePeriodOfLeg1Multiplier = builder.getFloatingRateReferencePeriodOfLeg1Multiplier();
			this.floatingRateReferencePeriodOfLeg2Multiplier = builder.getFloatingRateReferencePeriodOfLeg2Multiplier();
			this.isCrypto = builder.getIsCrypto();
			this.maturityDateOfTheUnderlying = builder.getMaturityDateOfTheUnderlying();
			this.seniority = builder.getSeniority();
			this.series = builder.getSeries();
			this.version = builder.getVersion();
			this.cdSIndexAttachmentPoint = builder.getCdSIndexAttachmentPoint();
			this.cdSIndexDetachmentPoint = builder.getCdSIndexDetachmentPoint();
			this.customBasketCode = builder.getCustomBasketCode();
			this.basketConstituents = ofNullable(builder.getBasketConstituents()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.contractType = builder.getContractType();
			this.optionStyle = builder.getOptionStyle();
			this.optionType = builder.getOptionType();
			this.packageIdentifier = builder.getPackageIdentifier();
			this.packageTransactionPrice = ofNullable(builder.getPackageTransactionPrice()).map(f->f.build()).orElse(null);
			this.packageTransactionPriceCurrency = builder.getPackageTransactionPriceCurrency();
			this.packageTransactionPriceNotation = builder.getPackageTransactionPriceNotation();
			this.packageTransactionSpread = ofNullable(builder.getPackageTransactionSpread()).map(f->f.build()).orElse(null);
			this.packageTransactionSpreadCurrency = builder.getPackageTransactionSpreadCurrency();
			this.packageTransactionSpreadNotation = builder.getPackageTransactionSpreadNotation();
			this.delta = builder.getDelta();
			this.technicalRecordId = builder.getTechnicalRecordId();
			this.barrier = ofNullable(builder.getBarrier()).map(f->f.build()).orElse(null);
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public Date getEarlyTerminationDate() {
			return earlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
		@RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		public String getDirection1() {
			return direction1;
		}
		
		@Override
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		public String getDirection2Leg1() {
			return direction2Leg1;
		}
		
		@Override
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		public String getDirection2Leg2() {
			return direction2Leg2;
		}
		
		@Override
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public String getOriginalSwapSDRIdentifier() {
			return originalSwapSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public String getPlatformIdentifier() {
			return platformIdentifier;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public String getConfirmed() {
			return confirmed;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg1")
		@RuneAttribute("settlementCurrencyLeg1")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
			return settlementCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg2")
		@RuneAttribute("settlementCurrencyLeg2")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
			return settlementCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public String getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public String getOriginalSwapUTI() {
			return originalSwapUTI;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTIProprietary")
		@RuneAttribute("originalSwapUTIProprietary")
		public String getOriginalSwapUTIProprietary() {
			return originalSwapUTIProprietary;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("utiProprietary")
		@RuneAttribute("utiProprietary")
		public String getUtiProprietary() {
			return utiProprietary;
		}
		
		@Override
		@RosettaAttribute("priorUti")
		@RuneAttribute("priorUti")
		public String getPriorUti() {
			return priorUti;
		}
		
		@Override
		@RosettaAttribute("priorUtiProprietary")
		@RuneAttribute("priorUtiProprietary")
		public String getPriorUtiProprietary() {
			return priorUtiProprietary;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
			return fixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
			return floatingRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
			return fixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
			return floatingRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		public String getFixedRatePaymentFrequencyPeriodLeg1() {
			return fixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		public String getFixedRatePaymentFrequencyPeriodLeg2() {
			return fixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		public String getFloatingRatePaymentFrequencyPeriodLeg1() {
			return floatingRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		public String getFloatingRatePaymentFrequencyPeriodLeg2() {
			return floatingRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg1")
		@RuneAttribute("fixingDateLeg1")
		public ZonedDateTime getFixingDateLeg1() {
			return fixingDateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg2")
		@RuneAttribute("fixingDateLeg2")
		public ZonedDateTime getFixingDateLeg2() {
			return fixingDateLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodLeg1")
		public String getFloatingRateResetFrequencyPeriodLeg1() {
			return floatingRateResetFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		public String getFloatingRateResetFrequencyPeriodOfLeg2() {
			return floatingRateResetFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public PriceAndNotation getPrice() {
			return price;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public String getPriceNotation() {
			return priceNotation;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public String getPriceUnitOfMeasure() {
			return priceUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public List<? extends PriceScheduleReport> getPriceSchedule() {
			return priceSchedule;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg1")
		@RuneAttribute("fixedRateLeg1")
		public BigDecimal getFixedRateLeg1() {
			return fixedRateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg2")
		@RuneAttribute("fixedRateLeg2")
		public BigDecimal getFixedRateLeg2() {
			return fixedRateLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1")
		@RuneAttribute("spreadOfLeg1")
		public SpreadOfLeg1 getSpreadOfLeg1() {
			return spreadOfLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadNotationOfLeg1")
		@RuneAttribute("spreadNotationOfLeg1")
		public String getSpreadNotationOfLeg1() {
			return spreadNotationOfLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2")
		@RuneAttribute("spreadOfLeg2")
		public SpreadOfLeg2 getSpreadOfLeg2() {
			return spreadOfLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadNotationOfLeg2")
		@RuneAttribute("spreadNotationOfLeg2")
		public String getSpreadNotationOfLeg2() {
			return spreadNotationOfLeg2;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public StrikePriceAndNotation getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public String getStrikePriceNotation() {
			return strikePriceNotation;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public List<? extends StrikePriceScheduleReport> getStrikePriceSchedule() {
			return strikePriceSchedule;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public Date getFirstExerciseDate() {
			return firstExerciseDate;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		public BigDecimal getNotionalLeg1() {
			return notionalLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		public BigDecimal getNotionalLeg2() {
			return notionalLeg2;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public BigDecimal getCallAmount() {
			return callAmount;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public BigDecimal getPutAmount() {
			return putAmount;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyOfLeg1")
		@RuneAttribute("notionalCurrencyOfLeg1")
		public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg1() {
			return notionalCurrencyOfLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyOfLeg2")
		@RuneAttribute("notionalCurrencyOfLeg2")
		public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2() {
			return notionalCurrencyOfLeg2;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public ISOCurrencyCodeEnum getCallCurrency() {
			return callCurrency;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public ISOCurrencyCodeEnum getPutCurrency() {
			return putCurrency;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public String getQuantityUnitOfMeasureLeg1() {
			return quantityUnitOfMeasureLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public String getQuantityUnitOfMeasureLeg2() {
			return quantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1() {
			return notionalAmountScheduleLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2() {
			return notionalAmountScheduleLeg2;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg1")
		@RuneAttribute("notionalQuantityScheduleLeg1")
		public List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1() {
			return notionalQuantityScheduleLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg2")
		@RuneAttribute("notionalQuantityScheduleLeg2")
		public List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2() {
			return notionalQuantityScheduleLeg2;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public String getEventIdentifier() {
			return eventIdentifier;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public String getEmbeddedOptionType() {
			return embeddedOptionType;
		}
		
		@Override
		@RosettaAttribute("upi")
		@RuneAttribute("upi")
		public String getUpi() {
			return upi;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public String getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("underlyingIndexIndicator")
		@RuneAttribute("underlyingIndexIndicator")
		public String getUnderlyingIndexIndicator() {
			return underlyingIndexIndicator;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public String getNameOfTheUnderlyingIndex() {
			return nameOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg1")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg1")
		public String getIndicatorOfTheFloatingRateOfLeg1() {
			return indicatorOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg2")
		public String getIndicatorOfTheFloatingRateOfLeg2() {
			return indicatorOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		public String getNameOfTheFloatingRateOfLeg1() {
			return nameOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		public String getNameOfTheFloatingRateOfLeg2() {
			return nameOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg1TimePeriod() {
			return floatingRateReferencePeriodOfLeg1TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
			return floatingRateReferencePeriodOfLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg1Multiplier() {
			return floatingRateReferencePeriodOfLeg1Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
			return floatingRateReferencePeriodOfLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute(value="isCrypto", isRequired=true)
		@RuneAttribute(value="isCrypto", isRequired=true)
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public String getSeniority() {
			return seniority;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public Integer getSeries() {
			return series;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public BigDecimal getCdSIndexAttachmentPoint() {
			return cdSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public BigDecimal getCdSIndexDetachmentPoint() {
			return cdSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public List<? extends BasketConstituentsReport> getBasketConstituents() {
			return basketConstituents;
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public PackageTransactionPrice getPackageTransactionPrice() {
			return packageTransactionPrice;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
			return packageTransactionPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public String getPackageTransactionPriceNotation() {
			return packageTransactionPriceNotation;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public PackageTransactionSpread getPackageTransactionSpread() {
			return packageTransactionSpread;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
			return packageTransactionSpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public String getPackageTransactionSpreadNotation() {
			return packageTransactionSpreadNotation;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public BarrierAndNotation getBarrier() {
			return barrier;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public JFSANonReportable getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public JFSATransactionReport build() {
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder toBuilder() {
			JFSATransactionReport.JFSATransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(JFSATransactionReport.JFSATransactionReportBuilder builder) {
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getExpirationDate()).ifPresent(builder::setExpirationDate);
			ofNullable(getEarlyTerminationDate()).ifPresent(builder::setEarlyTerminationDate);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
			ofNullable(getDirection1()).ifPresent(builder::setDirection1);
			ofNullable(getDirection2Leg1()).ifPresent(builder::setDirection2Leg1);
			ofNullable(getDirection2Leg2()).ifPresent(builder::setDirection2Leg2);
			ofNullable(getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
			ofNullable(getNewSDRIdentifier()).ifPresent(builder::setNewSDRIdentifier);
			ofNullable(getOriginalSwapSDRIdentifier()).ifPresent(builder::setOriginalSwapSDRIdentifier);
			ofNullable(getCleared()).ifPresent(builder::setCleared);
			ofNullable(getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
			ofNullable(getClearingMember()).ifPresent(builder::setClearingMember);
			ofNullable(getPlatformIdentifier()).ifPresent(builder::setPlatformIdentifier);
			ofNullable(getConfirmed()).ifPresent(builder::setConfirmed);
			ofNullable(getFinalContractualSettlementDate()).ifPresent(builder::setFinalContractualSettlementDate);
			ofNullable(getConfirmationTimestamp()).ifPresent(builder::setConfirmationTimestamp);
			ofNullable(getSettlementCurrencyLeg1()).ifPresent(builder::setSettlementCurrencyLeg1);
			ofNullable(getSettlementCurrencyLeg2()).ifPresent(builder::setSettlementCurrencyLeg2);
			ofNullable(getClearingAccountOrigin()).ifPresent(builder::setClearingAccountOrigin);
			ofNullable(getOriginalSwapUTI()).ifPresent(builder::setOriginalSwapUTI);
			ofNullable(getOriginalSwapUTIProprietary()).ifPresent(builder::setOriginalSwapUTIProprietary);
			ofNullable(getClearingReceiptTimestamp()).ifPresent(builder::setClearingReceiptTimestamp);
			ofNullable(getUti()).ifPresent(builder::setUti);
			ofNullable(getUtiProprietary()).ifPresent(builder::setUtiProprietary);
			ofNullable(getPriorUti()).ifPresent(builder::setPriorUti);
			ofNullable(getPriorUtiProprietary()).ifPresent(builder::setPriorUtiProprietary);
			ofNullable(getFixedRateDayCountConventionLeg1()).ifPresent(builder::setFixedRateDayCountConventionLeg1);
			ofNullable(getFloatingRateDayCountConventionOfLeg1()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg1);
			ofNullable(getFixedRateDayCountConventionLeg2()).ifPresent(builder::setFixedRateDayCountConventionLeg2);
			ofNullable(getFloatingRateDayCountConventionOfLeg2()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg2);
			ofNullable(getFixedRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodLeg2);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getFixingDateLeg1()).ifPresent(builder::setFixingDateLeg1);
			ofNullable(getFixingDateLeg2()).ifPresent(builder::setFixingDateLeg2);
			ofNullable(getFloatingRateResetFrequencyPeriodLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodLeg1);
			ofNullable(getFloatingRateResetFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg2);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg1);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg2);
			ofNullable(getOtherPayment()).ifPresent(builder::setOtherPayment);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getPrice()).ifPresent(builder::setPrice);
			ofNullable(getPriceNotation()).ifPresent(builder::setPriceNotation);
			ofNullable(getPriceUnitOfMeasure()).ifPresent(builder::setPriceUnitOfMeasure);
			ofNullable(getPriceSchedule()).ifPresent(builder::setPriceSchedule);
			ofNullable(getFixedRateLeg1()).ifPresent(builder::setFixedRateLeg1);
			ofNullable(getFixedRateLeg2()).ifPresent(builder::setFixedRateLeg2);
			ofNullable(getSpreadOfLeg1()).ifPresent(builder::setSpreadOfLeg1);
			ofNullable(getSpreadNotationOfLeg1()).ifPresent(builder::setSpreadNotationOfLeg1);
			ofNullable(getSpreadOfLeg2()).ifPresent(builder::setSpreadOfLeg2);
			ofNullable(getSpreadNotationOfLeg2()).ifPresent(builder::setSpreadNotationOfLeg2);
			ofNullable(getStrikePrice()).ifPresent(builder::setStrikePrice);
			ofNullable(getStrikePriceNotation()).ifPresent(builder::setStrikePriceNotation);
			ofNullable(getStrikePriceSchedule()).ifPresent(builder::setStrikePriceSchedule);
			ofNullable(getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
			ofNullable(getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
			ofNullable(getOptionPremiumPaymentDate()).ifPresent(builder::setOptionPremiumPaymentDate);
			ofNullable(getFirstExerciseDate()).ifPresent(builder::setFirstExerciseDate);
			ofNullable(getExchangeRate()).ifPresent(builder::setExchangeRate);
			ofNullable(getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
			ofNullable(getNotionalLeg1()).ifPresent(builder::setNotionalLeg1);
			ofNullable(getNotionalLeg2()).ifPresent(builder::setNotionalLeg2);
			ofNullable(getCallAmount()).ifPresent(builder::setCallAmount);
			ofNullable(getPutAmount()).ifPresent(builder::setPutAmount);
			ofNullable(getNotionalCurrencyOfLeg1()).ifPresent(builder::setNotionalCurrencyOfLeg1);
			ofNullable(getNotionalCurrencyOfLeg2()).ifPresent(builder::setNotionalCurrencyOfLeg2);
			ofNullable(getCallCurrency()).ifPresent(builder::setCallCurrency);
			ofNullable(getPutCurrency()).ifPresent(builder::setPutCurrency);
			ofNullable(getQuantityUnitOfMeasureLeg1()).ifPresent(builder::setQuantityUnitOfMeasureLeg1);
			ofNullable(getQuantityUnitOfMeasureLeg2()).ifPresent(builder::setQuantityUnitOfMeasureLeg2);
			ofNullable(getNotionalAmountScheduleLeg1()).ifPresent(builder::setNotionalAmountScheduleLeg1);
			ofNullable(getNotionalAmountScheduleLeg2()).ifPresent(builder::setNotionalAmountScheduleLeg2);
			ofNullable(getTotalNotionalQuantityLeg1()).ifPresent(builder::setTotalNotionalQuantityLeg1);
			ofNullable(getTotalNotionalQuantityLeg2()).ifPresent(builder::setTotalNotionalQuantityLeg2);
			ofNullable(getNotionalQuantityScheduleLeg1()).ifPresent(builder::setNotionalQuantityScheduleLeg1);
			ofNullable(getNotionalQuantityScheduleLeg2()).ifPresent(builder::setNotionalQuantityScheduleLeg2);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getEventType()).ifPresent(builder::setEventType);
			ofNullable(getEventTimestamp()).ifPresent(builder::setEventTimestamp);
			ofNullable(getEventIdentifier()).ifPresent(builder::setEventIdentifier);
			ofNullable(getIndexFactor()).ifPresent(builder::setIndexFactor);
			ofNullable(getEmbeddedOptionType()).ifPresent(builder::setEmbeddedOptionType);
			ofNullable(getUpi()).ifPresent(builder::setUpi);
			ofNullable(getDeliveryType()).ifPresent(builder::setDeliveryType);
			ofNullable(getAssetClass()).ifPresent(builder::setAssetClass);
			ofNullable(getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
			ofNullable(getUnderlyingIdentification()).ifPresent(builder::setUnderlyingIdentification);
			ofNullable(getUnderlyingIndexIndicator()).ifPresent(builder::setUnderlyingIndexIndicator);
			ofNullable(getNameOfTheUnderlyingIndex()).ifPresent(builder::setNameOfTheUnderlyingIndex);
			ofNullable(getReferenceEntity()).ifPresent(builder::setReferenceEntity);
			ofNullable(getIndicatorOfTheFloatingRateOfLeg1()).ifPresent(builder::setIndicatorOfTheFloatingRateOfLeg1);
			ofNullable(getIndicatorOfTheFloatingRateOfLeg2()).ifPresent(builder::setIndicatorOfTheFloatingRateOfLeg2);
			ofNullable(getNameOfTheFloatingRateOfLeg1()).ifPresent(builder::setNameOfTheFloatingRateOfLeg1);
			ofNullable(getNameOfTheFloatingRateOfLeg2()).ifPresent(builder::setNameOfTheFloatingRateOfLeg2);
			ofNullable(getFloatingRateReferencePeriodOfLeg1TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg1TimePeriod);
			ofNullable(getFloatingRateReferencePeriodOfLeg2TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2TimePeriod);
			ofNullable(getFloatingRateReferencePeriodOfLeg1Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg1Multiplier);
			ofNullable(getFloatingRateReferencePeriodOfLeg2Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2Multiplier);
			ofNullable(getIsCrypto()).ifPresent(builder::setIsCrypto);
			ofNullable(getMaturityDateOfTheUnderlying()).ifPresent(builder::setMaturityDateOfTheUnderlying);
			ofNullable(getSeniority()).ifPresent(builder::setSeniority);
			ofNullable(getSeries()).ifPresent(builder::setSeries);
			ofNullable(getVersion()).ifPresent(builder::setVersion);
			ofNullable(getCdSIndexAttachmentPoint()).ifPresent(builder::setCdSIndexAttachmentPoint);
			ofNullable(getCdSIndexDetachmentPoint()).ifPresent(builder::setCdSIndexDetachmentPoint);
			ofNullable(getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
			ofNullable(getBasketConstituents()).ifPresent(builder::setBasketConstituents);
			ofNullable(getContractType()).ifPresent(builder::setContractType);
			ofNullable(getOptionStyle()).ifPresent(builder::setOptionStyle);
			ofNullable(getOptionType()).ifPresent(builder::setOptionType);
			ofNullable(getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
			ofNullable(getPackageTransactionPrice()).ifPresent(builder::setPackageTransactionPrice);
			ofNullable(getPackageTransactionPriceCurrency()).ifPresent(builder::setPackageTransactionPriceCurrency);
			ofNullable(getPackageTransactionPriceNotation()).ifPresent(builder::setPackageTransactionPriceNotation);
			ofNullable(getPackageTransactionSpread()).ifPresent(builder::setPackageTransactionSpread);
			ofNullable(getPackageTransactionSpreadCurrency()).ifPresent(builder::setPackageTransactionSpreadCurrency);
			ofNullable(getPackageTransactionSpreadNotation()).ifPresent(builder::setPackageTransactionSpreadNotation);
			ofNullable(getDelta()).ifPresent(builder::setDelta);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
			ofNullable(getBarrier()).ifPresent(builder::setBarrier);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			JFSATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(earlyTerminationDate, _that.getEarlyTerminationDate())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(direction1, _that.getDirection1())) return false;
			if (!Objects.equals(direction2Leg1, _that.getDirection2Leg1())) return false;
			if (!Objects.equals(direction2Leg2, _that.getDirection2Leg2())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(platformIdentifier, _that.getPlatformIdentifier())) return false;
			if (!Objects.equals(confirmed, _that.getConfirmed())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) return false;
			if (!Objects.equals(settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!Objects.equals(originalSwapUTI, _that.getOriginalSwapUTI())) return false;
			if (!Objects.equals(originalSwapUTIProprietary, _that.getOriginalSwapUTIProprietary())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(utiProprietary, _that.getUtiProprietary())) return false;
			if (!Objects.equals(priorUti, _that.getPriorUti())) return false;
			if (!Objects.equals(priorUtiProprietary, _that.getPriorUtiProprietary())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodLeg1, _that.getFloatingRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodLeg2, _that.getFloatingRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(fixingDateLeg1, _that.getFixingDateLeg1())) return false;
			if (!Objects.equals(fixingDateLeg2, _that.getFixingDateLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodLeg1, _that.getFloatingRateResetFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!Objects.equals(priceNotation, _that.getPriceNotation())) return false;
			if (!Objects.equals(priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) return false;
			if (!ListEquals.listEquals(priceSchedule, _that.getPriceSchedule())) return false;
			if (!Objects.equals(fixedRateLeg1, _that.getFixedRateLeg1())) return false;
			if (!Objects.equals(fixedRateLeg2, _that.getFixedRateLeg2())) return false;
			if (!Objects.equals(spreadOfLeg1, _that.getSpreadOfLeg1())) return false;
			if (!Objects.equals(spreadNotationOfLeg1, _that.getSpreadNotationOfLeg1())) return false;
			if (!Objects.equals(spreadOfLeg2, _that.getSpreadOfLeg2())) return false;
			if (!Objects.equals(spreadNotationOfLeg2, _that.getSpreadNotationOfLeg2())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!Objects.equals(strikePriceNotation, _that.getStrikePriceNotation())) return false;
			if (!ListEquals.listEquals(strikePriceSchedule, _that.getStrikePriceSchedule())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(firstExerciseDate, _that.getFirstExerciseDate())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(notionalLeg1, _that.getNotionalLeg1())) return false;
			if (!Objects.equals(notionalLeg2, _that.getNotionalLeg2())) return false;
			if (!Objects.equals(callAmount, _that.getCallAmount())) return false;
			if (!Objects.equals(putAmount, _that.getPutAmount())) return false;
			if (!Objects.equals(notionalCurrencyOfLeg1, _that.getNotionalCurrencyOfLeg1())) return false;
			if (!Objects.equals(notionalCurrencyOfLeg2, _that.getNotionalCurrencyOfLeg2())) return false;
			if (!Objects.equals(callCurrency, _that.getCallCurrency())) return false;
			if (!Objects.equals(putCurrency, _that.getPutCurrency())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg1, _that.getNotionalQuantityScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg2, _that.getNotionalQuantityScheduleLeg2())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(eventIdentifier, _that.getEventIdentifier())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(embeddedOptionType, _that.getEmbeddedOptionType())) return false;
			if (!Objects.equals(upi, _that.getUpi())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!Objects.equals(underlyingIndexIndicator, _that.getUnderlyingIndexIndicator())) return false;
			if (!Objects.equals(nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg1, _that.getIndicatorOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg2, _that.getIndicatorOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1TimePeriod, _that.getFloatingRateReferencePeriodOfLeg1TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1Multiplier, _that.getFloatingRateReferencePeriodOfLeg1Multiplier())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(seniority, _that.getSeniority())) return false;
			if (!Objects.equals(series, _that.getSeries())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!ListEquals.listEquals(basketConstituents, _that.getBasketConstituents())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(packageTransactionPrice, _that.getPackageTransactionPrice())) return false;
			if (!Objects.equals(packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) return false;
			if (!Objects.equals(packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) return false;
			if (!Objects.equals(packageTransactionSpread, _that.getPackageTransactionSpread())) return false;
			if (!Objects.equals(packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) return false;
			if (!Objects.equals(packageTransactionSpreadNotation, _that.getPackageTransactionSpreadNotation())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(barrier, _that.getBarrier())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (earlyTerminationDate != null ? earlyTerminationDate.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (direction1 != null ? direction1.hashCode() : 0);
			_result = 31 * _result + (direction2Leg1 != null ? direction2Leg1.hashCode() : 0);
			_result = 31 * _result + (direction2Leg2 != null ? direction2Leg2.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (originalSwapSDRIdentifier != null ? originalSwapSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (platformIdentifier != null ? platformIdentifier.hashCode() : 0);
			_result = 31 * _result + (confirmed != null ? confirmed.hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg1 != null ? settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg2 != null ? settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTI != null ? originalSwapUTI.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTIProprietary != null ? originalSwapUTIProprietary.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (utiProprietary != null ? utiProprietary.hashCode() : 0);
			_result = 31 * _result + (priorUti != null ? priorUti.hashCode() : 0);
			_result = 31 * _result + (priorUtiProprietary != null ? priorUtiProprietary.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg1 != null ? fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg1 != null ? floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg2 != null ? fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg2 != null ? floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg1 != null ? fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg2 != null ? fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodLeg1 != null ? floatingRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodLeg2 != null ? floatingRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg1 != null ? fixingDateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg2 != null ? fixingDateLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodLeg1 != null ? floatingRateResetFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg2 != null ? floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceNotation != null ? priceNotation.hashCode() : 0);
			_result = 31 * _result + (priceUnitOfMeasure != null ? priceUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (priceSchedule != null ? priceSchedule.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg1 != null ? fixedRateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg2 != null ? fixedRateLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1 != null ? spreadOfLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadNotationOfLeg1 != null ? spreadNotationOfLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2 != null ? spreadOfLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadNotationOfLeg2 != null ? spreadNotationOfLeg2.hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotation != null ? strikePriceNotation.hashCode() : 0);
			_result = 31 * _result + (strikePriceSchedule != null ? strikePriceSchedule.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (firstExerciseDate != null ? firstExerciseDate.hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (notionalLeg1 != null ? notionalLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalLeg2 != null ? notionalLeg2.hashCode() : 0);
			_result = 31 * _result + (callAmount != null ? callAmount.hashCode() : 0);
			_result = 31 * _result + (putAmount != null ? putAmount.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyOfLeg1 != null ? notionalCurrencyOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyOfLeg2 != null ? notionalCurrencyOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (callCurrency != null ? callCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (putCurrency != null ? putCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg1 != null ? quantityUnitOfMeasureLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg2 != null ? quantityUnitOfMeasureLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1 != null ? notionalAmountScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2 != null ? notionalAmountScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg1 != null ? notionalQuantityScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg2 != null ? notionalQuantityScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (eventIdentifier != null ? eventIdentifier.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (embeddedOptionType != null ? embeddedOptionType.hashCode() : 0);
			_result = 31 * _result + (upi != null ? upi.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (underlyingIndexIndicator != null ? underlyingIndexIndicator.hashCode() : 0);
			_result = 31 * _result + (nameOfTheUnderlyingIndex != null ? nameOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg1 != null ? indicatorOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg2 != null ? indicatorOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg1 != null ? nameOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg2 != null ? nameOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1TimePeriod != null ? floatingRateReferencePeriodOfLeg1TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2TimePeriod != null ? floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1Multiplier != null ? floatingRateReferencePeriodOfLeg1Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2Multiplier != null ? floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (seniority != null ? seniority.hashCode() : 0);
			_result = 31 * _result + (series != null ? series.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (cdSIndexAttachmentPoint != null ? cdSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cdSIndexDetachmentPoint != null ? cdSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (basketConstituents != null ? basketConstituents.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPrice != null ? packageTransactionPrice.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceCurrency != null ? packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceNotation != null ? packageTransactionPriceNotation.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpread != null ? packageTransactionSpread.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadCurrency != null ? packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadNotation != null ? packageTransactionSpreadNotation.hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (barrier != null ? barrier.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "JFSATransactionReport {" +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"earlyTerminationDate=" + this.earlyTerminationDate + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"direction1=" + this.direction1 + ", " +
				"direction2Leg1=" + this.direction2Leg1 + ", " +
				"direction2Leg2=" + this.direction2Leg2 + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", " +
				"cleared=" + this.cleared + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"platformIdentifier=" + this.platformIdentifier + ", " +
				"confirmed=" + this.confirmed + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"settlementCurrencyLeg1=" + this.settlementCurrencyLeg1 + ", " +
				"settlementCurrencyLeg2=" + this.settlementCurrencyLeg2 + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"originalSwapUTI=" + this.originalSwapUTI + ", " +
				"originalSwapUTIProprietary=" + this.originalSwapUTIProprietary + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"uti=" + this.uti + ", " +
				"utiProprietary=" + this.utiProprietary + ", " +
				"priorUti=" + this.priorUti + ", " +
				"priorUtiProprietary=" + this.priorUtiProprietary + ", " +
				"fixedRateDayCountConventionLeg1=" + this.fixedRateDayCountConventionLeg1 + ", " +
				"floatingRateDayCountConventionOfLeg1=" + this.floatingRateDayCountConventionOfLeg1 + ", " +
				"fixedRateDayCountConventionLeg2=" + this.fixedRateDayCountConventionLeg2 + ", " +
				"floatingRateDayCountConventionOfLeg2=" + this.floatingRateDayCountConventionOfLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodLeg1=" + this.floatingRatePaymentFrequencyPeriodLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodLeg2=" + this.floatingRatePaymentFrequencyPeriodLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"fixingDateLeg1=" + this.fixingDateLeg1 + ", " +
				"fixingDateLeg2=" + this.fixingDateLeg2 + ", " +
				"floatingRateResetFrequencyPeriodLeg1=" + this.floatingRateResetFrequencyPeriodLeg1 + ", " +
				"floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"price=" + this.price + ", " +
				"priceNotation=" + this.priceNotation + ", " +
				"priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", " +
				"priceSchedule=" + this.priceSchedule + ", " +
				"fixedRateLeg1=" + this.fixedRateLeg1 + ", " +
				"fixedRateLeg2=" + this.fixedRateLeg2 + ", " +
				"spreadOfLeg1=" + this.spreadOfLeg1 + ", " +
				"spreadNotationOfLeg1=" + this.spreadNotationOfLeg1 + ", " +
				"spreadOfLeg2=" + this.spreadOfLeg2 + ", " +
				"spreadNotationOfLeg2=" + this.spreadNotationOfLeg2 + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"strikePriceNotation=" + this.strikePriceNotation + ", " +
				"strikePriceSchedule=" + this.strikePriceSchedule + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"firstExerciseDate=" + this.firstExerciseDate + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"notionalLeg1=" + this.notionalLeg1 + ", " +
				"notionalLeg2=" + this.notionalLeg2 + ", " +
				"callAmount=" + this.callAmount + ", " +
				"putAmount=" + this.putAmount + ", " +
				"notionalCurrencyOfLeg1=" + this.notionalCurrencyOfLeg1 + ", " +
				"notionalCurrencyOfLeg2=" + this.notionalCurrencyOfLeg2 + ", " +
				"callCurrency=" + this.callCurrency + ", " +
				"putCurrency=" + this.putCurrency + ", " +
				"quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", " +
				"quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", " +
				"notionalAmountScheduleLeg1=" + this.notionalAmountScheduleLeg1 + ", " +
				"notionalAmountScheduleLeg2=" + this.notionalAmountScheduleLeg2 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"notionalQuantityScheduleLeg1=" + this.notionalQuantityScheduleLeg1 + ", " +
				"notionalQuantityScheduleLeg2=" + this.notionalQuantityScheduleLeg2 + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"eventIdentifier=" + this.eventIdentifier + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"embeddedOptionType=" + this.embeddedOptionType + ", " +
				"upi=" + this.upi + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"underlyingIndexIndicator=" + this.underlyingIndexIndicator + ", " +
				"nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"indicatorOfTheFloatingRateOfLeg1=" + this.indicatorOfTheFloatingRateOfLeg1 + ", " +
				"indicatorOfTheFloatingRateOfLeg2=" + this.indicatorOfTheFloatingRateOfLeg2 + ", " +
				"nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", " +
				"nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", " +
				"floatingRateReferencePeriodOfLeg1TimePeriod=" + this.floatingRateReferencePeriodOfLeg1TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg1Multiplier=" + this.floatingRateReferencePeriodOfLeg1Multiplier + ", " +
				"floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"seniority=" + this.seniority + ", " +
				"series=" + this.series + ", " +
				"version=" + this.version + ", " +
				"cdSIndexAttachmentPoint=" + this.cdSIndexAttachmentPoint + ", " +
				"cdSIndexDetachmentPoint=" + this.cdSIndexDetachmentPoint + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"basketConstituents=" + this.basketConstituents + ", " +
				"contractType=" + this.contractType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"optionType=" + this.optionType + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"packageTransactionPrice=" + this.packageTransactionPrice + ", " +
				"packageTransactionPriceCurrency=" + this.packageTransactionPriceCurrency + ", " +
				"packageTransactionPriceNotation=" + this.packageTransactionPriceNotation + ", " +
				"packageTransactionSpread=" + this.packageTransactionSpread + ", " +
				"packageTransactionSpreadCurrency=" + this.packageTransactionSpreadCurrency + ", " +
				"packageTransactionSpreadNotation=" + this.packageTransactionSpreadNotation + ", " +
				"delta=" + this.delta + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"barrier=" + this.barrier + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}

	/*********************** Builder Implementation of JFSATransactionReport  ***********************/
	class JFSATransactionReportBuilderImpl implements JFSATransactionReport.JFSATransactionReportBuilder {
	
		protected Date effectiveDate;
		protected Date expirationDate;
		protected Date earlyTerminationDate;
		protected ZonedDateTime reportingTimestamp;
		protected ZonedDateTime executionTimestamp;
		protected String entityResponsibleForReporting;
		protected String counterparty1;
		protected String counterparty2;
		protected Boolean counterparty2IdentifierType;
		protected String direction1;
		protected String direction2Leg1;
		protected String direction2Leg2;
		protected String submitterIdentifier;
		protected String newSDRIdentifier;
		protected String originalSwapSDRIdentifier;
		protected String cleared;
		protected String centralCounterparty;
		protected String clearingMember;
		protected String platformIdentifier;
		protected String confirmed;
		protected Date finalContractualSettlementDate;
		protected ZonedDateTime confirmationTimestamp;
		protected ISOCurrencyCodeEnum settlementCurrencyLeg1;
		protected ISOCurrencyCodeEnum settlementCurrencyLeg2;
		protected String clearingAccountOrigin;
		protected String originalSwapUTI;
		protected String originalSwapUTIProprietary;
		protected ZonedDateTime clearingReceiptTimestamp;
		protected String uti;
		protected String utiProprietary;
		protected String priorUti;
		protected String priorUtiProprietary;
		protected InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
		protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
		protected InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
		protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
		protected String fixedRatePaymentFrequencyPeriodLeg1;
		protected String fixedRatePaymentFrequencyPeriodLeg2;
		protected String floatingRatePaymentFrequencyPeriodLeg1;
		protected String floatingRatePaymentFrequencyPeriodLeg2;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierLeg1;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierLeg2;
		protected ZonedDateTime fixingDateLeg1;
		protected ZonedDateTime fixingDateLeg2;
		protected String floatingRateResetFrequencyPeriodLeg1;
		protected String floatingRateResetFrequencyPeriodOfLeg2;
		protected Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
		protected Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
		protected List<OtherPaymentReport.OtherPaymentReportBuilder> otherPayment = new ArrayList<>();
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ValuationType1Code valuationMethod;
		protected ZonedDateTime valuationTimestamp;
		protected Boolean collateralPortfolioIndicator;
		protected String initialMarginCollateralPortfolioCode;
		protected String variationMarginCollateralPortfolioCode;
		protected PriceAndNotation.PriceAndNotationBuilder price;
		protected String priceNotation;
		protected String priceUnitOfMeasure;
		protected List<PriceScheduleReport.PriceScheduleReportBuilder> priceSchedule = new ArrayList<>();
		protected BigDecimal fixedRateLeg1;
		protected BigDecimal fixedRateLeg2;
		protected SpreadOfLeg1.SpreadOfLeg1Builder spreadOfLeg1;
		protected String spreadNotationOfLeg1;
		protected SpreadOfLeg2.SpreadOfLeg2Builder spreadOfLeg2;
		protected String spreadNotationOfLeg2;
		protected StrikePriceAndNotation.StrikePriceAndNotationBuilder strikePrice;
		protected String strikePriceNotation;
		protected List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> strikePriceSchedule = new ArrayList<>();
		protected BigDecimal optionPremiumAmount;
		protected ISOCurrencyCodeEnum optionPremiumCurrency;
		protected Date optionPremiumPaymentDate;
		protected Date firstExerciseDate;
		protected BigDecimal exchangeRate;
		protected String exchangeRateBasis;
		protected BigDecimal notionalLeg1;
		protected BigDecimal notionalLeg2;
		protected BigDecimal callAmount;
		protected BigDecimal putAmount;
		protected ISOCurrencyCodeEnum notionalCurrencyOfLeg1;
		protected ISOCurrencyCodeEnum notionalCurrencyOfLeg2;
		protected ISOCurrencyCodeEnum callCurrency;
		protected ISOCurrencyCodeEnum putCurrency;
		protected String quantityUnitOfMeasureLeg1;
		protected String quantityUnitOfMeasureLeg2;
		protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> notionalAmountScheduleLeg1 = new ArrayList<>();
		protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> notionalAmountScheduleLeg2 = new ArrayList<>();
		protected BigDecimal totalNotionalQuantityLeg1;
		protected BigDecimal totalNotionalQuantityLeg2;
		protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> notionalQuantityScheduleLeg1 = new ArrayList<>();
		protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> notionalQuantityScheduleLeg2 = new ArrayList<>();
		protected String actionType;
		protected String eventType;
		protected ZonedDateTime eventTimestamp;
		protected String eventIdentifier;
		protected BigDecimal indexFactor;
		protected String embeddedOptionType;
		protected String upi;
		protected String deliveryType;
		protected String assetClass;
		protected String underlyingIdentificationType;
		protected String underlyingIdentification;
		protected String underlyingIndexIndicator;
		protected String nameOfTheUnderlyingIndex;
		protected String referenceEntity;
		protected String indicatorOfTheFloatingRateOfLeg1;
		protected String indicatorOfTheFloatingRateOfLeg2;
		protected String nameOfTheFloatingRateOfLeg1;
		protected String nameOfTheFloatingRateOfLeg2;
		protected String floatingRateReferencePeriodOfLeg1TimePeriod;
		protected String floatingRateReferencePeriodOfLeg2TimePeriod;
		protected Integer floatingRateReferencePeriodOfLeg1Multiplier;
		protected Integer floatingRateReferencePeriodOfLeg2Multiplier;
		protected Boolean isCrypto;
		protected Date maturityDateOfTheUnderlying;
		protected String seniority;
		protected Integer series;
		protected Integer version;
		protected BigDecimal cdSIndexAttachmentPoint;
		protected BigDecimal cdSIndexDetachmentPoint;
		protected String customBasketCode;
		protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> basketConstituents = new ArrayList<>();
		protected String contractType;
		protected String optionStyle;
		protected String optionType;
		protected String packageIdentifier;
		protected PackageTransactionPrice.PackageTransactionPriceBuilder packageTransactionPrice;
		protected ISOCurrencyCodeEnum packageTransactionPriceCurrency;
		protected String packageTransactionPriceNotation;
		protected PackageTransactionSpread.PackageTransactionSpreadBuilder packageTransactionSpread;
		protected ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
		protected String packageTransactionSpreadNotation;
		protected BigDecimal delta;
		protected String technicalRecordId;
		protected BarrierAndNotation.BarrierAndNotationBuilder barrier;
		protected JFSANonReportable.JFSANonReportableBuilder nonReportable;
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public Date getEarlyTerminationDate() {
			return earlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
		@RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		public String getDirection1() {
			return direction1;
		}
		
		@Override
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		public String getDirection2Leg1() {
			return direction2Leg1;
		}
		
		@Override
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		public String getDirection2Leg2() {
			return direction2Leg2;
		}
		
		@Override
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public String getOriginalSwapSDRIdentifier() {
			return originalSwapSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public String getPlatformIdentifier() {
			return platformIdentifier;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public String getConfirmed() {
			return confirmed;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg1")
		@RuneAttribute("settlementCurrencyLeg1")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
			return settlementCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg2")
		@RuneAttribute("settlementCurrencyLeg2")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
			return settlementCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public String getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public String getOriginalSwapUTI() {
			return originalSwapUTI;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTIProprietary")
		@RuneAttribute("originalSwapUTIProprietary")
		public String getOriginalSwapUTIProprietary() {
			return originalSwapUTIProprietary;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("utiProprietary")
		@RuneAttribute("utiProprietary")
		public String getUtiProprietary() {
			return utiProprietary;
		}
		
		@Override
		@RosettaAttribute("priorUti")
		@RuneAttribute("priorUti")
		public String getPriorUti() {
			return priorUti;
		}
		
		@Override
		@RosettaAttribute("priorUtiProprietary")
		@RuneAttribute("priorUtiProprietary")
		public String getPriorUtiProprietary() {
			return priorUtiProprietary;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
			return fixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
			return floatingRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
			return fixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
			return floatingRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		public String getFixedRatePaymentFrequencyPeriodLeg1() {
			return fixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		public String getFixedRatePaymentFrequencyPeriodLeg2() {
			return fixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		public String getFloatingRatePaymentFrequencyPeriodLeg1() {
			return floatingRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		public String getFloatingRatePaymentFrequencyPeriodLeg2() {
			return floatingRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg1")
		@RuneAttribute("fixingDateLeg1")
		public ZonedDateTime getFixingDateLeg1() {
			return fixingDateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg2")
		@RuneAttribute("fixingDateLeg2")
		public ZonedDateTime getFixingDateLeg2() {
			return fixingDateLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodLeg1")
		public String getFloatingRateResetFrequencyPeriodLeg1() {
			return floatingRateResetFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		public String getFloatingRateResetFrequencyPeriodOfLeg2() {
			return floatingRateResetFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index) {
			if (otherPayment==null) {
				this.otherPayment = new ArrayList<>();
			}
			return getIndex(otherPayment, index, () -> {
						OtherPaymentReport.OtherPaymentReportBuilder newOtherPayment = OtherPaymentReport.builder();
						return newOtherPayment;
					});
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public PriceAndNotation.PriceAndNotationBuilder getPrice() {
			return price;
		}
		
		@Override
		public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice() {
			PriceAndNotation.PriceAndNotationBuilder result;
			if (price!=null) {
				result = price;
			}
			else {
				result = price = PriceAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public String getPriceNotation() {
			return priceNotation;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public String getPriceUnitOfMeasure() {
			return priceUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule() {
			return priceSchedule;
		}
		
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int index) {
			if (priceSchedule==null) {
				this.priceSchedule = new ArrayList<>();
			}
			return getIndex(priceSchedule, index, () -> {
						PriceScheduleReport.PriceScheduleReportBuilder newPriceSchedule = PriceScheduleReport.builder();
						return newPriceSchedule;
					});
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg1")
		@RuneAttribute("fixedRateLeg1")
		public BigDecimal getFixedRateLeg1() {
			return fixedRateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg2")
		@RuneAttribute("fixedRateLeg2")
		public BigDecimal getFixedRateLeg2() {
			return fixedRateLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1")
		@RuneAttribute("spreadOfLeg1")
		public SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1() {
			return spreadOfLeg1;
		}
		
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1() {
			SpreadOfLeg1.SpreadOfLeg1Builder result;
			if (spreadOfLeg1!=null) {
				result = spreadOfLeg1;
			}
			else {
				result = spreadOfLeg1 = SpreadOfLeg1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("spreadNotationOfLeg1")
		@RuneAttribute("spreadNotationOfLeg1")
		public String getSpreadNotationOfLeg1() {
			return spreadNotationOfLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2")
		@RuneAttribute("spreadOfLeg2")
		public SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2() {
			return spreadOfLeg2;
		}
		
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2() {
			SpreadOfLeg2.SpreadOfLeg2Builder result;
			if (spreadOfLeg2!=null) {
				result = spreadOfLeg2;
			}
			else {
				result = spreadOfLeg2 = SpreadOfLeg2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("spreadNotationOfLeg2")
		@RuneAttribute("spreadNotationOfLeg2")
		public String getSpreadNotationOfLeg2() {
			return spreadNotationOfLeg2;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice() {
			StrikePriceAndNotation.StrikePriceAndNotationBuilder result;
			if (strikePrice!=null) {
				result = strikePrice;
			}
			else {
				result = strikePrice = StrikePriceAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public String getStrikePriceNotation() {
			return strikePriceNotation;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule() {
			return strikePriceSchedule;
		}
		
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int index) {
			if (strikePriceSchedule==null) {
				this.strikePriceSchedule = new ArrayList<>();
			}
			return getIndex(strikePriceSchedule, index, () -> {
						StrikePriceScheduleReport.StrikePriceScheduleReportBuilder newStrikePriceSchedule = StrikePriceScheduleReport.builder();
						return newStrikePriceSchedule;
					});
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public Date getFirstExerciseDate() {
			return firstExerciseDate;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		public BigDecimal getNotionalLeg1() {
			return notionalLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		public BigDecimal getNotionalLeg2() {
			return notionalLeg2;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public BigDecimal getCallAmount() {
			return callAmount;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public BigDecimal getPutAmount() {
			return putAmount;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyOfLeg1")
		@RuneAttribute("notionalCurrencyOfLeg1")
		public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg1() {
			return notionalCurrencyOfLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyOfLeg2")
		@RuneAttribute("notionalCurrencyOfLeg2")
		public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2() {
			return notionalCurrencyOfLeg2;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public ISOCurrencyCodeEnum getCallCurrency() {
			return callCurrency;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public ISOCurrencyCodeEnum getPutCurrency() {
			return putCurrency;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public String getQuantityUnitOfMeasureLeg1() {
			return quantityUnitOfMeasureLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public String getQuantityUnitOfMeasureLeg2() {
			return quantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1() {
			return notionalAmountScheduleLeg1;
		}
		
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index) {
			if (notionalAmountScheduleLeg1==null) {
				this.notionalAmountScheduleLeg1 = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg1, index, () -> {
						NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder newNotionalAmountScheduleLeg1 = NotionalAmountScheduleLeg1Report.builder();
						return newNotionalAmountScheduleLeg1;
					});
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2() {
			return notionalAmountScheduleLeg2;
		}
		
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index) {
			if (notionalAmountScheduleLeg2==null) {
				this.notionalAmountScheduleLeg2 = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg2, index, () -> {
						NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder newNotionalAmountScheduleLeg2 = NotionalAmountScheduleLeg2Report.builder();
						return newNotionalAmountScheduleLeg2;
					});
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg1")
		@RuneAttribute("notionalQuantityScheduleLeg1")
		public List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1() {
			return notionalQuantityScheduleLeg1;
		}
		
		@Override
		public NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1(int index) {
			if (notionalQuantityScheduleLeg1==null) {
				this.notionalQuantityScheduleLeg1 = new ArrayList<>();
			}
			return getIndex(notionalQuantityScheduleLeg1, index, () -> {
						NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder newNotionalQuantityScheduleLeg1 = NotionalQuantityScheduleLeg1Report.builder();
						return newNotionalQuantityScheduleLeg1;
					});
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg2")
		@RuneAttribute("notionalQuantityScheduleLeg2")
		public List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2() {
			return notionalQuantityScheduleLeg2;
		}
		
		@Override
		public NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2(int index) {
			if (notionalQuantityScheduleLeg2==null) {
				this.notionalQuantityScheduleLeg2 = new ArrayList<>();
			}
			return getIndex(notionalQuantityScheduleLeg2, index, () -> {
						NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder newNotionalQuantityScheduleLeg2 = NotionalQuantityScheduleLeg2Report.builder();
						return newNotionalQuantityScheduleLeg2;
					});
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public String getEventIdentifier() {
			return eventIdentifier;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public String getEmbeddedOptionType() {
			return embeddedOptionType;
		}
		
		@Override
		@RosettaAttribute("upi")
		@RuneAttribute("upi")
		public String getUpi() {
			return upi;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public String getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("underlyingIndexIndicator")
		@RuneAttribute("underlyingIndexIndicator")
		public String getUnderlyingIndexIndicator() {
			return underlyingIndexIndicator;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public String getNameOfTheUnderlyingIndex() {
			return nameOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg1")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg1")
		public String getIndicatorOfTheFloatingRateOfLeg1() {
			return indicatorOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg2")
		public String getIndicatorOfTheFloatingRateOfLeg2() {
			return indicatorOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		public String getNameOfTheFloatingRateOfLeg1() {
			return nameOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		public String getNameOfTheFloatingRateOfLeg2() {
			return nameOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg1TimePeriod() {
			return floatingRateReferencePeriodOfLeg1TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
			return floatingRateReferencePeriodOfLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg1Multiplier() {
			return floatingRateReferencePeriodOfLeg1Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
			return floatingRateReferencePeriodOfLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute(value="isCrypto", isRequired=true)
		@RuneAttribute(value="isCrypto", isRequired=true)
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public String getSeniority() {
			return seniority;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public Integer getSeries() {
			return series;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public BigDecimal getCdSIndexAttachmentPoint() {
			return cdSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public BigDecimal getCdSIndexDetachmentPoint() {
			return cdSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents() {
			return basketConstituents;
		}
		
		@Override
		public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index) {
			if (basketConstituents==null) {
				this.basketConstituents = new ArrayList<>();
			}
			return getIndex(basketConstituents, index, () -> {
						BasketConstituentsReport.BasketConstituentsReportBuilder newBasketConstituents = BasketConstituentsReport.builder();
						return newBasketConstituents;
					});
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice() {
			return packageTransactionPrice;
		}
		
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice() {
			PackageTransactionPrice.PackageTransactionPriceBuilder result;
			if (packageTransactionPrice!=null) {
				result = packageTransactionPrice;
			}
			else {
				result = packageTransactionPrice = PackageTransactionPrice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
			return packageTransactionPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public String getPackageTransactionPriceNotation() {
			return packageTransactionPriceNotation;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread() {
			return packageTransactionSpread;
		}
		
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread() {
			PackageTransactionSpread.PackageTransactionSpreadBuilder result;
			if (packageTransactionSpread!=null) {
				result = packageTransactionSpread;
			}
			else {
				result = packageTransactionSpread = PackageTransactionSpread.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
			return packageTransactionSpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public String getPackageTransactionSpreadNotation() {
			return packageTransactionSpreadNotation;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public BarrierAndNotation.BarrierAndNotationBuilder getBarrier() {
			return barrier;
		}
		
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder getOrCreateBarrier() {
			BarrierAndNotation.BarrierAndNotationBuilder result;
			if (barrier!=null) {
				result = barrier;
			}
			else {
				result = barrier = BarrierAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public JFSANonReportable.JFSANonReportableBuilder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public JFSANonReportable.JFSANonReportableBuilder getOrCreateNonReportable() {
			JFSANonReportable.JFSANonReportableBuilder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = JFSANonReportable.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
		@RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setDirection1(String _direction1) {
			this.direction1 = _direction1 == null ? null : _direction1;
			return this;
		}
		
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setDirection2Leg1(String _direction2Leg1) {
			this.direction2Leg1 = _direction2Leg1 == null ? null : _direction2Leg1;
			return this;
		}
		
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setDirection2Leg2(String _direction2Leg2) {
			this.direction2Leg2 = _direction2Leg2 == null ? null : _direction2Leg2;
			return this;
		}
		
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
			this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
			return this;
		}
		
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
			this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
			return this;
		}
		
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
			this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
			return this;
		}
		
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCleared(String _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setConfirmed(String _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
			this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
			return this;
		}
		
		@RosettaAttribute("settlementCurrencyLeg1")
		@RuneAttribute("settlementCurrencyLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum _settlementCurrencyLeg1) {
			this.settlementCurrencyLeg1 = _settlementCurrencyLeg1 == null ? null : _settlementCurrencyLeg1;
			return this;
		}
		
		@RosettaAttribute("settlementCurrencyLeg2")
		@RuneAttribute("settlementCurrencyLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum _settlementCurrencyLeg2) {
			this.settlementCurrencyLeg2 = _settlementCurrencyLeg2 == null ? null : _settlementCurrencyLeg2;
			return this;
		}
		
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setClearingAccountOrigin(String _clearingAccountOrigin) {
			this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
			return this;
		}
		
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
			this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
			return this;
		}
		
		@RosettaAttribute("originalSwapUTIProprietary")
		@RuneAttribute("originalSwapUTIProprietary")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setOriginalSwapUTIProprietary(String _originalSwapUTIProprietary) {
			this.originalSwapUTIProprietary = _originalSwapUTIProprietary == null ? null : _originalSwapUTIProprietary;
			return this;
		}
		
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
			this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
			return this;
		}
		
		@RosettaAttribute("uti")
		@RuneAttribute("uti")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setUti(String _uti) {
			this.uti = _uti == null ? null : _uti;
			return this;
		}
		
		@RosettaAttribute("utiProprietary")
		@RuneAttribute("utiProprietary")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setUtiProprietary(String _utiProprietary) {
			this.utiProprietary = _utiProprietary == null ? null : _utiProprietary;
			return this;
		}
		
		@RosettaAttribute("priorUti")
		@RuneAttribute("priorUti")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPriorUti(String _priorUti) {
			this.priorUti = _priorUti == null ? null : _priorUti;
			return this;
		}
		
		@RosettaAttribute("priorUtiProprietary")
		@RuneAttribute("priorUtiProprietary")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPriorUtiProprietary(String _priorUtiProprietary) {
			this.priorUtiProprietary = _priorUtiProprietary == null ? null : _priorUtiProprietary;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code _fixedRateDayCountConventionLeg1) {
			this.fixedRateDayCountConventionLeg1 = _fixedRateDayCountConventionLeg1 == null ? null : _fixedRateDayCountConventionLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg1) {
			this.floatingRateDayCountConventionOfLeg1 = _floatingRateDayCountConventionOfLeg1 == null ? null : _floatingRateDayCountConventionOfLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code _fixedRateDayCountConventionLeg2) {
			this.fixedRateDayCountConventionLeg2 = _fixedRateDayCountConventionLeg2 == null ? null : _fixedRateDayCountConventionLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg2) {
			this.floatingRateDayCountConventionOfLeg2 = _floatingRateDayCountConventionOfLeg2 == null ? null : _floatingRateDayCountConventionOfLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String _fixedRatePaymentFrequencyPeriodLeg1) {
			this.fixedRatePaymentFrequencyPeriodLeg1 = _fixedRatePaymentFrequencyPeriodLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String _fixedRatePaymentFrequencyPeriodLeg2) {
			this.fixedRatePaymentFrequencyPeriodLeg2 = _fixedRatePaymentFrequencyPeriodLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg1(String _floatingRatePaymentFrequencyPeriodLeg1) {
			this.floatingRatePaymentFrequencyPeriodLeg1 = _floatingRatePaymentFrequencyPeriodLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg2(String _floatingRatePaymentFrequencyPeriodLeg2) {
			this.floatingRatePaymentFrequencyPeriodLeg2 = _floatingRatePaymentFrequencyPeriodLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg1) {
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = _fixedRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg2) {
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = _fixedRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg1(Integer _floatingRatePaymentFrequencyPeriodMultiplierLeg1) {
			this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 = _floatingRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg2(Integer _floatingRatePaymentFrequencyPeriodMultiplierLeg2) {
			this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 = _floatingRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("fixingDateLeg1")
		@RuneAttribute("fixingDateLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixingDateLeg1(ZonedDateTime _fixingDateLeg1) {
			this.fixingDateLeg1 = _fixingDateLeg1 == null ? null : _fixingDateLeg1;
			return this;
		}
		
		@RosettaAttribute("fixingDateLeg2")
		@RuneAttribute("fixingDateLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixingDateLeg2(ZonedDateTime _fixingDateLeg2) {
			this.fixingDateLeg2 = _fixingDateLeg2 == null ? null : _fixingDateLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodLeg1(String _floatingRateResetFrequencyPeriodLeg1) {
			this.floatingRateResetFrequencyPeriodLeg1 = _floatingRateResetFrequencyPeriodLeg1 == null ? null : _floatingRateResetFrequencyPeriodLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String _floatingRateResetFrequencyPeriodOfLeg2) {
			this.floatingRateResetFrequencyPeriodOfLeg2 = _floatingRateResetFrequencyPeriodOfLeg2 == null ? null : _floatingRateResetFrequencyPeriodOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer _floatingRateResetFrequencyPeriodMultiplierLeg1) {
			this.floatingRateResetFrequencyPeriodMultiplierLeg1 = _floatingRateResetFrequencyPeriodMultiplierLeg1 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer _floatingRateResetFrequencyPeriodMultiplierLeg2) {
			this.floatingRateResetFrequencyPeriodMultiplierLeg2 = _floatingRateResetFrequencyPeriodMultiplierLeg2 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment, int idx) {
			getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPaymentReport toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("otherPayment")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("price")
		@RuneAttribute("price")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPrice(PriceAndNotation _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPriceNotation(String _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule, int idx) {
			getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
			if (priceSchedules != null) {
				for (final PriceScheduleReport toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("priceSchedule")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("fixedRateLeg1")
		@RuneAttribute("fixedRateLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixedRateLeg1(BigDecimal _fixedRateLeg1) {
			this.fixedRateLeg1 = _fixedRateLeg1 == null ? null : _fixedRateLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRateLeg2")
		@RuneAttribute("fixedRateLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFixedRateLeg2(BigDecimal _fixedRateLeg2) {
			this.fixedRateLeg2 = _fixedRateLeg2 == null ? null : _fixedRateLeg2;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg1")
		@RuneAttribute("spreadOfLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 _spreadOfLeg1) {
			this.spreadOfLeg1 = _spreadOfLeg1 == null ? null : _spreadOfLeg1.toBuilder();
			return this;
		}
		
		@RosettaAttribute("spreadNotationOfLeg1")
		@RuneAttribute("spreadNotationOfLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setSpreadNotationOfLeg1(String _spreadNotationOfLeg1) {
			this.spreadNotationOfLeg1 = _spreadNotationOfLeg1 == null ? null : _spreadNotationOfLeg1;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg2")
		@RuneAttribute("spreadOfLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 _spreadOfLeg2) {
			this.spreadOfLeg2 = _spreadOfLeg2 == null ? null : _spreadOfLeg2.toBuilder();
			return this;
		}
		
		@RosettaAttribute("spreadNotationOfLeg2")
		@RuneAttribute("spreadNotationOfLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setSpreadNotationOfLeg2(String _spreadNotationOfLeg2) {
			this.spreadNotationOfLeg2 = _spreadNotationOfLeg2 == null ? null : _spreadNotationOfLeg2;
			return this;
		}
		
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setStrikePrice(StrikePriceAndNotation _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceNotation(String _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule, int idx) {
			getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final StrikePriceScheduleReport toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("strikePriceSchedule")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNotionalLeg1(BigDecimal _notionalLeg1) {
			this.notionalLeg1 = _notionalLeg1 == null ? null : _notionalLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNotionalLeg2(BigDecimal _notionalLeg2) {
			this.notionalLeg2 = _notionalLeg2 == null ? null : _notionalLeg2;
			return this;
		}
		
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@RosettaAttribute("notionalCurrencyOfLeg1")
		@RuneAttribute("notionalCurrencyOfLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNotionalCurrencyOfLeg1(ISOCurrencyCodeEnum _notionalCurrencyOfLeg1) {
			this.notionalCurrencyOfLeg1 = _notionalCurrencyOfLeg1 == null ? null : _notionalCurrencyOfLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalCurrencyOfLeg2")
		@RuneAttribute("notionalCurrencyOfLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNotionalCurrencyOfLeg2(ISOCurrencyCodeEnum _notionalCurrencyOfLeg2) {
			this.notionalCurrencyOfLeg2 = _notionalCurrencyOfLeg2 == null ? null : _notionalCurrencyOfLeg2;
			return this;
		}
		
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1) {
			if (_notionalAmountScheduleLeg1 != null) {
				this.notionalAmountScheduleLeg1.add(_notionalAmountScheduleLeg1.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1, int idx) {
			getIndex(this.notionalAmountScheduleLeg1, idx, () -> _notionalAmountScheduleLeg1.toBuilder());
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
			if (notionalAmountScheduleLeg1s != null) {
				for (final NotionalAmountScheduleLeg1Report toAdd : notionalAmountScheduleLeg1s) {
					this.notionalAmountScheduleLeg1.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
			if (notionalAmountScheduleLeg1s == null) {
				this.notionalAmountScheduleLeg1 = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2) {
			if (_notionalAmountScheduleLeg2 != null) {
				this.notionalAmountScheduleLeg2.add(_notionalAmountScheduleLeg2.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2, int idx) {
			getIndex(this.notionalAmountScheduleLeg2, idx, () -> _notionalAmountScheduleLeg2.toBuilder());
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
			if (notionalAmountScheduleLeg2s != null) {
				for (final NotionalAmountScheduleLeg2Report toAdd : notionalAmountScheduleLeg2s) {
					this.notionalAmountScheduleLeg2.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
			if (notionalAmountScheduleLeg2s == null) {
				this.notionalAmountScheduleLeg2 = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal _totalNotionalQuantityLeg1) {
			this.totalNotionalQuantityLeg1 = _totalNotionalQuantityLeg1 == null ? null : _totalNotionalQuantityLeg1;
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal _totalNotionalQuantityLeg2) {
			this.totalNotionalQuantityLeg2 = _totalNotionalQuantityLeg2 == null ? null : _totalNotionalQuantityLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalQuantityScheduleLeg1")
		@RuneAttribute("notionalQuantityScheduleLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1) {
			if (_notionalQuantityScheduleLeg1 != null) {
				this.notionalQuantityScheduleLeg1.add(_notionalQuantityScheduleLeg1.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1, int idx) {
			getIndex(this.notionalQuantityScheduleLeg1, idx, () -> _notionalQuantityScheduleLeg1.toBuilder());
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1s) {
			if (notionalQuantityScheduleLeg1s != null) {
				for (final NotionalQuantityScheduleLeg1Report toAdd : notionalQuantityScheduleLeg1s) {
					this.notionalQuantityScheduleLeg1.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalQuantityScheduleLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNotionalQuantityScheduleLeg1(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1s) {
			if (notionalQuantityScheduleLeg1s == null) {
				this.notionalQuantityScheduleLeg1 = new ArrayList<>();
			} else {
				this.notionalQuantityScheduleLeg1 = notionalQuantityScheduleLeg1s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("notionalQuantityScheduleLeg2")
		@RuneAttribute("notionalQuantityScheduleLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2) {
			if (_notionalQuantityScheduleLeg2 != null) {
				this.notionalQuantityScheduleLeg2.add(_notionalQuantityScheduleLeg2.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2, int idx) {
			getIndex(this.notionalQuantityScheduleLeg2, idx, () -> _notionalQuantityScheduleLeg2.toBuilder());
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2s) {
			if (notionalQuantityScheduleLeg2s != null) {
				for (final NotionalQuantityScheduleLeg2Report toAdd : notionalQuantityScheduleLeg2s) {
					this.notionalQuantityScheduleLeg2.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalQuantityScheduleLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNotionalQuantityScheduleLeg2(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2s) {
			if (notionalQuantityScheduleLeg2s == null) {
				this.notionalQuantityScheduleLeg2 = new ArrayList<>();
			} else {
				this.notionalQuantityScheduleLeg2 = notionalQuantityScheduleLeg2s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setActionType(String _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setEventType(String _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setEmbeddedOptionType(String _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@RosettaAttribute("upi")
		@RuneAttribute("upi")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setUpi(String _upi) {
			this.upi = _upi == null ? null : _upi;
			return this;
		}
		
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setDeliveryType(String _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setAssetClass(String _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
			this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
			this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
			return this;
		}
		
		@RosettaAttribute("underlyingIndexIndicator")
		@RuneAttribute("underlyingIndexIndicator")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setUnderlyingIndexIndicator(String _underlyingIndexIndicator) {
			this.underlyingIndexIndicator = _underlyingIndexIndicator == null ? null : _underlyingIndexIndicator;
			return this;
		}
		
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setReferenceEntity(String _referenceEntity) {
			this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
			return this;
		}
		
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg1")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg1(String _indicatorOfTheFloatingRateOfLeg1) {
			this.indicatorOfTheFloatingRateOfLeg1 = _indicatorOfTheFloatingRateOfLeg1 == null ? null : _indicatorOfTheFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg2(String _indicatorOfTheFloatingRateOfLeg2) {
			this.indicatorOfTheFloatingRateOfLeg2 = _indicatorOfTheFloatingRateOfLeg2 == null ? null : _indicatorOfTheFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String _nameOfTheFloatingRateOfLeg1) {
			this.nameOfTheFloatingRateOfLeg1 = _nameOfTheFloatingRateOfLeg1 == null ? null : _nameOfTheFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String _nameOfTheFloatingRateOfLeg2) {
			this.nameOfTheFloatingRateOfLeg2 = _nameOfTheFloatingRateOfLeg2 == null ? null : _nameOfTheFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg1TimePeriod(String _floatingRateReferencePeriodOfLeg1TimePeriod) {
			this.floatingRateReferencePeriodOfLeg1TimePeriod = _floatingRateReferencePeriodOfLeg1TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg1TimePeriod;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String _floatingRateReferencePeriodOfLeg2TimePeriod) {
			this.floatingRateReferencePeriodOfLeg2TimePeriod = _floatingRateReferencePeriodOfLeg2TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg2TimePeriod;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg1Multiplier(Integer _floatingRateReferencePeriodOfLeg1Multiplier) {
			this.floatingRateReferencePeriodOfLeg1Multiplier = _floatingRateReferencePeriodOfLeg1Multiplier == null ? null : _floatingRateReferencePeriodOfLeg1Multiplier;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer _floatingRateReferencePeriodOfLeg2Multiplier) {
			this.floatingRateReferencePeriodOfLeg2Multiplier = _floatingRateReferencePeriodOfLeg2Multiplier == null ? null : _floatingRateReferencePeriodOfLeg2Multiplier;
			return this;
		}
		
		@RosettaAttribute(value="isCrypto", isRequired=true)
		@RuneAttribute(value="isCrypto", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setIsCrypto(Boolean _isCrypto) {
			this.isCrypto = _isCrypto == null ? null : _isCrypto;
			return this;
		}
		
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setSeniority(String _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@RosettaAttribute("series")
		@RuneAttribute("series")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@RosettaAttribute("version")
		@RuneAttribute("version")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setVersion(Integer _version) {
			this.version = _version == null ? null : _version;
			return this;
		}
		
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
			return this;
		}
		
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
			getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("basketConstituents")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setContractType(String _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionStyle(String _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setOptionType(String _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionPriceNotation(String _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setPackageTransactionSpreadNotation(String _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setBarrier(BarrierAndNotation _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder setNonReportable(JFSANonReportable _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@Override
		public JFSATransactionReport build() {
			return new JFSATransactionReport.JFSATransactionReportImpl(this);
		}
		
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder prune() {
			otherPayment = otherPayment.stream().filter(b->b!=null).<OtherPaymentReport.OtherPaymentReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (price!=null && !price.prune().hasData()) price = null;
			priceSchedule = priceSchedule.stream().filter(b->b!=null).<PriceScheduleReport.PriceScheduleReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (spreadOfLeg1!=null && !spreadOfLeg1.prune().hasData()) spreadOfLeg1 = null;
			if (spreadOfLeg2!=null && !spreadOfLeg2.prune().hasData()) spreadOfLeg2 = null;
			if (strikePrice!=null && !strikePrice.prune().hasData()) strikePrice = null;
			strikePriceSchedule = strikePriceSchedule.stream().filter(b->b!=null).<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1.stream().filter(b->b!=null).<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2.stream().filter(b->b!=null).<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalQuantityScheduleLeg1 = notionalQuantityScheduleLeg1.stream().filter(b->b!=null).<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalQuantityScheduleLeg2 = notionalQuantityScheduleLeg2.stream().filter(b->b!=null).<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			basketConstituents = basketConstituents.stream().filter(b->b!=null).<BasketConstituentsReport.BasketConstituentsReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (packageTransactionPrice!=null && !packageTransactionPrice.prune().hasData()) packageTransactionPrice = null;
			if (packageTransactionSpread!=null && !packageTransactionSpread.prune().hasData()) packageTransactionSpread = null;
			if (barrier!=null && !barrier.prune().hasData()) barrier = null;
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEffectiveDate()!=null) return true;
			if (getExpirationDate()!=null) return true;
			if (getEarlyTerminationDate()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getExecutionTimestamp()!=null) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2IdentifierType()!=null) return true;
			if (getDirection1()!=null) return true;
			if (getDirection2Leg1()!=null) return true;
			if (getDirection2Leg2()!=null) return true;
			if (getSubmitterIdentifier()!=null) return true;
			if (getNewSDRIdentifier()!=null) return true;
			if (getOriginalSwapSDRIdentifier()!=null) return true;
			if (getCleared()!=null) return true;
			if (getCentralCounterparty()!=null) return true;
			if (getClearingMember()!=null) return true;
			if (getPlatformIdentifier()!=null) return true;
			if (getConfirmed()!=null) return true;
			if (getFinalContractualSettlementDate()!=null) return true;
			if (getConfirmationTimestamp()!=null) return true;
			if (getSettlementCurrencyLeg1()!=null) return true;
			if (getSettlementCurrencyLeg2()!=null) return true;
			if (getClearingAccountOrigin()!=null) return true;
			if (getOriginalSwapUTI()!=null) return true;
			if (getOriginalSwapUTIProprietary()!=null) return true;
			if (getClearingReceiptTimestamp()!=null) return true;
			if (getUti()!=null) return true;
			if (getUtiProprietary()!=null) return true;
			if (getPriorUti()!=null) return true;
			if (getPriorUtiProprietary()!=null) return true;
			if (getFixedRateDayCountConventionLeg1()!=null) return true;
			if (getFloatingRateDayCountConventionOfLeg1()!=null) return true;
			if (getFixedRateDayCountConventionLeg2()!=null) return true;
			if (getFloatingRateDayCountConventionOfLeg2()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodLeg2()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getFixingDateLeg1()!=null) return true;
			if (getFixingDateLeg2()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodLeg1()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodOfLeg2()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getOtherPayment()!=null && getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getPrice()!=null && getPrice().hasData()) return true;
			if (getPriceNotation()!=null) return true;
			if (getPriceUnitOfMeasure()!=null) return true;
			if (getPriceSchedule()!=null && getPriceSchedule().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getFixedRateLeg1()!=null) return true;
			if (getFixedRateLeg2()!=null) return true;
			if (getSpreadOfLeg1()!=null && getSpreadOfLeg1().hasData()) return true;
			if (getSpreadNotationOfLeg1()!=null) return true;
			if (getSpreadOfLeg2()!=null && getSpreadOfLeg2().hasData()) return true;
			if (getSpreadNotationOfLeg2()!=null) return true;
			if (getStrikePrice()!=null && getStrikePrice().hasData()) return true;
			if (getStrikePriceNotation()!=null) return true;
			if (getStrikePriceSchedule()!=null && getStrikePriceSchedule().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getOptionPremiumAmount()!=null) return true;
			if (getOptionPremiumCurrency()!=null) return true;
			if (getOptionPremiumPaymentDate()!=null) return true;
			if (getFirstExerciseDate()!=null) return true;
			if (getExchangeRate()!=null) return true;
			if (getExchangeRateBasis()!=null) return true;
			if (getNotionalLeg1()!=null) return true;
			if (getNotionalLeg2()!=null) return true;
			if (getCallAmount()!=null) return true;
			if (getPutAmount()!=null) return true;
			if (getNotionalCurrencyOfLeg1()!=null) return true;
			if (getNotionalCurrencyOfLeg2()!=null) return true;
			if (getCallCurrency()!=null) return true;
			if (getPutCurrency()!=null) return true;
			if (getQuantityUnitOfMeasureLeg1()!=null) return true;
			if (getQuantityUnitOfMeasureLeg2()!=null) return true;
			if (getNotionalAmountScheduleLeg1()!=null && getNotionalAmountScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getNotionalAmountScheduleLeg2()!=null && getNotionalAmountScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getTotalNotionalQuantityLeg1()!=null) return true;
			if (getTotalNotionalQuantityLeg2()!=null) return true;
			if (getNotionalQuantityScheduleLeg1()!=null && getNotionalQuantityScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getNotionalQuantityScheduleLeg2()!=null && getNotionalQuantityScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getActionType()!=null) return true;
			if (getEventType()!=null) return true;
			if (getEventTimestamp()!=null) return true;
			if (getEventIdentifier()!=null) return true;
			if (getIndexFactor()!=null) return true;
			if (getEmbeddedOptionType()!=null) return true;
			if (getUpi()!=null) return true;
			if (getDeliveryType()!=null) return true;
			if (getAssetClass()!=null) return true;
			if (getUnderlyingIdentificationType()!=null) return true;
			if (getUnderlyingIdentification()!=null) return true;
			if (getUnderlyingIndexIndicator()!=null) return true;
			if (getNameOfTheUnderlyingIndex()!=null) return true;
			if (getReferenceEntity()!=null) return true;
			if (getIndicatorOfTheFloatingRateOfLeg1()!=null) return true;
			if (getIndicatorOfTheFloatingRateOfLeg2()!=null) return true;
			if (getNameOfTheFloatingRateOfLeg1()!=null) return true;
			if (getNameOfTheFloatingRateOfLeg2()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg1TimePeriod()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg2TimePeriod()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg1Multiplier()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg2Multiplier()!=null) return true;
			if (getIsCrypto()!=null) return true;
			if (getMaturityDateOfTheUnderlying()!=null) return true;
			if (getSeniority()!=null) return true;
			if (getSeries()!=null) return true;
			if (getVersion()!=null) return true;
			if (getCdSIndexAttachmentPoint()!=null) return true;
			if (getCdSIndexDetachmentPoint()!=null) return true;
			if (getCustomBasketCode()!=null) return true;
			if (getBasketConstituents()!=null && getBasketConstituents().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getContractType()!=null) return true;
			if (getOptionStyle()!=null) return true;
			if (getOptionType()!=null) return true;
			if (getPackageIdentifier()!=null) return true;
			if (getPackageTransactionPrice()!=null && getPackageTransactionPrice().hasData()) return true;
			if (getPackageTransactionPriceCurrency()!=null) return true;
			if (getPackageTransactionPriceNotation()!=null) return true;
			if (getPackageTransactionSpread()!=null && getPackageTransactionSpread().hasData()) return true;
			if (getPackageTransactionSpreadCurrency()!=null) return true;
			if (getPackageTransactionSpreadNotation()!=null) return true;
			if (getDelta()!=null) return true;
			if (getTechnicalRecordId()!=null) return true;
			if (getBarrier()!=null && getBarrier().hasData()) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public JFSATransactionReport.JFSATransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			JFSATransactionReport.JFSATransactionReportBuilder o = (JFSATransactionReport.JFSATransactionReportBuilder) other;
			
			merger.mergeRosetta(getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
			merger.mergeRosetta(getPrice(), o.getPrice(), this::setPrice);
			merger.mergeRosetta(getPriceSchedule(), o.getPriceSchedule(), this::getOrCreatePriceSchedule);
			merger.mergeRosetta(getSpreadOfLeg1(), o.getSpreadOfLeg1(), this::setSpreadOfLeg1);
			merger.mergeRosetta(getSpreadOfLeg2(), o.getSpreadOfLeg2(), this::setSpreadOfLeg2);
			merger.mergeRosetta(getStrikePrice(), o.getStrikePrice(), this::setStrikePrice);
			merger.mergeRosetta(getStrikePriceSchedule(), o.getStrikePriceSchedule(), this::getOrCreateStrikePriceSchedule);
			merger.mergeRosetta(getNotionalAmountScheduleLeg1(), o.getNotionalAmountScheduleLeg1(), this::getOrCreateNotionalAmountScheduleLeg1);
			merger.mergeRosetta(getNotionalAmountScheduleLeg2(), o.getNotionalAmountScheduleLeg2(), this::getOrCreateNotionalAmountScheduleLeg2);
			merger.mergeRosetta(getNotionalQuantityScheduleLeg1(), o.getNotionalQuantityScheduleLeg1(), this::getOrCreateNotionalQuantityScheduleLeg1);
			merger.mergeRosetta(getNotionalQuantityScheduleLeg2(), o.getNotionalQuantityScheduleLeg2(), this::getOrCreateNotionalQuantityScheduleLeg2);
			merger.mergeRosetta(getBasketConstituents(), o.getBasketConstituents(), this::getOrCreateBasketConstituents);
			merger.mergeRosetta(getPackageTransactionPrice(), o.getPackageTransactionPrice(), this::setPackageTransactionPrice);
			merger.mergeRosetta(getPackageTransactionSpread(), o.getPackageTransactionSpread(), this::setPackageTransactionSpread);
			merger.mergeRosetta(getBarrier(), o.getBarrier(), this::setBarrier);
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getExpirationDate(), o.getExpirationDate(), this::setExpirationDate);
			merger.mergeBasic(getEarlyTerminationDate(), o.getEarlyTerminationDate(), this::setEarlyTerminationDate);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getExecutionTimestamp(), o.getExecutionTimestamp(), this::setExecutionTimestamp);
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierType(), o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType);
			merger.mergeBasic(getDirection1(), o.getDirection1(), this::setDirection1);
			merger.mergeBasic(getDirection2Leg1(), o.getDirection2Leg1(), this::setDirection2Leg1);
			merger.mergeBasic(getDirection2Leg2(), o.getDirection2Leg2(), this::setDirection2Leg2);
			merger.mergeBasic(getSubmitterIdentifier(), o.getSubmitterIdentifier(), this::setSubmitterIdentifier);
			merger.mergeBasic(getNewSDRIdentifier(), o.getNewSDRIdentifier(), this::setNewSDRIdentifier);
			merger.mergeBasic(getOriginalSwapSDRIdentifier(), o.getOriginalSwapSDRIdentifier(), this::setOriginalSwapSDRIdentifier);
			merger.mergeBasic(getCleared(), o.getCleared(), this::setCleared);
			merger.mergeBasic(getCentralCounterparty(), o.getCentralCounterparty(), this::setCentralCounterparty);
			merger.mergeBasic(getClearingMember(), o.getClearingMember(), this::setClearingMember);
			merger.mergeBasic(getPlatformIdentifier(), o.getPlatformIdentifier(), this::setPlatformIdentifier);
			merger.mergeBasic(getConfirmed(), o.getConfirmed(), this::setConfirmed);
			merger.mergeBasic(getFinalContractualSettlementDate(), o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate);
			merger.mergeBasic(getConfirmationTimestamp(), o.getConfirmationTimestamp(), this::setConfirmationTimestamp);
			merger.mergeBasic(getSettlementCurrencyLeg1(), o.getSettlementCurrencyLeg1(), this::setSettlementCurrencyLeg1);
			merger.mergeBasic(getSettlementCurrencyLeg2(), o.getSettlementCurrencyLeg2(), this::setSettlementCurrencyLeg2);
			merger.mergeBasic(getClearingAccountOrigin(), o.getClearingAccountOrigin(), this::setClearingAccountOrigin);
			merger.mergeBasic(getOriginalSwapUTI(), o.getOriginalSwapUTI(), this::setOriginalSwapUTI);
			merger.mergeBasic(getOriginalSwapUTIProprietary(), o.getOriginalSwapUTIProprietary(), this::setOriginalSwapUTIProprietary);
			merger.mergeBasic(getClearingReceiptTimestamp(), o.getClearingReceiptTimestamp(), this::setClearingReceiptTimestamp);
			merger.mergeBasic(getUti(), o.getUti(), this::setUti);
			merger.mergeBasic(getUtiProprietary(), o.getUtiProprietary(), this::setUtiProprietary);
			merger.mergeBasic(getPriorUti(), o.getPriorUti(), this::setPriorUti);
			merger.mergeBasic(getPriorUtiProprietary(), o.getPriorUtiProprietary(), this::setPriorUtiProprietary);
			merger.mergeBasic(getFixedRateDayCountConventionLeg1(), o.getFixedRateDayCountConventionLeg1(), this::setFixedRateDayCountConventionLeg1);
			merger.mergeBasic(getFloatingRateDayCountConventionOfLeg1(), o.getFloatingRateDayCountConventionOfLeg1(), this::setFloatingRateDayCountConventionOfLeg1);
			merger.mergeBasic(getFixedRateDayCountConventionLeg2(), o.getFixedRateDayCountConventionLeg2(), this::setFixedRateDayCountConventionLeg2);
			merger.mergeBasic(getFloatingRateDayCountConventionOfLeg2(), o.getFloatingRateDayCountConventionOfLeg2(), this::setFloatingRateDayCountConventionOfLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodLeg1(), o.getFixedRatePaymentFrequencyPeriodLeg1(), this::setFixedRatePaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodLeg2(), o.getFixedRatePaymentFrequencyPeriodLeg2(), this::setFixedRatePaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodLeg1(), o.getFloatingRatePaymentFrequencyPeriodLeg1(), this::setFloatingRatePaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodLeg2(), o.getFloatingRatePaymentFrequencyPeriodLeg2(), this::setFloatingRatePaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this::setFloatingRatePaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this::setFloatingRatePaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getFixingDateLeg1(), o.getFixingDateLeg1(), this::setFixingDateLeg1);
			merger.mergeBasic(getFixingDateLeg2(), o.getFixingDateLeg2(), this::setFixingDateLeg2);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodLeg1(), o.getFloatingRateResetFrequencyPeriodLeg1(), this::setFloatingRateResetFrequencyPeriodLeg1);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodOfLeg2(), o.getFloatingRateResetFrequencyPeriodOfLeg2(), this::setFloatingRateResetFrequencyPeriodOfLeg2);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierLeg1(), o.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierLeg2(), o.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getPriceNotation(), o.getPriceNotation(), this::setPriceNotation);
			merger.mergeBasic(getPriceUnitOfMeasure(), o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure);
			merger.mergeBasic(getFixedRateLeg1(), o.getFixedRateLeg1(), this::setFixedRateLeg1);
			merger.mergeBasic(getFixedRateLeg2(), o.getFixedRateLeg2(), this::setFixedRateLeg2);
			merger.mergeBasic(getSpreadNotationOfLeg1(), o.getSpreadNotationOfLeg1(), this::setSpreadNotationOfLeg1);
			merger.mergeBasic(getSpreadNotationOfLeg2(), o.getSpreadNotationOfLeg2(), this::setSpreadNotationOfLeg2);
			merger.mergeBasic(getStrikePriceNotation(), o.getStrikePriceNotation(), this::setStrikePriceNotation);
			merger.mergeBasic(getOptionPremiumAmount(), o.getOptionPremiumAmount(), this::setOptionPremiumAmount);
			merger.mergeBasic(getOptionPremiumCurrency(), o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency);
			merger.mergeBasic(getOptionPremiumPaymentDate(), o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate);
			merger.mergeBasic(getFirstExerciseDate(), o.getFirstExerciseDate(), this::setFirstExerciseDate);
			merger.mergeBasic(getExchangeRate(), o.getExchangeRate(), this::setExchangeRate);
			merger.mergeBasic(getExchangeRateBasis(), o.getExchangeRateBasis(), this::setExchangeRateBasis);
			merger.mergeBasic(getNotionalLeg1(), o.getNotionalLeg1(), this::setNotionalLeg1);
			merger.mergeBasic(getNotionalLeg2(), o.getNotionalLeg2(), this::setNotionalLeg2);
			merger.mergeBasic(getCallAmount(), o.getCallAmount(), this::setCallAmount);
			merger.mergeBasic(getPutAmount(), o.getPutAmount(), this::setPutAmount);
			merger.mergeBasic(getNotionalCurrencyOfLeg1(), o.getNotionalCurrencyOfLeg1(), this::setNotionalCurrencyOfLeg1);
			merger.mergeBasic(getNotionalCurrencyOfLeg2(), o.getNotionalCurrencyOfLeg2(), this::setNotionalCurrencyOfLeg2);
			merger.mergeBasic(getCallCurrency(), o.getCallCurrency(), this::setCallCurrency);
			merger.mergeBasic(getPutCurrency(), o.getPutCurrency(), this::setPutCurrency);
			merger.mergeBasic(getQuantityUnitOfMeasureLeg1(), o.getQuantityUnitOfMeasureLeg1(), this::setQuantityUnitOfMeasureLeg1);
			merger.mergeBasic(getQuantityUnitOfMeasureLeg2(), o.getQuantityUnitOfMeasureLeg2(), this::setQuantityUnitOfMeasureLeg2);
			merger.mergeBasic(getTotalNotionalQuantityLeg1(), o.getTotalNotionalQuantityLeg1(), this::setTotalNotionalQuantityLeg1);
			merger.mergeBasic(getTotalNotionalQuantityLeg2(), o.getTotalNotionalQuantityLeg2(), this::setTotalNotionalQuantityLeg2);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getEventType(), o.getEventType(), this::setEventType);
			merger.mergeBasic(getEventTimestamp(), o.getEventTimestamp(), this::setEventTimestamp);
			merger.mergeBasic(getEventIdentifier(), o.getEventIdentifier(), this::setEventIdentifier);
			merger.mergeBasic(getIndexFactor(), o.getIndexFactor(), this::setIndexFactor);
			merger.mergeBasic(getEmbeddedOptionType(), o.getEmbeddedOptionType(), this::setEmbeddedOptionType);
			merger.mergeBasic(getUpi(), o.getUpi(), this::setUpi);
			merger.mergeBasic(getDeliveryType(), o.getDeliveryType(), this::setDeliveryType);
			merger.mergeBasic(getAssetClass(), o.getAssetClass(), this::setAssetClass);
			merger.mergeBasic(getUnderlyingIdentificationType(), o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType);
			merger.mergeBasic(getUnderlyingIdentification(), o.getUnderlyingIdentification(), this::setUnderlyingIdentification);
			merger.mergeBasic(getUnderlyingIndexIndicator(), o.getUnderlyingIndexIndicator(), this::setUnderlyingIndexIndicator);
			merger.mergeBasic(getNameOfTheUnderlyingIndex(), o.getNameOfTheUnderlyingIndex(), this::setNameOfTheUnderlyingIndex);
			merger.mergeBasic(getReferenceEntity(), o.getReferenceEntity(), this::setReferenceEntity);
			merger.mergeBasic(getIndicatorOfTheFloatingRateOfLeg1(), o.getIndicatorOfTheFloatingRateOfLeg1(), this::setIndicatorOfTheFloatingRateOfLeg1);
			merger.mergeBasic(getIndicatorOfTheFloatingRateOfLeg2(), o.getIndicatorOfTheFloatingRateOfLeg2(), this::setIndicatorOfTheFloatingRateOfLeg2);
			merger.mergeBasic(getNameOfTheFloatingRateOfLeg1(), o.getNameOfTheFloatingRateOfLeg1(), this::setNameOfTheFloatingRateOfLeg1);
			merger.mergeBasic(getNameOfTheFloatingRateOfLeg2(), o.getNameOfTheFloatingRateOfLeg2(), this::setNameOfTheFloatingRateOfLeg2);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg1TimePeriod(), o.getFloatingRateReferencePeriodOfLeg1TimePeriod(), this::setFloatingRateReferencePeriodOfLeg1TimePeriod);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg2TimePeriod(), o.getFloatingRateReferencePeriodOfLeg2TimePeriod(), this::setFloatingRateReferencePeriodOfLeg2TimePeriod);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg1Multiplier(), o.getFloatingRateReferencePeriodOfLeg1Multiplier(), this::setFloatingRateReferencePeriodOfLeg1Multiplier);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg2Multiplier(), o.getFloatingRateReferencePeriodOfLeg2Multiplier(), this::setFloatingRateReferencePeriodOfLeg2Multiplier);
			merger.mergeBasic(getIsCrypto(), o.getIsCrypto(), this::setIsCrypto);
			merger.mergeBasic(getMaturityDateOfTheUnderlying(), o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying);
			merger.mergeBasic(getSeniority(), o.getSeniority(), this::setSeniority);
			merger.mergeBasic(getSeries(), o.getSeries(), this::setSeries);
			merger.mergeBasic(getVersion(), o.getVersion(), this::setVersion);
			merger.mergeBasic(getCdSIndexAttachmentPoint(), o.getCdSIndexAttachmentPoint(), this::setCdSIndexAttachmentPoint);
			merger.mergeBasic(getCdSIndexDetachmentPoint(), o.getCdSIndexDetachmentPoint(), this::setCdSIndexDetachmentPoint);
			merger.mergeBasic(getCustomBasketCode(), o.getCustomBasketCode(), this::setCustomBasketCode);
			merger.mergeBasic(getContractType(), o.getContractType(), this::setContractType);
			merger.mergeBasic(getOptionStyle(), o.getOptionStyle(), this::setOptionStyle);
			merger.mergeBasic(getOptionType(), o.getOptionType(), this::setOptionType);
			merger.mergeBasic(getPackageIdentifier(), o.getPackageIdentifier(), this::setPackageIdentifier);
			merger.mergeBasic(getPackageTransactionPriceCurrency(), o.getPackageTransactionPriceCurrency(), this::setPackageTransactionPriceCurrency);
			merger.mergeBasic(getPackageTransactionPriceNotation(), o.getPackageTransactionPriceNotation(), this::setPackageTransactionPriceNotation);
			merger.mergeBasic(getPackageTransactionSpreadCurrency(), o.getPackageTransactionSpreadCurrency(), this::setPackageTransactionSpreadCurrency);
			merger.mergeBasic(getPackageTransactionSpreadNotation(), o.getPackageTransactionSpreadNotation(), this::setPackageTransactionSpreadNotation);
			merger.mergeBasic(getDelta(), o.getDelta(), this::setDelta);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			JFSATransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(earlyTerminationDate, _that.getEarlyTerminationDate())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(direction1, _that.getDirection1())) return false;
			if (!Objects.equals(direction2Leg1, _that.getDirection2Leg1())) return false;
			if (!Objects.equals(direction2Leg2, _that.getDirection2Leg2())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(platformIdentifier, _that.getPlatformIdentifier())) return false;
			if (!Objects.equals(confirmed, _that.getConfirmed())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) return false;
			if (!Objects.equals(settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!Objects.equals(originalSwapUTI, _that.getOriginalSwapUTI())) return false;
			if (!Objects.equals(originalSwapUTIProprietary, _that.getOriginalSwapUTIProprietary())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(utiProprietary, _that.getUtiProprietary())) return false;
			if (!Objects.equals(priorUti, _that.getPriorUti())) return false;
			if (!Objects.equals(priorUtiProprietary, _that.getPriorUtiProprietary())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodLeg1, _that.getFloatingRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodLeg2, _that.getFloatingRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(fixingDateLeg1, _that.getFixingDateLeg1())) return false;
			if (!Objects.equals(fixingDateLeg2, _that.getFixingDateLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodLeg1, _that.getFloatingRateResetFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!Objects.equals(priceNotation, _that.getPriceNotation())) return false;
			if (!Objects.equals(priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) return false;
			if (!ListEquals.listEquals(priceSchedule, _that.getPriceSchedule())) return false;
			if (!Objects.equals(fixedRateLeg1, _that.getFixedRateLeg1())) return false;
			if (!Objects.equals(fixedRateLeg2, _that.getFixedRateLeg2())) return false;
			if (!Objects.equals(spreadOfLeg1, _that.getSpreadOfLeg1())) return false;
			if (!Objects.equals(spreadNotationOfLeg1, _that.getSpreadNotationOfLeg1())) return false;
			if (!Objects.equals(spreadOfLeg2, _that.getSpreadOfLeg2())) return false;
			if (!Objects.equals(spreadNotationOfLeg2, _that.getSpreadNotationOfLeg2())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!Objects.equals(strikePriceNotation, _that.getStrikePriceNotation())) return false;
			if (!ListEquals.listEquals(strikePriceSchedule, _that.getStrikePriceSchedule())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(firstExerciseDate, _that.getFirstExerciseDate())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(notionalLeg1, _that.getNotionalLeg1())) return false;
			if (!Objects.equals(notionalLeg2, _that.getNotionalLeg2())) return false;
			if (!Objects.equals(callAmount, _that.getCallAmount())) return false;
			if (!Objects.equals(putAmount, _that.getPutAmount())) return false;
			if (!Objects.equals(notionalCurrencyOfLeg1, _that.getNotionalCurrencyOfLeg1())) return false;
			if (!Objects.equals(notionalCurrencyOfLeg2, _that.getNotionalCurrencyOfLeg2())) return false;
			if (!Objects.equals(callCurrency, _that.getCallCurrency())) return false;
			if (!Objects.equals(putCurrency, _that.getPutCurrency())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg1, _that.getNotionalQuantityScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg2, _that.getNotionalQuantityScheduleLeg2())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(eventIdentifier, _that.getEventIdentifier())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(embeddedOptionType, _that.getEmbeddedOptionType())) return false;
			if (!Objects.equals(upi, _that.getUpi())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!Objects.equals(underlyingIndexIndicator, _that.getUnderlyingIndexIndicator())) return false;
			if (!Objects.equals(nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg1, _that.getIndicatorOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg2, _that.getIndicatorOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1TimePeriod, _that.getFloatingRateReferencePeriodOfLeg1TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1Multiplier, _that.getFloatingRateReferencePeriodOfLeg1Multiplier())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(seniority, _that.getSeniority())) return false;
			if (!Objects.equals(series, _that.getSeries())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!ListEquals.listEquals(basketConstituents, _that.getBasketConstituents())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(packageTransactionPrice, _that.getPackageTransactionPrice())) return false;
			if (!Objects.equals(packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) return false;
			if (!Objects.equals(packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) return false;
			if (!Objects.equals(packageTransactionSpread, _that.getPackageTransactionSpread())) return false;
			if (!Objects.equals(packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) return false;
			if (!Objects.equals(packageTransactionSpreadNotation, _that.getPackageTransactionSpreadNotation())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(barrier, _that.getBarrier())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (earlyTerminationDate != null ? earlyTerminationDate.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (direction1 != null ? direction1.hashCode() : 0);
			_result = 31 * _result + (direction2Leg1 != null ? direction2Leg1.hashCode() : 0);
			_result = 31 * _result + (direction2Leg2 != null ? direction2Leg2.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (originalSwapSDRIdentifier != null ? originalSwapSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (platformIdentifier != null ? platformIdentifier.hashCode() : 0);
			_result = 31 * _result + (confirmed != null ? confirmed.hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg1 != null ? settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg2 != null ? settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTI != null ? originalSwapUTI.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTIProprietary != null ? originalSwapUTIProprietary.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (utiProprietary != null ? utiProprietary.hashCode() : 0);
			_result = 31 * _result + (priorUti != null ? priorUti.hashCode() : 0);
			_result = 31 * _result + (priorUtiProprietary != null ? priorUtiProprietary.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg1 != null ? fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg1 != null ? floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg2 != null ? fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg2 != null ? floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg1 != null ? fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg2 != null ? fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodLeg1 != null ? floatingRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodLeg2 != null ? floatingRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg1 != null ? fixingDateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg2 != null ? fixingDateLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodLeg1 != null ? floatingRateResetFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg2 != null ? floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceNotation != null ? priceNotation.hashCode() : 0);
			_result = 31 * _result + (priceUnitOfMeasure != null ? priceUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (priceSchedule != null ? priceSchedule.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg1 != null ? fixedRateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg2 != null ? fixedRateLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1 != null ? spreadOfLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadNotationOfLeg1 != null ? spreadNotationOfLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2 != null ? spreadOfLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadNotationOfLeg2 != null ? spreadNotationOfLeg2.hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotation != null ? strikePriceNotation.hashCode() : 0);
			_result = 31 * _result + (strikePriceSchedule != null ? strikePriceSchedule.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (firstExerciseDate != null ? firstExerciseDate.hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (notionalLeg1 != null ? notionalLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalLeg2 != null ? notionalLeg2.hashCode() : 0);
			_result = 31 * _result + (callAmount != null ? callAmount.hashCode() : 0);
			_result = 31 * _result + (putAmount != null ? putAmount.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyOfLeg1 != null ? notionalCurrencyOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyOfLeg2 != null ? notionalCurrencyOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (callCurrency != null ? callCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (putCurrency != null ? putCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg1 != null ? quantityUnitOfMeasureLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg2 != null ? quantityUnitOfMeasureLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1 != null ? notionalAmountScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2 != null ? notionalAmountScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg1 != null ? notionalQuantityScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg2 != null ? notionalQuantityScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (eventIdentifier != null ? eventIdentifier.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (embeddedOptionType != null ? embeddedOptionType.hashCode() : 0);
			_result = 31 * _result + (upi != null ? upi.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (underlyingIndexIndicator != null ? underlyingIndexIndicator.hashCode() : 0);
			_result = 31 * _result + (nameOfTheUnderlyingIndex != null ? nameOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg1 != null ? indicatorOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg2 != null ? indicatorOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg1 != null ? nameOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg2 != null ? nameOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1TimePeriod != null ? floatingRateReferencePeriodOfLeg1TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2TimePeriod != null ? floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1Multiplier != null ? floatingRateReferencePeriodOfLeg1Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2Multiplier != null ? floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (seniority != null ? seniority.hashCode() : 0);
			_result = 31 * _result + (series != null ? series.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (cdSIndexAttachmentPoint != null ? cdSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cdSIndexDetachmentPoint != null ? cdSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (basketConstituents != null ? basketConstituents.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPrice != null ? packageTransactionPrice.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceCurrency != null ? packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceNotation != null ? packageTransactionPriceNotation.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpread != null ? packageTransactionSpread.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadCurrency != null ? packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadNotation != null ? packageTransactionSpreadNotation.hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (barrier != null ? barrier.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "JFSATransactionReportBuilder {" +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"earlyTerminationDate=" + this.earlyTerminationDate + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"direction1=" + this.direction1 + ", " +
				"direction2Leg1=" + this.direction2Leg1 + ", " +
				"direction2Leg2=" + this.direction2Leg2 + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", " +
				"cleared=" + this.cleared + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"platformIdentifier=" + this.platformIdentifier + ", " +
				"confirmed=" + this.confirmed + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"settlementCurrencyLeg1=" + this.settlementCurrencyLeg1 + ", " +
				"settlementCurrencyLeg2=" + this.settlementCurrencyLeg2 + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"originalSwapUTI=" + this.originalSwapUTI + ", " +
				"originalSwapUTIProprietary=" + this.originalSwapUTIProprietary + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"uti=" + this.uti + ", " +
				"utiProprietary=" + this.utiProprietary + ", " +
				"priorUti=" + this.priorUti + ", " +
				"priorUtiProprietary=" + this.priorUtiProprietary + ", " +
				"fixedRateDayCountConventionLeg1=" + this.fixedRateDayCountConventionLeg1 + ", " +
				"floatingRateDayCountConventionOfLeg1=" + this.floatingRateDayCountConventionOfLeg1 + ", " +
				"fixedRateDayCountConventionLeg2=" + this.fixedRateDayCountConventionLeg2 + ", " +
				"floatingRateDayCountConventionOfLeg2=" + this.floatingRateDayCountConventionOfLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodLeg1=" + this.floatingRatePaymentFrequencyPeriodLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodLeg2=" + this.floatingRatePaymentFrequencyPeriodLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"fixingDateLeg1=" + this.fixingDateLeg1 + ", " +
				"fixingDateLeg2=" + this.fixingDateLeg2 + ", " +
				"floatingRateResetFrequencyPeriodLeg1=" + this.floatingRateResetFrequencyPeriodLeg1 + ", " +
				"floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"price=" + this.price + ", " +
				"priceNotation=" + this.priceNotation + ", " +
				"priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", " +
				"priceSchedule=" + this.priceSchedule + ", " +
				"fixedRateLeg1=" + this.fixedRateLeg1 + ", " +
				"fixedRateLeg2=" + this.fixedRateLeg2 + ", " +
				"spreadOfLeg1=" + this.spreadOfLeg1 + ", " +
				"spreadNotationOfLeg1=" + this.spreadNotationOfLeg1 + ", " +
				"spreadOfLeg2=" + this.spreadOfLeg2 + ", " +
				"spreadNotationOfLeg2=" + this.spreadNotationOfLeg2 + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"strikePriceNotation=" + this.strikePriceNotation + ", " +
				"strikePriceSchedule=" + this.strikePriceSchedule + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"firstExerciseDate=" + this.firstExerciseDate + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"notionalLeg1=" + this.notionalLeg1 + ", " +
				"notionalLeg2=" + this.notionalLeg2 + ", " +
				"callAmount=" + this.callAmount + ", " +
				"putAmount=" + this.putAmount + ", " +
				"notionalCurrencyOfLeg1=" + this.notionalCurrencyOfLeg1 + ", " +
				"notionalCurrencyOfLeg2=" + this.notionalCurrencyOfLeg2 + ", " +
				"callCurrency=" + this.callCurrency + ", " +
				"putCurrency=" + this.putCurrency + ", " +
				"quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", " +
				"quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", " +
				"notionalAmountScheduleLeg1=" + this.notionalAmountScheduleLeg1 + ", " +
				"notionalAmountScheduleLeg2=" + this.notionalAmountScheduleLeg2 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"notionalQuantityScheduleLeg1=" + this.notionalQuantityScheduleLeg1 + ", " +
				"notionalQuantityScheduleLeg2=" + this.notionalQuantityScheduleLeg2 + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"eventIdentifier=" + this.eventIdentifier + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"embeddedOptionType=" + this.embeddedOptionType + ", " +
				"upi=" + this.upi + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"underlyingIndexIndicator=" + this.underlyingIndexIndicator + ", " +
				"nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"indicatorOfTheFloatingRateOfLeg1=" + this.indicatorOfTheFloatingRateOfLeg1 + ", " +
				"indicatorOfTheFloatingRateOfLeg2=" + this.indicatorOfTheFloatingRateOfLeg2 + ", " +
				"nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", " +
				"nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", " +
				"floatingRateReferencePeriodOfLeg1TimePeriod=" + this.floatingRateReferencePeriodOfLeg1TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg1Multiplier=" + this.floatingRateReferencePeriodOfLeg1Multiplier + ", " +
				"floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"seniority=" + this.seniority + ", " +
				"series=" + this.series + ", " +
				"version=" + this.version + ", " +
				"cdSIndexAttachmentPoint=" + this.cdSIndexAttachmentPoint + ", " +
				"cdSIndexDetachmentPoint=" + this.cdSIndexDetachmentPoint + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"basketConstituents=" + this.basketConstituents + ", " +
				"contractType=" + this.contractType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"optionType=" + this.optionType + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"packageTransactionPrice=" + this.packageTransactionPrice + ", " +
				"packageTransactionPriceCurrency=" + this.packageTransactionPriceCurrency + ", " +
				"packageTransactionPriceNotation=" + this.packageTransactionPriceNotation + ", " +
				"packageTransactionSpread=" + this.packageTransactionSpread + ", " +
				"packageTransactionSpreadCurrency=" + this.packageTransactionSpreadCurrency + ", " +
				"packageTransactionSpreadNotation=" + this.packageTransactionSpreadNotation + ", " +
				"delta=" + this.delta + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"barrier=" + this.barrier + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}
}
