package drr.regulation.jfsa.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.jfsa.rewrite.trade.PriceAndNotation;
import drr.regulation.jfsa.rewrite.trade.validation.PriceAndNotationTypeFormatValidator;
import drr.regulation.jfsa.rewrite.trade.validation.PriceAndNotationValidator;
import drr.regulation.jfsa.rewrite.trade.validation.datarule.PriceAndNotationMonetaryOrDecimal;
import drr.regulation.jfsa.rewrite.trade.validation.exists.PriceAndNotationOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.57.0
 */
@RosettaMeta(model=PriceAndNotation.class)
public class PriceAndNotationMeta implements RosettaMetaData<PriceAndNotation> {

	@Override
	public List<Validator<? super PriceAndNotation>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<PriceAndNotation>create(PriceAndNotationMonetaryOrDecimal.class)
		);
	}
	
	@Override
	public List<Function<? super PriceAndNotation, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super PriceAndNotation> validator(ValidatorFactory factory) {
		return factory.<PriceAndNotation>create(PriceAndNotationValidator.class);
	}

	@Override
	public Validator<? super PriceAndNotation> typeFormatValidator(ValidatorFactory factory) {
		return factory.<PriceAndNotation>create(PriceAndNotationTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super PriceAndNotation> validator() {
		return new PriceAndNotationValidator();
	}

	@Deprecated
	@Override
	public Validator<? super PriceAndNotation> typeFormatValidator() {
		return new PriceAndNotationTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super PriceAndNotation, Set<String>> onlyExistsValidator() {
		return new PriceAndNotationOnlyExistsValidator();
	}
}
