package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.event.workflow.EventTimestamp;
import cdm.event.workflow.EventTimestampQualificationEnum;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.IsCleared;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import java.time.ZonedDateTime;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ConfirmationTimestampDTCCRule.ConfirmationTimestampDTCCRuleDefault.class)
public abstract class ConfirmationTimestampDTCCRule implements ReportFunction<ReportableEvent, ZonedDateTime> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected IsCleared isCleared;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ZonedDateTime evaluate(ReportableEvent input) {
		ZonedDateTime output = doEvaluate(input);
		
		return output;
	}

	protected abstract ZonedDateTime doEvaluate(ReportableEvent input);

	public static class ConfirmationTimestampDTCCRuleDefault extends ConfirmationTimestampDTCCRule {
		@Override
		protected ZonedDateTime doEvaluate(ReportableEvent input) {
			ZonedDateTime output = null;
			return assignOutput(output, input);
		}
		
		protected ZonedDateTime assignOutput(ZonedDateTime output, ReportableEvent input) {
			final MapperS<ReportableEvent> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final MapperC<EventTimestamp> thenArg1 = thenArg0
				.mapSingleToList(item -> {
					if (areEqual(MapperS.of(isCleared.evaluate(item.<WorkflowStep>map("getOriginatingWorkflowStep", reportableEvent -> reportableEvent.getOriginatingWorkflowStep()).get())), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
						return item.<WorkflowStep>map("getOriginatingWorkflowStep", reportableEvent -> reportableEvent.getOriginatingWorkflowStep()).<EventTimestamp>mapC("getTimestamp", workflowStep -> workflowStep.getTimestamp());
					}
					return MapperC.<EventTimestamp>ofNull();
				});
			final MapperC<EventTimestamp> thenArg2 = thenArg1
				.filterItemNullSafe(item -> areEqual(item.<EventTimestampQualificationEnum>map("getQualification", eventTimestamp -> eventTimestamp.getQualification()), MapperS.of(EventTimestampQualificationEnum.CONFIRMATION_DATE_TIME), CardinalityOperator.All).get());
			final MapperS<EventTimestamp> thenArg3 = MapperS.of(distinct(thenArg2).get());
			output = thenArg3
				.mapSingleToItem(item -> item.<ZonedDateTime>map("getDateTime", eventTimestamp -> eventTimestamp.getDateTime())).get();
			
			return output;
		}
	}
}
