package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEStrikePriceScheduleEndDateRule;
import javax.inject.Inject;


@ImplementedBy(EndDateStrikePriceRule.EndDateStrikePriceRuleDefault.class)
public abstract class EndDateStrikePriceRule implements ReportFunction<PriceReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceScheduleEndDateRule cDEStrikePriceScheduleEndDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(PriceReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(PriceReportablePeriod input);

	public static class EndDateStrikePriceRuleDefault extends EndDateStrikePriceRule {
		@Override
		protected Date doEvaluate(PriceReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, PriceReportablePeriod input) {
			output = cDEStrikePriceScheduleEndDateRule.evaluate(input);
			
			return output;
		}
	}
}
