package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.labels.JFSATradeLabelProvider;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.jfsa.rewrite.trade", body="JFSA", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=JFSATradeLabelProvider.class)
@ImplementedBy(JFSATradeReportFunction.JFSATradeReportFunctionDefault.class)
public abstract class JFSATradeReportFunction implements ReportFunction<TransactionReportInstruction, JFSATransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AssetClassRule assetClassRule;
	@Inject protected BasketConstituentsRule basketConstituentsRule;
	@Inject protected CDSIndexAttachmentPointRule cDSIndexAttachmentPointRule;
	@Inject protected CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected CentralCounterpartyRule centralCounterpartyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingAccountOriginRule clearingAccountOriginRule;
	@Inject protected ClearingMemberRule clearingMemberRule;
	@Inject protected ClearingReceiptTimestampRule clearingReceiptTimestampRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected ConfirmationTimestampDTCCRule confirmationTimestampDTCCRule;
	@Inject protected ConfirmedRule confirmedRule;
	@Inject protected ContractTypeRule contractTypeRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CustomBasketCodeRule customBasketCodeRule;
	@Inject protected DeliveryTypeRule deliveryTypeRule;
	@Inject protected DeltaRule deltaRule;
	@Inject protected DerivativeBasedOnCryptoAssetsRule derivativeBasedOnCryptoAssetsRule;
	@Inject protected Direction1Rule direction1Rule;
	@Inject protected Direction2Leg1Rule direction2Leg1Rule;
	@Inject protected Direction2Leg2Rule direction2Leg2Rule;
	@Inject protected EarlyTerminationDateRule earlyTerminationDateRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EmbeddedOptionTypeRule embeddedOptionTypeRule;
	@Inject protected EnrichmentDataRule enrichmentDataRule;
	@Inject protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
	@Inject protected EventIdentifierRule eventIdentifierRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
	@Inject protected FirstExerciseDateRule firstExerciseDateRule;
	@Inject protected FixedRateDayCountConventionLeg1Rule fixedRateDayCountConventionLeg1Rule;
	@Inject protected FixedRateDayCountConventionLeg2Rule fixedRateDayCountConventionLeg2Rule;
	@Inject protected FixedRateLeg1Rule fixedRateLeg1Rule;
	@Inject protected FixedRateLeg2Rule fixedRateLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodLeg1Rule fixedRatePaymentFrequencyPeriodLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodLeg2Rule fixedRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierLeg1Rule fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected FixingDateLeg1Rule fixingDateLeg1Rule;
	@Inject protected FixingDateLeg2Rule fixingDateLeg2Rule;
	@Inject protected FloatingRateDayCountConventionOfLeg1Rule floatingRateDayCountConventionOfLeg1Rule;
	@Inject protected FloatingRateDayCountConventionOfLeg2Rule floatingRateDayCountConventionOfLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodLeg1Rule floatingRatePaymentFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodLeg2Rule floatingRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierLeg1Rule floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierLeg2Rule floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected FloatingRateReferencePeriodOfLeg1MultiplierRule floatingRateReferencePeriodOfLeg1MultiplierRule;
	@Inject protected FloatingRateReferencePeriodOfLeg1TimePeriodRule floatingRateReferencePeriodOfLeg1TimePeriodRule;
	@Inject protected FloatingRateReferencePeriodOfLeg2MultiplierRule floatingRateReferencePeriodOfLeg2MultiplierRule;
	@Inject protected FloatingRateReferencePeriodOfLeg2TimePeriodRule floatingRateReferencePeriodOfLeg2TimePeriodRule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg1Rule floatingRateResetFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg2Rule floatingRateResetFrequencyPeriodLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg1Rule floatingRateResetFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg2Rule floatingRateResetFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected GetPackageTransactionPriceNotationEnumRule getPackageTransactionPriceNotationEnumRule;
	@Inject protected GetPackageTransactionSpreadNotationEnumRule getPackageTransactionSpreadNotationEnumRule;
	@Inject protected GetPriceNotationEnumRule getPriceNotationEnumRule;
	@Inject protected GetSpreadLeg1NotationEnumRule getSpreadLeg1NotationEnumRule;
	@Inject protected GetSpreadLeg2NotationEnumRule getSpreadLeg2NotationEnumRule;
	@Inject protected GetStrikePriceNotationEnumRule getStrikePriceNotationEnumRule;
	@Inject protected IndexFactorRule indexFactorRule;
	@Inject protected IndicatorOfTheFloatingRateOfLeg1Rule indicatorOfTheFloatingRateOfLeg1Rule;
	@Inject protected IndicatorOfTheFloatingRateOfLeg2Rule indicatorOfTheFloatingRateOfLeg2Rule;
	@Inject protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
	@Inject protected LowerBarrierPriceCurrencyRule lowerBarrierPriceCurrencyRule;
	@Inject protected LowerBarrierPriceDecimalRule lowerBarrierPriceDecimalRule;
	@Inject protected LowerBarrierPriceMonetaryRule lowerBarrierPriceMonetaryRule;
	@Inject protected LowerBarrierPriceNotationRule lowerBarrierPriceNotationRule;
	@Inject protected MaturityDateOfTheUnderlyingRule maturityDateOfTheUnderlyingRule;
	@Inject protected NameOfTheFloatingRateOfLeg1Rule nameOfTheFloatingRateOfLeg1Rule;
	@Inject protected NameOfTheFloatingRateOfLeg2Rule nameOfTheFloatingRateOfLeg2Rule;
	@Inject protected NameOfTheUnderlyingIndexRule nameOfTheUnderlyingIndexRule;
	@Inject protected NewSDRIdentifierRule newSDRIdentifierRule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalCurrencyOfLeg1Rule notionalCurrencyOfLeg1Rule;
	@Inject protected NotionalCurrencyOfLeg2Rule notionalCurrencyOfLeg2Rule;
	@Inject protected NotionalLeg1Rule notionalLeg1Rule;
	@Inject protected NotionalLeg2Rule notionalLeg2Rule;
	@Inject protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
	@Inject protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
	@Inject protected OptionStyleRule optionStyleRule;
	@Inject protected OptionTypeRule optionTypeRule;
	@Inject protected OriginalSwapSDRIdentifierRule originalSwapSDRIdentifierRule;
	@Inject protected OriginalSwapUTIProprietaryRule originalSwapUTIProprietaryRule;
	@Inject protected OriginalSwapUTIRule originalSwapUTIRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PackageTransactionPriceBasisRule packageTransactionPriceBasisRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceDecimalRule packageTransactionPriceDecimalRule;
	@Inject protected PackageTransactionPriceMonetaryRule packageTransactionPriceMonetaryRule;
	@Inject protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
	@Inject protected PackageTransactionSpreadBasisRule packageTransactionSpreadBasisRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadDecimalRule packageTransactionSpreadDecimalRule;
	@Inject protected PackageTransactionSpreadMonetaryRule packageTransactionSpreadMonetaryRule;
	@Inject protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceFormatDecimalRule priceFormatDecimalRule;
	@Inject protected PriceFormatMonetaryRule priceFormatMonetaryRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceScheduleRule priceScheduleRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PriorUtiProprietaryRule priorUtiProprietaryRule;
	@Inject protected PriorUtiRule priorUtiRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected ReferenceEntityRule referenceEntityRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SeniorityRule seniorityRule;
	@Inject protected SeriesRule seriesRule;
	@Inject protected SettlementCurrencyLeg1Rule settlementCurrencyLeg1Rule;
	@Inject protected SettlementCurrencyLeg2Rule settlementCurrencyLeg2Rule;
	@Inject protected SingleBarrierPriceCurrencyRule singleBarrierPriceCurrencyRule;
	@Inject protected SingleBarrierPriceDecimalRule singleBarrierPriceDecimalRule;
	@Inject protected SingleBarrierPriceMonetaryRule singleBarrierPriceMonetaryRule;
	@Inject protected SingleBarrierPriceNotationRule singleBarrierPriceNotationRule;
	@Inject protected SpreadCurrencyOfLeg1Rule spreadCurrencyOfLeg1Rule;
	@Inject protected SpreadCurrencyOfLeg2Rule spreadCurrencyOfLeg2Rule;
	@Inject protected SpreadNotationOfLeg1Rule spreadNotationOfLeg1Rule;
	@Inject protected SpreadNotationOfLeg2Rule spreadNotationOfLeg2Rule;
	@Inject protected SpreadOfLeg1BasisRule spreadOfLeg1BasisRule;
	@Inject protected SpreadOfLeg1DecimalRule spreadOfLeg1DecimalRule;
	@Inject protected SpreadOfLeg1MonetaryRule spreadOfLeg1MonetaryRule;
	@Inject protected SpreadOfLeg2BasisRule spreadOfLeg2BasisRule;
	@Inject protected SpreadOfLeg2DecimalRule spreadOfLeg2DecimalRule;
	@Inject protected SpreadOfLeg2MonetaryRule spreadOfLeg2MonetaryRule;
	@Inject protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
	@Inject protected StrikePriceDecimalRule strikePriceDecimalRule;
	@Inject protected StrikePriceMonetaryRule strikePriceMonetaryRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected StrikePriceScheduleRule strikePriceScheduleRule;
	@Inject protected SubmitterIdentifierRule submitterIdentifierRule;
	@Inject protected TechnicalRecordIdRule technicalRecordIdRule;
	@Inject protected TotalNotionalQuantityLeg1Rule totalNotionalQuantityLeg1Rule;
	@Inject protected TotalNotionalQuantityLeg2Rule totalNotionalQuantityLeg2Rule;
	@Inject protected UPIRule uPIRule;
	@Inject protected UnderlyingIdentificationRule underlyingIdentificationRule;
	@Inject protected UnderlyingIdentificationTypeRule underlyingIdentificationTypeRule;
	@Inject protected UnderlyingIndexIndicatorRule underlyingIndexIndicatorRule;
	@Inject protected UpperBarrierPriceCurrencyRule upperBarrierPriceCurrencyRule;
	@Inject protected UpperBarrierPriceDecimalRule upperBarrierPriceDecimalRule;
	@Inject protected UpperBarrierPriceMonetaryRule upperBarrierPriceMonetaryRule;
	@Inject protected UpperBarrierPriceNotationRule upperBarrierPriceNotationRule;
	@Inject protected UtiProprietaryRule utiProprietaryRule;
	@Inject protected UtiRule utiRule;
	@Inject protected ValuationAmountRule valuationAmountRule;
	@Inject protected ValuationCurrencyRule valuationCurrencyRule;
	@Inject protected ValuationMethodRule valuationMethodRule;
	@Inject protected ValuationTimestampRule valuationTimestampRule;
	@Inject protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
	@Inject protected VersionRule versionRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public JFSATransactionReport evaluate(TransactionReportInstruction input) {
		JFSATransactionReport.JFSATransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final JFSATransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(JFSATransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract JFSATransactionReport.JFSATransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class JFSATradeReportFunctionDefault extends JFSATradeReportFunction {
		@Override
		protected JFSATransactionReport.JFSATransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			JFSATransactionReport.JFSATransactionReportBuilder output = JFSATransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected JFSATransactionReport.JFSATransactionReportBuilder assignOutput(JFSATransactionReport.JFSATransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setEarlyTerminationDate(earlyTerminationDateRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setEntityResponsibleForReporting(entityResponsibleForReportingRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeRule.evaluate(input));
			
			output
				.setDirection1(direction1Rule.evaluate(input));
			
			output
				.setDirection2Leg1(direction2Leg1Rule.evaluate(input));
			
			output
				.setDirection2Leg2(direction2Leg2Rule.evaluate(input));
			
			output
				.setSubmitterIdentifier(submitterIdentifierRule.evaluate(input));
			
			output
				.setNewSDRIdentifier(newSDRIdentifierRule.evaluate(input));
			
			output
				.setOriginalSwapSDRIdentifier(originalSwapSDRIdentifierRule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCentralCounterparty(centralCounterpartyRule.evaluate(input));
			
			output
				.setClearingMember(clearingMemberRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setConfirmed(confirmedRule.evaluate(input));
			
			output
				.setFinalContractualSettlementDate(finalContractualSettlementDateRule.evaluate(input));
			
			output
				.setConfirmationTimestamp(confirmationTimestampDTCCRule.evaluate(input));
			
			output
				.setSettlementCurrencyLeg1(settlementCurrencyLeg1Rule.evaluate(input));
			
			output
				.setSettlementCurrencyLeg2(settlementCurrencyLeg2Rule.evaluate(input));
			
			output
				.setClearingAccountOrigin(clearingAccountOriginRule.evaluate(input));
			
			output
				.setOriginalSwapUTI(originalSwapUTIRule.evaluate(input));
			
			output
				.setOriginalSwapUTIProprietary(originalSwapUTIProprietaryRule.evaluate(input));
			
			output
				.setClearingReceiptTimestamp(clearingReceiptTimestampRule.evaluate(input));
			
			output
				.setUti(utiRule.evaluate(input));
			
			output
				.setUtiProprietary(utiProprietaryRule.evaluate(input));
			
			output
				.setPriorUti(priorUtiRule.evaluate(input));
			
			output
				.setPriorUtiProprietary(priorUtiProprietaryRule.evaluate(input));
			
			output
				.setFixedRateDayCountConventionLeg1(fixedRateDayCountConventionLeg1Rule.evaluate(input));
			
			output
				.setFloatingRateDayCountConventionOfLeg1(floatingRateDayCountConventionOfLeg1Rule.evaluate(input));
			
			output
				.setFixedRateDayCountConventionLeg2(fixedRateDayCountConventionLeg2Rule.evaluate(input));
			
			output
				.setFloatingRateDayCountConventionOfLeg2(floatingRateDayCountConventionOfLeg2Rule.evaluate(input));
			
			output
				.setFixedRatePaymentFrequencyPeriodLeg1(fixedRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.setFixedRatePaymentFrequencyPeriodLeg2(fixedRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			output
				.setFloatingRatePaymentFrequencyPeriodLeg1(floatingRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.setFloatingRatePaymentFrequencyPeriodLeg2(floatingRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal0 = fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.setFixedRatePaymentFrequencyPeriodMultiplierLeg1((bigDecimal0 == null ? null : bigDecimal0.intValueExact()));
			
			final BigDecimal bigDecimal1 = fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.setFixedRatePaymentFrequencyPeriodMultiplierLeg2((bigDecimal1 == null ? null : bigDecimal1.intValueExact()));
			
			final BigDecimal bigDecimal2 = floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.setFloatingRatePaymentFrequencyPeriodMultiplierLeg1((bigDecimal2 == null ? null : bigDecimal2.intValueExact()));
			
			final BigDecimal bigDecimal3 = floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.setFloatingRatePaymentFrequencyPeriodMultiplierLeg2((bigDecimal3 == null ? null : bigDecimal3.intValueExact()));
			
			output
				.setFixingDateLeg1(fixingDateLeg1Rule.evaluate(input));
			
			output
				.setFixingDateLeg2(fixingDateLeg2Rule.evaluate(input));
			
			output
				.setFloatingRateResetFrequencyPeriodLeg1(floatingRateResetFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.setFloatingRateResetFrequencyPeriodOfLeg2(floatingRateResetFrequencyPeriodLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal4 = floatingRateResetFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.setFloatingRateResetFrequencyPeriodMultiplierLeg1((bigDecimal4 == null ? null : bigDecimal4.intValueExact()));
			
			final BigDecimal bigDecimal5 = floatingRateResetFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.setFloatingRateResetFrequencyPeriodMultiplierLeg2((bigDecimal5 == null ? null : bigDecimal5.intValueExact()));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.setValuationAmount(valuationAmountRule.evaluate(input));
			
			output
				.setValuationCurrency(valuationCurrencyRule.evaluate(input));
			
			output
				.setValuationMethod(valuationMethodRule.evaluate(input));
			
			output
				.setValuationTimestamp(valuationTimestampRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceMonetary(priceFormatMonetaryRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceDecimal(priceFormatDecimalRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.getOrCreatePrice()
				.setPriceNotation(getPriceNotationEnumRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setPriceSchedule(priceScheduleRule.evaluate(input));
			
			output
				.setFixedRateLeg1(fixedRateLeg1Rule.evaluate(input));
			
			output
				.setFixedRateLeg2(fixedRateLeg2Rule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadOfLeg1Monetary(spreadOfLeg1MonetaryRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadOfLeg1Decimal(spreadOfLeg1DecimalRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadOfLeg1Basis(spreadOfLeg1BasisRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadCurrencyOfLeg1(spreadCurrencyOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg1()
				.setSpreadOfLeg1Notation(getSpreadLeg1NotationEnumRule.evaluate(input));
			
			output
				.setSpreadNotationOfLeg1(spreadNotationOfLeg1Rule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadOfLeg2Monetary(spreadOfLeg2MonetaryRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadOfLeg2Decimal(spreadOfLeg2DecimalRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadOfLeg2Basis(spreadOfLeg2BasisRule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadCurrencyOfLeg2(spreadCurrencyOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateSpreadOfLeg2()
				.setSpreadOfLeg2Notation(getSpreadLeg2NotationEnumRule.evaluate(input));
			
			output
				.setSpreadNotationOfLeg2(spreadNotationOfLeg2Rule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceMonetary(strikePriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceDecimal(strikePriceDecimalRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceCurrency(strikePriceCurrencyCurrencyPairRule.evaluate(input));
			
			output
				.getOrCreateStrikePrice()
				.setStrikePriceNotation(getStrikePriceNotationEnumRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.setStrikePriceSchedule(strikePriceScheduleRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setOptionPremiumPaymentDate(optionPremiumPaymentDateRule.evaluate(input));
			
			output
				.setFirstExerciseDate(firstExerciseDateRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setNotionalLeg1(notionalLeg1Rule.evaluate(input));
			
			output
				.setNotionalLeg2(notionalLeg2Rule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setNotionalCurrencyOfLeg1(notionalCurrencyOfLeg1Rule.evaluate(input));
			
			output
				.setNotionalCurrencyOfLeg2(notionalCurrencyOfLeg2Rule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg1(quantityUnitOfMeasureLeg1Rule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg2(quantityUnitOfMeasureLeg2Rule.evaluate(input));
			
			output
				.setNotionalAmountScheduleLeg1(notionalAmountScheduleLeg1Rule.evaluate(input));
			
			output
				.setNotionalAmountScheduleLeg2(notionalAmountScheduleLeg2Rule.evaluate(input));
			
			output
				.setTotalNotionalQuantityLeg1(totalNotionalQuantityLeg1Rule.evaluate(input));
			
			output
				.setTotalNotionalQuantityLeg2(totalNotionalQuantityLeg2Rule.evaluate(input));
			
			output
				.setNotionalQuantityScheduleLeg1(notionalQuantityScheduleLeg1Rule.evaluate(input));
			
			output
				.setNotionalQuantityScheduleLeg2(notionalQuantityScheduleLeg2Rule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.setEventIdentifier(eventIdentifierRule.evaluate(input));
			
			output
				.setIndexFactor(indexFactorRule.evaluate(input));
			
			output
				.setEmbeddedOptionType(embeddedOptionTypeRule.evaluate(input));
			
			output
				.setUpi(uPIRule.evaluate(input));
			
			output
				.setDeliveryType(deliveryTypeRule.evaluate(input));
			
			output
				.setAssetClass(assetClassRule.evaluate(input));
			
			output
				.setUnderlyingIdentificationType(underlyingIdentificationTypeRule.evaluate(input));
			
			output
				.setUnderlyingIdentification(underlyingIdentificationRule.evaluate(input));
			
			output
				.setUnderlyingIndexIndicator(underlyingIndexIndicatorRule.evaluate(input));
			
			output
				.setNameOfTheUnderlyingIndex(nameOfTheUnderlyingIndexRule.evaluate(input));
			
			output
				.setReferenceEntity(referenceEntityRule.evaluate(input));
			
			output
				.setIndicatorOfTheFloatingRateOfLeg1(indicatorOfTheFloatingRateOfLeg1Rule.evaluate(input));
			
			output
				.setIndicatorOfTheFloatingRateOfLeg2(indicatorOfTheFloatingRateOfLeg2Rule.evaluate(input));
			
			output
				.setNameOfTheFloatingRateOfLeg1(nameOfTheFloatingRateOfLeg1Rule.evaluate(input));
			
			output
				.setNameOfTheFloatingRateOfLeg2(nameOfTheFloatingRateOfLeg2Rule.evaluate(input));
			
			output
				.setFloatingRateReferencePeriodOfLeg1TimePeriod(floatingRateReferencePeriodOfLeg1TimePeriodRule.evaluate(input));
			
			output
				.setFloatingRateReferencePeriodOfLeg2TimePeriod(floatingRateReferencePeriodOfLeg2TimePeriodRule.evaluate(input));
			
			final BigDecimal bigDecimal6 = floatingRateReferencePeriodOfLeg1MultiplierRule.evaluate(input);
			output
				.setFloatingRateReferencePeriodOfLeg1Multiplier((bigDecimal6 == null ? null : bigDecimal6.intValueExact()));
			
			final BigDecimal bigDecimal7 = floatingRateReferencePeriodOfLeg2MultiplierRule.evaluate(input);
			output
				.setFloatingRateReferencePeriodOfLeg2Multiplier((bigDecimal7 == null ? null : bigDecimal7.intValueExact()));
			
			output
				.setIsCrypto(derivativeBasedOnCryptoAssetsRule.evaluate(input));
			
			output
				.setMaturityDateOfTheUnderlying(maturityDateOfTheUnderlyingRule.evaluate(input));
			
			output
				.setSeniority(seniorityRule.evaluate(input));
			
			final BigDecimal bigDecimal8 = seriesRule.evaluate(input);
			output
				.setSeries((bigDecimal8 == null ? null : bigDecimal8.intValueExact()));
			
			final BigDecimal bigDecimal9 = versionRule.evaluate(input);
			output
				.setVersion((bigDecimal9 == null ? null : bigDecimal9.intValueExact()));
			
			output
				.setCdSIndexAttachmentPoint(cDSIndexAttachmentPointRule.evaluate(input));
			
			output
				.setCdSIndexDetachmentPoint(cDSIndexDetachmentPointRule.evaluate(input));
			
			output
				.setCustomBasketCode(customBasketCodeRule.evaluate(input));
			
			output
				.setBasketConstituents(basketConstituentsRule.evaluate(input));
			
			output
				.setContractType(contractTypeRule.evaluate(input));
			
			output
				.setOptionStyle(optionStyleRule.evaluate(input));
			
			output
				.setOptionType(optionTypeRule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionPrice()
				.setPackageTransactionPriceMonetary(packageTransactionPriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionPrice()
				.setPackageTransactionPriceDecimal(packageTransactionPriceDecimalRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionPrice()
				.setPackageTransactionPriceBasis(packageTransactionPriceBasisRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionPrice()
				.setPackageTransactionPriceNotation(getPackageTransactionPriceNotationEnumRule.evaluate(input));
			
			output
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionSpread()
				.setPackageTransactionSpreadMonetary(packageTransactionSpreadMonetaryRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionSpread()
				.setPackageTransactionSpreadDecimal(packageTransactionSpreadDecimalRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionSpread()
				.setPackageTransactionSpreadBasis(packageTransactionSpreadBasisRule.evaluate(input));
			
			output
				.getOrCreatePackageTransactionSpread()
				.setPackageTransactionSpreadNotation(getPackageTransactionSpreadNotationEnumRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationRule.evaluate(input));
			
			output
				.setDelta(deltaRule.evaluate(input));
			
			output
				.setTechnicalRecordId(technicalRecordIdRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setSingleBarrierPriceMonetary(singleBarrierPriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setSingleBarrierPriceDecimal(singleBarrierPriceDecimalRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setLowerBarrierPriceMonetary(lowerBarrierPriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setLowerBarrierPriceDecimal(lowerBarrierPriceDecimalRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setUpperBarrierPriceMonetary(upperBarrierPriceMonetaryRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setUpperBarrierPriceDecimal(upperBarrierPriceDecimalRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setSingleBarrierPriceNotation(singleBarrierPriceNotationRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setLowerBarrierPriceNotation(lowerBarrierPriceNotationRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setUpperBarrierPriceNotation(upperBarrierPriceNotationRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setSingleBarrierPriceCurrency(singleBarrierPriceCurrencyRule.evaluate(input));
			
			output
				.getOrCreateBarrier()
				.setLowerBarrierPriceCurrency(MapperC.of(lowerBarrierPriceCurrencyRule.evaluate(input)).get());
			
			output
				.getOrCreateBarrier()
				.setUpperBarrierPriceCurrency(MapperC.of(upperBarrierPriceCurrencyRule.evaluate(input)).get());
			
			output
				.getOrCreateNonReportable()
				.setEnrichment(enrichmentDataRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
