package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.common.settlement.FixedPrice;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FXLeg2;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iosco.cde.functions.CDECommodityNotional;
import drr.standards.iosco.cde.reports.CDEFXNotionalRule;
import drr.standards.iosco.cde.reports.CDEInterestRateNotionalRule;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(NotionalLeg2Rule.NotionalLeg2RuleDefault.class)
public abstract class NotionalLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected CDECommodityNotional cDECommodityNotional;
	@Inject protected CDEFXNotionalRule cDEFXNotionalRule;
	@Inject protected CDEInterestRateNotionalRule cDEInterestRateNotionalRule;
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FXLeg2 fXLeg2;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXOption isFXOption;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected TradeForEvent tradeForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class NotionalLeg2RuleDefault extends NotionalLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final Boolean _boolean = isActionTypeTERM.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(beforeTradeForEvent.evaluate(item.get()));
					}
					return MapperS.of(tradeForEvent.evaluate(item.get()));
				});
			final MapperS<BigDecimal> thenArg2 = thenArg1
				.mapSingleToItem(trade -> MapperS.of(productForTrade.evaluate(trade.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms())
					.mapSingleToItem(item -> {
						final Boolean boolean0 = qualify_InterestRate_Option_Swaption.evaluate(item.get());
						if ((boolean0 == null ? false : boolean0)) {
							return MapperS.of(cDEInterestRateNotionalRule.evaluate(interestRateLeg2.evaluate(underlierForProduct.evaluate(productForTrade.evaluate(trade.get())))));
						}
						if (ComparisonResult.ofNullSafe(MapperS.of(isFXForward.evaluate(productForTrade.evaluate(trade.get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isFXOption.evaluate(productForTrade.evaluate(trade.get()))))).getOrDefault(false)) {
							if (areEqual(MapperS.of(cDEFXNotionalRule.evaluate(fXLeg2.evaluate(productForTrade.evaluate(trade.get())))), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
								return bigInteger == null ? MapperS.<BigDecimal>ofNull() : MapperS.of(new BigDecimal(bigInteger));
							}
							return MapperS.of(cDEFXNotionalRule.evaluate(fXLeg2.evaluate(productForTrade.evaluate(trade.get()))));
						}
						final Boolean boolean1 = qualify_Commodity_Swap_FixedFloat.evaluate(item.get());
						if ((boolean1 == null ? false : boolean1)) {
							final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule = MapperS.of(commodityLeg2.evaluate(productForTrade.evaluate(trade.get()))).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).get();
							final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = MapperS.of(fixedPriceLeg1.evaluate(productForTrade.evaluate(trade.get()))).<FixedPrice>map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).<ReferenceWithMetaPriceSchedule>map("getPrice", fixedPrice -> fixedPrice.getPrice()).get();
							return MapperS.of(cDECommodityNotional.evaluate((referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()), (referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue())));
						}
						final Boolean boolean2 = qualify_Commodity_Swap_Basis.evaluate(trade.<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
						if ((boolean2 == null ? false : boolean2)) {
							final MapperC<FieldWithMetaNonNegativeQuantitySchedule> _thenArg0 = MapperS.of(commodityObservablePriceQuantity.evaluate(trade.<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(trade.get())))).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity())
								.filterItemNullSafe(_item -> exists(_item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency())).get());
							final MapperC<BigDecimal> _thenArg1 = _thenArg0
								.mapItem(_item -> _item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
							return MapperS.of(_thenArg1.get());
						}
						if (ComparisonResult.ofNullSafe(MapperS.of(qualify_AssetClass_InterestRate.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade.get()))))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_AssetClass_Equity.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade.get())))))).getOrDefault(false)) {
							return MapperS.of(cDEInterestRateNotionalRule.evaluate(interestRateLeg2.evaluate(productForTrade.evaluate(trade.get()))));
						}
						return MapperS.<BigDecimal>ofNull();
					}));
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg2.get())).get();
			
			return output;
		}
	}
}
